/*
 * Decompiled with CFR 0.152.
 */
package pswing;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import pswing.PSwing;
import pswing.PSwingCanvas;
import pswing.PSwingMouseEvent;

public class PSwingEventHandler
implements PInputEventListener {
    protected PNode listenNode = null;
    protected boolean active = false;
    Component prevComponent = null;
    Component cursorComponent = null;
    Point2D prevPoint = null;
    Point2D prevOff = null;
    PSwing focusPSwingLeft = null;
    PNode focusNodeLeft = null;
    Component focusComponentLeft = null;
    int focusOffXLeft = 0;
    int focusOffYLeft = 0;
    PSwing focusPSwingMiddle = null;
    PNode focusNodeMiddle = null;
    Component focusComponentMiddle = null;
    int focusOffXMiddle = 0;
    int focusOffYMiddle = 0;
    PSwing focusPSwingRight = null;
    PNode focusNodeRight = null;
    Component focusComponentRight = null;
    int focusOffXRight = 0;
    int focusOffYRight = 0;
    PSwingCanvas canvas;
    private boolean recursing = false;

    public PSwingEventHandler(PSwingCanvas canvas) {
        this.canvas = canvas;
    }

    public PSwingEventHandler(PSwingCanvas canvas, PNode node) {
        this.canvas = canvas;
        this.listenNode = node;
    }

    public void setActive(boolean active) {
        if (this.active && !active) {
            if (this.listenNode != null) {
                this.active = false;
                this.listenNode.removeInputEventListener((PInputEventListener)this);
            }
        } else if (!this.active && active && this.listenNode != null) {
            this.active = true;
            this.listenNode.addInputEventListener((PInputEventListener)this);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    Component findComponentAt(Component c, int x, int y) {
        if (!c.contains(x, y)) {
            return null;
        }
        if (c instanceof Container) {
            Container contain = (Container)c;
            int ncomponents = contain.getComponentCount();
            Component[] component = contain.getComponents();
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = component[i];
                if (comp == null) continue;
                Point p = comp.getLocation();
                if ((comp = comp instanceof Container ? this.findComponentAt(comp, x - (int)p.getX(), y - (int)p.getY()) : comp.getComponentAt(x - (int)p.getX(), y - (int)p.getY())) == null || !comp.isShowing()) continue;
                return comp;
            }
        }
        return c;
    }

    void dispatchEvent(PSwingMouseEvent e1, PInputEvent aEvent) {
        PNode grabNode = null;
        Component comp = null;
        Point2D.Double pt = null;
        PNode currentNode = e1.getPath().getPickedNode();
        int offX = 0;
        int offY = 0;
        PNode vc = e1.getCurrentNode();
        PNode visualNode = currentNode;
        if (vc instanceof PSwing) {
            PSwingMouseEvent e2;
            MouseEvent e_temp;
            PSwing swing = (PSwing)vc;
            grabNode = visualNode;
            if (grabNode.isDescendentOf((PNode)this.canvas.getRoot())) {
                pt = new Point2D.Double(e1.getX(), e1.getY());
                this.cameraToLocal(e1.getPath().getTopCamera(), pt, grabNode);
                this.prevPoint = (Point2D)pt.clone();
                comp = this.findComponentAt(swing.getComponent(), (int)((Point2D)pt).getX(), (int)((Point2D)pt).getY());
                if (comp != null && comp != swing.getComponent()) {
                    for (Component c = comp; c != swing.getComponent(); c = c.getParent()) {
                        offX = (int)((double)offX + c.getLocation().getX());
                        offY = (int)((double)offY + c.getLocation().getY());
                    }
                }
                if (comp != null && e1.getID() == 501) {
                    if (SwingUtilities.isLeftMouseButton(e1)) {
                        this.focusPSwingLeft = swing;
                        this.focusComponentLeft = comp;
                        this.focusNodeLeft = visualNode;
                        this.focusOffXLeft = offX;
                        this.focusOffYLeft = offY;
                    } else if (SwingUtilities.isMiddleMouseButton(e1)) {
                        this.focusPSwingMiddle = swing;
                        this.focusComponentMiddle = comp;
                        this.focusNodeMiddle = visualNode;
                        this.focusOffXMiddle = offX;
                        this.focusOffYMiddle = offY;
                    } else if (SwingUtilities.isRightMouseButton(e1)) {
                        this.focusPSwingRight = swing;
                        this.focusComponentRight = comp;
                        this.focusNodeRight = visualNode;
                        this.focusOffXRight = offX;
                        this.focusOffYRight = offY;
                    }
                }
            }
            if (e1.getID() == 506 || e1.getID() == 502) {
                if (SwingUtilities.isLeftMouseButton(e1) && this.focusComponentLeft != null) {
                    if (this.focusNodeLeft.isDescendentOf((PNode)this.canvas.getRoot())) {
                        pt = new Point2D.Double(e1.getX(), e1.getY());
                        this.cameraToLocal(e1.getPath().getTopCamera(), pt, this.focusNodeLeft);
                        e_temp = new MouseEvent(this.focusComponentLeft, e1.getID(), e1.getWhen(), e1.getModifiers(), (int)((Point2D)pt).getX() - this.focusOffXLeft, (int)((Point2D)pt).getY() - this.focusOffYLeft, e1.getXOnScreen(), e1.getYOnScreen(), e1.getClickCount(), e1.isPopupTrigger(), e1.getButton());
                        e2 = PSwingMouseEvent.createMouseEvent(e_temp.getID(), e_temp, aEvent);
                        if (((Point2D)pt).getX() > 0.0 && ((Point2D)pt).getY() > 0.0 && ((Point2D)pt).getX() < this.focusPSwingLeft.getWidth() && ((Point2D)pt).getY() < this.focusPSwingLeft.getHeight()) {
                            this.dispatchEvent(this.focusComponentLeft, e2);
                        } else {
                            this.dispatchEvent(this.focusComponentLeft, e1);
                        }
                    } else {
                        this.dispatchEvent(this.focusComponentLeft, e1);
                    }
                    this.focusPSwingLeft.repaint();
                    e1.consume();
                    if (e1.getID() == 502) {
                        this.focusComponentLeft = null;
                        this.focusNodeLeft = null;
                    }
                }
                if (SwingUtilities.isMiddleMouseButton(e1) && this.focusComponentMiddle != null) {
                    if (this.focusNodeMiddle.isDescendentOf((PNode)this.canvas.getRoot())) {
                        pt = new Point2D.Double(e1.getX(), e1.getY());
                        this.cameraToLocal(e1.getPath().getTopCamera(), pt, this.focusNodeMiddle);
                        e_temp = new MouseEvent(this.focusComponentMiddle, e1.getID(), e1.getWhen(), e1.getModifiers(), (int)((Point2D)pt).getX() - this.focusOffXMiddle, (int)((Point2D)pt).getY() - this.focusOffYMiddle, e1.getClickCount(), e1.isPopupTrigger());
                        e2 = PSwingMouseEvent.createMouseEvent(e_temp.getID(), e_temp, aEvent);
                        this.dispatchEvent(this.focusComponentMiddle, e2);
                    } else {
                        this.dispatchEvent(this.focusComponentMiddle, e1);
                    }
                    this.focusPSwingMiddle.repaint();
                    e1.consume();
                    if (e1.getID() == 502) {
                        this.focusComponentMiddle = null;
                        this.focusNodeMiddle = null;
                    }
                }
                if (SwingUtilities.isRightMouseButton(e1) && this.focusComponentRight != null) {
                    if (this.focusNodeRight.isDescendentOf((PNode)this.canvas.getRoot())) {
                        pt = new Point2D.Double(e1.getX(), e1.getY());
                        this.cameraToLocal(e1.getPath().getTopCamera(), pt, this.focusNodeRight);
                        e_temp = new MouseEvent(this.focusComponentRight, e1.getID(), e1.getWhen(), e1.getModifiers(), (int)((Point2D)pt).getX() - this.focusOffXRight, (int)((Point2D)pt).getY() - this.focusOffYRight, e1.getClickCount(), e1.isPopupTrigger());
                        e2 = PSwingMouseEvent.createMouseEvent(e_temp.getID(), e_temp, aEvent);
                        this.dispatchEvent(this.focusComponentRight, e2);
                    } else {
                        this.dispatchEvent(this.focusComponentRight, e1);
                    }
                    this.focusPSwingRight.repaint();
                    e1.consume();
                    if (e1.getID() == 502) {
                        this.focusComponentRight = null;
                        this.focusNodeRight = null;
                    }
                }
            } else if ((e1.getID() == 501 || e1.getID() == 500 || e1.getID() == 503) && comp != null) {
                e_temp = new MouseEvent(comp, e1.getID(), e1.getWhen(), e1.getModifiers(), (int)((Point2D)pt).getX() - offX, (int)((Point2D)pt).getY() - offY, e1.getClickCount(), e1.isPopupTrigger());
                e2 = PSwingMouseEvent.createMouseEvent(e_temp.getID(), e_temp, aEvent);
                this.dispatchEvent(comp, e2);
                e1.consume();
            }
            if (this.prevComponent != null) {
                if (comp == null || e1.getID() == 505) {
                    e_temp = new MouseEvent(this.prevComponent, 505, e1.getWhen(), 0, (int)this.prevPoint.getX() - (int)this.prevOff.getX(), (int)this.prevPoint.getY() - (int)this.prevOff.getY(), e1.getClickCount(), e1.isPopupTrigger());
                    e2 = PSwingMouseEvent.createMouseEvent(e_temp.getID(), e_temp, aEvent);
                    this.dispatchEvent(this.prevComponent, e2);
                    this.prevComponent = null;
                    if (e1.getID() == 505) {
                        e1.consume();
                    }
                } else if (this.prevComponent != comp) {
                    e_temp = new MouseEvent(this.prevComponent, 505, e1.getWhen(), 0, (int)this.prevPoint.getX() - (int)this.prevOff.getX(), (int)this.prevPoint.getY() - (int)this.prevOff.getY(), e1.getClickCount(), e1.isPopupTrigger());
                    e2 = PSwingMouseEvent.createMouseEvent(e_temp.getID(), e_temp, aEvent);
                    this.dispatchEvent(this.prevComponent, e2);
                    e_temp = new MouseEvent(comp, 504, e1.getWhen(), 0, (int)this.prevPoint.getX() - offX, (int)this.prevPoint.getY() - offY, e1.getClickCount(), e1.isPopupTrigger());
                    e2 = PSwingMouseEvent.createMouseEvent(e_temp.getID(), e_temp, aEvent);
                    comp.dispatchEvent(e2);
                }
            } else if (comp != null) {
                e_temp = new MouseEvent(comp, 504, e1.getWhen(), 0, (int)this.prevPoint.getX() - offX, (int)this.prevPoint.getY() - offY, e1.getClickCount(), e1.isPopupTrigger());
                e2 = PSwingMouseEvent.createMouseEvent(e_temp.getID(), e_temp, aEvent);
                this.dispatchEvent(comp, e2);
            }
            this.prevComponent = comp;
            if (comp != null) {
                this.prevOff = new Point2D.Double(offX, offY);
            }
        }
    }

    private void dispatchEvent(final Component target, final PSwingMouseEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!(event.getSource().getClass().getName().endsWith("MappingComponent") && event.paramString().contains("RELEASED") && target instanceof JButton)) {
                    target.dispatchEvent(event);
                }
            }
        });
    }

    private void cameraToLocal(PCamera topCamera, Point2D pt, PNode node) {
        try {
            topCamera.getViewTransform().inverseTransform(pt, pt);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        if (node != null) {
            node.globalToLocal(pt);
        }
    }

    public void processEvent(PInputEvent aEvent, int type) {
        if (aEvent.isMouseEvent()) {
            InputEvent sourceSwingEvent = aEvent.getSourceSwingEvent();
            PSwingMouseEvent pSwingMouseEvent = PSwingMouseEvent.createMouseEvent(sourceSwingEvent.getID(), (MouseEvent)sourceSwingEvent, aEvent);
            if (!this.recursing) {
                this.recursing = true;
                this.dispatchEvent(pSwingMouseEvent, aEvent);
                this.recursing = false;
            }
        }
    }
}

