/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cismap.commons.drophandler.builtin;

import lombok.Getter;

import org.apache.log4j.Logger;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;

import java.io.File;

import javax.swing.ImageIcon;

import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.ExifReader;

import de.cismet.tools.gui.ImageUtil;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class MappingComponentGeoImageFileDropHandlerInfoComponent extends javax.swing.JPanel {

    //~ Static fields/initializers ---------------------------------------------

    private static final int MAX_IMAGE_WIDTH = 320;
    private static final int MAX_IMAGE_HEIGHT = 240;

    //~ Instance fields --------------------------------------------------------

    @Getter private final File imageFile;
    private final ImageIcon reducedIcon;
    private final int reducedWidth;
    private final int reducedHeight;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form MappingComponentImageFileDropHandlerAnno.
     *
     * @param  imageFile  DOCUMENT ME!
     */
    public MappingComponentGeoImageFileDropHandlerInfoComponent(final File imageFile) {
        this.imageFile = imageFile;
        final Image origImage = ImageUtil.loadImageAccordingToExifOrientation(imageFile);

        reducedIcon = new ImageIcon(ImageUtil.resizeOnScale(origImage, MAX_IMAGE_WIDTH, MAX_IMAGE_HEIGHT));
        reducedWidth = reducedIcon.getIconWidth();
        reducedHeight = reducedIcon.getIconHeight();
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();

        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setIcon(reducedIcon);
        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(
                MappingComponentGeoImageFileDropHandlerInfoComponent.class,
                "MappingComponentGeoImageFileDropHandlerInfoComponent.jLabel1.text")); // NOI18N
        jLabel1.setToolTipText(imageFile.getAbsolutePath());
        jLabel1.setMaximumSize(new Dimension(reducedWidth, reducedHeight));
        jLabel1.setMinimumSize(new Dimension(reducedWidth, reducedHeight));
        jLabel1.setPreferredSize(new Dimension(reducedWidth, reducedHeight));
        jLabel1.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseClicked(final java.awt.event.MouseEvent evt) {
                    jLabel1MouseClicked(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jLabel1MouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_jLabel1MouseClicked
        if (evt.getClickCount() > 1) {
            BrowserLauncher.openURLorFile(imageFile.getAbsolutePath());
        }
    }                                                                       //GEN-LAST:event_jLabel1MouseClicked
}
