/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * QueryEditorDialog.java
 *
 * Created on 27. Februar 2008, 15:17
 */
package de.cismet.cismap.commons.featureservice;

import java.awt.Frame;

import javax.swing.JDialog;

/**
 * DOCUMENT ME!
 *
 * @author   nh
 * @version  $Revision$, $Date$
 */
public class QueryEditorDialog extends JDialog {

    //~ Static fields/initializers ---------------------------------------------

    public static final int RET_OK = 1;
    public static final int RET_CANCEL = 0;

    //~ Instance fields --------------------------------------------------------

    /** A return status code - returned if Cancel button has been pressed. */
    private int returnStatus = RET_CANCEL;
    private String query;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cmdCancel;
    private javax.swing.JButton cmdOK;
    private javax.swing.JEditorPane edtQuery;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel panButtons;
    private javax.swing.JPanel panEditor;
    private javax.swing.JPanel panMain;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form QueryEditorDialog.
     *
     * @param  parent  DOCUMENT ME!
     * @param  modal   DOCUMENT ME!
     * @param  query   DOCUMENT ME!
     */
    public QueryEditorDialog(final Frame parent, final boolean modal, final String query) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(parent);
        this.query = query;
        edtQuery.setText(query);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  the return status of this dialog - one of RET_OK or RET_CANCEL
     */
    public int getReturnStatus() {
        return returnStatus;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  the changed querystring
     */
    public String getQueryString() {
        return query;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        panMain = new javax.swing.JPanel();
        panEditor = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        edtQuery = new javax.swing.JEditorPane();
        panButtons = new javax.swing.JPanel();
        cmdOK = new javax.swing.JButton();
        cmdCancel = new javax.swing.JButton();

        setTitle(org.openide.util.NbBundle.getMessage(QueryEditorDialog.class, "QueryEditorDialog.title")); // NOI18N
        setMinimumSize(new java.awt.Dimension(550, 400));
        addWindowListener(new java.awt.event.WindowAdapter() {

                @Override
                public void windowClosing(final java.awt.event.WindowEvent evt) {
                    closeDialog(evt);
                }
            });

        panMain.setLayout(new java.awt.BorderLayout());

        panEditor.setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panEditor.setLayout(new java.awt.BorderLayout());

        edtQuery.setContentType("text/xml");
        jScrollPane1.setViewportView(edtQuery);

        panEditor.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        panMain.add(panEditor, java.awt.BorderLayout.CENTER);

        getContentPane().add(panMain, java.awt.BorderLayout.CENTER);

        panButtons.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 5, -5));
        panButtons.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT, 10, 0));

        cmdOK.setText(org.openide.util.NbBundle.getMessage(QueryEditorDialog.class, "QueryEditorDialog.cmdOK.text")); // NOI18N
        cmdOK.setMaximumSize(new java.awt.Dimension(88, 23));
        cmdOK.setMinimumSize(new java.awt.Dimension(88, 23));
        cmdOK.setPreferredSize(new java.awt.Dimension(88, 23));
        cmdOK.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cmdOKActionPerformed(evt);
                }
            });
        panButtons.add(cmdOK);

        cmdCancel.setText(org.openide.util.NbBundle.getMessage(
                QueryEditorDialog.class,
                "QueryEditorDialog.cmdCancel.text")); // NOI18N
        cmdCancel.setMaximumSize(new java.awt.Dimension(88, 23));
        cmdCancel.setMinimumSize(new java.awt.Dimension(88, 23));
        cmdCancel.setPreferredSize(new java.awt.Dimension(88, 23));
        cmdCancel.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cmdCancelActionPerformed(evt);
                }
            });
        panButtons.add(cmdCancel);

        getContentPane().add(panButtons, java.awt.BorderLayout.SOUTH);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * Closes the dialog.
     *
     * @param  evt  DOCUMENT ME!
     */
    private void closeDialog(final java.awt.event.WindowEvent evt) { //GEN-FIRST:event_closeDialog
        doClose(RET_CANCEL);
    }                                                                //GEN-LAST:event_closeDialog

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cmdOKActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cmdOKActionPerformed
        // neues Query zur\u00FCckgeben
        query = edtQuery.getText();
        doClose(RET_OK);
    } //GEN-LAST:event_cmdOKActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cmdCancelActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cmdCancelActionPerformed
        doClose(RET_CANCEL);
    }                                                                             //GEN-LAST:event_cmdCancelActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  retStatus  DOCUMENT ME!
     */
    private void doClose(final int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }
}
