/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cismap.commons.gui.options;

import org.apache.log4j.Logger;

import org.jdom.Element;

import org.openide.util.NbBundle;
import org.openide.util.lookup.ServiceProvider;

import java.awt.Color;

import javax.swing.JPanel;

import de.cismet.cismap.commons.interaction.CismapBroker;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsCategory;
import de.cismet.lookupoptions.OptionsPanelController;

import de.cismet.tools.configuration.NoWriteError;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
@ServiceProvider(service = OptionsPanelController.class)
public class GPSDirectionOptions extends AbstractOptionsPanel implements OptionsPanelController {

    //~ Static fields/initializers ---------------------------------------------

    private static final String OPTION_NAME = NbBundle.getMessage(
            GPSDirectionOptions.class,
            "GPSDirectionOptions.OPTION_NAME");
    private static Logger LOG = Logger.getLogger(GPSDirectionOptions.class);
    private static final String CONFIGURATION = "GPSDirectionOptions";
    private static final String GPS_ANGLE_DIRECTION_CONFIG = "GpsAngleDirection";

    //~ Enums ------------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    public static enum GPSDirection {

        //~ Enum constants -----------------------------------------------------

        AUTO, CW, CCW
    }

    //~ Instance fields --------------------------------------------------------

    private GPSDirection direction = GPSDirection.AUTO;
    private boolean stillConfigured = false;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup bgDirection;
    private javax.swing.JRadioButton rbAuto;
    private javax.swing.JRadioButton rbClockwise;
    private javax.swing.JRadioButton rbCounterClockwise;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form GPSDirectionOptions.
     */
    public GPSDirectionOptions() {
        super(OPTION_NAME, CismapOptionsCategory.class);
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        bgDirection = new javax.swing.ButtonGroup();
        rbAuto = new javax.swing.JRadioButton();
        rbClockwise = new javax.swing.JRadioButton();
        rbCounterClockwise = new javax.swing.JRadioButton();

        setLayout(new java.awt.GridBagLayout());

        bgDirection.add(rbAuto);
        org.openide.awt.Mnemonics.setLocalizedText(
            rbAuto,
            org.openide.util.NbBundle.getMessage(
                GPSDirectionOptions.class,
                "GPSDirectionOptions.rbAuto.text",
                new Object[] {})); // NOI18N
        rbAuto.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    rbAutoActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 0, 5);
        add(rbAuto, gridBagConstraints);

        bgDirection.add(rbClockwise);
        org.openide.awt.Mnemonics.setLocalizedText(
            rbClockwise,
            org.openide.util.NbBundle.getMessage(
                GPSDirectionOptions.class,
                "GPSDirectionOptions.rbClockwise.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        add(rbClockwise, gridBagConstraints);

        bgDirection.add(rbCounterClockwise);
        org.openide.awt.Mnemonics.setLocalizedText(
            rbCounterClockwise,
            org.openide.util.NbBundle.getMessage(
                GPSDirectionOptions.class,
                "GPSDirectionOptions.rbCounterClockwise.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        add(rbCounterClockwise, gridBagConstraints);
    }                              // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void rbAutoActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_rbAutoActionPerformed
        // TODO add your handling code here:
    } //GEN-LAST:event_rbAutoActionPerformed

    @Override
    public int getOrder() {
        return 4;
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(GPSDirectionOptions.class, "GPSDirectionOptions.tooltip");
    }

    @Override
    public void applyChanges() {
        direction = getSelectedValue();

        CismapBroker.getInstance().setGpsAngleDirection(direction);
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private GPSDirection getSelectedValue() {
        if (rbAuto.isSelected()) {
            return GPSDirection.AUTO;
        } else if (rbClockwise.isSelected()) {
            return GPSDirection.CW;
        } else if (rbCounterClockwise.isSelected()) {
            return GPSDirection.CCW;
        } else {
            return GPSDirection.AUTO;
        }
    }

    @Override
    public void update() {
        direction = CismapBroker.getInstance().getGpsAngleDirection();

        if (direction == null) {
            rbAuto.setSelected(true);
        } else if (direction.equals(GPSDirection.AUTO)) {
            rbAuto.setSelected(true);
        } else if (direction.equals(GPSDirection.CW)) {
            rbClockwise.setSelected(true);
        } else if (direction.equals(GPSDirection.CCW)) {
            rbCounterClockwise.setSelected(true);
        }
    }

    @Override
    public boolean isChanged() {
        final GPSDirection selected = getSelectedValue();

        return (direction == null) || !direction.equals(selected);
    }

    @Override
    public void configure(final Element elmnt) {
        if (!stillConfigured) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configure GPSDirectionOptions");
            }
            int gpsAngleDirection = 0;
            try {
                String gpsDirection = "";
                if (elmnt != null) {
                    final Element conf = elmnt.getChild(CONFIGURATION);

                    if (conf != null) {
                        gpsDirection = conf.getChildText(GPS_ANGLE_DIRECTION_CONFIG);
                    }
                }
                try {
                    gpsAngleDirection = Integer.valueOf(gpsDirection);
                } catch (NumberFormatException ex) {
                    gpsAngleDirection = 0;
                }
            } catch (Exception ex) {
                LOG.error("Fehler beim Konfigurieren des SearchOptionsPanel", ex);
            }

            if ((gpsAngleDirection >= 0) && (gpsAngleDirection < GPSDirection.values().length)) {
                if (GPSDirection.values()[gpsAngleDirection].equals(GPSDirection.AUTO)) {
                    rbAuto.setSelected(true);
                } else if (GPSDirection.values()[gpsAngleDirection].equals(GPSDirection.CW)) {
                    rbClockwise.setSelected(true);
                } else if (GPSDirection.values()[gpsAngleDirection].equals(GPSDirection.CCW)) {
                    rbCounterClockwise.setSelected(true);
                }
            } else {
                rbAuto.setSelected(true);
            }

            stillConfigured = true;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("skip Configure SearchOptionsPanel - still configured");
            }
        }

        applyChanges();
    }

    @Override
    public Element getConfiguration() throws NoWriteError {
        final Element conf = new Element(CONFIGURATION);
        final Element GpsAngleElement = new Element(GPS_ANGLE_DIRECTION_CONFIG);

        GpsAngleElement.addContent(String.valueOf(direction.ordinal()));
        conf.addContent(GpsAngleElement);

        return conf;
    }
}
