/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * InfoPanel.java
 *
 * Created on 16. August 2007, 16:56
 */
package de.cismet.cismap.commons.gui.piccolo;

import edu.umd.cs.piccolo.PNode;

import pswing.PSwing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

import de.cismet.cismap.commons.interaction.CismapBroker;

import de.cismet.tools.CismetThreadPool;

/**
 * DOCUMENT ME!
 *
 * @author   hell
 * @version  $Revision$, $Date$
 */
public class InfoPanel extends JPanel {

    //~ Instance fields --------------------------------------------------------

    private final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(this.getClass());
    private ImageIcon icoMore = new ImageIcon(getClass().getResource("/de/cismet/cismap/commons/gui/res/more.png"));     // NOI18N
    private ImageIcon icoShrink = new ImageIcon(getClass().getResource("/de/cismet/cismap/commons/gui/res/shrink.png")); // NOI18N
    private PFeature pfeature;
    private PNode pNodeParent;
    private PSwing pSwing;
    private JComponent more;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cmdMore;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JLabel lblTitle;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form InfoPanel.
     *
     * @param  more  DOCUMENT ME!
     */
    public InfoPanel(final JComponent more) {
        super();
        try {
            initComponents();
            cmdMore.setIcon(icoMore);
            cmdMore.setText("");           // NOI18N
            cmdMore.setOpaque(false);
            this.more = more;
            if (more == null) {
                cmdMore.setVisible(false); // macht die Komponente zu klein
                // cmdMore.setEnabled(false);
            } else {
                this.add(more, BorderLayout.CENTER);
                more.setVisible(false);
                more.addComponentListener(new ComponentListener() {

                        @Override
                        public void componentHidden(final ComponentEvent e) {
                        }

                        @Override
                        public void componentMoved(final ComponentEvent e) {
                        }

                        @Override
                        public void componentResized(final ComponentEvent e) {
                            // TODO: calling revalidate outside the EDT looks like an error!
                            final Runnable t = new Thread("InfoPanel componentResized()") {

                                    @Override
                                    public void run() {
                                        revalidate();
                                    }
                                };
                            CismetThreadPool.execute(t);
                            pSwing.reshape();
                            // pNodeParent.repaint();
                            // pfeature.ensureFullVisibility();
                        }

                        @Override
                        public void componentShown(final ComponentEvent e) {
                        }
                    });
            }
        } catch (Throwable t) {
            log.error("Error in InfoPanel"); // NOI18N
        }
        // scptest.setVisible(false);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();
        lblTitle = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        cmdMore = new javax.swing.JButton();

        setBackground(java.awt.Color.lightGray);
        setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 4, 1, 4));
        setOpaque(false);
        setLayout(new java.awt.BorderLayout());

        jPanel1.setMinimumSize(new java.awt.Dimension(83, 42));
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.BorderLayout());

        lblTitle.setBackground(javax.swing.UIManager.getDefaults().getColor("Nb.Desktop.background"));
        lblTitle.setFont(new java.awt.Font("Tahoma", 0, 12));                                              // NOI18N
        lblTitle.setText(org.openide.util.NbBundle.getMessage(InfoPanel.class, "InfoPanel.jLabel1.text")); // NOI18N
        lblTitle.setBorder(javax.swing.BorderFactory.createEmptyBorder(8, 3, 8, 3));
        lblTitle.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseClicked(final java.awt.event.MouseEvent evt) {
                    lblTitleMouseClicked(evt);
                }
            });
        jPanel1.add(lblTitle, java.awt.BorderLayout.CENTER);

        jPanel2.setOpaque(false);

        cmdMore.setText(org.openide.util.NbBundle.getMessage(InfoPanel.class, "InfoPanel.cmdMore.text")); // NOI18N
        cmdMore.setBorderPainted(false);
        cmdMore.setFocusPainted(false);
        cmdMore.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cmdMoreActionPerformed(evt);
                }
            });
        jPanel2.add(cmdMore);

        jPanel1.add(jPanel2, java.awt.BorderLayout.LINE_END);

        add(jPanel1, java.awt.BorderLayout.NORTH);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lblTitleMouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_lblTitleMouseClicked
        cmdMoreActionPerformed(null);
    }                                                                        //GEN-LAST:event_lblTitleMouseClicked

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cmdMoreActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cmdMoreActionPerformed
        if (CismapBroker.getInstance().getMappingComponent().isInfoNodesVisible()) {
            setExpanded(!isExpanded());
        }
    }                                                                           //GEN-LAST:event_cmdMoreActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public boolean isExpanded() {
        return (more != null) && more.isVisible();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  expanded  DOCUMENT ME!
     */
    public void setExpanded(final boolean expanded) {
        setExpanded(expanded, true);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  expanded  DOCUMENT ME!
     * @param  rescale   DOCUMENT ME!
     */
    public void setExpanded(final boolean expanded, final boolean rescale) {
        if ((more != null) && (more.getComponentCount() > 0)) {
            more.setVisible(expanded);

            revalidate();

            if (more.isVisible()) {
                cmdMore.setIcon(icoShrink);
            } else {
                cmdMore.setIcon(icoMore);
            }
            pSwing.reshape();
            if (rescale) {
                pfeature.ensureFullVisibility();
            }
        }
    }

    @Override
    public void paintComponent(final Graphics g) {
        synchronized (getTreeLock()) {
            super.paintComponent(g);
            final Color myGrey = new Color(210, 210, 210);
            g.setColor(myGrey);
            g.fillRoundRect(2, 1, getWidth() - 4, getHeight() - 2, 10, 10);
            if (pNodeParent != null) {
                pNodeParent.setWidth(this.getWidth());
                pNodeParent.setHeight(this.getHeight());
            }
        }
    }

    @Override
    public void paint(final Graphics g) {
        // If the InfoPanel should be drawn offscreen, the size of the sub components must be set
        // and doLayout must be invoked. Otherwise the infoPanel will be drawn empty.
        synchronized (getTreeLock()) {
            doLayout();

            final Graphics gr = g.create();

            // Print the component
            printComponent(gr);

            // ... any border
            printBorder(gr);

            adjustSize(this);

            // ... and all of the children.
            for (int c = 0; c < getComponentCount(); c++) {
                final Component comp = getComponent(c);
                if (comp.isVisible()) {
                    final Rectangle cr = comp.getBounds();

                    final Graphics cg = gr.create(cr.x, cr.y, cr.width, cr.height);
                    comp.printAll(cg);
                }
            }
        }
    }

    /**
     * Adjusts the size of all sub components and invokes doLayout.
     *
     * @param  comp  DOCUMENT ME!
     */
    private void adjustSize(final JComponent comp) {
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            comp.getComponent(i).setSize(comp.getComponent(i).getPreferredSize());
            comp.getComponent(i).doLayout();

            if (comp.getComponent(i) instanceof JComponent) {
                adjustSize((JComponent)comp.getComponent(i));
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  text  DOCUMENT ME!
     */
    public void setTitleText(final String text) {
        lblTitle.setText(text);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  icon  DOCUMENT ME!
     */
    public void setTitleIcon(final Icon icon) {
        lblTitle.setIcon(icon);
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public PFeature getPfeature() {
        return pfeature;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  pfeature  DOCUMENT ME!
     */
    public void setPfeature(final PFeature pfeature) {
        this.pfeature = pfeature;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public PNode getPNodeParent() {
        return pNodeParent;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  pNodeParent  DOCUMENT ME!
     */
    public void setPNodeParent(final PNode pNodeParent) {
        this.pNodeParent = pNodeParent;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public PSwing getPSwing() {
        return pSwing;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  pSwing  DOCUMENT ME!
     */
    public void setPSwing(final PSwing pSwing) {
        this.pSwing = pSwing;
    }
}
