/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/*
 * DocumentProgressWidget.java
 *
 * Created on 22.09.2009, 11:24:40
 */
package de.cismet.cismap.commons.gui.progresswidgets;

import org.apache.log4j.Logger;

import java.awt.Component;
import java.awt.event.MouseMotionListener;

import javax.swing.plaf.basic.BasicInternalFrameUI;

/**
 * Displays the loading progress of Documents, e.g. SHP Files.
 *
 * @author   Pascal Dihé
 * @version  $Revision$, $Date$
 */
public class DocumentProgressWidget extends javax.swing.JInternalFrame {

    //~ Instance fields --------------------------------------------------------

    protected final Logger logger = Logger.getLogger(this.getClass());

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JLabel serviceLabel;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DocumentProgressWidget.
     */
    public DocumentProgressWidget() {
        // JInternalFrame fixieren, indem alle MouseMotionListener der Statusbar entfernt werden
        try {
            final BasicInternalFrameUI fui = (BasicInternalFrameUI)getUI();
            final Component north = fui.getNorthPane();
            final MouseMotionListener[] listener = (MouseMotionListener[])north.getListeners(MouseMotionListener.class);
            for (int i = 0; i < listener.length; i++) {
                north.removeMouseMotionListener(listener[i]);
            }
        } catch (Exception e) {
            logger.error("Fehler beim Entfernen von Mousemotionlisteners", e);
        }

        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  name  DOCUMENT ME!
     */
    public void setServiceName(final String name) {
        this.serviceLabel.setText(name);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  progress  DOCUMENT ME!
     */
    public void setProgress(final int progress) {
        if (logger.isDebugEnabled()) {
            logger.debug("setting progress: " + progress);
        }
        if (progress == -1) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(progress);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        final javax.swing.JPanel mainPanel = new javax.swing.JPanel();
        progressBar = new javax.swing.JProgressBar();
        final javax.swing.JLabel iconLabel = new javax.swing.JLabel();
        serviceLabel = new javax.swing.JLabel();
        final javax.swing.JLabel messageLabel = new javax.swing.JLabel();

        progressBar.setPreferredSize(new java.awt.Dimension(360, 20));

        iconLabel.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cismap/commons/gui/res/blockdevice.png"))); // NOI18N

        serviceLabel.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        serviceLabel.setText("Service Name");

        messageLabel.setText(org.openide.util.NbBundle.getMessage(
                DocumentProgressWidget.class,
                "DocumentProgressWidget.messageLabel")); // NOI18N

        final javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
                mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(
                    mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(
                        progressBar,
                        javax.swing.GroupLayout.PREFERRED_SIZE,
                        360,
                        javax.swing.GroupLayout.PREFERRED_SIZE).addGroup(
                        mainPanelLayout.createSequentialGroup().addComponent(iconLabel).addPreferredGap(
                            javax.swing.LayoutStyle.ComponentPlacement.RELATED).addGroup(
                            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
                                mainPanelLayout.createSequentialGroup().addComponent(messageLabel).addGap(
                                    51,
                                    51,
                                    51)).addComponent(
                                serviceLabel,
                                javax.swing.GroupLayout.DEFAULT_SIZE,
                                javax.swing.GroupLayout.DEFAULT_SIZE,
                                Short.MAX_VALUE)))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
                mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(
                    mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false).addGroup(
                        mainPanelLayout.createSequentialGroup().addComponent(serviceLabel).addPreferredGap(
                            javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(messageLabel))
                                .addComponent(iconLabel, javax.swing.GroupLayout.Alignment.TRAILING)).addPreferredGap(
                    javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(
                    progressBar,
                    javax.swing.GroupLayout.PREFERRED_SIZE,
                    20,
                    javax.swing.GroupLayout.PREFERRED_SIZE).addContainerGap(20, Short.MAX_VALUE)));

        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);

        pack();
    } // </editor-fold>//GEN-END:initComponents
}
