/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * WFSFormTester.java
 *
 * Created on 25. Juli 2006, 17:38
 */
package de.cismet.cismap.commons.wfsforms;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;

import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

import java.awt.BorderLayout;
import java.awt.Dimension;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

import java.util.Vector;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten.hell@cismet.de
 * @version  $Revision$, $Date$
 */
public class WFSFormTester extends AbstractWFSForm {

    //~ Instance fields --------------------------------------------------------

    private final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(this.getClass());

    private WFSFormFeature strasse = null;
    private WFSFormFeature nr = null;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox cboNr;
    private javax.swing.JComboBox cboStreets;
    private javax.swing.JButton cmdOk;
    private javax.swing.JProgressBar prbNr;
    private javax.swing.JProgressBar prbStreets;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form WFSFormTester.
     */
    public WFSFormTester() {
        if (log.isDebugEnabled()) {
            log.debug("new WFSFormTester");                       // NOI18N
        }
        initComponents();
        StaticSwingTools.decorateWithFixedAutoCompleteDecorator(cboStreets);
        StaticSwingTools.decorateWithFixedAutoCompleteDecorator(cboNr);
        prbStreets.setPreferredSize(new Dimension(10, 5));
        prbNr.setPreferredSize(new Dimension(10, 5));
        listComponents.put("cboAllStreets", cboStreets);          // NOI18N
        listComponents.put("cboAllStreetsProgress", prbStreets);  // NOI18N
        listComponents.put("cboNumbersOfAStreet", cboNr);         // NOI18N
        listComponents.put("cboNumbersOfAStreetProgress", prbNr); // NOI18N
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void garbageDuringAutoCompletion(final JComboBox box) {
    }
    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        cboStreets = new javax.swing.JComboBox();
        cboNr = new javax.swing.JComboBox();
        cmdOk = new javax.swing.JButton();
        prbStreets = new javax.swing.JProgressBar();
        prbNr = new javax.swing.JProgressBar();

        cboStreets.setEnabled(false);
        cboStreets.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cboStreetsActionPerformed(evt);
                }
            });
        cboStreets.addKeyListener(new java.awt.event.KeyAdapter() {

                @Override
                public void keyTyped(final java.awt.event.KeyEvent evt) {
                    cboStreetsKeyTyped(evt);
                }
            });

        cboNr.setEnabled(false);
        cboNr.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cboNrActionPerformed(evt);
                }
            });

        cmdOk.setText(org.openide.util.NbBundle.getMessage(WFSFormTester.class, "WFSFormTester.cmdOk.text")); // NOI18N

        prbStreets.setBorderPainted(false);

        prbNr.setBorderPainted(false);

        final org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
                layout.createSequentialGroup().addContainerGap().add(
                    layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        prbStreets,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        Short.MAX_VALUE).add(
                        org.jdesktop.layout.GroupLayout.LEADING,
                        cboStreets,
                        0,
                        236,
                        Short.MAX_VALUE)).addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED).add(
                    layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false).add(
                        prbNr,
                        0,
                        0,
                        Short.MAX_VALUE).add(cboNr, 0, 60, Short.MAX_VALUE)).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(cmdOk).addContainerGap(194, Short.MAX_VALUE)));

        layout.linkSize(
            new java.awt.Component[] { cboStreets, prbStreets },
            org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.linkSize(new java.awt.Component[] { cboNr, prbNr }, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
                layout.createSequentialGroup().addContainerGap().add(
                    layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(
                        cboStreets,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(
                        cboNr,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(cmdOk)).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(
                    layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING).add(
                        prbStreets,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(
                        prbNr,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).addContainerGap(
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                    Short.MAX_VALUE)));
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cboNrActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cboNrActionPerformed
// TODO add your handling code here:
    } //GEN-LAST:event_cboNrActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cboStreetsKeyTyped(final java.awt.event.KeyEvent evt) { //GEN-FIRST:event_cboStreetsKeyTyped
        if (cboNr.getSelectedItem() instanceof WFSFormFeature) {
            nr = (WFSFormFeature)cboNr.getSelectedItem();
        } else {
            nr = null;
        }
    }                                                                    //GEN-LAST:event_cboStreetsKeyTyped

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cboStreetsActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cboStreetsActionPerformed
//        log.debug(!cboStreets.isPopupVisible());
//        String s="";
//        if (cboStreets.getSelectedItem()!=null)  {
//            s=cboStreets.getSelectedItem().getClass().toString();
//        }
//        log.debug(cboStreets.getSelectedItem()+":::"+s);
        if (cboStreets.getSelectedItem() instanceof WFSFormFeature) {
            strasse = (WFSFormFeature)cboStreets.getSelectedItem();
            requestRefresh("cboNumbersOfAStreet", (WFSFormFeature)cboStreets.getSelectedItem()); // NOI18N
        }
    }                                                                                            //GEN-LAST:event_cboStreetsActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param   args  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    public static void main(final String[] args) throws Exception {
        try {
            // javax.swing.UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName()) ;
            // javax.swing.UIManager.setLookAndFeel(new Plastic3DLookAndFeel());
            // javax.swing.UIManager.setLookAndFeel(new PlasticLookAndFeel());
            javax.swing.UIManager.setLookAndFeel(new PlasticXPLookAndFeel());
            // javax.swing.UIManager.setLookAndFeel(new com.sun.java.swing.plaf.windows.WindowsLookAndFeel());
            // UIManager.setLookAndFeel(new PlasticLookAndFeel()); javax.swing.UIManager.setLookAndFeel(new
            // PlasticXPLookAndFeel());
        } catch (Exception e) {
            e.printStackTrace();
        }
        final WFSFormQuery allStreets = new WFSFormQuery();
        allStreets.setComponentName("cboAllStreets");                                                     // NOI18N
        allStreets.setServerUrl("http://s103bdc-a1/deegreewfs/wfs");                                      // NOI18N
        allStreets.setDisplayTextProperty("geographicIdentifier");                                        // NOI18N
        allStreets.setExtentProperty("geographicExtent");                                                 // NOI18N
        allStreets.setFilename("/request_all_streets.xml");                                               // NOI18N
        allStreets.setId("all_streets");                                                                  // NOI18N
        allStreets.setIdProperty("identifier");                                                           // NOI18N
        allStreets.setTitle("Strassen");                                                                  // NOI18N
        allStreets.setType(WFSFormQuery.INITIAL);
        allStreets.setWfsQueryString(readFileAsString(new File("C:\\request_alle_strassen_extent.xml"))); // NOI18N

        final WFSFormQuery numbers = new WFSFormQuery();
        numbers.setComponentName("cboNumbersOfAStreet");                                                          // NOI18N
        numbers.setServerUrl("http://s103bdc-a1/deegreewfs/wfs");                                                 // NOI18N
        numbers.setDisplayTextProperty("geographicIdentifier");                                                   // NOI18N
        numbers.setExtentProperty("geographicExtent");                                                            // NOI18N
        numbers.setFilename("/request_all_numbers.xml");                                                          // NOI18N
        numbers.setId("numbers");                                                                                 // NOI18N
        numbers.setIdProperty("identifier");                                                                      // NOI18N
        numbers.setTitle("Nr");                                                                                   // NOI18N
        numbers.setType(WFSFormQuery.FOLLOWUP);
        numbers.setQueryPlaceholder("@@strasse_id@@");                                                            // NOI18N
        numbers.setWfsQueryString(readFileAsString(new File("C:\\request_hausnummern_from_strasse_extent.xml"))); // NOI18N
        final Vector<WFSFormQuery> v = new Vector<WFSFormQuery>();
        v.add(allStreets);
        v.add(numbers);

        final WFSFormTester tester = new WFSFormTester();
        tester.setQueries(v);
        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    final JFrame f = new JFrame();
                    f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                    f.getContentPane().setLayout(new BorderLayout());
                    f.getContentPane().add(tester, BorderLayout.CENTER);
                    f.setVisible(true);
                    f.pack();
                }
            });
        tester.initWFSForm();
    }

    @Override
    public JComponent getListComponentByName(final String name) {
        return listComponents.get(name);
    }

    /**
     * DOCUMENT ME!
     *
     * @param   file  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  java.io.IOException  DOCUMENT ME!
     */
    private static String readFileAsString(final File file) throws java.io.IOException {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        final StringBuffer fileData = new StringBuffer(1000);
        final BufferedReader reader = new BufferedReader(
                new FileReader(file));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            final String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}
