/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.deegree.io.geotiff.GeoTiffException;
import org.deegree.io.geotiff.GeoTiffReader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImageFileRetrievalTest {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGeoTiffReader() throws IOException, GeoTiffException, URISyntaxException {
        String geoTiffName = "geotiff.tif";
        Assert.assertNotNull((Object)this.getClass().getResource("geotiff.tif"));
        File file = new File(this.getClass().getResource("geotiff.tif").toURI());
        Assert.assertTrue((boolean)file.canRead());
        GeoTiffReader geoTiffReader = new GeoTiffReader(file);
        Assert.assertNotNull((Object)geoTiffReader);
        Assert.assertNotNull((Object)geoTiffReader.getTIFFImage());
        Assert.assertEquals((Object)"<empty>", (Object)geoTiffReader.getHumanReadableCoordinateSystem());
        Assert.assertEquals((long)1L, (long)geoTiffReader.getGTModelTypeGeoKey());
        Assert.assertEquals((Object)"min = Position: 793450.4967766507 6342804.112485806 max = Position: 794471.126986027 6343386.195819735", (Object)geoTiffReader.getBoundingBox().toString());
        Assert.assertEquals((long)163L, (long)geoTiffReader.getTIFFImage().getNumYTiles());
        Assert.assertEquals((long)487L, (long)geoTiffReader.getTIFFImage().getHeight());
        Assert.assertEquals((long)0L, (long)geoTiffReader.getTIFFImage().getMinTileX());
        Assert.assertEquals((long)1L, (long)geoTiffReader.getTIFFImage().getNumXTiles());
    }
}

