/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.commons.cismap.io.converters.AbstractGeometryFromTextConverter;
import de.cismet.commons.converter.ConversionException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AbstractGeometryFromTextConverterTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private String getCurrentMethodName() {
        return new Throwable().getStackTrace()[1].getMethodName();
    }

    @Test
    public void testConvertForward() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        AbstractGeometryFromTextConverterImpl conv = new AbstractGeometryFromTextConverterImpl();
        String from = "1 2:3;4\t5\n6  7     \n\t\n\t\t\n    8";
        String[] params = new String[]{"4326"};
        conv.convertForward(from, params);
        Object[] expected = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0), new Coordinate(7.0, 8.0)};
        Assert.assertEquals((long)4L, (long)conv.coordinates.length);
        Assert.assertArrayEquals((Object[])expected, (Object[])conv.coordinates);
        Assert.assertEquals((long)4326L, (long)conv.geomFactory.getSRID());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertForwardNullFrom() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        AbstractGeometryFromTextConverterImpl conf = new AbstractGeometryFromTextConverterImpl();
        conf.convertForward(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertForwardEmptyFrom() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        AbstractGeometryFromTextConverterImpl conf = new AbstractGeometryFromTextConverterImpl();
        conf.convertForward("", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertForwardNullParams() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        AbstractGeometryFromTextConverterImpl conf = new AbstractGeometryFromTextConverterImpl();
        conf.convertForward("abc", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertForwardTooFewParams() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        AbstractGeometryFromTextConverterImpl conf = new AbstractGeometryFromTextConverterImpl();
        conf.convertForward("abc", new String[0]);
    }

    @Test(expected=ConversionException.class)
    public void testConvertForwardUnEvenNumberOfCoords() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        AbstractGeometryFromTextConverterImpl conf = new AbstractGeometryFromTextConverterImpl();
        conf.convertForward("abcde", new String[]{"12345"});
    }

    @Test(expected=ConversionException.class)
    public void testConvertForwardUnsupportedEPSG() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        AbstractGeometryFromTextConverterImpl conf = new AbstractGeometryFromTextConverterImpl();
        conf.convertForward("abcde fghij", new String[]{"myEpsg"});
    }

    @Test
    public void testGetDecimalSeparator() {
        System.out.println("TEST " + this.getCurrentMethodName());
        AbstractGeometryFromTextConverterImpl conf = new AbstractGeometryFromTextConverterImpl();
        char defaultSep = ((DecimalFormat)NumberFormat.getInstance(Locale.getDefault())).getDecimalFormatSymbols().getDecimalSeparator();
        System.setProperty(AbstractGeometryFromTextConverter.SYS_PROP_DECIMAL_SEP, ".");
        Assert.assertEquals((long)46L, (long)conf.getDecimalSeparator());
        System.setProperty(AbstractGeometryFromTextConverter.SYS_PROP_DECIMAL_SEP, "0x20");
        Assert.assertEquals((long)defaultSep, (long)conf.getDecimalSeparator());
        System.setProperty(AbstractGeometryFromTextConverter.SYS_PROP_DECIMAL_SEP, "0x3D");
        Assert.assertEquals((long)61L, (long)conf.getDecimalSeparator());
        System.setProperty(AbstractGeometryFromTextConverter.SYS_PROP_DECIMAL_SEP, "\\u0040");
        Assert.assertEquals((long)64L, (long)conf.getDecimalSeparator());
        System.setProperty(AbstractGeometryFromTextConverter.SYS_PROP_DECIMAL_SEP, String.valueOf(defaultSep));
    }

    @Test
    public void testConvertBackward() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        AbstractGeometryFromTextConverterImpl conv = new AbstractGeometryFromTextConverterImpl();
        PrecisionModel pm = new PrecisionModel(PrecisionModel.FLOATING);
        GeometryFactory gf = new GeometryFactory(pm, 4326);
        Point g = gf.createPoint(new Coordinate(54.65, 23.44));
        String result = conv.convertBackward((Geometry)g, null);
        String expected = this.createExpected((Geometry)g);
        Assert.assertEquals((Object)expected, (Object)result);
        g = gf.createLineString(new Coordinate[0]);
        result = conv.convertBackward((Geometry)g, new String[]{""});
        expected = this.createExpected((Geometry)g);
        Assert.assertEquals((Object)expected, (Object)result);
        g = gf.createLineString(new Coordinate[]{new Coordinate(33.33, 44.44), new Coordinate(33.32, 2.0), new Coordinate(37.33, 4.0), new Coordinate(32.45, 22.0), new Coordinate(3.9, 55.3), new Coordinate(1.0, 44.45)});
        result = conv.convertBackward((Geometry)g, new String[]{""});
        expected = this.createExpected((Geometry)g);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private String createExpected(Geometry g) {
        StringBuilder expected = new StringBuilder();
        String[] coordString = this.getCoorindateString(g.getCoordinates());
        for (int i = 0; i < coordString.length; ++i) {
            expected.append(coordString[i]);
            expected.append(i % 2 == 0 ? (char)' ' : '\n');
        }
        return expected.toString();
    }

    private String[] getCoorindateString(Coordinate[] coords) {
        NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
        String[] result = new String[coords.length * 2];
        for (int i = 0; i < coords.length; ++i) {
            result[i * 2] = nf.format(coords[i].x);
            result[i * 2 + 1] = nf.format(coords[i].y);
        }
        return result;
    }

    private class AbstractGeometryFromTextConverterImpl
    extends AbstractGeometryFromTextConverter {
        Coordinate[] coordinates;
        GeometryFactory geomFactory;

        private AbstractGeometryFromTextConverterImpl() {
        }

        public Geometry createGeometry(Coordinate[] coordinates, GeometryFactory geomFactory) throws ConversionException {
            this.coordinates = coordinates;
            this.geomFactory = geomFactory;
            return null;
        }

        public String getFormatName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getFormatDisplayName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getFormatHtmlName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getFormatDescription() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getFormatHtmlDescription() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object getFormatExample() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

