/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.commons.cismap.io.converters.GeomFromWktConverter;
import de.cismet.commons.converter.ConversionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GeomFromWktConverterTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private String getCurrentMethodName() {
        return new Throwable().getStackTrace()[1].getMethodName();
    }

    @Test
    public void testConvertForward() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        GeomFromWktConverter conv = new GeomFromWktConverter();
        String wkt = "POINT(1.13 2)";
        Geometry resGeom = conv.convertForward("POINT(1.13 2)", new String[]{"4326"});
        Assert.assertNotNull((Object)resGeom);
        Assert.assertEquals((long)4326L, (long)resGeom.getSRID());
        Assert.assertEquals((long)1L, (long)resGeom.getCoordinates().length);
        Assert.assertEquals((Object)new Coordinate(1.13, 2.0), (Object)resGeom.getCoordinates()[0]);
        Assert.assertEquals((Object)"Point", (Object)resGeom.getGeometryType());
        String ewkt = "SRID=3021;POINT(1.13 2)";
        resGeom = conv.convertForward("SRID=3021;POINT(1.13 2)", new String[]{"4326"});
        Assert.assertNotNull((Object)resGeom);
        Assert.assertEquals((long)3021L, (long)resGeom.getSRID());
        Assert.assertEquals((long)1L, (long)resGeom.getCoordinates().length);
        Assert.assertEquals((Object)new Coordinate(1.13, 2.0), (Object)resGeom.getCoordinates()[0]);
        Assert.assertEquals((Object)"Point", (Object)resGeom.getGeometryType());
    }

    @Test(expected=ConversionException.class)
    public void testConvertForwardIllegalEwkt() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        GeomFromWktConverter conv = new GeomFromWktConverter();
        conv.convertForward("SRID=abc;bla", new String[]{"4326"});
    }

    @Test(expected=ConversionException.class)
    public void testConvertForwardIllegalWkt() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        GeomFromWktConverter conv = new GeomFromWktConverter();
        conv.convertForward("abc", new String[]{"4326"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertForwardNullFrom() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        GeomFromWktConverter conv = new GeomFromWktConverter();
        conv.convertForward(null, (String[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertForwardEmptyFrom() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        GeomFromWktConverter conf = new GeomFromWktConverter();
        conf.convertForward("", (String[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertForwardNullParams() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        GeomFromWktConverter conv = new GeomFromWktConverter();
        conv.convertForward("abc", (String[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertForwardTooFewParams() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        GeomFromWktConverter conv = new GeomFromWktConverter();
        conv.convertForward("abc", new String[0]);
    }

    @Test
    public void testConvertBackward() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        GeomFromWktConverter conv = new GeomFromWktConverter();
        PrecisionModel pm = new PrecisionModel(PrecisionModel.FLOATING);
        GeometryFactory gf = new GeometryFactory(pm, 4326);
        Point geom = gf.createPoint(new Coordinate(1.13, 2.0));
        String wkt = conv.convertBackward((Geometry)geom, (String[])null);
        Assert.assertNotNull((Object)wkt);
        Assert.assertEquals((Object)"POINT (1.13 2)", (Object)wkt);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertBackwardToNull() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        GeomFromWktConverter conv = new GeomFromWktConverter();
        conv.convertBackward(null, (String[])null);
    }
}

