/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.actions;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cismap.actions.WaitDialog;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.CommonFeatureAction;
import de.cismet.cismap.commons.features.CommonMultiAndSingleFeatureAction;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeaturesProvider;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class DuplicateGeometryFeatureAction
extends AbstractAction
implements CommonFeatureAction,
FeaturesProvider,
CommonMultiAndSingleFeatureAction {
    Feature f = null;
    List<Feature> featureList;
    private final transient Logger log = Logger.getLogger(this.getClass());

    public DuplicateGeometryFeatureAction() {
        super(NbBundle.getMessage(DuplicateGeometryFeatureAction.class, (String)"DuplicateGeometryFeatureAction.DuplicateGeometryFeatureAction()"));
        super.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/actions/raisePoly.png")));
    }

    @Override
    public int getSorter() {
        return 1;
    }

    @Override
    public Feature getSourceFeature() {
        return this.f;
    }

    @Override
    public boolean isActive() {
        return !(this.f instanceof PureNewFeature);
    }

    @Override
    public void setSourceFeature(Feature source) {
        this.f = source;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final WaitDialog wd = new WaitDialog();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                StaticSwingTools.showDialog((JDialog)wd);
            }
        });
        CismetThreadPool.execute((Runnable)new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Thread.currentThread().setName("DuplicateGeometryFeatureAction");
                if (DuplicateGeometryFeatureAction.this.featureList != null) {
                    for (Feature feature : DuplicateGeometryFeatureAction.this.featureList) {
                        Geometry geom = (Geometry)feature.getGeometry().clone();
                        PureNewFeature pnf = new PureNewFeature(geom);
                        if (geom instanceof LineString || geom instanceof MultiLineString) {
                            pnf.setGeometryType(AbstractNewFeature.geomTypes.LINESTRING);
                        } else if (geom instanceof Polygon) {
                            pnf.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                        } else if (geom instanceof MultiPolygon) {
                            pnf.setGeometryType(AbstractNewFeature.geomTypes.MULTIPOLYGON);
                        } else if (geom instanceof Point || geom instanceof MultiPoint) {
                            pnf.setGeometryType(AbstractNewFeature.geomTypes.POINT);
                        } else {
                            pnf.setGeometryType(AbstractNewFeature.geomTypes.UNKNOWN);
                        }
                        pnf.setEditable(true);
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature(pnf);
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().holdFeature(pnf);
                    }
                } else {
                    Geometry geom = (Geometry)DuplicateGeometryFeatureAction.this.f.getGeometry().clone();
                    PureNewFeature pnf = new PureNewFeature(geom);
                    if (geom instanceof LineString || geom instanceof MultiLineString) {
                        pnf.setGeometryType(AbstractNewFeature.geomTypes.LINESTRING);
                    } else if (geom instanceof Polygon) {
                        pnf.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                    } else if (geom instanceof MultiPolygon) {
                        pnf.setGeometryType(AbstractNewFeature.geomTypes.MULTIPOLYGON);
                    } else if (geom instanceof Point || geom instanceof MultiPoint) {
                        pnf.setGeometryType(AbstractNewFeature.geomTypes.POINT);
                    } else {
                        pnf.setGeometryType(AbstractNewFeature.geomTypes.UNKNOWN);
                    }
                    pnf.setEditable(true);
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature(pnf);
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().holdFeature(pnf);
                }
                return null;
            }

            @Override
            protected void done() {
                wd.setVisible(false);
                wd.dispose();
            }
        });
    }

    public static void main(String[] args) {
        WaitDialog w = new WaitDialog();
        w.setVisible(true);
    }

    @Override
    public void setSourceFeatures(List<Feature> sourceList) {
        this.featureList = sourceList;
        super.putValue("Name", NbBundle.getMessage(DuplicateGeometryFeatureAction.class, (String)"DuplicateGeometryFeatureAction.DuplicateGeometriesFeatureAction()", (Object[])new Object[]{sourceList.size()}));
    }

    @Override
    public List<Feature> getSourceFeatures() {
        return this.featureList;
    }

    @Override
    public boolean isResponsibleFor(Feature feature) {
        return true;
    }
}

