/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.actions;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.CheckedFeaturesProvider;
import de.cismet.cismap.commons.features.CommonFeatureAction;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class MergeFeatureAction
extends AbstractAction
implements CommonFeatureAction,
CheckedFeaturesProvider {
    private static final Logger LOG = Logger.getLogger(MergeFeatureAction.class);
    Feature f = null;
    List<Feature> features = new ArrayList<Feature>();

    public MergeFeatureAction() {
        super(NbBundle.getMessage(MergeFeatureAction.class, (String)"MergeFeatureAction.MergeFeatureAction()"));
        super.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/actions/arrow-join.png")));
    }

    @Override
    public int getSorter() {
        return 1;
    }

    @Override
    public Feature getSourceFeature() {
        return this.f;
    }

    @Override
    public boolean isActive() {
        return CismapBroker.getInstance().getMappingComponent().getFeatureCollection().getSelectedFeatures().size() > 1;
    }

    @Override
    public void setSourceFeature(Feature source) {
        this.f = source;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CismetThreadPool.execute((Runnable)new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Thread.currentThread().setName("MergeFeatureAction");
                ArrayList<Geometry> allGeoms = new ArrayList<Geometry>(MergeFeatureAction.this.features.size());
                for (Feature f : MergeFeatureAction.this.features) {
                    allGeoms.add(f.getGeometry());
                }
                GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.getCurrentSrid());
                Geometry geometryCollection = gf.buildGeometry(allGeoms);
                Geometry geom = geometryCollection.union();
                PureNewFeature pnf = new PureNewFeature(geom);
                if (geom instanceof LineString || geom instanceof MultiLineString) {
                    pnf.setGeometryType(AbstractNewFeature.geomTypes.LINESTRING);
                } else if (geom instanceof Polygon) {
                    pnf.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                } else if (geom instanceof MultiPolygon) {
                    pnf.setGeometryType(AbstractNewFeature.geomTypes.MULTIPOLYGON);
                } else if (geom instanceof Point || geom instanceof MultiPoint) {
                    pnf.setGeometryType(AbstractNewFeature.geomTypes.POINT);
                } else {
                    pnf.setGeometryType(AbstractNewFeature.geomTypes.UNKNOWN);
                }
                pnf.setEditable(true);
                CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature(pnf);
                CismapBroker.getInstance().getMappingComponent().getFeatureCollection().holdFeature(pnf);
                CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeatures(MergeFeatureAction.this.features);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem while merging geometries.", (Throwable)e);
                    ErrorInfo errorInfo = new ErrorInfo(NbBundle.getMessage(MergeFeatureAction.class, (String)"MergeFeatureAction.actionPerformed().done().title"), NbBundle.getMessage(MergeFeatureAction.class, (String)"MergeFeatureAction.actionPerformed().done().message"), null, null, (Throwable)e, Level.ALL, null);
                    JXErrorPane.showDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), (ErrorInfo)errorInfo);
                }
            }
        });
    }

    @Override
    public boolean isResponsibleFor(Feature feature) {
        return feature instanceof PureNewFeature;
    }

    @Override
    public void setSourceFeatures(List<Feature> source) {
        this.features.clear();
        this.features.addAll(source);
    }

    @Override
    public List<Feature> getSourceFeatures() {
        return this.features;
    }

    @Override
    public boolean isActiveForFeatures(List<Feature> source) {
        String type = null;
        for (Feature tmp : source) {
            if (tmp == null || tmp.getGeometry() == null) continue;
            if (type == null) {
                type = this.getGeometryType(tmp.getGeometry());
            } else if (!type.equals(this.getGeometryType(tmp.getGeometry()))) {
                return false;
            }
            if (!(tmp.getGeometry() instanceof Point) && !(tmp.getGeometry() instanceof MultiPoint)) continue;
            return false;
        }
        return source.size() > 1;
    }

    private String getGeometryType(Geometry geom) {
        if (geom instanceof MultiPolygon || geom instanceof Polygon) {
            return "polygon";
        }
        if (geom instanceof MultiLineString || geom instanceof LineString) {
            return "linestring";
        }
        if (geom instanceof MultiPoint || geom instanceof Point) {
            return "point";
        }
        return "unknown";
    }
}

