/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.actions;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LineStringExtracter;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import de.cismet.cismap.actions.WaitDialog;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.CommonFeatureAction;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class SplitFeatureAction
extends AbstractAction
implements CommonFeatureAction {
    private static final Logger LOG = Logger.getLogger(SplitFeatureAction.class);
    Feature currentFeature = null;

    public SplitFeatureAction() {
        super(NbBundle.getMessage(SplitFeatureAction.class, (String)"SplitFeatureAction.SplitFeatureAction()"));
        super.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/actions/arrow-split.png")));
    }

    @Override
    public int getSorter() {
        return 1;
    }

    @Override
    public Feature getSourceFeature() {
        return this.currentFeature;
    }

    @Override
    public boolean isActive() {
        return this.currentFeature instanceof PureNewFeature && this.currentFeature.getGeometry() instanceof Polygon && this.getIntersectingLineFeatureIfUnambigous(this.currentFeature) != null;
    }

    @Override
    public void setSourceFeature(Feature source) {
        this.currentFeature = source;
    }

    public static Geometry polygonize(Geometry geometry) {
        List lines = LineStringExtracter.getLines((Geometry)geometry);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add((Collection)lines);
        Collection polys = polygonizer.getPolygons();
        Polygon[] polyArray = GeometryFactory.toPolygonArray((Collection)polys);
        return geometry.getFactory().createGeometryCollection((Geometry[])polyArray);
    }

    public static Geometry splitPolygon(Geometry poly, Geometry line) {
        Geometry nodedLinework = poly.getBoundary().union(line);
        Geometry polys = SplitFeatureAction.polygonize(nodedLinework);
        ArrayList<Polygon> output = new ArrayList<Polygon>();
        for (int i = 0; i < polys.getNumGeometries(); ++i) {
            Polygon candpoly = (Polygon)polys.getGeometryN(i);
            if (!poly.contains((Geometry)candpoly.getInteriorPoint())) continue;
            output.add(candpoly);
        }
        return poly.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray(output));
    }

    private Feature getIntersectingLineFeatureIfUnambigous(Feature polygonfeature) {
        Feature lineFeature = null;
        for (Feature f : CismapBroker.getInstance().getMappingComponent().getFeatureCollection().getAllFeatures()) {
            if (f == polygonfeature || !(f.getGeometry() instanceof LineString) || !polygonfeature.getGeometry().intersects(f.getGeometry())) continue;
            if (lineFeature == null) {
                lineFeature = f;
                continue;
            }
            return null;
        }
        return lineFeature;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CismetThreadPool.execute((Runnable)new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Thread.currentThread().setName("SplitGeometryFeatureAction");
                Feature lineFeature = SplitFeatureAction.this.getIntersectingLineFeatureIfUnambigous(SplitFeatureAction.this.currentFeature);
                Geometry splitResult = SplitFeatureAction.splitPolygon(SplitFeatureAction.this.currentFeature.getGeometry(), lineFeature.getGeometry());
                if (splitResult instanceof GeometryCollection) {
                    for (int i = 0; i < ((GeometryCollection)splitResult).getNumGeometries(); ++i) {
                        Geometry geom = ((GeometryCollection)splitResult).getGeometryN(i);
                        PureNewFeature pnf = new PureNewFeature((Geometry)geom.clone());
                        if (geom instanceof LineString || geom instanceof MultiLineString) {
                            pnf.setGeometryType(AbstractNewFeature.geomTypes.LINESTRING);
                        } else if (geom instanceof Polygon) {
                            pnf.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                        } else if (geom instanceof MultiPolygon) {
                            pnf.setGeometryType(AbstractNewFeature.geomTypes.MULTIPOLYGON);
                        } else if (geom instanceof Point || geom instanceof MultiPoint) {
                            pnf.setGeometryType(AbstractNewFeature.geomTypes.POINT);
                        } else {
                            pnf.setGeometryType(AbstractNewFeature.geomTypes.UNKNOWN);
                        }
                        pnf.setEditable(true);
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature(pnf);
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().holdFeature(pnf);
                    }
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature(lineFeature);
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature(SplitFeatureAction.this.currentFeature);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while splitting geometries.", (Throwable)e);
                    ErrorInfo errorInfo = new ErrorInfo(NbBundle.getMessage(SplitFeatureAction.class, (String)"SplitFeatureAction.actionPerformed().done().title"), NbBundle.getMessage(SplitFeatureAction.class, (String)"SplitFeatureAction.actionPerformed().done().message"), null, null, (Throwable)e, Level.ALL, null);
                    JXErrorPane.showDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), (ErrorInfo)errorInfo);
                }
            }
        });
    }

    public static void main(String[] args) {
        WaitDialog w = new WaitDialog();
        w.setVisible(true);
    }
}

