/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.WorldToScreenTransform;
import edu.umd.cs.piccolo.util.PBounds;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.apache.log4j.Logger;
import org.jdom.DataConversionException;
import org.jdom.Element;

@Deprecated
public class BoundingBox
implements Cloneable,
Serializable {
    private final transient Logger log = Logger.getLogger(this.getClass());
    private double x1 = -1.0;
    private double y1 = -1.0;
    private double x2 = -1.0;
    private double y2 = -1.0;

    public BoundingBox() {
    }

    public BoundingBox(Element parent) throws DataConversionException {
        Element conf = parent.getChild("BoundingBox");
        this.setX1(conf.getAttribute("x1").getDoubleValue());
        this.setY1(conf.getAttribute("y1").getDoubleValue());
        this.setX2(conf.getAttribute("x2").getDoubleValue());
        this.setY2(conf.getAttribute("y2").getDoubleValue());
    }

    public BoundingBox(Geometry geom) {
        Geometry bb = geom.getEnvelope();
        if (geom instanceof Point) {
            this.setX1(((Point)geom).getX());
            this.setX2(((Point)geom).getX());
            this.setY1(((Point)geom).getY());
            this.setY2(((Point)geom).getY());
        } else if (bb instanceof Polygon) {
            this.setX1(((Polygon)bb).getExteriorRing().getCoordinateN((int)0).x);
            this.setY1(((Polygon)bb).getExteriorRing().getCoordinateN((int)0).y);
            this.setX2(((Polygon)bb).getExteriorRing().getCoordinateN((int)2).x);
            this.setY2(((Polygon)bb).getExteriorRing().getCoordinateN((int)2).y);
        } else if (bb instanceof LineString) {
            bb = bb.buffer(1.0).getEnvelope();
            this.setX1(((Polygon)bb).getExteriorRing().getCoordinateN((int)0).x);
            this.setY1(((Polygon)bb).getExteriorRing().getCoordinateN((int)0).y);
            this.setX2(((Polygon)bb).getExteriorRing().getCoordinateN((int)2).x);
            this.setY2(((Polygon)bb).getExteriorRing().getCoordinateN((int)2).y);
        } else {
            this.log.fatal((Object)("BoundingBox was not created by jtsGeometry:" + geom));
        }
    }

    public BoundingBox(double x1, double y1, double x2, double y2) {
        if (x1 <= x2) {
            this.x1 = x1;
            this.x2 = x2;
        } else {
            this.x1 = x2;
            this.x2 = x1;
        }
        if (y1 <= y2) {
            this.y1 = y1;
            this.y2 = y2;
        } else {
            this.y1 = y2;
            this.y2 = y1;
        }
    }

    public double getX1() {
        if (this.x1 <= this.x2) {
            return this.x1;
        }
        return this.x2;
    }

    public void setX1(double x1) {
        this.x1 = x1;
    }

    public double getY1() {
        if (this.y1 <= this.y2) {
            return this.y1;
        }
        return this.y2;
    }

    public void setY1(double y1) {
        this.y1 = y1;
    }

    public double getX2() {
        if (this.x2 > this.x1) {
            return this.x2;
        }
        return this.x1;
    }

    public void setX2(double x2) {
        this.x2 = x2;
    }

    public double getY2() {
        if (this.y2 > this.y1) {
            return this.y2;
        }
        return this.y1;
    }

    public void setY2(double y2) {
        this.y2 = y2;
    }

    public Geometry getGeometry(int srid) {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
        Envelope envelope = new Envelope(this.x1, this.x2, this.y1, this.y2);
        return factory.toGeometry(envelope);
    }

    public String toString() {
        return "(" + BoundingBox.round(this.getX1()) + "," + BoundingBox.round(this.getY1()) + "," + BoundingBox.round(this.getX2()) + "," + BoundingBox.round(this.getY2()) + ")";
    }

    public String getURLString() {
        return this.getURLString(false);
    }

    public String getURLString(boolean reverseOrder) {
        if (reverseOrder) {
            return this.getY1() + "," + this.getX1() + "," + this.getY2() + "," + this.getX2();
        }
        return this.getX1() + "," + this.getY1() + "," + this.getX2() + "," + this.getY2();
    }

    public String getGeometryFromTextLineString() {
        return "LINESTRING(" + this.getX1() + " " + this.getY1() + "," + this.getX2() + " " + this.getY2() + ")";
    }

    public String getGeometryFromTextCompatibleString() {
        return "BOX3D(" + this.getURLString() + ")";
    }

    public Logger getLog() {
        return this.log;
    }

    public PBounds getPBounds(WorldToScreenTransform wtst) {
        return new PBounds(wtst.getScreenX(this.x1), wtst.getScreenY(this.y2), this.x2 - this.x1, wtst.getScreenY(this.y1) - wtst.getScreenY(this.y2));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.x1) ^ Double.doubleToLongBits(this.x1) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.y1) ^ Double.doubleToLongBits(this.y1) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.x2) ^ Double.doubleToLongBits(this.x2) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.y2) ^ Double.doubleToLongBits(this.y2) >>> 32);
        return hash;
    }

    public boolean equals(Object other) {
        if (other instanceof BoundingBox) {
            BoundingBox bb = (BoundingBox)other;
            return this.getX1() == bb.getX1() && this.getX2() == bb.getX2() && this.getY1() == bb.getY1() && this.getY2() == bb.getY2();
        }
        return false;
    }

    public Object clone() {
        return new BoundingBox(this.x1, this.y1, this.x2, this.y2);
    }

    public static String round(double d) {
        double dd = (double)Math.round(d * 100.0) / 100.0;
        String pattern = "0.00";
        DecimalFormat myFormatter = new DecimalFormat("0.00");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator('.');
        myFormatter.setDecimalFormatSymbols(symbols);
        return myFormatter.format(d);
    }

    public Element getJDOMElement() {
        Element e = new Element("BoundingBox");
        e.setAttribute("x1", new Double(this.x1).toString());
        e.setAttribute("y1", new Double(this.y1).toString());
        e.setAttribute("x2", new Double(this.x2).toString());
        e.setAttribute("y2", new Double(this.y2).toString());
        return e;
    }

    public double getWidth() {
        return Math.abs(this.x2 - this.x1);
    }

    public double getHeight() {
        return Math.abs(this.y2 - this.y1);
    }

    public String toGmlString() {
        return "<gml:Box><gml:coord><gml:X>" + this.getX1() + "</gml:X><gml:Y>" + this.getY1() + "</gml:Y></gml:coord><gml:coord><gml:X>" + this.getX2() + "</gml:X><gml:Y>" + this.getY2() + "</gml:Y></gml:coord></gml:Box>";
    }

    public String toGml4WFS110String() {
        return "<gml:Envelope><gml:lowerCorner>" + this.getX1() + " " + this.getY1() + "</gml:lowerCorner><gml:upperCorner>" + this.getX2() + " " + this.getY2() + "</gml:upperCorner></gml:Envelope>";
    }

    public void increase(int percentage) {
        double factor = (double)percentage / 2.0 / 100.0;
        double additionalWidth = this.getWidth() * factor;
        double additionalHeight = this.getHeight() * factor;
        this.setX1(this.getX1() - additionalWidth);
        this.setX2(this.getX2() + additionalWidth);
        this.setY1(this.getY1() - additionalHeight);
        this.setY2(this.getY2() + additionalHeight);
    }

    public boolean isValid() {
        return this.x1 != Double.NaN && this.x2 != Double.NaN && this.y1 != Double.NaN && this.y2 != Double.NaN;
    }
}

