/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons;

import de.cismet.cismap.commons.ConvertableToXML;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.ModeLayer;
import de.cismet.cismap.commons.ModeLayerRegistry;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.XMLObjectFactory;
import de.cismet.cismap.commons.featureservice.DocumentFeatureService;
import de.cismet.cismap.commons.featureservice.JDBCFeatureService;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.featureservice.SimplePostgisFeatureService;
import de.cismet.cismap.commons.featureservice.SimpleUpdateablePostgisFeatureService;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.LayerCollection;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.raster.wms.SlidableWMSServiceLayerGroup;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.rasterservice.ImageRasterService;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

public class CidsLayerFactory {
    private static final Logger LOG = Logger.getLogger(CidsLayerFactory.class);
    private static boolean DEBUG = true;

    public static ServiceLayer createLayer(Element element, HashMap<String, WMSCapabilities> capabilities, ActiveLayerModel model) {
        block46: {
            if (DEBUG && LOG.isDebugEnabled()) {
                LOG.debug((Object)("trying to create Layer '" + element.getName() + "'"));
            }
            try {
                if (element.getName().equals("WMSServiceLayer")) {
                    WMSServiceLayer wmsServiceLayer = new WMSServiceLayer(element, capabilities);
                    try {
                        if (wmsServiceLayer.getWMSLayers().size() > 0) {
                            try {
                                LOG.info((Object)("createLayer WMSServiceLayer (" + wmsServiceLayer.getName() + ")"));
                                return wmsServiceLayer;
                            }
                            catch (IllegalArgumentException schonVorhanden) {
                                LOG.warn((Object)("Layer WMSServiceLayer '" + wmsServiceLayer.getName() + "' already existed. Do not add the Layer. \n" + schonVorhanden.getMessage()));
                            }
                        }
                        break block46;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while initialising WMS", (Throwable)e);
                    }
                    break block46;
                }
                if (element.getName().equals("WebFeatureServiceLayer")) {
                    WebFeatureService wfs = new WebFeatureService(element);
                    if (EventQueue.isDispatchThread()) {
                        LOG.fatal((Object)"InvokeLater in EDT");
                    }
                    try {
                        LOG.info((Object)("addLayer WebFeatureServiceLayer (" + wfs.getName() + ")"));
                        return wfs;
                    }
                    catch (IllegalArgumentException schonVorhanden) {
                        LOG.warn((Object)("Layer WebFeatureServiceLayer '" + wfs.getName() + "' already existed. Do not add the Layer. \n" + schonVorhanden.getMessage()));
                    }
                } else if (element.getName().equals("DocumentFeatureServiceLayer")) {
                    LOG.error((Object)"DocumentFeatureServiceLayer not supported");
                } else if (element.getName().equals("simpleWms")) {
                    SimpleWMS simpleWMS = new SimpleWMS(element);
                    LOG.info((Object)("addLayer SimpleWMS (" + simpleWMS.getName() + ")"));
                    try {
                        return simpleWMS;
                    }
                    catch (IllegalArgumentException schonVorhanden) {
                        LOG.warn((Object)("Layer SimpleWMS '" + simpleWMS.getName() + "' already existed. Do not add the Layer. \n" + schonVorhanden.getMessage()));
                    }
                } else if (element.getName().equals("ImageRasterService")) {
                    ImageRasterService rasterService = new ImageRasterService(element);
                    LOG.info((Object)("addLayer image raster service (" + rasterService.getName() + ")"));
                    try {
                        return rasterService;
                    }
                    catch (IllegalArgumentException schonVorhanden) {
                        LOG.warn((Object)("Layer ImageRasterService '" + rasterService.getName() + "' already existed. Do not add the Layer. \n" + schonVorhanden.getMessage()));
                    }
                } else if (element.getName().equals("SlidableWMSServiceLayerGroup")) {
                    SlidableWMSServiceLayerGroup wms = new SlidableWMSServiceLayerGroup(element, capabilities);
                    LOG.info((Object)("addLayer SlidableWMSServiceLayerGroup (" + wms.getName() + ")"));
                    try {
                        return wms;
                    }
                    catch (IllegalArgumentException schonVorhanden) {
                        LOG.warn((Object)("Layer SimpleWMS '" + wms.getName() + "' already existed. Do not add the Layer. \n" + schonVorhanden.getMessage()));
                    }
                } else if (element.getName().equals("simplePostgisFeatureService")) {
                    SimplePostgisFeatureService spfs = element.getAttributeValue("updateable") != null && element.getAttributeValue("updateable").equals("true") ? new SimpleUpdateablePostgisFeatureService(element) : new SimplePostgisFeatureService(element);
                    SimplePostgisFeatureService simplePostgisFeatureService = spfs;
                    try {
                        LOG.info((Object)("addLayer SimplePostgisFeatureService (" + simplePostgisFeatureService.getName() + ")"));
                        return simplePostgisFeatureService;
                    }
                    catch (IllegalArgumentException schonVorhanden) {
                        LOG.warn((Object)("Layer SimplePostgisFeatureService '" + simplePostgisFeatureService.getName() + "' already existed. Do not add the Layer. \n" + schonVorhanden.getMessage()));
                    }
                } else if (element.getName().equals("LayerCollection")) {
                    LayerCollection lc = new LayerCollection(element, capabilities, model);
                    try {
                        LOG.info((Object)("addLayer LayerCollection (" + lc.getName() + ")"));
                        return lc;
                    }
                    catch (IllegalArgumentException schonVorhanden) {
                        LOG.warn((Object)("Layer LayerCollection '" + lc.getName() + "' already existed. Do not add the Layer. \n" + schonVorhanden.getMessage()));
                    }
                } else {
                    if (element.getName().equals("ModeLayer")) {
                        ModeLayer modeLayer = new ModeLayer();
                        String selectedMode = element.getAttributeValue("mode");
                        String modeLayerKey = element.getAttributeValue("key");
                        modeLayer.setLayerKey(modeLayerKey);
                        Iterator modeIt = element.getChildren("Mode").iterator();
                        String first = null;
                        while (modeIt.hasNext()) {
                            Element mode = (Element)modeIt.next();
                            String key = mode.getAttributeValue("key");
                            if (first == null) {
                                first = key;
                            }
                            Element layerDef = (Element)mode.getChildren().get(0);
                            ServiceLayer layer = CidsLayerFactory.createLayer(layerDef, capabilities, model);
                            modeLayer.putModeLayer(key, (RetrievalServiceLayer)layer);
                        }
                        if (selectedMode == null) {
                            modeLayer.setMode(first);
                        } else {
                            modeLayer.setMode(selectedMode);
                        }
                        ModeLayerRegistry.getInstance().putModeLayer(modeLayerKey, modeLayer);
                        return modeLayer;
                    }
                    try {
                        if (DEBUG && LOG.isDebugEnabled()) {
                            LOG.debug((Object)("restoring generic layer configuration from xml element '" + element.getName() + "'"));
                        }
                        RetrievalServiceLayer layer = (RetrievalServiceLayer)XMLObjectFactory.restoreObjectfromElement(element);
                        try {
                            LOG.info((Object)("addLayer generic layer configuration (" + layer.getName() + ")"));
                            return layer;
                        }
                        catch (IllegalArgumentException schonVorhanden) {
                            LOG.warn((Object)("Layer SimplePostgisFeatureService '" + layer.getName() + "' already existed. Do not add the Layer. \n" + schonVorhanden.getMessage()));
                        }
                    }
                    catch (Throwable t) {
                        LOG.error((Object)("unsupported xml configuration, layer '" + element.getName() + "' could not be created: \n" + t.getLocalizedMessage()), t);
                    }
                }
            }
            catch (Throwable t) {
                LOG.error((Object)("Layer layer '" + element.getName() + "' could not be created: \n" + t.getMessage()), t);
            }
        }
        return null;
    }

    public static String getKeyforLayerElement(Element layerelement) {
        Object keyString = null;
        if (layerelement != null) {
            try {
                if (layerelement.getName().equals("WMSServiceLayer")) {
                    WMSServiceLayer wmsServiceLayer = new WMSServiceLayer(layerelement, new HashMap<String, WMSCapabilities>());
                    return CidsLayerFactory.getKeyForRetrievalService(wmsServiceLayer);
                }
                if (layerelement.getName().equals("WebFeatureServiceLayer")) {
                    WebFeatureService wfs = new WebFeatureService(layerelement);
                    return CidsLayerFactory.getKeyForRetrievalService(wfs);
                }
                if (!layerelement.getName().equals("DocumentFeatureServiceLayer")) {
                    if (layerelement.getName().equals("simpleWms")) {
                        SimpleWMS simpleWMS = new SimpleWMS(layerelement);
                        return CidsLayerFactory.getKeyForRetrievalService(simpleWMS);
                    }
                    if (layerelement.getName().equals("simplePostgisFeatureService")) {
                        SimplePostgisFeatureService spfs = layerelement.getAttributeValue("updateable") != null && layerelement.getAttributeValue("updateable").equals("true") ? new SimpleUpdateablePostgisFeatureService(layerelement) : new SimplePostgisFeatureService(layerelement);
                        return CidsLayerFactory.getKeyForRetrievalService(spfs);
                    }
                    if (layerelement.getName().equals("SlidableWMSServiceLayerGroup")) {
                        SlidableWMSServiceLayerGroup slidableWms = new SlidableWMSServiceLayerGroup(layerelement, new HashMap<String, WMSCapabilities>());
                        ActiveLayerEvent event = new ActiveLayerEvent();
                        event.setLayer(slidableWms);
                        slidableWms.layerRemoved(event);
                        return CidsLayerFactory.getKeyForRetrievalService(slidableWms);
                    }
                    if (layerelement.getName().equals("ModeLayer")) {
                        return "ModeLayer#" + layerelement.getAttributeValue("key");
                    }
                    if (layerelement.getName().equals("LayerCollection")) {
                        return "LayerCollection#" + layerelement.getAttributeValue("name");
                    }
                    RetrievalServiceLayer layer = (RetrievalServiceLayer)XMLObjectFactory.restoreObjectfromElement(layerelement);
                    return CidsLayerFactory.getKeyForRetrievalService(layer);
                }
                LOG.warn((Object)"Sollte nicht vorkommen. Die sollten alle von der XMLObjectFactory geladen werden.");
            }
            catch (Exception ex) {
                LOG.error((Object)("Konnte keinen Key f\u00fcr das layerelement " + (layerelement.getName() != null ? layerelement.getName() : "null erstellen")), (Throwable)ex);
            }
        }
        return null;
    }

    private static String getKeyForRetrievalService(RetrievalServiceLayer layer) {
        if (layer != null) {
            try {
                if (layer instanceof WMSServiceLayer) {
                    WMSServiceLayer wmsServiceLayer = (WMSServiceLayer)layer;
                    return wmsServiceLayer.getName() + "#" + wmsServiceLayer.getCapabilitiesUrl();
                }
                if (layer instanceof WebFeatureService) {
                    WebFeatureService wfs = (WebFeatureService)layer;
                    return wfs.getName() + "#" + wfs.getHostname();
                }
                if (layer instanceof DocumentFeatureService) {
                    DocumentFeatureService dfs = (DocumentFeatureService)layer;
                    return dfs.getName() + dfs.getDocumentURI();
                }
                if (layer instanceof SimpleWMS) {
                    SimpleWMS simpleWMS = (SimpleWMS)layer;
                    return simpleWMS.getName() + "#" + simpleWMS.getGmUrl().getUrlTemplate();
                }
                if (layer instanceof SimplePostgisFeatureService) {
                    SimplePostgisFeatureService spfs = (SimplePostgisFeatureService)layer;
                    return spfs.getName() + "#" + spfs.getConnectionInfo().getUrl();
                }
                if (layer instanceof SlidableWMSServiceLayerGroup) {
                    SlidableWMSServiceLayerGroup wms = (SlidableWMSServiceLayerGroup)layer;
                    return wms.getName() + "#" + wms.getName();
                }
                if (layer instanceof ImageRasterService) {
                    ImageRasterService rs = (ImageRasterService)layer;
                    return rs.getName() + "#" + rs.getLayerURI();
                }
                RetrievalServiceLayer rsl = layer;
                return rsl.getName() + "#" + rsl.getClass();
            }
            catch (Exception ex) {
                LOG.error((Object)"Konnte keinen Key f\u00fcr das layerelement erstellen", (Throwable)ex);
            }
        }
        return null;
    }

    public static void wmsSpecificConfiguration(RetrievalServiceLayer layer, String preferredBGColor, String preferredExceptionsFormat, String preferredRasterFormat, Crs srs) {
        if (layer instanceof WMSServiceLayer) {
            WMSServiceLayer wmsLayer = (WMSServiceLayer)layer;
            if (wmsLayer.getBackgroundColor() == null) {
                wmsLayer.setBackgroundColor(preferredBGColor);
            }
            if (wmsLayer.getExceptionsFormat() == null) {
                wmsLayer.setExceptionsFormat(preferredExceptionsFormat);
            }
            if (wmsLayer.getImageFormat() == null) {
                wmsLayer.setImageFormat(preferredRasterFormat);
            }
            wmsLayer.setSrs(srs.getCode());
        } else if (layer instanceof SlidableWMSServiceLayerGroup) {
            ((SlidableWMSServiceLayerGroup)layer).setSrs(srs.getCode());
        } else if (layer instanceof ModeLayer) {
            ModeLayer ml = (ModeLayer)layer;
            Set<String> modes = ml.getModes();
            for (String mode : modes) {
                CidsLayerFactory.wmsSpecificConfiguration(ml.getModeLayer(mode), preferredBGColor, preferredExceptionsFormat, preferredRasterFormat, srs);
            }
        }
    }

    public static void setLayerToCrs(Crs crs, Object layer) {
        if (layer instanceof WMSServiceLayer) {
            ((WMSServiceLayer)layer).setSrs(crs.getCode());
        } else if (layer instanceof SlidableWMSServiceLayerGroup) {
            ((SlidableWMSServiceLayerGroup)layer).setSrs(crs.getCode());
        } else if (layer instanceof WebFeatureService) {
            ((WebFeatureService)layer).setCrs(crs);
        } else if (layer instanceof ShapeFileFeatureService) {
            ((ShapeFileFeatureService)layer).setCrs(crs);
        } else if (layer instanceof LayerCollection) {
            ((LayerCollection)layer).setCrs(crs);
        } else if (layer instanceof ModeLayer) {
            ((ModeLayer)layer).setCrs(crs);
        } else if (layer instanceof JDBCFeatureService) {
            ((JDBCFeatureService)layer).setCrs(crs);
        } else {
            LOG.error((Object)("The SRS of a layer cannot be changed. Layer is of type  " + layer.getClass().getName()));
        }
    }

    public static Element getElement(Object layer) {
        if (layer instanceof WMSServiceLayer) {
            return ((WMSServiceLayer)layer).getElement();
        }
        if (layer instanceof SimpleWMS) {
            return ((SimpleWMS)layer).getElement();
        }
        if (layer instanceof WebFeatureService) {
            return ((WebFeatureService)layer).toElement();
        }
        if (layer instanceof DocumentFeatureService) {
            return ((DocumentFeatureService)layer).toElement();
        }
        if (layer instanceof SimplePostgisFeatureService) {
            return ((SimplePostgisFeatureService)layer).toElement();
        }
        if (layer instanceof LayerCollection) {
            return ((LayerCollection)layer).toElement();
        }
        if (layer instanceof SimpleUpdateablePostgisFeatureService) {
            return ((SimpleUpdateablePostgisFeatureService)layer).toElement();
        }
        if (layer instanceof SlidableWMSServiceLayerGroup) {
            return ((SlidableWMSServiceLayerGroup)layer).toElement();
        }
        if (layer instanceof ModeLayer) {
            return ((ModeLayer)layer).toElement();
        }
        if (layer instanceof ConvertableToXML) {
            return ((ConvertableToXML)layer).toElement();
        }
        if (layer instanceof JDBCFeatureService) {
            return ((JDBCFeatureService)layer).toElement();
        }
        if (layer instanceof ImageRasterService) {
            return ((ImageRasterService)layer).getElement();
        }
        LOG.warn((Object)("saving configuration not supported by service: " + layer));
        return null;
    }

    public static Element[] orderLayers(Element layersElement) {
        List layerElements = layersElement.getChildren();
        Element[] orderedLayerElements = new Element[layerElements.size()];
        int i = 0;
        for (Element layerElement : layerElements) {
            int layerPosition = -1;
            Attribute layerPositionAttr = layerElement.getAttribute("layerPosition");
            if (layerPositionAttr != null) {
                try {
                    layerPosition = layerPositionAttr.getIntValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (layerPosition < 0 || layerPosition >= orderedLayerElements.length) {
                LOG.warn((Object)("layer position of layer #" + i + " (" + layerElement.getName() + ") not set or invalid, setting to " + i));
                layerPosition = i;
            }
            if (orderedLayerElements[layerPosition] != null) {
                LOG.warn((Object)("conflicting layer position " + layerPosition + ": '" + layerElement.getName() + "' vs '" + orderedLayerElements[layerPosition].getName() + "'"));
                for (int j = 0; j < orderedLayerElements.length; ++j) {
                    if (orderedLayerElements[j] != null) continue;
                    orderedLayerElements[j] = layerElement;
                    break;
                }
            } else {
                orderedLayerElements[layerPosition] = layerElement;
            }
            if (DEBUG && LOG.isDebugEnabled()) {
                LOG.debug((Object)(i + " layer '" + layerElement.getName() + "' set to position " + layerPosition));
            }
            ++i;
        }
        return orderedLayerElements;
    }
}

