/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.interaction.CismapBroker;
import edu.umd.cs.piccolo.PNode;
import groovy.lang.GroovyShell;
import java.awt.Component;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.deegree.crs.components.Unit;
import org.deegree.model.crs.CRSFactory;
import org.deegree.model.crs.CRSTransformationException;
import org.deegree.model.crs.CoordinateSystem;
import org.deegree.model.crs.GeoTransformer;
import org.deegree.model.crs.UnknownCRSException;
import org.deegree.model.spatialschema.Geometry;
import org.deegree.model.spatialschema.GeometryException;
import org.deegree.model.spatialschema.JTSAdapter;
import org.openide.util.NbBundle;

public class CrsTransformer {
    private static final transient Logger LOG = Logger.getLogger(CrsTransformer.class);
    private static final Map<String, String> CRS_CORRECTION_FORMULA;
    private static GroovyShell SHELL;
    private final GeoTransformer transformer;
    private final CoordinateSystem crs;
    private final String destCrsAsString;

    public CrsTransformer(String destCrs) throws UnknownCRSException, InvalidParameterException {
        this.destCrsAsString = destCrs;
        this.transformer = new GeoTransformer(destCrs);
        this.crs = CRSFactory.create((String)destCrs);
    }

    public String getDestinationCrs() {
        return this.destCrsAsString;
    }

    public BoundingBox transformBoundingBox(BoundingBox bbox, String sourceCrs) throws UnknownCRSException, CRSTransformationException, IllegalArgumentException {
        if (CrsTransformer.isDefaultCrs(sourceCrs)) {
            sourceCrs = CismapBroker.getInstance().getDefaultCrs();
        }
        CoordinateSystem coordSystem = CRSFactory.create((String)sourceCrs);
        org.deegree.model.spatialschema.Point minPoint = org.deegree.model.spatialschema.GeometryFactory.createPoint((double)bbox.getX1(), (double)bbox.getY1(), (CoordinateSystem)coordSystem);
        org.deegree.model.spatialschema.Point maxPoint = org.deegree.model.spatialschema.GeometryFactory.createPoint((double)bbox.getX2(), (double)bbox.getY2(), (CoordinateSystem)coordSystem);
        if (CrsTransformer.extractSridFromCrs(sourceCrs) == 3857 && (CrsTransformer.extractSridFromCrs(this.destCrsAsString) == 31466 || CrsTransformer.extractSridFromCrs(this.destCrsAsString) == 31467)) {
            GeoTransformer transformer4326 = new GeoTransformer("EPSG:4326");
            minPoint = (org.deegree.model.spatialschema.Point)transformer4326.transform((Geometry)minPoint);
            maxPoint = (org.deegree.model.spatialschema.Point)transformer4326.transform((Geometry)maxPoint);
            minPoint = (org.deegree.model.spatialschema.Point)this.transformer.transform((Geometry)minPoint);
            maxPoint = (org.deegree.model.spatialschema.Point)this.transformer.transform((Geometry)maxPoint);
        } else {
            minPoint = (org.deegree.model.spatialschema.Point)this.transformer.transform((Geometry)minPoint);
            maxPoint = (org.deegree.model.spatialschema.Point)this.transformer.transform((Geometry)maxPoint);
        }
        BoundingBox newBbox = bbox instanceof XBoundingBox ? new XBoundingBox(minPoint.getX(), minPoint.getY(), maxPoint.getX(), maxPoint.getY(), this.crs.getIdentifier(), this.crs.getAxisUnits()[0].equals((Object)Unit.METRE)) : new BoundingBox(minPoint.getX(), minPoint.getY(), maxPoint.getX(), maxPoint.getY());
        return newBbox;
    }

    public XBoundingBox transformBoundingBox(XBoundingBox bbox) throws UnknownCRSException, CRSTransformationException, IllegalArgumentException {
        return (XBoundingBox)this.transformBoundingBox(bbox, bbox.getSrs());
    }

    public <T extends com.vividsolutions.jts.geom.Geometry> T transformGeometry(T geom, String sourceCrs) throws UnknownCRSException, CRSTransformationException, IllegalArgumentException, GeometryException {
        com.vividsolutions.jts.geom.Geometry newGeom = (com.vividsolutions.jts.geom.Geometry)geom.clone();
        return (T)this.fastTransformGeometry(newGeom, sourceCrs);
    }

    public <T extends com.vividsolutions.jts.geom.Geometry> T fastTransformGeometry(T geom, String sourceCrs) throws UnknownCRSException, CRSTransformationException, IllegalArgumentException, GeometryException {
        String srcCrs = CrsTransformer.isDefaultCrs(sourceCrs) ? CismapBroker.getInstance().getDefaultCrs() : sourceCrs;
        if (CrsTransformer.extractSridFromCrs(srcCrs) == 3857 && (CrsTransformer.extractSridFromCrs(this.destCrsAsString) == 31466 || CrsTransformer.extractSridFromCrs(this.destCrsAsString) == 31467)) {
            T ret = CrsTransformer.transformToGivenCrs(geom, "EPSG:4326");
            return this.fastTransformGeometry(ret, "EPSG:4326");
        }
        CoordinateSystem coordSystem = CRSFactory.create((String)srcCrs);
        Geometry deegreeGeom = JTSAdapter.wrap(geom);
        deegreeGeom = this.transformer.transform(deegreeGeom, coordSystem.getCRS());
        com.vividsolutions.jts.geom.Geometry ret = JTSAdapter.export((Geometry)deegreeGeom);
        this.setSrid(ret);
        return (T)ret;
    }

    public Coordinate[] transformGeometry(String sourceCrs, Coordinate ... coords) throws UnknownCRSException, CRSTransformationException, IllegalArgumentException, GeometryException {
        GeometryFactory gfac = new GeometryFactory();
        Object geom = coords.length == 1 ? gfac.createPoint(coords[0]) : gfac.createLineString(coords);
        geom = this.transformGeometry(geom, sourceCrs);
        return geom.getCoordinates();
    }

    public void setSrid(com.vividsolutions.jts.geom.Geometry geom) {
        geom.setSRID(CrsTransformer.extractSridFromCrs(this.destCrsAsString));
    }

    public static void transformPNodeToGivenCrs(PNode node, String oldCrs, String newCrs, WorldToScreenTransform oldWtst, WorldToScreenTransform newWtst) {
        GeometryFactory fac = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(oldCrs));
        double x = oldWtst.getWorldX(node.getXOffset());
        double y = oldWtst.getWorldY(node.getYOffset());
        Point p = fac.createPoint(new Coordinate(x, y));
        p = CrsTransformer.transformToGivenCrs(p, newCrs);
        node.setOffset(newWtst.getScreenX(p.getX()), newWtst.getScreenY(p.getY()));
        for (int index = 0; index < node.getChildrenCount(); ++index) {
            CrsTransformer.transformPNodeToGivenCrs(node.getChild(index), oldCrs, newCrs, oldWtst, newWtst);
        }
    }

    public static int extractSridFromCrs(String crs) {
        try {
            if (CrsTransformer.isDefaultCrs(crs)) {
                crs = CismapBroker.getInstance().getDefaultCrs();
            }
            return Integer.parseInt(crs.substring(crs.lastIndexOf(":") + 1));
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot extract the SRID from the CRS " + crs));
            return -1;
        }
    }

    public static String createCrsFromSrid(int srid) {
        if (CrsTransformer.isDefaultCrs("EPSG:" + srid)) {
            return CismapBroker.getInstance().getDefaultCrs();
        }
        return "EPSG:" + srid;
    }

    public static int getCurrentSrid() {
        return CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode());
    }

    public static <T extends com.vividsolutions.jts.geom.Geometry> T transformToCurrentCrs(T geom) {
        String currentSrs = CismapBroker.getInstance().getSrs().getCode();
        return CrsTransformer.transformToGivenCrs(geom, currentSrs);
    }

    public static <T extends com.vividsolutions.jts.geom.Geometry> T transformToGivenCrs(T geom, String crs) {
        if (geom == null) {
            return null;
        }
        String crsname = "EPSG:" + geom.getSRID();
        String defaultCrs = CismapBroker.getInstance().getDefaultCrs();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("crsname " + crsname + " given crs " + crs + " default crs: " + defaultCrs));
        }
        if (CrsTransformer.isDefaultCrs(crsname)) {
            crsname = defaultCrs;
        }
        if (!crs.equals(crsname)) {
            try {
                CrsTransformer crsTransformer = new CrsTransformer(crs);
                return crsTransformer.transformGeometry(geom, crsname);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot transform the geometry from " + crsname + " to " + crs), (Throwable)e);
            }
        }
        return geom;
    }

    public static <T extends com.vividsolutions.jts.geom.Geometry> T transformToDefaultCrs(T geom) {
        if (geom == null) {
            return null;
        }
        T newGeom = null;
        String curCrs = "EPSG:" + geom.getSRID();
        if (!CrsTransformer.isDefaultCrs(curCrs)) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("transform geometry from " + curCrs + " to " + CismapBroker.getInstance().getDefaultCrs()));
                }
                CrsTransformer transformer = new CrsTransformer(CismapBroker.getInstance().getDefaultCrs());
                newGeom = transformer.transformGeometry(geom, curCrs);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot transform the geometry from " + curCrs + " to " + CismapBroker.getInstance().getDefaultCrs()), (Throwable)e);
                newGeom = geom;
            }
        } else {
            newGeom = geom;
        }
        return newGeom;
    }

    public static <T extends com.vividsolutions.jts.geom.Geometry> T transformToMetricCrs(T geom) {
        Crs crs;
        if (geom == null) {
            return null;
        }
        List<Crs> crsList = CismapBroker.getInstance().getMappingComponent().getCrsList();
        T newGeom = null;
        String curCrs = "EPSG:" + geom.getSRID();
        if (CrsTransformer.isDefaultCrs(curCrs)) {
            curCrs = CismapBroker.getInstance().getDefaultCrs();
        }
        Crs curCrsObject = new Crs();
        curCrsObject.setCode(curCrs);
        int index = crsList.indexOf(curCrsObject);
        if (index != -1 && (crs = crsList.get(index)).isMetric()) {
            newGeom = geom;
        }
        if (newGeom == null) {
            String metricCrs = CrsTransformer.getMetricCrs().getCode();
            try {
                CrsTransformer transformer = new CrsTransformer(metricCrs);
                newGeom = transformer.transformGeometry(geom, curCrs);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot transform the geometry from " + curCrs + " to " + metricCrs), (Throwable)e);
                newGeom = geom;
            }
        }
        return newGeom;
    }

    private static Crs getMetricCrs() {
        List<Crs> crsList = CismapBroker.getInstance().getMappingComponent().getCrsList();
        Crs metricCrs = null;
        for (Crs crs : crsList) {
            if (crs.isSelected() && crs.isMetric()) {
                metricCrs = crs;
                continue;
            }
            if (!crs.isMetric() || metricCrs != null) continue;
            metricCrs = crs;
        }
        if (metricCrs == null) {
            // empty if block
        }
        return metricCrs;
    }

    public static <T extends com.vividsolutions.jts.geom.Geometry> T transformToMetricCrs(T geom, List<Crs> crsList) {
        Crs crs;
        if (geom == null) {
            return null;
        }
        T newGeom = null;
        String curCrs = "EPSG:" + geom.getSRID();
        if (CrsTransformer.isDefaultCrs(curCrs)) {
            curCrs = CismapBroker.getInstance().getDefaultCrs();
        }
        Crs curCrsObject = new Crs();
        curCrsObject.setCode(curCrs);
        int index = crsList.indexOf(curCrsObject);
        if (index != -1 && (crs = crsList.get(index)).isMetric()) {
            newGeom = geom;
        }
        if (newGeom == null) {
            String metricCrs = CrsTransformer.getMetricCrs().getCode();
            try {
                CrsTransformer transformer = new CrsTransformer(metricCrs);
                newGeom = transformer.transformGeometry(geom, curCrs);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot transform the geometry from " + curCrs + " to " + metricCrs), (Throwable)e);
                newGeom = geom;
            }
        }
        return newGeom;
    }

    public static boolean isDefaultCrs(String crs) {
        return crs.endsWith(":" + CismapBroker.getInstance().getDefaultCrsAlias()) || crs.endsWith(":0") || crs.endsWith(":-1") || crs.equals(CismapBroker.getInstance().getDefaultCrs());
    }

    public static double getCrsFactor(Point coord) {
        String calculationRule;
        String currentSrs;
        if (SHELL == null) {
            return 1.0;
        }
        if (coord != null && coord.getSRID() != 0) {
            currentSrs = CrsTransformer.createCrsFromSrid(coord.getSRID());
            calculationRule = CRS_CORRECTION_FORMULA.get(currentSrs);
        } else {
            currentSrs = CismapBroker.getInstance().getSrs().getCode();
            calculationRule = CRS_CORRECTION_FORMULA.get(currentSrs);
        }
        if (calculationRule != null) {
            if (coord != null) {
                Point coord4326 = CrsTransformer.transformToGivenCrs(coord, "EPSG:4326");
                calculationRule = calculationRule.replace("long", String.valueOf(coord4326.getCoordinate().x));
                calculationRule = calculationRule.replace("lat", String.valueOf(coord4326.getCoordinate().y));
            } else {
                Point mapCentroid = CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBoxFromCamera().getGeometry(CrsTransformer.extractSridFromCrs(currentSrs)).getCentroid();
                Point coord4326 = CrsTransformer.transformToGivenCrs(mapCentroid, "EPSG:4326");
                calculationRule = calculationRule.replace("long", String.valueOf(coord4326.getCoordinate().x));
                calculationRule = calculationRule.replace("lat", String.valueOf(coord4326.getCoordinate().y));
            }
            Object o = SHELL.evaluate(calculationRule);
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
        }
        return 1.0;
    }

    static {
        SHELL = null;
        try {
            SHELL = new GroovyShell();
        }
        catch (Throwable th) {
            JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(CrsTransformer.class, (String)"CrsTransformer.static.message"), NbBundle.getMessage(CrsTransformer.class, (String)"CrsTransformer.static.title"), 2);
        }
        CRS_CORRECTION_FORMULA = new HashMap<String, String>();
        try {
            ResourceBundle srsCalc = ResourceBundle.getBundle("crsCorrection", Locale.getDefault());
            for (String key : srsCalc.keySet()) {
                CRS_CORRECTION_FORMULA.put(key, srsCalc.getString(key));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"No crs factor calculation rules found", (Throwable)e);
        }
    }
}

