/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class RestrictedFileSystemView
extends FileSystemView {
    private static final String newFolderString = UIManager.getString("FileChooser.other.newFolder");
    private File _defaultDirectory;

    public RestrictedFileSystemView() {
        this(null);
    }

    public RestrictedFileSystemView(File defaultDirectory) {
        this._defaultDirectory = defaultDirectory;
    }

    @Override
    public boolean isRoot(File f) {
        if (f == null || !f.isAbsolute()) {
            return false;
        }
        File[] roots = this.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!roots[i].equals(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean isTraversable(File f) {
        return f.isDirectory();
    }

    @Override
    public String getSystemDisplayName(File f) {
        String name = null;
        if (f != null) {
            name = this.isRoot(f) ? f.getAbsolutePath() : f.getName();
        }
        return name;
    }

    @Override
    public String getSystemTypeDescription(File f) {
        return null;
    }

    @Override
    public Icon getSystemIcon(File f) {
        if (f != null) {
            return UIManager.getIcon(f.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
        }
        return null;
    }

    @Override
    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    @Override
    public File getChild(File parent, String fileName) {
        return this.createFileObject(parent, fileName);
    }

    @Override
    public boolean isFileSystem(File f) {
        return true;
    }

    @Override
    public boolean isHiddenFile(File f) {
        return f.isHidden();
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        return this.isRoot(dir);
    }

    @Override
    public boolean isDrive(File dir) {
        return false;
    }

    @Override
    public boolean isFloppyDrive(File dir) {
        return false;
    }

    @Override
    public boolean isComputerNode(File dir) {
        return false;
    }

    @Override
    public File[] getRoots() {
        return File.listRoots();
    }

    @Override
    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    @Override
    public File getDefaultDirectory() {
        if (this._defaultDirectory == null) {
            try {
                File tempFile = File.createTempFile("filesystemview", "restricted");
                tempFile.deleteOnExit();
                this._defaultDirectory = tempFile.getParentFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this._defaultDirectory;
    }

    @Override
    public File createFileObject(File dir, String filename) {
        if (dir == null) {
            return new File(filename);
        }
        return new File(dir, filename);
    }

    @Override
    public File createFileObject(String path) {
        File f = new File(path);
        if (this.isFileSystemRoot(f)) {
            f = this.createFileSystemRoot(f);
        }
        return f;
    }

    @Override
    public File[] getFiles(File dir, boolean useFileHiding) {
        Vector<File> files = new Vector<File>();
        File[] names = dir.listFiles();
        int nameCount = names == null ? 0 : names.length;
        for (int i = 0; i < nameCount && !Thread.currentThread().isInterrupted(); ++i) {
            File f = names[i];
            if (useFileHiding && this.isHiddenFile(f)) continue;
            files.addElement(f);
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public File getParentDirectory(File dir) {
        File psf;
        if (dir != null && dir.exists() && (psf = dir.getParentFile()) != null) {
            if (this.isFileSystem(psf)) {
                File ppsf;
                File f = psf;
                if (!(f == null || f.exists() || (ppsf = psf.getParentFile()) != null && this.isFileSystem(ppsf))) {
                    f = this.createFileSystemRoot(f);
                }
                return f;
            }
            return psf;
        }
        return null;
    }

    @Override
    protected File createFileSystemRoot(File f) {
        return new FileSystemRoot(f);
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException("Containing directory is null:");
        }
        File newFolder = null;
        newFolder = this.createFileObject(containingDir, newFolderString);
        for (int i = 2; newFolder.exists() && i < 100; ++i) {
            newFolder = this.createFileObject(containingDir, MessageFormat.format(newFolderString, new Integer(i)));
        }
        if (newFolder.exists()) {
            throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
        }
        newFolder.mkdirs();
        return newFolder;
    }

    static class FileSystemRoot
    extends File {
        public FileSystemRoot(File f) {
            super(f, "");
        }

        public FileSystemRoot(String s) {
            super(s);
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public String getName() {
            return this.getPath();
        }
    }
}

