/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.interaction.CismapBroker;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class XBoundingBox
extends BoundingBox {
    private String srs;
    private boolean metric = true;

    public XBoundingBox(Geometry geom) {
        super(geom);
        this.srs = CrsTransformer.createCrsFromSrid(geom.getSRID());
        List<Crs> crsList = CismapBroker.getInstance().getMappingComponent().getCrsList();
        for (Crs crsTmp : crsList) {
            if (!crsTmp.getCode().equals(this.srs)) continue;
            this.metric = crsTmp.isMetric();
            break;
        }
    }

    public XBoundingBox(Element boundingBoxElementParent) throws DataConversionException {
        super(boundingBoxElementParent);
        Element conf = boundingBoxElementParent.getChild("BoundingBox");
        Attribute attributeSrs = conf.getAttribute("srs");
        Attribute attributeMetric = conf.getAttribute("metric");
        this.srs = attributeSrs != null ? attributeSrs.getValue() : null;
        this.metric = attributeMetric != null ? attributeMetric.getBooleanValue() : false;
    }

    public XBoundingBox(Geometry geom, String crs, boolean metric) {
        super(geom);
        this.srs = crs;
        this.metric = metric;
    }

    public XBoundingBox(Element boundingBoxElementParent, String srs, boolean metric) throws DataConversionException {
        super(boundingBoxElementParent);
        this.srs = srs;
        this.metric = metric;
    }

    public XBoundingBox(double x1, double y1, double x2, double y2, String srs, boolean metric) {
        super(x1, y1, x2, y2);
        this.srs = srs;
        this.metric = metric;
    }

    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String srs) {
        this.srs = srs;
    }

    public boolean isMetric() {
        return this.metric;
    }

    public void setMetric(boolean metric) {
        this.metric = metric;
    }

    public Geometry getGeometry() {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(this.srs));
        Coordinate[] bbox = new Coordinate[]{new Coordinate(this.getX1(), this.getY1()), new Coordinate(this.getX1(), this.getY2()), new Coordinate(this.getX2(), this.getY2()), new Coordinate(this.getX2(), this.getY1()), new Coordinate(this.getX1(), this.getY1())};
        LinearRing ring = new LinearRing((CoordinateSequence)new CoordinateArraySequence(bbox), factory);
        return factory.createPolygon(ring, new LinearRing[0]);
    }

    @Override
    public Element getJDOMElement() {
        Element result = super.getJDOMElement();
        result.setAttribute(new Attribute("srs", this.srs));
        result.setAttribute(new Attribute("metric", Boolean.toString(this.metric)));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof XBoundingBox) {
            XBoundingBox bb = (XBoundingBox)other;
            return this.getX1() == bb.getX1() && this.getX2() == bb.getX2() && this.getY1() == bb.getY1() && this.getY2() == bb.getY2() && this.getSrs() == bb.getSrs();
        }
        return super.equals(other);
    }

    @Override
    public Object clone() {
        return new XBoundingBox(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.srs, this.metric);
    }
}

