/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.capabilities;

import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.CalculationCache;
import de.cismet.tools.Calculator;
import de.cismet.tools.TimeoutThread;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class CapabilitiesCache
extends CalculationCache<String, String> {
    private static final CapabilitiesCache INSTANCE = new CapabilitiesCache();

    private CapabilitiesCache() {
        super((Calculator)new TimeoutHttpRequestCalculator());
    }

    public static CapabilitiesCache getInstance() {
        return INSTANCE;
    }

    private static class TimeoutHttpRequester
    extends TimeoutThread<StringBuilder> {
        private String url;

        public TimeoutHttpRequester(String url) {
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputStream is = null;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("send Getcapabilities request to the service: " + this.url));
                }
                URL getCapURL = new URL(this.url);
                is = WebAccessManager.getInstance().doRequest(getCapURL);
                if (Thread.interrupted()) {
                    return;
                }
                this.result = FeatureServiceUtilities.readInputStream(is);
                boolean invalidCharacter = false;
                invalidCharacter = TimeoutHttpRequester.hasInvalidCharacter(((StringBuilder)this.result).toString().getBytes());
                for (int attempts = 0; invalidCharacter && attempts < 3; ++attempts) {
                    LOG.warn((Object)"invalid character found. Reload capabilities document");
                    is.close();
                    is = WebAccessManager.getInstance().doRequest(getCapURL);
                    this.result = FeatureServiceUtilities.readInputStream(is);
                    invalidCharacter = TimeoutHttpRequester.hasInvalidCharacter(((StringBuilder)this.result).toString().getBytes());
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private static boolean hasInvalidCharacter(byte[] bytes) {
            boolean efFound = false;
            boolean bfFound = false;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == -17) {
                    efFound = true;
                    bfFound = false;
                    continue;
                }
                if (bytes[i] == -65 && efFound && !bfFound) {
                    efFound = true;
                    bfFound = true;
                    continue;
                }
                if (bytes[i] == -67 && efFound && bfFound) {
                    return true;
                }
                efFound = false;
                bfFound = false;
            }
            return false;
        }
    }

    private static class TimeoutHttpRequestCalculator
    implements Calculator<String, String> {
        private TimeoutHttpRequestCalculator() {
        }

        public String calculate(String link) throws Exception {
            TimeoutHttpRequester r = new TimeoutHttpRequester(link);
            StringBuilder tmp = (StringBuilder)r.start(15000L);
            return tmp.toString();
        }
    }
}

