/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.demo;

import de.cismet.tools.CismetThreadPool;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Observable;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;

public class ProgressMonitoredDataTransfer
extends Observable
implements Runnable,
ActionListener {
    public static final int DELAY = 1;
    public static final int BUFSIZ = 1024;
    private InputStream readFrom;
    private OutputStream writeTo;
    private ProgressMonitor monitor;
    private boolean done;
    private int max;
    private int current;
    private Timer mytimer;
    private Thread mythread;
    private boolean closeWhenDone;

    public ProgressMonitoredDataTransfer(Component par, InputStream from, OutputStream to, int maxtransfer, Object message, boolean close) {
        this.readFrom = new BufferedInputStream(from);
        this.writeTo = to;
        this.max = maxtransfer;
        this.monitor = new ProgressMonitor(par, message, null, 0, this.max);
        this.monitor.setMillisToPopup(2);
        this.mythread = new Thread((Runnable)this, "ProgressMonitoredDataTransfer");
        this.mytimer = new Timer(1, this);
        this.done = false;
        this.closeWhenDone = close;
        this.current = 0;
        CismetThreadPool.execute((Runnable)this.mythread);
        this.mytimer.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isDone()) {
            this.monitor.close();
            this.mytimer.stop();
        } else if (this.monitor.isCanceled()) {
            if (this.mythread != null && this.mythread.isAlive()) {
                this.mythread.interrupt();
            }
            this.monitor.close();
            this.mytimer.stop();
        } else {
            int cur = this.getCurrent();
            this.monitor.setProgress(cur);
        }
    }

    public void handleProblem(String msg) {
        System.err.println("Transfer problem: " + msg);
    }

    public synchronized int getCurrent() {
        return this.current;
    }

    private synchronized void addToCurrent(int x) {
        this.current += x;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    private synchronized void setDone() {
        this.done = true;
        this.setChanged();
        this.notifyObservers("Done");
    }

    public void waitForDone() {
        try {
            this.mythread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public final void run() {
        try {
            byte[] buf = new byte[1024];
            int cc = this.readFrom.read(buf, 0, 1024);
            while (cc > 0) {
                this.writeTo.write(buf, 0, cc);
                this.addToCurrent(cc);
                if (this.mythread.isInterrupted()) {
                    break;
                }
                this.setChanged();
                this.notifyObservers(null);
                cc = this.readFrom.read(buf, 0, 1024);
            }
        }
        catch (InterruptedIOException ioe) {
            this.handleProblem("Cancelled by user after " + this.current + " bytes.");
        }
        catch (Exception ie) {
            this.handleProblem("IO exception: " + ie);
        }
        finally {
            this.setDone();
            if (this.closeWhenDone) {
                if (this.readFrom != null) {
                    try {
                        this.readFrom.close();
                    }
                    catch (Exception ioe) {}
                }
                if (this.writeTo != null) {
                    try {
                        this.writeTo.close();
                    }
                    catch (Exception ioe) {}
                }
            }
        }
    }
}

