/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.drophandler;

import de.cismet.cismap.commons.drophandler.MappingComponentDropHandler;
import de.cismet.cismap.commons.drophandler.MappingComponentDropHandlerFileMatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;

public class MappingComponentDropHandlerRegistry {
    private static final transient Logger LOG = Logger.getLogger(MappingComponentDropHandlerRegistry.class);
    private final transient Collection<MappingComponentDropHandler> repo = new ArrayList<MappingComponentDropHandler>();

    private MappingComponentDropHandlerRegistry() {
        Lookup.Result result = Lookup.getDefault().lookupResult(MappingComponentDropHandler.class);
        Collection instances = result.allInstances();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("found " + instances.size() + " instances of MappingComponentDropHandler"));
        }
        for (MappingComponentDropHandler dropHandler : instances) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found entry: " + dropHandler.getFileMatcher() + " -> " + dropHandler.getClass()));
            }
            this.repo.add(dropHandler);
        }
    }

    public static MappingComponentDropHandlerRegistry getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public MappingComponentDropHandler getDropHandler(File file) {
        HashMap<Integer, MappingComponentDropHandler> matchingDropHandlers = new HashMap<Integer, MappingComponentDropHandler>();
        for (MappingComponentDropHandler dropHandler : this.repo) {
            MappingComponentDropHandlerFileMatcher fileMatcher = dropHandler.getFileMatcher();
            if (!fileMatcher.isMatching(file)) continue;
            matchingDropHandlers.put(dropHandler.getPriority(), dropHandler);
        }
        if (matchingDropHandlers.isEmpty()) {
            return null;
        }
        ArrayList priorityList = new ArrayList(matchingDropHandlers.keySet());
        Collections.sort(priorityList);
        Integer highestPriority = (Integer)priorityList.get(priorityList.size() - 1);
        return (MappingComponentDropHandler)matchingDropHandlers.get(highestPriority);
    }

    private static final class LazyInitialiser {
        private static final MappingComponentDropHandlerRegistry INSTANCE = new MappingComponentDropHandlerRegistry();

        private LazyInitialiser() {
        }
    }
}

