/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.drophandler.builtin;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cismap.commons.drophandler.MappingComponentDropHandler;
import de.cismet.cismap.commons.drophandler.builtin.MappingComponentGeoImageFileFeatureRenderer;
import de.cismet.cismap.commons.drophandler.filematcher.builtin.MappingComponentDropHandlerFileTypeMatcher;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.options.GPSDirectionOptions;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.ExifReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MappingComponentGeoImageFileDropHandler
implements MappingComponentDropHandler {
    private static final Logger LOG = Logger.getLogger(MappingComponentGeoImageFileDropHandler.class);
    private final ExifGeoImageFileMatcher fileMatcher = new ExifGeoImageFileMatcher();
    private Map<File, GpsData> gpsDataMap = new HashMap<File, GpsData>();

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public void dropFiles(Collection<File> files) {
        final ArrayList<Feature> featuresToAdd = new ArrayList<Feature>();
        for (File file : files) {
            GpsData gpsData = this.gpsDataMap.get(file);
            Point point = gpsData.getPoint();
            Double direction = gpsData.getDirection();
            MappingComponentGeoImageFileFeatureRenderer featureRenderer = new MappingComponentGeoImageFileFeatureRenderer(file, point, direction);
            featureRenderer.setGeometry((Geometry)point);
            featuresToAdd.add(featureRenderer);
        }
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().substituteFeatures(featuresToAdd);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
                if (!mappingComponent.isFixedMapExtent()) {
                    mappingComponent.zoomToAFeatureCollection(featuresToAdd, true, mappingComponent.isFixedMapScale());
                }
            }
        });
    }

    private double adjustDirection(double direction, String model) {
        GPSDirectionOptions.GPSDirection angleDirection = CismapBroker.getInstance().getGpsAngleDirection();
        if (angleDirection.equals((Object)GPSDirectionOptions.GPSDirection.AUTO)) {
            String counterClockwisePattern;
            String clockwisePattern = this.getRegEx(true);
            if (model != null && clockwisePattern != null && Pattern.matches(clockwisePattern, model) && ((counterClockwisePattern = this.getRegEx(false)) == null || !Pattern.matches(counterClockwisePattern, model))) {
                direction *= -1.0;
            }
        } else if (angleDirection.equals((Object)GPSDirectionOptions.GPSDirection.CW)) {
            direction *= -1.0;
        }
        return direction;
    }

    private String getRegEx(boolean clockwise) {
        Properties prop = new Properties();
        try {
            prop.load(MappingComponentGeoImageFileDropHandler.class.getResourceAsStream("/GPSDirection.properties"));
            if (clockwise) {
                return prop.getProperty("clockwise-filter");
            }
            return prop.getProperty("counter-clockwise-filter");
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot read GPSDirection.properties", (Throwable)e);
            return null;
        }
    }

    @Override
    public ExifGeoImageFileMatcher getFileMatcher() {
        return this.fileMatcher;
    }

    class GpsData {
        private Point point;
        private Double direction;

        public Point getPoint() {
            return this.point;
        }

        public Double getDirection() {
            return this.direction;
        }

        public void setPoint(Point point) {
            this.point = point;
        }

        public void setDirection(Double direction) {
            this.direction = direction;
        }

        public GpsData(Point point, Double direction) {
            this.point = point;
            this.direction = direction;
        }
    }

    class ExifGeoImageFileMatcher
    extends MappingComponentDropHandlerFileTypeMatcher {
        ExifGeoImageFileMatcher() {
            super(MappingComponentDropHandlerFileTypeMatcher.FileType.IMAGE);
        }

        @Override
        public boolean isMatching(File file) {
            boolean superIsMatching = super.isMatching(file);
            if (!superIsMatching) {
                return false;
            }
            try {
                Double direction;
                ExifReader reader = new ExifReader(file);
                Point point = reader.getGpsCoords();
                if (point == null) {
                    return false;
                }
                try {
                    direction = reader.getGpsDirection();
                    direction = MappingComponentGeoImageFileDropHandler.this.adjustDirection(direction, reader.getModel());
                }
                catch (Exception ex) {
                    direction = null;
                }
                MappingComponentGeoImageFileDropHandler.this.gpsDataMap.put(file, new GpsData(point, direction));
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

