/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.drophandler.filematcher.builtin;

import de.cismet.cismap.commons.drophandler.MappingComponentDropHandlerFileMatcher;
import de.cismet.cismap.commons.drophandler.filematcher.builtin.MappingComponentDropHandlerFileExtensionMatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MappingComponentDropHandlerFileTypeMatcher
implements MappingComponentDropHandlerFileMatcher {
    public static String[] VIDEO_TYPES = new String[]{"mov", "mpeg", "mpg", "avi", "mkv"};
    public static String[] IMAGE_TYPES = new String[]{"jpg", "jpeg", "bmp", "tif", "tiff", "png"};
    public static String[] TEXT_TYPES = new String[]{"txt", "csv"};
    public static String[] BINARY_TYPES = new String[]{"exe"};
    public static Map<FileType, String> typeExtensionMap = new HashMap<FileType, String>();
    private final MappingComponentDropHandlerFileExtensionMatcher extensionMatcher;
    private final Collection<FileType> types;

    public MappingComponentDropHandlerFileTypeMatcher(FileType type) {
        this(Arrays.asList(type));
    }

    public MappingComponentDropHandlerFileTypeMatcher(Collection<FileType> types) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (FileType type : types) {
            switch (type) {
                case VIDEO: {
                    extensions.addAll(Arrays.asList(VIDEO_TYPES));
                    break;
                }
                case IMAGE: {
                    extensions.addAll(Arrays.asList(IMAGE_TYPES));
                    break;
                }
                case TEXT: {
                    extensions.addAll(Arrays.asList(TEXT_TYPES));
                    break;
                }
                case BINARY: {
                    extensions.addAll(Arrays.asList(BINARY_TYPES));
                }
            }
        }
        this.types = types;
        this.extensionMatcher = new MappingComponentDropHandlerFileExtensionMatcher(extensions);
    }

    @Override
    public boolean isMatching(File file) {
        if (this.types.contains((Object)FileType.ANY)) {
            return true;
        }
        return this.extensionMatcher.isMatching(file);
    }

    public static enum FileType {
        ANY,
        VIDEO,
        IMAGE,
        TEXT,
        BINARY;

    }
}

