/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.Attachable;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class AbstractNewFeature
extends DefaultStyledFeature
implements Cloneable,
XStyledFeature,
Attachable {
    static ImageIcon icoPoint = new ImageIcon(AbstractNewFeature.class.getResource("/de/cismet/cismap/commons/gui/res/point.png"));
    static ImageIcon icoPolyline = new ImageIcon(AbstractNewFeature.class.getResource("/de/cismet/cismap/commons/gui/res/polyline.png"));
    static ImageIcon icoPolygon = new ImageIcon(AbstractNewFeature.class.getResource("/de/cismet/cismap/commons/gui/res/polygon.png"));
    static ImageIcon icoEllipse = new ImageIcon(AbstractNewFeature.class.getResource("/de/cismet/cismap/commons/gui/res/ellipse.png"));
    static ImageIcon icoRectangle = new ImageIcon(AbstractNewFeature.class.getResource("/de/cismet/cismap/commons/gui/res/rectangle.png"));
    private static final Logger LOG = Logger.getLogger(AbstractNewFeature.class);
    private Paint fillingPaint = new Color(1.0f, 0.0f, 0.0f, 0.4f);
    private geomTypes geomType = geomTypes.UNKNOWN;
    private String name = "";

    public AbstractNewFeature(Geometry g) {
        this.setGeometry(g);
    }

    public AbstractNewFeature(Point2D point, WorldToScreenTransform wtst) {
        Coordinate[] coordArr = new Coordinate[]{new Coordinate(wtst.getSourceX(point.getX()), wtst.getSourceY(point.getY()))};
        this.init(coordArr, wtst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNewFeature(Point2D[] canvasPoints, WorldToScreenTransform wtst) {
        Point2D[] point2DArray = canvasPoints;
        synchronized (canvasPoints) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("canvasPoints " + canvasPoints));
                }
                Coordinate[] coordArr = new Coordinate[canvasPoints.length];
                float[] xp = new float[canvasPoints.length];
                float[] yp = new float[canvasPoints.length];
                for (int i = 0; i < canvasPoints.length; ++i) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("canvasPoints[" + i + "]:" + canvasPoints[i]));
                    }
                    xp[i] = (float)canvasPoints[i].getX();
                    yp[i] = (float)canvasPoints[i].getY();
                    coordArr[i] = new Coordinate(wtst.getSourceX(xp[i]), wtst.getSourceY(yp[i]));
                }
                this.init(coordArr, wtst);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"pureNewFeature created");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error during creating a PureNewfeatures", (Throwable)e);
            }
            return;
        }
    }

    public AbstractNewFeature(Coordinate[] coordArr, WorldToScreenTransform wtst) {
        this.init(coordArr, wtst);
    }

    private void init(Coordinate[] coordArr, WorldToScreenTransform wtst) {
        try {
            GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.getCurrentSrid());
            if (coordArr.length == 1) {
                Point p = gf.createPoint(coordArr[0]);
                this.setGeometry((Geometry)p);
            } else if (coordArr[0].equals((Object)coordArr[coordArr.length - 1]) && coordArr.length > 3) {
                LinearRing shell = gf.createLinearRing(coordArr);
                Polygon poly = gf.createPolygon(shell, null);
                this.setGeometry((Geometry)poly);
            } else {
                LineString line = gf.createLineString(coordArr);
                this.setGeometry((Geometry)line);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error in init", (Throwable)e);
        }
    }

    @Override
    public Stroke getLineStyle() {
        return null;
    }

    @Override
    public Paint getFillingPaint() {
        return this.fillingPaint;
    }

    @Override
    public void setFillingPaint(Paint fillingStyle) {
        this.fillingPaint = fillingStyle;
    }

    @Override
    public float getTransparency() {
        return 1.0f;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ImageIcon getIconImage() {
        if (this.getGeometry() instanceof Point) {
            return icoPoint;
        }
        if (this.getGeometryType() == geomTypes.LINESTRING) {
            return icoPolyline;
        }
        if (this.getGeometryType() == geomTypes.ELLIPSE) {
            return icoEllipse;
        }
        if (this.getGeometryType() == geomTypes.RECTANGLE) {
            return icoRectangle;
        }
        if (this.getGeometryType() == geomTypes.POLYGON) {
            return icoPolygon;
        }
        if (this.getGeometryType() == geomTypes.MULTIPOLYGON) {
            return icoPolygon;
        }
        return null;
    }

    public float getInfoComponentTransparency() {
        return this.getTransparency();
    }

    public void setGeometryType(geomTypes geomType) {
        this.geomType = geomType == null ? geomTypes.UNKNOWN : geomType;
    }

    @Override
    public JComponent getInfoComponent(Refreshable refresh) {
        return null;
    }

    @Override
    public FeatureAnnotationSymbol getPointAnnotationSymbol() {
        return null;
    }

    public geomTypes getGeometryType() {
        return this.geomType;
    }

    public static enum geomTypes {
        ELLIPSE,
        LINESTRING,
        RECTANGLE,
        POINT,
        POLYGON,
        MULTIPOLYGON,
        TEXT,
        UNKNOWN;

    }
}

