/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.SLDStyledFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.style.Style;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.gui.piccolo.FixedPImage;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PSticky;
import de.cismet.cismap.commons.gui.piccolo.SelectionAwareTexturePaint;
import de.cismet.cismap.commons.styling.CustomStyle;
import de.cismet.cismap.commons.styling.EndPointStyle;
import de.cismet.cismap.commons.styling.EndPointStyleDescription;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RescaleOp;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xerces.xs.XSElementDeclaration;
import org.deegree.commons.tom.TypedObjectNode;
import org.deegree.commons.tom.gml.GMLObjectCategory;
import org.deegree.commons.tom.gml.property.Property;
import org.deegree.commons.tom.gml.property.PropertyType;
import org.deegree.commons.tom.primitive.BaseType;
import org.deegree.commons.tom.primitive.PrimitiveType;
import org.deegree.commons.tom.primitive.PrimitiveValue;
import org.deegree.commons.utils.Triple;
import org.deegree.feature.Feature;
import org.deegree.feature.property.ExtraProps;
import org.deegree.feature.types.AppSchema;
import org.deegree.feature.types.FeatureType;
import org.deegree.feature.types.property.GeometryPropertyType;
import org.deegree.filter.FilterEvaluationException;
import org.deegree.filter.XPathEvaluator;
import org.deegree.filter.expression.ValueReference;
import org.deegree.geometry.Envelope;
import org.deegree.geometry.standard.AbstractDefaultGeometry;
import org.deegree.geometry.standard.primitive.DefaultPoint;
import org.deegree.model.spatialschema.JTSAdapter;
import org.deegree.style.styling.LineStyling;
import org.deegree.style.styling.PointStyling;
import org.deegree.style.styling.PolygonStyling;
import org.deegree.style.styling.Styling;
import org.deegree.style.styling.TextStyling;
import org.deegree.style.styling.components.Fill;
import org.deegree.style.styling.components.Font;
import org.deegree.style.styling.components.Graphic;
import org.deegree.style.styling.components.Halo;
import org.deegree.style.styling.components.Mark;
import org.deegree.style.styling.components.Stroke;
import org.deegree.style.styling.components.UOM;
import org.jfree.util.Log;

public class DefaultFeatureServiceFeature
implements FeatureServiceFeature,
Comparable<DefaultFeatureServiceFeature> {
    protected static final String CLASS_ID = "class_id";
    protected static final String GEOMETRIE = "geo_field";
    protected static final String OBJECT_ID = "object_id";
    protected static Map<BufferedImage, BufferedImage> selectedImage = new HashMap<BufferedImage, BufferedImage>();
    private static AbstractDefaultGeometry defaultGeom = new DefaultPoint(null, null, null, new double[]{0.0, 0.0});
    protected Logger logger = Logger.getLogger(this.getClass());
    protected XPathEvaluator<Feature> evaluator = new DeegreeEvaluator();
    protected List<org.deegree.style.se.unevaluated.Style> styles;
    protected LinkedList<Triple<Styling, LinkedList<org.deegree.geometry.Geometry>, String>> stylings;
    private int id = -1;
    private String primaryAnnotation;
    private String secondaryAnnotation;
    private boolean hiding = false;
    private boolean editable = false;
    private Boolean canBeSelected = null;
    private LinkedHashMap<String, Object> container = new LinkedHashMap();
    private Geometry geometry = null;
    private LayerProperties layerProperties;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Paint customFillingStyle;

    public DefaultFeatureServiceFeature() {
    }

    public DefaultFeatureServiceFeature(FeatureServiceFeature feature) {
        this.setId(feature.getId());
        this.setPrimaryAnnotation(feature.getPrimaryAnnotation());
        this.setSecondaryAnnotation(feature.getSecondaryAnnotation());
        this.hide(feature.isHidden());
        this.setEditable(feature.isEditable());
        this.setCanBeSelected(feature.canBeSelected());
        if (feature instanceof DefaultFeatureServiceFeature) {
            this.styles = ((DefaultFeatureServiceFeature)feature).styles;
        }
        if (feature.getProperties() != null && feature.getProperties().size() > 0) {
            this.container = new LinkedHashMap(feature.getProperties());
        }
        if (feature.getLayerProperties() != null) {
            this.setLayerProperties(feature.getLayerProperties().clone());
        }
        if (feature.getGeometry() != null) {
            this.setGeometry((Geometry)feature.getGeometry().clone());
        }
    }

    public DefaultFeatureServiceFeature(int id, Geometry geometry, LayerProperties layerProperties) {
        this.setId(id);
        this.setGeometry(geometry);
        this.setLayerProperties(layerProperties);
    }

    public DefaultFeatureServiceFeature(int id, Geometry geometry, LayerProperties layerProperties, List<org.deegree.style.se.unevaluated.Style> styles) {
        this(id, geometry, layerProperties);
        this.styles = styles;
    }

    @Override
    public Object clone() {
        return new DefaultFeatureServiceFeature(this);
    }

    @Override
    public void addProperty(String propertyName, Object property) {
        this.container.put(propertyName, property);
    }

    public void addProperties(Map<String, Object> map) {
        this.container.putAll(map);
    }

    @Override
    public HashMap getProperties() {
        if (this.hasAdditionalProperties()) {
            String[] names;
            AttributeTableRuleSet ruleSet = this.layerProperties.getAttributeTableRuleSet();
            for (String tmpName : names = ruleSet.getAdditionalFieldNames()) {
                Object value = ruleSet.getAdditionalFieldValue(tmpName, this);
                this.container.put(tmpName, value);
            }
        }
        return this.container;
    }

    @Override
    public void setProperties(HashMap properties) {
        this.container = new LinkedHashMap(properties);
    }

    @Override
    public Object getProperty(String propertyName) {
        int index;
        Object o = this.container.get(propertyName);
        if (this.hasAdditionalProperties() && (index = this.layerProperties.getAttributeTableRuleSet().getIndexOfAdditionalFieldName(propertyName)) != Integer.MIN_VALUE) {
            o = this.layerProperties.getAttributeTableRuleSet().getAdditionalFieldValue(propertyName, this);
        }
        return o;
    }

    @Override
    public void removeProperty(String propertyName) {
        this.container.remove(propertyName);
    }

    protected boolean hasAdditionalProperties() {
        if (this.layerProperties != null) {
            AttributeTableRuleSet ruleSet = this.layerProperties.getAttributeTableRuleSet();
            if (ruleSet == null) {
                return false;
            }
            String[] fieldNames = ruleSet.getAdditionalFieldNames();
            return fieldNames != null && fieldNames.length > 0;
        }
        return false;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getIdExpression() {
        return this.layerProperties.getIdExpression();
    }

    @Override
    public void setIdExpression(String idExpression) {
        this.layerProperties.setIdExpression(idExpression, this.layerProperties.getIdExpressionType());
    }

    @Override
    public LayerProperties getLayerProperties() {
        return this.layerProperties;
    }

    @Override
    public void setLayerProperties(LayerProperties layerProperties) {
        this.layerProperties = layerProperties;
    }

    @Override
    public Paint getLinePaint() {
        if (this.styles == null || this.styles.isEmpty()) {
            return this.getStyle().isDrawLine() ? this.getStyle().getLineColor() : null;
        }
        return null;
    }

    @Override
    public void setLinePaint(Paint linePaint) {
        this.getStyle().setLineColor((Color)linePaint);
        this.getStyle().setDrawLine(true);
    }

    @Override
    public int getLineWidth() {
        if (this.styles == null || this.styles.isEmpty()) {
            return this.getStyle().getLineWidth();
        }
        return 0;
    }

    @Override
    public void setLineWidth(int width) {
        this.getStyle().setLineWidth(width);
    }

    @Override
    public Paint getFillingPaint() {
        if (this.customFillingStyle != null) {
            return this.customFillingStyle;
        }
        if (this.styles == null || this.styles.isEmpty()) {
            return this.getStyle().isDrawFill() ? this.getStyle().getFillColor() : null;
        }
        return null;
    }

    @Override
    public void setFillingPaint(Paint fillingStyle) {
        this.customFillingStyle = fillingStyle;
    }

    @Override
    public float getTransparency() {
        if (this.styles == null || this.styles.isEmpty()) {
            return this.getStyle().getAlpha();
        }
        return 0.5f;
    }

    @Override
    public void setTransparency(float transparrency) {
        this.getStyle().setAlpha(transparrency);
    }

    @Override
    public FeatureAnnotationSymbol getPointAnnotationSymbol() {
        if (this.styles == null || this.styles.isEmpty()) {
            return this.getStyle().getPointSymbol();
        }
        return null;
    }

    @Override
    public void setPointAnnotationSymbol(FeatureAnnotationSymbol featureAnnotationSymbol) {
        this.getStyle().setPointSymbol(featureAnnotationSymbol);
    }

    @Override
    public boolean isHighlightingEnabled() {
        if (this.styles == null || this.styles.isEmpty()) {
            return this.getStyle().isHighlightFeature();
        }
        return true;
    }

    @Override
    public void setHighlightingEnabled(boolean enabled) {
        this.getStyle().setHighlightFeature(enabled);
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public void setGeometry(Geometry geom) {
        if (this.getLayerProperties() != null && this.getLayerProperties().getAttributeTableRuleSet() != null) {
            geom = (Geometry)this.getLayerProperties().getAttributeTableRuleSet().afterEdit(this, "", -1, this.geometry, geom);
        }
        this.geometry = geom;
        this.setProperty(this.getGeometryFieldName(), geom);
    }

    private String getGeometryFieldName() {
        if (this.getLayerProperties() != null && this.getLayerProperties().getFeatureService() != null && this.getLayerProperties().getFeatureService().getFeatureServiceAttributes() != null) {
            Map<String, FeatureServiceAttribute> attributes = this.getLayerProperties().getFeatureService().getFeatureServiceAttributes();
            for (String key : attributes.keySet()) {
                FeatureServiceAttribute attr = attributes.get(key);
                if (!attr.isGeometry()) continue;
                return attr.getName();
            }
        }
        return "geom";
    }

    @Override
    public boolean canBeSelected() {
        if (this.layerProperties != null && this.layerProperties.getFeatureService() != null && this.layerProperties.getFeatureService().getPNode() != null && !this.layerProperties.getFeatureService().getPNode().getVisible()) {
            return false;
        }
        if (this.canBeSelected == null) {
            if (this.layerProperties != null && this.layerProperties.getFeatureService() != null) {
                return this.layerProperties.getFeatureService().isSelectable();
            }
            return true;
        }
        return this.canBeSelected;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public boolean isHidden() {
        return this.hiding;
    }

    @Override
    public void hide(boolean hiding) {
        this.hiding = hiding;
    }

    @Override
    public String getPrimaryAnnotation() {
        if (this.styles == null || this.styles.isEmpty()) {
            return this.primaryAnnotation;
        }
        return null;
    }

    @Override
    public boolean isPrimaryAnnotationVisible() {
        if (this.styles == null || this.styles.isEmpty()) {
            return this.getStyle().isDrawLabel();
        }
        return false;
    }

    @Override
    public void setPrimaryAnnotationVisible(boolean visible) {
        this.getStyle().setDrawLabel(visible);
    }

    @Override
    public java.awt.Font getPrimaryAnnotationFont() {
        return this.getStyle().getFont();
    }

    @Override
    public Paint getPrimaryAnnotationPaint() {
        return this.getStyle().getFontColor();
    }

    @Override
    public double getPrimaryAnnotationScaling() {
        return this.getStyle().getMultiplier();
    }

    @Override
    public float getPrimaryAnnotationJustification() {
        return this.getStyle().getAlignment();
    }

    @Override
    public void setPrimaryAnnotationJustification(float just) {
        this.getStyle().setAlignment(just);
    }

    @Override
    public String getSecondaryAnnotation() {
        return this.secondaryAnnotation;
    }

    @Override
    public void setPrimaryAnnotation(String primaryAnnotation) {
        this.primaryAnnotation = primaryAnnotation;
    }

    @Override
    public void setPrimaryAnnotationFont(java.awt.Font primaryAnnotationFont) {
        this.getStyle().setFont(primaryAnnotationFont);
    }

    @Override
    public void setPrimaryAnnotationPaint(Paint primaryAnnotationPaint) {
        this.getStyle().setFontColor((Color)primaryAnnotationPaint);
    }

    @Override
    public void setPrimaryAnnotationScaling(double primaryAnnotationScaling) {
        this.getStyle().setMultiplier(primaryAnnotationScaling);
    }

    @Override
    public void setSecondaryAnnotation(String secondaryAnnotation) {
        this.secondaryAnnotation = secondaryAnnotation;
    }

    @Override
    public boolean isAutoscale() {
        return this.getStyle().isAutoscale();
    }

    @Override
    public void setAutoScale(boolean autoScale) {
        this.getStyle().setAutoscale(autoScale);
    }

    @Override
    public Integer getMinScaleDenominator() {
        return this.getStyle().getMinScale();
    }

    @Override
    public Integer getMaxScaleDenominator() {
        return this.getStyle().getMaxScale();
    }

    @Override
    public void setMinScaleDenominator(Integer min) {
        this.getStyle().setMinScale(min);
    }

    @Override
    public void setMaxScaleDenominator(Integer max) {
        this.getStyle().setMaxScale(max);
    }

    @Override
    public void setPrimaryAnnotationHalo(Color halo) {
        this.getStyle().setHalo(halo);
    }

    @Override
    public Color getPrimaryAnnotationHalo() {
        return this.getStyle().getHalo();
    }

    protected Style getStyle() {
        return this.layerProperties.getStyle();
    }

    @Override
    public void setCanBeSelected(boolean canBeSelected) {
        this.canBeSelected = canBeSelected;
    }

    public boolean equals(Object obj) {
        if (obj.getClass().getName().equals(this.getClass().getName())) {
            DefaultFeatureServiceFeature other = (DefaultFeatureServiceFeature)obj;
            if (this.getId() != -1) {
                return this.getId() == other.getId();
            }
        } else {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.id;
        hash = 79 * hash + (this.getClass().getName() != null ? this.getClass().getName().hashCode() : 0);
        return hash;
    }

    protected void applyFill(UOM uom, Fill fill, PPath pfeature, MappingComponent map) {
        pfeature.setPaint(this.getPaintFromDeegree(fill.graphic, fill.color, uom, (PNode)pfeature, map));
    }

    protected void applyLineStyling(PPath pfeature, LineStyling styling, MappingComponent map) {
        if (styling.stroke != null) {
            this.applyStroke(styling.uom, styling.stroke, pfeature, map);
        }
    }

    protected void applyPointStyling(PImage image, PointStyling styling, WorldToScreenTransform wtst, double x, double y, PCamera camera, boolean selected) {
        BufferedImage buffImage = this.getImageFromDeegree(styling.graphic, selected);
        image.setImage((Image)buffImage);
        if (this.getUOMFromDeegree(styling.uom) == SLDStyledFeature.UOM.pixel) {
            ((FixedPImage)image).setMultiplier(1.0 / ((double)buffImage.getHeight() / styling.graphic.size));
            ((FixedPImage)image).setSweetSpotX(-1.0 * styling.graphic.anchorPointX);
            ((FixedPImage)image).setSweetSpotY(-1.0 * styling.graphic.anchorPointY);
            image.setOffset(wtst.getScreenX(x), wtst.getScreenY(y));
        } else {
            double multiplier = this.getMultiplierFromDeegreeUOM(styling.uom);
            double sizeMulti = styling.graphic.size / (double)buffImage.getHeight();
            image.setScale(multiplier * sizeMulti);
            image.setOffset(wtst.getScreenX(x + (styling.graphic.displacementX + -styling.graphic.anchorPointX * (double)buffImage.getWidth() * sizeMulti) * multiplier), wtst.getScreenY(y + (styling.graphic.displacementY + styling.graphic.anchorPointY * styling.graphic.size) * multiplier));
        }
        image.setTransparency((float)styling.graphic.opacity);
    }

    protected void applyPolygonStyling(PPath pfeature, PolygonStyling styling, MappingComponent map) {
        if (styling.fill != null) {
            this.applyFill(styling.uom, styling.fill, pfeature, map);
        }
        if (styling.stroke != null) {
            this.applyStroke(styling.uom, styling.stroke, pfeature, map);
        }
    }

    protected void applyStroke(UOM uom, org.deegree.style.styling.components.Stroke stroke, PPath pfeature, MappingComponent map) {
        double multiplier = this.getMultiplierFromDeegreeUOM(uom);
        int linecap = 1;
        if (stroke.linecap == Stroke.LineCap.BUTT) {
            linecap = 0;
        } else if (stroke.linecap == Stroke.LineCap.ROUND) {
            linecap = 1;
        } else if (stroke.linecap == Stroke.LineCap.SQUARE) {
            linecap = 2;
        }
        int lineJoin = 1;
        if (stroke.linejoin == Stroke.LineJoin.BEVEL) {
            lineJoin = 2;
        } else if (stroke.linejoin == Stroke.LineJoin.MITRE) {
            lineJoin = 0;
        } else if (stroke.linejoin == Stroke.LineJoin.ROUND) {
            lineJoin = 1;
        }
        float[] dash_array = null;
        if (stroke.dasharray != null && stroke.dasharray.length != 0) {
            dash_array = new float[stroke.dasharray.length];
            for (int i = 0; i < stroke.dasharray.length; ++i) {
                dash_array[i] = (float)(stroke.dasharray[i] * multiplier);
            }
        }
        BasicStroke newStroke = uom == UOM.Pixel ? new CustomFixedWidthStroke((float)stroke.width, linecap, lineJoin, 1.0f, dash_array, (float)stroke.dashoffset, map) : new BasicStroke((float)(stroke.width * multiplier), linecap, lineJoin, 1.0f, dash_array, (float)(stroke.dashoffset * multiplier));
        pfeature.setStroke((Stroke)newStroke);
        pfeature.setStrokePaint(this.getPaintFromDeegree(stroke.fill, stroke.color, uom, (PNode)pfeature, map));
    }

    protected Feature getDeegreeFeature() {
        return new DeegreeFeature();
    }

    @Override
    public void applyStyle(PFeature pfeature, WorldToScreenTransform wtst) {
        if (this.styles == null) {
            return;
        }
        this.stylings = null;
        pfeature.setStrokePaint(null);
        pfeature.setStroke(null);
        pfeature.setPaintOnAllFeatures(null);
        pfeature.setPaint(null);
        for (org.deegree.style.se.unevaluated.Style tempStyle : this.styles) {
            org.deegree.style.se.unevaluated.Style filteredStyle = tempStyle.filter(pfeature.getMappingComponent().getScaleDenominator());
            LinkedList tempStylings = filteredStyle.evaluate(this.getDeegreeFeature(), this.evaluator);
            if (this.stylings == null) {
                this.stylings = tempStylings;
                continue;
            }
            this.stylings.addAll(tempStylings);
        }
        ListIterator it = pfeature.getChildrenIterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof PSticky)) continue;
            pfeature.getMappingComponent().removeStickyNode((PSticky)child);
        }
        pfeature.removeAllChildren();
        pfeature.sldStyledPolygon.clear();
        for (PImage image : pfeature.sldStyledImage) {
            if (!(image instanceof PSticky)) continue;
            pfeature.getMappingComponent().removeStickyNode((PSticky)image);
        }
        pfeature.sldStyledImage.clear();
        for (PFeature.PTextWithDisplacement text : pfeature.sldStyledText) {
            pfeature.getMappingComponent().removeStickyNode(text);
        }
        pfeature.sldStyledText.clear();
        if (this.stylings == null || this.stylings.size() == 0) {
            return;
        }
        Geometry geom = pfeature.getFeature().getGeometry();
        int polygonNr = -1;
        int textNr = 0;
        int imageNr = 0;
        ArrayList<Triple<Styling, LinkedList<org.deegree.geometry.Geometry>, String>> reverseList = new ArrayList<Triple<Styling, LinkedList<org.deegree.geometry.Geometry>, String>>(this.stylings);
        if (geom != null && !geom.getGeometryType().equalsIgnoreCase("Point")) {
            Collections.reverse(reverseList);
        }
        for (Triple triple : reverseList) {
            PImage selectedImage;
            PImage image;
            PFeature path;
            if (triple.first instanceof PolygonStyling && (geom instanceof Polygon || geom instanceof MultiPolygon)) {
                Geometry newGeom;
                double metrePerPixel;
                final PolygonStyling polygonStyle = (PolygonStyling)triple.first;
                if (polygonNr < 0) {
                    path = pfeature;
                } else {
                    try {
                        path = pfeature.sldStyledPolygon.get(polygonNr);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        path = new PPath();
                        pfeature.sldStyledPolygon.add(path);
                        pfeature.addChild((PNode)path);
                    }
                    path.setPathTo((GeneralPath)pfeature.getPathReference().clone());
                }
                if (polygonStyle.displacementX != 0.0 || polygonStyle.displacementY != 0.0) {
                    if (polygonStyle.uom == UOM.Pixel) {
                        MappingComponent mc = pfeature.getViewer();
                        metrePerPixel = mc.getCamera().getViewBounds().getHeight() / (double)mc.getHeight();
                        Geometry newGeom2 = (Geometry)geom.clone();
                        newGeom2.apply(new CoordinateFilter(){

                            public void filter(Coordinate coord) {
                                coord.x += polygonStyle.displacementX * metrePerPixel;
                                coord.y += polygonStyle.displacementY * metrePerPixel;
                            }
                        });
                        newGeom2.geometryChanged();
                        this.setPath(path, newGeom2, wtst);
                    } else {
                        final double multiplier = this.getMultiplierFromDeegreeUOM(polygonStyle.uom);
                        newGeom = (Geometry)geom.clone();
                        newGeom.apply(new CoordinateFilter(){

                            public void filter(Coordinate coord) {
                                coord.x += polygonStyle.displacementX * multiplier;
                                coord.y += polygonStyle.displacementY * multiplier;
                            }
                        });
                        newGeom.geometryChanged();
                        this.setPath(path, newGeom, wtst);
                    }
                }
                if (polygonStyle.perpendicularOffset != 0.0) {
                    if (polygonStyle.uom == UOM.Pixel) {
                        MappingComponent mc = pfeature.getViewer();
                        metrePerPixel = mc.getCamera().getViewBounds().getHeight() / (double)mc.getHeight();
                        Geometry newGeom2 = this.createOffsetCurve(geom, polygonStyle.perpendicularOffset * metrePerPixel);
                        this.setPath(path, newGeom2, wtst);
                    } else {
                        double multiplier = this.getMultiplierFromDeegreeUOM(polygonStyle.uom);
                        newGeom = this.createOffsetCurve(geom, polygonStyle.perpendicularOffset * multiplier);
                        this.setPath(path, newGeom, wtst);
                    }
                }
                this.applyPolygonStyling(path, (PolygonStyling)triple.first, pfeature.getMappingComponent());
                ++polygonNr;
                continue;
            }
            if (triple.first instanceof LineStyling && (geom instanceof LineString || geom instanceof MultiLineString)) {
                LineStyling lineStyle = (LineStyling)triple.first;
                if (polygonNr < 0) {
                    path = pfeature;
                } else {
                    try {
                        path = pfeature.sldStyledPolygon.get(polygonNr);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        path = new PPath();
                        pfeature.sldStyledPolygon.add(path);
                        pfeature.addChild((PNode)path);
                    }
                    path.setPathTo((GeneralPath)pfeature.getPathReference().clone());
                }
                Geometry offsetGeom = geom;
                if (lineStyle.perpendicularOffset != 0.0) {
                    if (lineStyle.uom == UOM.Pixel) {
                        MappingComponent mc = pfeature.getViewer();
                        double metrePerPixel = mc.getCamera().getViewBounds().getHeight() / (double)mc.getHeight();
                        offsetGeom = this.createOffsetCurve(geom, lineStyle.perpendicularOffset * metrePerPixel);
                        this.setPath(path, offsetGeom, wtst);
                    } else {
                        double multiplier = this.getMultiplierFromDeegreeUOM(lineStyle.uom);
                        offsetGeom = this.createOffsetCurve(geom, lineStyle.perpendicularOffset * multiplier);
                        this.setPath(path, offsetGeom, wtst);
                    }
                }
                List<EndPointStyle> epStyles = this.getEndPointStyles();
                this.applyLineStyling(path, (LineStyling)triple.first, pfeature.getMappingComponent());
                ++polygonNr;
                if (epStyles.isEmpty()) continue;
                for (EndPointStyle tmpStyle : epStyles) {
                    MappingComponent mc = pfeature.getViewer();
                    double metrePerPixel = mc.getCamera().getViewBounds().getHeight() / (double)mc.getHeight();
                    path = new PPath();
                    GeneralPath newPath = tmpStyle.arrowhead(this.transformCoordinateArr(offsetGeom.getCoordinates(), wtst), metrePerPixel);
                    pfeature.sldStyledPolygon.add(path);
                    pfeature.addChild((PNode)path);
                    path.setPathTo(newPath);
                    this.applyLineStyling(path, (LineStyling)triple.first, pfeature.getMappingComponent());
                    ++polygonNr;
                }
                continue;
            }
            if (triple.first instanceof TextStyling && triple.third != null && !((String)triple.third).equals("null")) {
                PFeature.PTextWithDisplacement text;
                try {
                    text = pfeature.sldStyledText.get(textNr++);
                }
                catch (IndexOutOfBoundsException ex) {
                    text = pfeature.new PFeature.PTextWithDisplacement();
                    pfeature.sldStyledText.add(text);
                    pfeature.addChild((PNode)text);
                    pfeature.getMappingComponent().addStickyNode(text);
                }
                Point intPoint = CrsTransformer.transformToGivenCrs(this.getGeometry(), pfeature.getMappingComponent().getMappingModel().getSrs().getCode()).getInteriorPoint();
                String value = (String)triple.third;
                try {
                    double val = Double.parseDouble((String)triple.third);
                    if (val == (double)((long)val)) {
                        value = String.valueOf((long)val);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.applyTextStyling(text, value, (TextStyling)triple.first, wtst, intPoint.getX(), intPoint.getY());
                this.rescaleStickyNode(pfeature, text);
                continue;
            }
            if (!(triple.first instanceof PointStyling) || !(geom instanceof Point) && !(geom instanceof MultiPoint)) continue;
            try {
                image = pfeature.sldStyledImage.get(imageNr);
                selectedImage = pfeature.sldStyledSelectedImage.get(imageNr++);
            }
            catch (IndexOutOfBoundsException ex) {
                if (((PointStyling)triple.first).uom == UOM.Pixel) {
                    image = new FixedPImage();
                    pfeature.getMappingComponent().addStickyNode((PSticky)image);
                    selectedImage = new FixedPImage();
                    pfeature.getMappingComponent().addStickyNode((PSticky)selectedImage);
                } else {
                    image = new PImage();
                    selectedImage = new PImage();
                }
                pfeature.sldStyledImage.add(image);
                pfeature.sldStyledSelectedImage.add(selectedImage);
                pfeature.addChild((PNode)image);
            }
            if (((PointStyling)triple.first).uom == UOM.Pixel) {
                if (!(image instanceof FixedPImage)) {
                    pfeature.removeChild((PNode)image);
                    pfeature.sldStyledImage.remove(image);
                    pfeature.sldStyledSelectedImage.remove(selectedImage);
                    image = new FixedPImage();
                    pfeature.sldStyledImage.add(image);
                    pfeature.sldStyledSelectedImage.add(selectedImage);
                    pfeature.addChild((PNode)image);
                    pfeature.addChild((PNode)selectedImage);
                    pfeature.getMappingComponent().addStickyNode((PSticky)image);
                    pfeature.getMappingComponent().addStickyNode((PSticky)selectedImage);
                }
            } else if (image instanceof FixedPImage) {
                pfeature.getMappingComponent().removeStickyNode((PSticky)image);
                pfeature.sldStyledImage.remove(image);
                pfeature.sldStyledSelectedImage.remove(selectedImage);
                pfeature.removeChild((PNode)image);
                image = new PImage();
                pfeature.sldStyledImage.add(image);
                pfeature.sldStyledSelectedImage.add(selectedImage);
                pfeature.addChild((PNode)image);
            }
            Point intPoint = CrsTransformer.transformToGivenCrs(this.getGeometry(), pfeature.getMappingComponent().getMappingModel().getSrs().getCode()).getInteriorPoint();
            this.applyPointStyling(image, (PointStyling)triple.first, wtst, intPoint.getX(), intPoint.getY(), pfeature.getMappingComponent().getCamera(), false);
            this.applyPointStyling(selectedImage, (PointStyling)triple.first, wtst, intPoint.getX(), intPoint.getY(), pfeature.getMappingComponent().getCamera(), true);
            if (((PointStyling)triple.first).uom != UOM.Pixel) continue;
            this.rescaleStickyNode(pfeature, (PSticky)image);
            this.rescaleStickyNode(pfeature, (PSticky)selectedImage);
        }
        if (polygonNr == -1 && imageNr == 0 && textNr == 0) {
            Log.warn((Object)"Es wurde kein passender Symbolizer f\u00fcr das Feature gefunden, Darstellung unm\u00f6glich.");
        }
    }

    private List<EndPointStyle> getEndPointStyles() {
        ArrayList<EndPointStyle> epStyles = new ArrayList<EndPointStyle>();
        for (org.deegree.style.se.unevaluated.Style tempStyle : this.styles) {
            CustomStyle cs;
            if (!(tempStyle instanceof CustomStyle) || (cs = (CustomStyle)tempStyle).getEndPointStyles().isEmpty()) continue;
            for (EndPointStyleDescription epStyle : cs.getEndPointStyles()) {
                try {
                    Class<?> c = Class.forName(epStyle.getClassName());
                    Constructor<?> constructor = c.getConstructor(new Class[0]);
                    Object o = constructor.newInstance(new Object[0]);
                    if (!(o instanceof EndPointStyle)) continue;
                    epStyles.add((EndPointStyle)o);
                }
                catch (Exception ex) {
                    this.logger.error((Object)"Cannot find end point style class", (Throwable)ex);
                }
            }
        }
        return epStyles;
    }

    private Geometry createOffsetCurve(Geometry geom, double offset) {
        BufferParameters bufParams = new BufferParameters();
        bufParams.setSingleSided(true);
        OffsetCurveBuilder curveBuilder = new OffsetCurveBuilder(geom.getPrecisionModel(), bufParams);
        GeometryFactory factory = geom.getFactory();
        if (geom.getNumGeometries() > 1) {
            ArrayList<LineString> geomList = new ArrayList<LineString>();
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                Coordinate[] newCoords = curveBuilder.getOffsetCurve(geom.getGeometryN(i).getCoordinates(), offset);
                LineString newGeom = factory.createLineString(newCoords);
                geomList.add(newGeom);
            }
            return factory.buildGeometry(geomList);
        }
        Coordinate[] newCoords = curveBuilder.getOffsetCurve(geom.getCoordinates(), offset);
        return factory.createLineString(newCoords);
    }

    private void setPath(PPath path, Geometry geom, WorldToScreenTransform wtst) {
        Coordinate[] coordArr;
        int ringIndex;
        int entityIndex;
        Coordinate[][][] entityRingCoordArr = this.getCoordinateArray(geom);
        float[][][] entityRingXArr = new float[entityRingCoordArr.length][][];
        float[][][] entityRingYArr = new float[entityRingCoordArr.length][][];
        for (entityIndex = 0; entityIndex < entityRingCoordArr.length; ++entityIndex) {
            entityRingXArr[entityIndex] = new float[entityRingCoordArr[entityIndex].length][];
            entityRingYArr[entityIndex] = new float[entityRingCoordArr[entityIndex].length][];
            for (ringIndex = 0; ringIndex < entityRingCoordArr[entityIndex].length; ++ringIndex) {
                Coordinate[] transformedCoordArr = this.transformCoordinateArr(entityRingCoordArr[entityIndex][ringIndex], wtst);
                int length = transformedCoordArr.length;
                entityRingXArr[entityIndex][ringIndex] = new float[length];
                entityRingYArr[entityIndex][ringIndex] = new float[length];
                for (int coordIndex = 0; coordIndex < length; ++coordIndex) {
                    entityRingXArr[entityIndex][ringIndex][coordIndex] = (float)transformedCoordArr[coordIndex].x;
                    entityRingYArr[entityIndex][ringIndex][coordIndex] = (float)transformedCoordArr[coordIndex].y;
                }
            }
        }
        path.getPathReference().reset();
        if (geom instanceof Point) {
            path.setPathToPolyline(new float[]{entityRingXArr[0][0][0], entityRingXArr[0][0][0]}, new float[]{entityRingYArr[0][0][0], entityRingYArr[0][0][0]});
        } else if (geom instanceof LineString || geom instanceof MultiPoint) {
            path.setPathToPolyline(entityRingXArr[0][0], entityRingYArr[0][0]);
        } else if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            path.getPathReference().setWindingRule(0);
            for (entityIndex = 0; entityIndex < entityRingCoordArr.length; ++entityIndex) {
                for (ringIndex = 0; ringIndex < entityRingCoordArr[entityIndex].length; ++ringIndex) {
                    coordArr = entityRingCoordArr[entityIndex][ringIndex];
                    this.addLinearRing(path, coordArr, wtst);
                }
            }
            path.updateBoundsFromPath();
            path.invalidatePaint();
        } else if (geom instanceof MultiLineString) {
            for (entityIndex = 0; entityIndex < entityRingCoordArr.length; ++entityIndex) {
                for (ringIndex = 0; ringIndex < entityRingCoordArr[entityIndex].length; ++ringIndex) {
                    coordArr = entityRingCoordArr[entityIndex][ringIndex];
                    this.addLinearRing(path, coordArr, wtst);
                }
            }
            path.updateBoundsFromPath();
            path.invalidatePaint();
        }
    }

    private void addLinearRing(PPath path, Coordinate[] coordinateArr, WorldToScreenTransform wtst) {
        Coordinate[] points = this.transformCoordinateArr(coordinateArr, wtst);
        GeneralPath gp = new GeneralPath();
        gp.reset();
        if (points.length > 0) {
            gp.moveTo((float)points[0].x, (float)points[0].y);
            for (int i = 1; i < points.length; ++i) {
                gp.lineTo((float)points[i].x, (float)points[i].y);
            }
        }
        path.getPathReference().append(gp, false);
    }

    private Coordinate[] transformCoordinateArr(Coordinate[] coordinateArr, WorldToScreenTransform wtst) {
        Coordinate[] points = new Coordinate[coordinateArr.length];
        for (int i = 0; i < coordinateArr.length; ++i) {
            points[i] = new Coordinate();
            if (wtst == null) {
                points[i].x = (float)coordinateArr[i].x;
                points[i].y = (float)coordinateArr[i].y;
                continue;
            }
            points[i].x = (float)wtst.getDestX(coordinateArr[i].x);
            points[i].y = (float)wtst.getDestY(coordinateArr[i].y);
        }
        return points;
    }

    private Coordinate[][][] getCoordinateArray(Geometry geom) {
        Coordinate[][][] otherCoords;
        block6: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block5: {
                                    otherCoords = null;
                                    if (!(geom instanceof Point)) break block5;
                                    Point point = (Point)geom;
                                    otherCoords = new Coordinate[][][]{{{point.getCoordinate()}}};
                                    break block6;
                                }
                                if (!(geom instanceof LineString)) break block7;
                                LineString lineString = (LineString)geom;
                                otherCoords = new Coordinate[][][]{{lineString.getCoordinates()}};
                                break block6;
                            }
                            if (!(geom instanceof Polygon)) break block8;
                            Polygon polygon = (Polygon)geom;
                            int numOfHoles = polygon.getNumInteriorRing();
                            otherCoords = new Coordinate[1][1 + numOfHoles][];
                            otherCoords[0][0] = polygon.getExteriorRing().getCoordinates();
                            for (int ringIndex = 1; ringIndex < otherCoords[0].length; ++ringIndex) {
                                otherCoords[0][ringIndex] = polygon.getInteriorRingN(ringIndex - 1).getCoordinates();
                            }
                            break block6;
                        }
                        if (geom instanceof LinearRing) break block6;
                        if (!(geom instanceof MultiPoint)) break block9;
                        otherCoords = new Coordinate[][][]{{((MultiPoint)geom).getCoordinates()}};
                        break block6;
                    }
                    if (!(geom instanceof MultiLineString)) break block10;
                    MultiLineString multiLineString = (MultiLineString)geom;
                    int numOfGeoms = multiLineString.getNumGeometries();
                    otherCoords = new Coordinate[numOfGeoms][][];
                    for (int entityIndex = 0; entityIndex < numOfGeoms; ++entityIndex) {
                        Coordinate[] coordSubArr = ((LineString)multiLineString.getGeometryN(entityIndex)).getCoordinates();
                        otherCoords[entityIndex] = new Coordinate[][]{coordSubArr};
                    }
                    break block6;
                }
                if (!(geom instanceof MultiPolygon)) break block11;
                MultiPolygon multiPolygon = (MultiPolygon)geom;
                int numOfEntities = multiPolygon.getNumGeometries();
                otherCoords = new Coordinate[numOfEntities][][];
                for (int entityIndex = 0; entityIndex < numOfEntities; ++entityIndex) {
                    Polygon polygon = (Polygon)multiPolygon.getGeometryN(entityIndex);
                    int numOfHoles = polygon.getNumInteriorRing();
                    otherCoords[entityIndex] = new Coordinate[1 + numOfHoles][];
                    otherCoords[entityIndex][0] = polygon.getExteriorRing().getCoordinates();
                    for (int ringIndex = 1; ringIndex < otherCoords[entityIndex].length; ++ringIndex) {
                        otherCoords[entityIndex][ringIndex] = polygon.getInteriorRingN(ringIndex - 1).getCoordinates();
                    }
                }
                break block6;
            }
            if (!(geom instanceof GeometryCollection)) break block6;
            GeometryCollection gc = (GeometryCollection)geom;
            int numOfGeoms = gc.getNumGeometries();
            otherCoords = new Coordinate[numOfGeoms][][];
            for (int entityIndex = 0; entityIndex < numOfGeoms; ++entityIndex) {
                Coordinate[][][] coordSubArr = this.getCoordinateArray(gc.getGeometryN(entityIndex));
                otherCoords[entityIndex] = coordSubArr[0];
            }
        }
        return otherCoords;
    }

    protected void rescaleStickyNode(PFeature pfeature, PSticky sticky) {
        double s = pfeature.getMappingComponent().getCamera().getViewScale();
        sticky.setScale(1.0 / s);
    }

    protected void applyTextStyling(PFeature.PTextWithDisplacement ptext, String value, TextStyling textStyling, WorldToScreenTransform wtst, double x, double y) {
        ptext.setText(value);
        ptext.setOffset(wtst.getScreenX(x), wtst.getScreenY(y));
        ptext.setTextPaint(textStyling.fill.color);
        java.awt.Font font = null;
        try {
            for (String fontName : textStyling.font.fontFamily) {
                font = new java.awt.Font(fontName, this.getFontStyling(textStyling.font), (int)textStyling.font.fontSize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ptext.setFont(font);
        ptext.setRotation(Math.toRadians(textStyling.rotation));
        if (textStyling.halo != null) {
            Halo halo = textStyling.halo;
            if (halo.fill != null && halo.fill.color != null) {
                ptext.setPaint(halo.fill.color);
            }
            if (halo.radius != 0.0) {
                PBounds bound = ptext.getBounds();
                ptext.setBounds(bound.x, bound.y, bound.width + halo.radius, bound.height + halo.radius);
            }
        }
        if (textStyling.uom == UOM.Pixel) {
            ptext.setDisplacement(this.getUOMFromDeegree(textStyling.uom), textStyling.displacementX, textStyling.displacementY, textStyling.anchorPointX, textStyling.anchorPointY, wtst);
        } else {
            double multiplier = this.getMultiplierFromDeegreeUOM(textStyling.uom);
            ptext.setDisplacement(this.getUOMFromDeegree(textStyling.uom), textStyling.displacementX * multiplier, textStyling.displacementY * multiplier, textStyling.anchorPointX, textStyling.anchorPointY, wtst);
        }
    }

    protected int getFontStyling(Font font) {
        int bolt = font.bold ? 1 : 0;
        switch (font.fontStyle) {
            case OBLIQUE: 
            case ITALIC: {
                return bolt + 2;
            }
            case NORMAL: {
                return bolt;
            }
        }
        return bolt;
    }

    protected BufferedImage getImageFromDeegree(Graphic graphic, boolean selected) {
        if (graphic.image != null) {
            if (selected) {
                return this.getSelectedImageFromImage(graphic.image);
            }
            return graphic.image;
        }
        BufferedImage temp = this.getImageFromWellKnownName(graphic.mark.wellKnown);
        if (graphic.mark.fill != null && graphic.mark.fill.color != null) {
            BufferedImage coloredVerion = new BufferedImage(temp.getWidth(), temp.getHeight(), 2);
            Graphics2D g = (Graphics2D)coloredVerion.getGraphics();
            if (selected) {
                g.setColor(PFeature.getHighlightingColorFromColor(graphic.mark.fill.color));
            } else {
                g.setColor(graphic.mark.fill.color);
            }
            g.fillRect(0, 0, temp.getWidth(), temp.getHeight());
            g.setComposite(AlphaComposite.DstIn);
            g.drawImage(temp, 0, 0, temp.getWidth(), temp.getHeight(), 0, 0, temp.getWidth(), temp.getHeight(), null);
            temp = coloredVerion;
        }
        return temp;
    }

    protected BufferedImage getImageFromWellKnownName(Mark.SimpleMark mark) {
        URL url = null;
        switch (mark) {
            case CIRCLE: {
                url = this.getClass().getResource("/icon-circlerecord.png");
                break;
            }
            case CROSS: {
                url = this.getClass().getResource("/icon-plus.png");
                break;
            }
            case SQUARE: {
                url = this.getClass().getResource("/icon-squareapp.png");
                break;
            }
            case STAR: {
                url = this.getClass().getResource("/icon-star.png");
                break;
            }
            case TRIANGLE: {
                url = this.getClass().getResource("/icon-play.png");
                break;
            }
            case X: {
                url = this.getClass().getResource("/icon-remove.png");
            }
        }
        if (url == null) {
            throw new RuntimeException("could not load Resource" + mark);
        }
        ImageIcon icon = new ImageIcon(url);
        Image image = icon.getImage();
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2d = bimage.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        return bimage;
    }

    protected double getMultiplierFromDeegreeUOM(UOM uom) {
        switch (uom) {
            case Foot: {
                return 0.3048;
            }
            case Metre: {
                return 1.0;
            }
            case Pixel: {
                return 1.0;
            }
            case mm: {
                return 0.001;
            }
        }
        throw new RuntimeException("unknown UOM" + uom.toString());
    }

    protected Paint getPaintFromDeegree(Graphic graphic, Color color, UOM uom, PNode parent, MappingComponent map) {
        Paint texture;
        if (graphic == null) {
            return color;
        }
        double multiplier = this.getMultiplierFromDeegreeUOM(uom);
        BufferedImage image = this.getImageFromDeegree(graphic, false);
        if (uom != UOM.Pixel) {
            texture = new TexturePaint(image, new Rectangle2D.Double(0.0, 0.0, multiplier * graphic.size * (double)image.getWidth() / (double)image.getHeight(), graphic.size * multiplier));
        } else {
            RescaleOp rescaleOp = new RescaleOp(0.25f, 0.0f, null);
            texture = new SelectionAwareTexturePaint(image, rescaleOp.filter(image, null), rescaleOp.filter(image, null), new Rectangle2D.Double(0.0, 0.0, multiplier * graphic.size * (double)image.getWidth(), multiplier * graphic.size * (double)image.getHeight()));
        }
        return texture;
    }

    protected SLDStyledFeature.UOM getUOMFromDeegree(UOM uom) {
        switch (uom) {
            case Foot: {
                return SLDStyledFeature.UOM.foot;
            }
            case Metre: {
                return SLDStyledFeature.UOM.metre;
            }
            case Pixel: {
                return SLDStyledFeature.UOM.pixel;
            }
            case mm: {
                return SLDStyledFeature.UOM.mm;
            }
        }
        throw new RuntimeException("unknown UOM" + uom.toString());
    }

    @Override
    public void setSLDStyles(List<org.deegree.style.se.unevaluated.Style> featureStyles) {
        if (this.styles == null || !this.styles.equals(featureStyles)) {
            this.styles = featureStyles;
            this.stylings = null;
            this.resetCustomStylesAdjustments();
        }
    }

    private void resetCustomStylesAdjustments() {
        this.customFillingStyle = null;
    }

    private BufferedImage getSelectedImageFromImage(BufferedImage unselectedImage) {
        BufferedImage bImage = selectedImage.get(unselectedImage);
        if (bImage == null) {
            Image image = this.ensureRGBAImage(unselectedImage);
            image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new SelectedFilter()));
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            bImage = new BufferedImage(width, height, 2);
            bImage.getGraphics().drawImage(image, 0, 0, null);
            selectedImage.put(unselectedImage, bImage);
        }
        return bImage;
    }

    private BufferedImage ensureRGBAImage(BufferedImage image) {
        if (image != null && image.getType() != 2) {
            BufferedImage tmpImg = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics g = tmpImg.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            image = tmpImg;
        }
        return image;
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        this.container.put(propertyName, propertyValue);
    }

    public FeatureServiceFeature saveChanges() throws Exception {
        throw new UnsupportedOperationException();
    }

    public void undoAll() {
        throw new UnsupportedOperationException();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public String toString() {
        AbstractFeatureService service = this.layerProperties.getFeatureService();
        ArrayList<String> nameParts = new ArrayList<String>();
        if (service != null) {
            Map<String, FeatureServiceAttribute> attributes = service.getFeatureServiceAttributes();
            List<String> attributeNames = service.getOrderedFeatureServiceAttributes();
            Iterator<String> iterator = attributeNames.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                FeatureServiceAttribute attr = attributes.get(key);
                if (!attr.isNameElement()) continue;
                nameParts.add(String.valueOf(this.getProperty(key)));
            }
        }
        if (!nameParts.isEmpty()) {
            StringBuilder sb = null;
            for (String string : nameParts) {
                if (sb == null) {
                    sb = new StringBuilder();
                    sb.append(string);
                    continue;
                }
                sb.append(" - ").append(string);
            }
            return sb.toString();
        }
        String[] prefferedKeys = new String[]{"ID", "id", "Id", "app:ID", "app:id", "app:Id"};
        HashMap propertyMap = this.getProperties();
        for (String key : prefferedKeys) {
            Object id;
            if (!propertyMap.containsKey(key) || (id = propertyMap.get(key)) == null) continue;
            return id.toString();
        }
        Iterator iterator = propertyMap.keySet().iterator();
        if (iterator.hasNext()) {
            return String.valueOf(propertyMap.get(iterator.next()));
        }
        return super.toString();
    }

    @Override
    public int compareTo(DefaultFeatureServiceFeature o) {
        return Integer.compare(this.id, o.id);
    }

    @Override
    public String getName() {
        return null;
    }

    private class SelectedFilter
    extends RGBImageFilter {
        private SelectedFilter() {
        }

        @Override
        public int filterRGB(int x, int y, int argb) {
            int r = (argb & 0xFF0000) >> 16;
            int g = (argb & 0xFF00) >> 8;
            int b = argb & 0xFF;
            Color c = new Color(r, g, b);
            Color newColor = PFeature.getHighlightingColorFromColor(c);
            return argb & 0xFF000000 | newColor.getRed() << 16 | newColor.getGreen() << 8 | newColor.getBlue();
        }
    }

    protected class DeegreeProperty
    implements Property {
        private QName name;
        private Object value;

        public DeegreeProperty(QName name, Object value) {
            this.name = name;
            this.value = value;
        }

        public QName getName() {
            return this.name;
        }

        public TypedObjectNode getValue() {
            if (this.value == null) {
                return new PrimitiveValue((Object)"null");
            }
            if (this.value instanceof String) {
                return new PrimitiveValue((String)this.value, new PrimitiveType(BaseType.STRING));
            }
            if (this.value instanceof Float) {
                return new PrimitiveValue((Object)new Double(((Float)this.value).floatValue()), new PrimitiveType(BaseType.DOUBLE));
            }
            if (this.value instanceof Boolean) {
                return new PrimitiveValue((Object)((Boolean)this.value), new PrimitiveType(BaseType.BOOLEAN));
            }
            if (this.value instanceof Double) {
                return new PrimitiveValue((Object)((Double)this.value), new PrimitiveType(BaseType.DOUBLE));
            }
            if (this.value instanceof Integer) {
                return new PrimitiveValue((Object)((Integer)this.value), new PrimitiveType(BaseType.INTEGER));
            }
            if (this.value instanceof Long) {
                return new PrimitiveValue((Object)((Long)this.value), new PrimitiveType(BaseType.INTEGER));
            }
            if (this.value instanceof org.deegree.geometry.Geometry) {
                return (org.deegree.geometry.Geometry)this.value;
            }
            if (this.value instanceof org.deegree.model.spatialschema.Geometry) {
                try {
                    org.deegree.model.spatialschema.Geometry geo = (org.deegree.model.spatialschema.Geometry)this.value;
                    Geometry g = JTSAdapter.export((org.deegree.model.spatialschema.Geometry)geo);
                    if (geo.getCoordinateSystem() != null) {
                        int srid = CrsTransformer.extractSridFromCrs(geo.getCoordinateSystem().getIdentifier());
                        g.setSRID(srid);
                    }
                    return defaultGeom.createFromJTS(g, null);
                }
                catch (Exception e) {
                    DefaultFeatureServiceFeature.this.logger.error((Object)"Cannot create deegree3 from deegree3 geometry.", (Throwable)e);
                    return new PrimitiveValue((Object)"null");
                }
            }
            if (this.value instanceof Geometry) {
                return defaultGeom.createFromJTS((Geometry)this.value, null);
            }
            return new PrimitiveValue((Object)"null");
        }

        public String toString() {
            return this.value.toString();
        }

        public PropertyType getType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setValue(TypedObjectNode ton) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setChildren(List<TypedObjectNode> list) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<QName, PrimitiveValue> getAttributes() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List<TypedObjectNode> getChildren() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public XSElementDeclaration getXSType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected class DeegreeFeatureType
    implements FeatureType {
        public GeometryPropertyType getDefaultGeometryPropertyDeclaration() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Feature newFeature(String string, List<Property> list, ExtraProps ep) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public AppSchema getSchema() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public GMLObjectCategory getCategory() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public QName getName() {
            return new QName("");
        }

        public boolean isAbstract() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public PropertyType getPropertyDeclaration(QName qname) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List<PropertyType> getPropertyDeclarations() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected class DeegreeFeature
    implements Feature {
        protected DeegreeFeature() {
        }

        public List<Property> getGeometryProperties() {
            return new ArrayList<Property>();
        }

        public FeatureType getType() {
            return new DeegreeFeatureType();
        }

        public List<Property> getProperties(QName qname) {
            LinkedList<Property> deegreeProperties = new LinkedList<Property>();
            if (qname == null) {
                return deegreeProperties;
            }
            String key = qname.getPrefix() != null && !qname.getPrefix().isEmpty() ? qname.getPrefix() + ":" + qname.getLocalPart() : qname.getLocalPart();
            if (DefaultFeatureServiceFeature.this.getProperties().containsKey(key)) {
                Object value = DefaultFeatureServiceFeature.this.getProperty(key);
                if (value == null) {
                    deegreeProperties.add(null);
                } else if (value instanceof BigDecimal) {
                    deegreeProperties.add(new DeegreeProperty(qname, ((BigDecimal)value).doubleValue()));
                } else {
                    deegreeProperties.add(new DeegreeProperty(qname, value));
                }
            } else if (DefaultFeatureServiceFeature.this.getProperties().containsKey("app:" + qname.getLocalPart())) {
                Object value = DefaultFeatureServiceFeature.this.getProperty("app:" + qname.getLocalPart());
                if (value == null) {
                    deegreeProperties.add(null);
                } else {
                    deegreeProperties.add(new DeegreeProperty(qname, value));
                }
            }
            return deegreeProperties;
        }

        public void setId(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public QName getName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Envelope getEnvelope() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setEnvelope(Envelope envlp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Envelope calcEnvelope() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setPropertyValue(QName qname, int i, TypedObjectNode ton) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setProperties(List<Property> list) throws IllegalArgumentException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ExtraProps getExtraProperties() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setExtraProperties(ExtraProps ep) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List<Property> getProperties() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected class DeegreeEvaluator
    implements XPathEvaluator<Feature> {
        protected DeegreeEvaluator() {
        }

        public TypedObjectNode[] eval(Feature t, ValueReference vr) throws FilterEvaluationException {
            List properties = t.getProperties(vr.getAsQName());
            TypedObjectNode[] ret = properties.toArray(new TypedObjectNode[properties.size()]);
            return ret;
        }

        public String getId(Feature t) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

