/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.JDBCFeatureInfo;
import de.cismet.cismap.commons.features.ModifiableFeature;
import de.cismet.cismap.commons.featureservice.factory.H2FeatureServiceFactory;
import de.cismet.cismap.commons.featureservice.factory.JDBCFeatureFactory;
import de.cismet.cismap.commons.gui.attributetable.H2AttributeTableRuleSet;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.cismap.linearreferencing.tools.StationEditorInterface;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.deegree.style.se.unevaluated.Style;
import org.h2.jdbc.JdbcClob;

public class JDBCFeature
extends DefaultFeatureServiceFeature
implements ModifiableFeature {
    private static final Object sync = new Object();
    private static final String DELETE_STATEMENT = "DELETE FROM \"%1s\" WHERE \"%2s\" = %3s;";
    private Map<String, StationEditorInterface> stations = null;
    private Color backgroundColor;
    private final JDBCFeatureInfo featureInfo;
    private boolean modified = false;
    private boolean deleted = false;

    public JDBCFeature(JDBCFeatureInfo shapeInfo, List<Style> styles) {
        this.setSLDStyles(styles);
        this.featureInfo = shapeInfo;
    }

    @Override
    public void setEditable(boolean editable) {
        boolean oldEditableStatus = this.isEditable();
        super.setEditable(editable);
        if (oldEditableStatus != editable) {
            this.modified = false;
            if (!editable && this.stations != null) {
                for (String key : this.stations.keySet()) {
                    this.stations.get(key).dispose();
                }
                this.stations.clear();
            } else if (!editable || CismapBroker.getInstance().getMappingComponent().getFeatureCollection().contains(this)) {
                CismapBroker.getInstance().getMappingComponent().getFeatureCollection().unholdFeature(this);
                CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature(this);
            }
            if (editable) {
                H2AttributeTableRuleSet tableRuleSet = (H2AttributeTableRuleSet)this.getLayerProperties().getAttributeTableRuleSet();
                if (tableRuleSet.getAllLinRefInfos() == null || tableRuleSet.getAllLinRefInfos().isEmpty()) {
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature(this);
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().holdFeature(this);
                    SelectionManager.getInstance().addSelectedFeatures(Collections.nCopies(1, this));
                    this.setBackgroundColor(new Color(255, 91, 0));
                } else {
                    tableRuleSet.startEditMode(this);
                }
            }
        }
    }

    @Override
    public HashMap getProperties() {
        if (this.existProperties()) {
            return super.getProperties();
        }
        LinkedHashMap<String, Object> container = null;
        int id = this.getId();
        try {
            container = this.featureInfo.getPropertiesFromCache(id);
            if (container != null) {
                return container;
            }
            container = new LinkedHashMap();
            ResultSet rs = null;
            PreparedStatement ps = this.featureInfo.getPropertiesStatement();
            ps.setInt(1, id);
            rs = ps.executeQuery();
            if (rs.next()) {
                int count = rs.getMetaData().getColumnCount();
                for (int i = 0; i < count; ++i) {
                    container.put(rs.getMetaData().getColumnName(i + 1), this.getPrepareObject(rs.getObject(i + 1)));
                }
            }
            this.featureInfo.addPropertiesToCache(id, container);
        }
        catch (Exception e) {
            this.logger.error((Object)"Cannot read properties from the database.", (Throwable)e);
        }
        return container;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (this.existProperties()) {
            return super.getProperties().get(propertyName);
        }
        int id = this.getId();
        String cacheId = id + "@" + propertyName;
        Object result = this.featureInfo.getPropertyFromCache(cacheId);
        if (result == null) {
            try {
                PreparedStatement ps = this.featureInfo.getPreparedStatementForProperty(propertyName);
                ps.setInt(1, id);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    result = this.getPrepareObject(rs.getObject(1));
                }
                try {
                    rs.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error while closing H2 result set", (Throwable)e);
                }
                this.featureInfo.addPropertyToCache(cacheId, result);
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot read property from the database.", (Throwable)e);
            }
        }
        return result;
    }

    private Object getPrepareObject(Object o) {
        if (o instanceof JdbcClob) {
            try {
                String tmp;
                BufferedReader r = new BufferedReader(((JdbcClob)o).getCharacterStream());
                StringBuilder resultString = new StringBuilder();
                while ((tmp = r.readLine()) != null) {
                    resultString.append(tmp).append('\n');
                }
                return resultString.toString();
            }
            catch (Exception e) {
                this.logger.error((Object)"Error while reading clob", (Throwable)e);
                return null;
            }
        }
        return o;
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        if (!this.existProperties()) {
            super.setProperties(this.getProperties());
        }
        super.addProperty(propertyName, propertyValue);
        this.featureInfo.clearCache();
        if (this.isEditable()) {
            this.modified = true;
        }
    }

    private boolean existProperties() {
        return !super.getProperties().isEmpty();
    }

    @Override
    public FeatureServiceFeature saveChanges() throws Exception {
        this.saveChangesWithoutReload();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsInDB() throws Exception {
        String checkSql = "SELECT \"%s\" FROM \"%s\" WHERE \"%s\" = %s";
        try (Statement st = this.featureInfo.getConnection().createStatement();){
            boolean alreadyExists;
            String sql = String.format("SELECT \"%s\" FROM \"%s\" WHERE \"%s\" = %s", this.featureInfo.getIdField(), this.featureInfo.getTableName(), this.featureInfo.getIdField(), this.getId());
            ResultSet rs = st.executeQuery(sql);
            boolean bl = alreadyExists = rs != null && rs.next();
            if (rs != null) {
                rs.close();
            }
            boolean bl2 = alreadyExists;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveChangesWithoutReload() throws Exception {
        if (!this.existProperties() || this.deleted) {
            return;
        }
        if (this.stations != null) {
            for (String name : this.stations.keySet()) {
                this.setGeometry(this.stations.get(name).getGeometry());
                if (!(this.stations.get(name).getGeometry() instanceof LineString)) continue;
                break;
            }
        }
        try (Statement st = this.featureInfo.getConnection().createStatement();){
            JDBCFeatureFactory factory;
            if (this.existsInDB()) {
                this.updateFeature(st);
            } else {
                this.addFeature(st);
            }
            if (this.getLayerProperties() != null && this.getLayerProperties().getFeatureService() != null && (factory = (JDBCFeatureFactory)this.getLayerProperties().getFeatureService().getFeatureFactory()) instanceof H2FeatureServiceFactory) {
                Geometry envelope = factory.getEnvelope();
                if (this.getGeometry() != null && envelope != null && !envelope.contains(this.getGeometry())) {
                    ((H2FeatureServiceFactory)factory).determineEnvelope();
                }
            }
        }
    }

    public void saveChangesWithoutUpdateEnvelope() throws Exception {
        if (!this.existProperties() || this.deleted) {
            return;
        }
        if (this.stations != null) {
            for (String name : this.stations.keySet()) {
                this.setGeometry(this.stations.get(name).getGeometry());
                if (!(this.stations.get(name).getGeometry() instanceof LineString)) continue;
                break;
            }
        }
        try (Statement st = this.featureInfo.getConnection().createStatement();){
            if (this.existsInDB()) {
                this.updateFeature(st);
            } else {
                this.addFeature(st);
            }
        }
    }

    public void saveChangesWithoutUpdateEnvelope(Statement st) throws Exception {
        if (!this.existProperties() || this.deleted) {
            return;
        }
        if (this.stations != null) {
            for (String name : this.stations.keySet()) {
                this.setGeometry(this.stations.get(name).getGeometry());
                if (!(this.stations.get(name).getGeometry() instanceof LineString)) continue;
                break;
            }
        }
        if (this.existsInDB()) {
            this.updateFeature(st);
        } else {
            this.addFeature(st);
        }
    }

    public Statement getStatement() {
        try {
            return this.featureInfo.getConnection().createStatement();
        }
        catch (Exception e) {
            this.logger.error((Object)"Cannot create statement", (Throwable)e);
            return null;
        }
    }

    private void updateFeature(Statement st) throws Exception {
        HashMap map = super.getProperties();
        StringBuilder update = new StringBuilder("UPDATE \"");
        update.append(this.featureInfo.getTableName()).append("\" SET ");
        boolean first = true;
        for (Object name : map.keySet()) {
            Object value = map.get(name);
            if (!first) {
                update.append(", ");
            } else {
                first = false;
            }
            String valueString = value instanceof String || value instanceof Geometry || value instanceof Timestamp ? "'" + value + "'" : String.valueOf(value);
            update.append("\"").append(name).append("\"").append(" = ").append(valueString);
        }
        update.append(" WHERE \"" + this.featureInfo.getIdField() + "\" = ").append(this.getId());
        st.executeUpdate(update.toString());
        super.getProperties().clear();
        this.featureInfo.clearCache();
    }

    private void addFeature(Statement st) throws Exception {
        HashMap map = super.getProperties();
        String insertSql = "INSERT INTO \"%1s\" (%2s) VALUES (%3s)";
        ArrayList<String> attributes = new ArrayList<String>(map.keySet().size());
        ArrayList<String> values = new ArrayList<String>(map.keySet().size());
        boolean idExists = false;
        for (Object name : map.keySet()) {
            Object value = map.get(name);
            String valueString = value instanceof String || value instanceof Geometry || value instanceof Timestamp ? "'" + value + '\'' : String.valueOf(value);
            attributes.add("\"" + String.valueOf(name) + '\"');
            values.add(valueString);
            if (!name.equals("id")) continue;
            idExists = true;
        }
        if (!idExists) {
            attributes.add("\"" + String.valueOf("id") + '\"');
            values.add(String.valueOf(this.getId()));
        }
        String query = String.format("INSERT INTO \"%1s\" (%2s) VALUES (%3s)", this.featureInfo.getTableName(), this.listToString(attributes), this.listToString(values));
        st.executeUpdate(query);
        super.getProperties().clear();
        this.featureInfo.clearCache();
    }

    private String listToString(List<String> attributes) {
        boolean firstElement = true;
        StringBuilder sb = new StringBuilder(32);
        for (String element : attributes) {
            if (firstElement) {
                firstElement = false;
            } else {
                sb.append(",");
            }
            sb.append(element);
        }
        return sb.toString();
    }

    @Override
    public void delete() throws Exception {
        super.getProperties().clear();
        super.setProperties(this.getProperties());
        String deleteStat = String.format(DELETE_STATEMENT, this.featureInfo.getTableName(), this.featureInfo.getIdField(), this.getId());
        Statement st = this.featureInfo.getConnection().createStatement();
        st.executeUpdate(deleteStat);
        this.deleted = true;
    }

    @Override
    public void restore() throws Exception {
        this.deleted = false;
        this.saveChangesWithoutReload();
    }

    @Override
    public void undoAll() {
        try {
            if (this.existsInDB()) {
                super.getProperties().clear();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while undo.", (Throwable)e);
            super.getProperties().clear();
        }
    }

    @Override
    public void setProperties(HashMap properties) {
    }

    public Object getStationEditor(String colName) {
        if (this.stations != null) {
            return this.stations.get(colName);
        }
        return null;
    }

    public void setStationEditor(String colName, StationEditorInterface editor) {
        if (this.stations == null) {
            this.stations = new HashMap<String, StationEditorInterface>();
        }
        this.stations.put(colName, editor);
    }

    public PropertyChangeListener getPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                for (String name : JDBCFeature.this.stations.keySet()) {
                    JDBCFeature.this.setProperty(name, ((StationEditorInterface)JDBCFeature.this.stations.get(name)).getValue());
                    JDBCFeature.this.firePropertyChange(name, evt.getOldValue(), evt.getNewValue());
                }
            }
        };
    }

    @Override
    public void addProperty(String propertyName, Object property) {
    }

    @Override
    public void addProperties(Map<String, Object> map) {
    }

    @Override
    public Geometry getGeometry() {
        if (this.existProperties()) {
            return (Geometry)super.getProperty(this.featureInfo.getGeoField());
        }
        return this.getOriginalGeometry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Geometry getOriginalGeometry() {
        Geometry g = null;
        g = this.featureInfo.getGeometryFromCache(this.getId());
        if (g != null) {
            GeometryFactory fg = new GeometryFactory(g.getPrecisionModel(), g.getSRID(), (CoordinateSequenceFactory)CoordinateArraySequenceFactory.instance());
            g = fg.createGeometry(g);
        }
        if (g != null) {
            return this.toSerializableGeometry(g);
        }
        ResultSet rs = null;
        if (this.featureInfo.getGeometryStatement() == null) {
            return null;
        }
        try {
            Object object = sync;
            synchronized (object) {
                PreparedStatement ps = this.featureInfo.getGeometryStatement();
                ps.setInt(1, this.getId());
                rs = ps.executeQuery();
                if (rs.next()) {
                    g = (Geometry)rs.getObject(1);
                    g.setSRID(this.featureInfo.getSrid());
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Cannot read geometry from the database.", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.featureInfo.addGeometryToCache(this.getId(), g);
        return this.toSerializableGeometry(g);
    }

    private Geometry toSerializableGeometry(Geometry g) {
        LineString ls;
        if (g instanceof LineString && (ls = (LineString)g).getCoordinateSequence() instanceof PackedCoordinateSequence) {
            GeometryFactory fg = new GeometryFactory(g.getPrecisionModel(), g.getSRID(), (CoordinateSequenceFactory)CoordinateArraySequenceFactory.instance());
            Geometry newGeometry = fg.createGeometry(g);
            return newGeometry;
        }
        return g;
    }

    @Override
    public void setGeometry(Geometry geom) {
        Geometry oldGeom;
        if (!this.existProperties()) {
            super.setProperties(this.getProperties());
        }
        if ((oldGeom = this.getGeometry()) == null != (geom == null) || oldGeom != null && geom != null && !oldGeom.getEnvelope().equalsExact(geom.getEnvelope()) || !oldGeom.equalsExact(geom)) {
            this.featureInfo.clearCache();
            super.addProperty(this.featureInfo.getGeoField(), geom);
            if (this.isEditable()) {
                this.modified = true;
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JDBCFeature) {
            JDBCFeature other = (JDBCFeature)obj;
            if (this.getId() != -1 || other.getId() != -1) {
                return this.featureInfo.getTableName().equals(other.featureInfo.getTableName()) && this.getId() == other.getId();
            }
            return obj == other;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.getId();
        hash = 41 * hash + (this.featureInfo != null && this.featureInfo.getTableName() != null ? this.featureInfo.getTableName().hashCode() : 0);
        return hash;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public boolean isFeatureChanged() {
        Geometry geom = this.getGeometry();
        Geometry backupGeometry = this.getOriginalGeometry();
        if (backupGeometry == null != (geom == null) || backupGeometry != null && geom != null && !backupGeometry.equalsExact(geom)) {
            return true;
        }
        return this.modified;
    }
}

