/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.util.FilePersistenceManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deegree.style.se.unevaluated.Style;

public class PersistentFeature
implements FeatureServiceFeature {
    private int id;
    private LayerProperties layerProperties;
    private long containerId;
    private long geometryId;
    private String geomField = null;
    private FilePersistenceManager pm;

    public PersistentFeature() {
    }

    public PersistentFeature(FeatureServiceFeature f, FilePersistenceManager pm) {
        this.id = f.getId();
        this.layerProperties = f.getLayerProperties();
        this.pm = pm;
        this.containerId = pm.save(f.getProperties());
        this.geomField = this.getGeometryFieldName();
        if (this.geomField == null) {
            this.geometryId = pm.save(f.getGeometry());
        }
    }

    private String getGeometryFieldName() {
        if (this.getLayerProperties() != null && this.getLayerProperties().getFeatureService() != null && this.getLayerProperties().getFeatureService().getFeatureServiceAttributes() != null) {
            Map<String, FeatureServiceAttribute> attributes = this.getLayerProperties().getFeatureService().getFeatureServiceAttributes();
            for (String key : attributes.keySet()) {
                FeatureServiceAttribute attr = attributes.get(key);
                if (!attr.isGeometry()) continue;
                return attr.getName();
            }
        }
        return "geom";
    }

    @Override
    public Object clone() {
        PersistentFeature f = new PersistentFeature();
        f.id = this.id;
        f.pm = this.pm;
        f.layerProperties = this.layerProperties;
        f.containerId = this.containerId;
        f.geometryId = this.geometryId;
        return f;
    }

    public FilePersistenceManager getPersistenceManager() {
        return this.pm;
    }

    @Override
    public Geometry getGeometry() {
        if (this.geomField == null) {
            return (Geometry)this.pm.load(this.geometryId);
        }
        return (Geometry)this.getProperties().get(this.geomField);
    }

    @Override
    public void setGeometry(Geometry geom) {
    }

    @Override
    public HashMap getProperties() {
        return (HashMap)this.pm.load(this.containerId);
    }

    @Override
    public void setProperties(HashMap properties) {
    }

    @Override
    public void addProperty(String propertyName, Object property) {
    }

    @Override
    public void removeProperty(String propertyName) {
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.getProperties().get(propertyName);
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public LayerProperties getLayerProperties() {
        return this.layerProperties;
    }

    @Override
    public void setLayerProperties(LayerProperties layerProperties) {
        this.layerProperties = layerProperties;
    }

    @Override
    public Paint getLinePaint() {
        return Color.BLACK;
    }

    @Override
    public void setLinePaint(Paint linePaint) {
    }

    @Override
    public int getLineWidth() {
        return 1;
    }

    @Override
    public void setLineWidth(int width) {
    }

    @Override
    public Paint getFillingPaint() {
        return Color.BLACK;
    }

    @Override
    public void setFillingPaint(Paint fillingStyle) {
    }

    @Override
    public float getTransparency() {
        return 1.0f;
    }

    @Override
    public void setTransparency(float transparrency) {
    }

    @Override
    public FeatureAnnotationSymbol getPointAnnotationSymbol() {
        return null;
    }

    @Override
    public void setPointAnnotationSymbol(FeatureAnnotationSymbol featureAnnotationSymbol) {
    }

    @Override
    public boolean isHighlightingEnabled() {
        return true;
    }

    @Override
    public void setHighlightingEnabled(boolean enabled) {
    }

    @Override
    public boolean canBeSelected() {
        return true;
    }

    @Override
    public void setCanBeSelected(boolean canBeSelected) {
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void setEditable(boolean editable) {
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public void hide(boolean hiding) {
    }

    @Override
    public String getPrimaryAnnotation() {
        return null;
    }

    @Override
    public boolean isPrimaryAnnotationVisible() {
        return false;
    }

    @Override
    public void setPrimaryAnnotationVisible(boolean visible) {
    }

    @Override
    public Font getPrimaryAnnotationFont() {
        return null;
    }

    @Override
    public Paint getPrimaryAnnotationPaint() {
        return Color.BLACK;
    }

    @Override
    public double getPrimaryAnnotationScaling() {
        return 1.0;
    }

    @Override
    public float getPrimaryAnnotationJustification() {
        return 0.0f;
    }

    @Override
    public void setPrimaryAnnotationJustification(float just) {
    }

    @Override
    public String getSecondaryAnnotation() {
        return null;
    }

    @Override
    public void setPrimaryAnnotation(String primaryAnnotation) {
    }

    @Override
    public void setPrimaryAnnotationFont(Font primaryAnnotationFont) {
    }

    @Override
    public void setPrimaryAnnotationPaint(Paint primaryAnnotationPaint) {
    }

    @Override
    public void setPrimaryAnnotationScaling(double primaryAnnotationScaling) {
    }

    @Override
    public void setSecondaryAnnotation(String secondaryAnnotation) {
    }

    @Override
    public boolean isAutoscale() {
        return true;
    }

    @Override
    public void setAutoScale(boolean autoScale) {
    }

    @Override
    public Integer getMinScaleDenominator() {
        return 1;
    }

    @Override
    public Integer getMaxScaleDenominator() {
        return 1;
    }

    @Override
    public void setMinScaleDenominator(Integer min) {
    }

    @Override
    public void setMaxScaleDenominator(Integer max) {
    }

    @Override
    public void setPrimaryAnnotationHalo(Color paint) {
    }

    @Override
    public Color getPrimaryAnnotationHalo() {
        return Color.BLACK;
    }

    @Override
    public void setId(int id) {
    }

    @Override
    public String getIdExpression() {
        return null;
    }

    @Override
    public void setIdExpression(String idExpression) {
    }

    @Override
    public void applyStyle(PFeature pFeature, WorldToScreenTransform wtst) {
    }

    @Override
    public void setSLDStyles(List<Style> style) {
    }

    @Override
    public String getName() {
        return "";
    }
}

