/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.Attachable;
import de.cismet.cismap.commons.features.PreventNamingDuplicates;
import de.cismet.cismap.commons.features.XStyledFeature;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class PureNewFeature
extends AbstractNewFeature
implements Cloneable,
XStyledFeature,
Attachable,
PreventNamingDuplicates {
    private static final Logger LOG = Logger.getLogger(PureNewFeature.class);
    int number = 0;
    private Paint fillingPaint = new Color(1.0f, 0.0f, 0.0f, 0.4f);

    public PureNewFeature(Geometry g) {
        super(g);
    }

    public PureNewFeature(Point2D point, WorldToScreenTransform wtst) {
        super(point, wtst);
    }

    public PureNewFeature(Point2D[] canvasPoints, WorldToScreenTransform wtst) {
        super(canvasPoints, wtst);
    }

    public PureNewFeature(Coordinate[] coordArr, WorldToScreenTransform wtst) {
        super(coordArr, wtst);
    }

    @Override
    public Stroke getLineStyle() {
        return null;
    }

    @Override
    public Paint getFillingPaint() {
        return this.fillingPaint;
    }

    @Override
    public void setFillingPaint(Paint fillingStyle) {
        this.fillingPaint = fillingStyle;
    }

    @Override
    public float getTransparency() {
        return 1.0f;
    }

    @Override
    public String getType() {
        return "";
    }

    @Override
    public String getOriginalName() {
        String name = super.getName();
        if (this.getGeometryType() != null) {
            if (name != null && name.trim().equals("")) {
                switch (this.getGeometryType()) {
                    case RECTANGLE: {
                        return NbBundle.getMessage(PureNewFeature.class, (String)"PureNewFeature.getName().newRectangle");
                    }
                    case LINESTRING: {
                        return NbBundle.getMessage(PureNewFeature.class, (String)"PureNewFeature.getName().newPolyline");
                    }
                    case ELLIPSE: {
                        return NbBundle.getMessage(PureNewFeature.class, (String)"PureNewFeature.getName().newEllipse");
                    }
                    case POINT: {
                        return NbBundle.getMessage(PureNewFeature.class, (String)"PureNewFeature.getName().newPoint");
                    }
                    case POLYGON: {
                        return NbBundle.getMessage(PureNewFeature.class, (String)"PureNewFeature.getName().newPolygon");
                    }
                    case MULTIPOLYGON: {
                        return NbBundle.getMessage(PureNewFeature.class, (String)"PureNewFeature.getName().newMultiPolygon");
                    }
                }
                return this.getGeometryType().toString() + " " + this.getGeometry().getGeometryType();
            }
            return name;
        }
        try {
            if (name.trim().equals("")) {
                if (this.getGeometry() instanceof Point) {
                    this.setName(NbBundle.getMessage(PureNewFeature.class, (String)"PureNewFeature.getName().newPoint"));
                } else if (this.getGeometry() instanceof LineString) {
                    this.setName(NbBundle.getMessage(PureNewFeature.class, (String)"PureNewFeature.getName().newPolyline"));
                } else if (this.getGeometry() instanceof Polygon) {
                    this.setName(NbBundle.getMessage(PureNewFeature.class, (String)"PureNewFeature.getName().newPolygon"));
                } else if (this.getGeometry() instanceof MultiPolygon) {
                    this.setName(NbBundle.getMessage(PureNewFeature.class, (String)"PureNewFeature.getName().newMultiPolygon"));
                } else {
                    this.setName("-");
                }
            }
            return super.getName();
        }
        catch (Exception e) {
            LOG.fatal((Object)"getName() error", (Throwable)e);
            return "Error in getName()";
        }
    }

    @Override
    public String getName() {
        if (this.number == 1) {
            return this.getOriginalName();
        }
        return this.getOriginalName() + " - " + this.number;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public void setNumber(int n) {
        this.number = n;
    }
}

