/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import de.cismet.cismap.commons.features.PostgisFeature;
import de.cismet.cismap.commons.featureservice.factory.PostgisAction;
import de.cismet.cismap.commons.featureservice.factory.PostgisFeatureFactory;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.retrieval.RetrievalService;
import de.cismet.tools.ConnectionInfo;
import java.awt.Component;
import java.sql.Connection;
import java.sql.Statement;
import java.util.logging.Level;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

public class UpdateablePostgisFeature
extends PostgisFeature {
    private final ConnectionInfo connectionInfo;
    private final RetrievalService parentService;
    private PostgisAction action;
    private Connection connection;

    public UpdateablePostgisFeature(ConnectionInfo connectionInfo, RetrievalService parentService, PostgisAction action, Connection connection) {
        this.connectionInfo = connectionInfo;
        this.parentService = parentService;
        this.action = action;
        this.connection = connection;
    }

    public PostgisAction getAction() {
        return this.action;
    }

    public void doUpdate() {
        try {
            if (this.action.getAction() != null && this.action.getAction().length() > 0) {
                if (this.connection == null || this.connection.isClosed()) {
                    this.logger.error((Object)"Connection to database lost or not correctly initialised");
                    this.connection = PostgisFeatureFactory.createConnection(this.connectionInfo);
                }
            } else {
                this.logger.warn((Object)"Feature Service not yet correclty initialised, ignoring action");
                throw new Exception("Feature Service not yet correclty initialised, ignoring action");
            }
            Statement statement = this.connection.createStatement();
            String sql = this.action.getAction().replaceAll("<cismap::update::id>", String.valueOf(this.getId()));
            statement.execute(sql);
            statement.close();
            this.parentService.retrieve(true);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Error during doAction(): " + ex.getMessage()), (Throwable)ex);
            ErrorInfo ei = new ErrorInfo("Fehler", "Fehler beim Zugriff auf den FeatureService", null, null, (Throwable)ex, Level.ALL, null);
            JXErrorPane.showDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), (ErrorInfo)ei);
        }
    }
}

