/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.ConvertableToXML;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.XMLObjectFactory;
import de.cismet.cismap.commons.exceptions.ShapeFileImportAborted;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.SLDStyledLayer;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.featureservice.factory.AbstractFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.CachingFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.DefaultQueryButtonAction;
import de.cismet.cismap.commons.rasterservice.FeatureMapService;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.retrieval.AbstractRetrievalService;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.styling.CustomSLDParser;
import de.cismet.tools.StaticXMLTools;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import javax.xml.stream.XMLInputFactory;
import org.apache.log4j.Logger;
import org.deegree.commons.utils.Pair;
import org.deegree.rendering.r2d.legends.Legends;
import org.deegree.style.se.unevaluated.Style;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.openide.util.Exceptions;

public abstract class AbstractFeatureService<FT extends FeatureServiceFeature, QT>
extends AbstractRetrievalService
implements MapService,
ServiceLayer,
RetrievalServiceLayer,
FeatureMapService,
ConvertableToXML,
Cloneable,
SLDStyledLayer {
    private static final transient Logger LOG = Logger.getLogger(AbstractFeatureService.class);
    public static String UNKNOWN = "UNKNOWN";
    public static String NONE = "none";
    public static final String DEFAULT_TYPE = "default";
    public static final List<DefaultQueryButtonAction> SQL_QUERY_BUTTONS = new ArrayList<DefaultQueryButtonAction>();
    protected boolean enabled = true;
    protected BoundingBox bb = null;
    protected int layerPosition;
    protected String name;
    protected float translucency = CismapBroker.getInstance().getDefaultTranslucency();
    protected String encoding;
    protected int maxFeatureCount = 1000;
    protected Map<String, FeatureServiceAttribute> featureServiceAttributes;
    protected PNode pNode;
    protected boolean visible = true;
    protected FeatureRetrievalWorker featureRetrievalWorker;
    protected Boolean initialized = false;
    protected LayerInitWorker layerInitWorker = null;
    protected LayerProperties layerProperties = null;
    protected FeatureFactory featureFactory = null;
    protected List<String> orderedFeatureServiceAttributes;
    protected List<DefaultQueryButtonAction> queryButtons = new ArrayList<DefaultQueryButtonAction>(SQL_QUERY_BUTTONS);
    protected boolean initializedFromElement = false;
    String sldDefinition;
    final XMLInputFactory factory = XMLInputFactory.newInstance();
    Legends legends = new Legends();
    private boolean initialisationError = false;
    private Element initElement = null;
    private boolean selectable = true;

    public AbstractFeatureService() {
        this.setLayerProperties(this.createLayerProperties());
    }

    public AbstractFeatureService(Element e) throws Exception {
        LOG.info((Object)("creating new FeatureService instance from xml element '" + e.getName() + "'"));
        if (e.getName().equals(this.getFeatureLayerType())) {
            this.initFromElement(e);
        } else if (e.getChild(this.getFeatureLayerType()) != null) {
            this.initFromElement(e.getChild(this.getFeatureLayerType()));
        } else {
            LOG.error((Object)("FeatureService could not be initailised from xml: unsupported element '" + e.getName() + "'"));
            throw new ClassNotFoundException("FeatureService could not be initailised from xml: unsupported element '" + e.getName() + "'");
        }
        if (this.getLayerProperties() == null) {
            LOG.warn((Object)"LayerProperties not properly initialised from XML Element, creating new Properties upon next retrieval");
            this.layerProperties = this.createLayerProperties();
        }
        if (this.getFeatureServiceAttributes() == null || this.getFeatureServiceAttributes().size() == 0) {
            LOG.warn((Object)"FeatureServiceAttributes not properly initialised from XML Element, creating new Attributes upon next retrieval");
        }
    }

    public AbstractFeatureService(String name, List<FeatureServiceAttribute> attributes) {
        this.setName(name);
        this.setFeatureServiceAttributes(attributes);
    }

    protected AbstractFeatureService(AbstractFeatureService afs) {
        if (!afs.isInitialized()) {
            LOG.warn((Object)"creating copy of uninitialised feature service");
        }
        this.setLayerPosition(afs.getLayerPosition());
        this.setName(afs.getName());
        this.setEncoding(afs.getEncoding());
        this.setTranslucency(afs.getTranslucency());
        this.setEncoding(afs.getEncoding());
        this.setEnabled(afs.isEnabled());
        this.layerProperties = afs.getLayerProperties() != null ? afs.getLayerProperties().clone() : null;
        this.featureFactory = afs.getFeatureFactory() != null ? afs.getFeatureFactory().clone() : null;
        TreeMap<String, FeatureServiceAttribute> attriuteMap = new TreeMap<String, FeatureServiceAttribute>();
        attriuteMap.putAll(afs.getFeatureServiceAttributes());
        this.setFeatureServiceAttributes(attriuteMap);
        this.setInitialized(afs.isInitialized());
        this.setInitialisationError(afs.getInitialisationError());
        this.setInitElement(afs.getInitElement());
        this.setSelectable(afs.isSelectable());
        this.sldDefinition = afs.sldDefinition;
    }

    protected void init() throws Exception {
        block20: {
            if (this.layerInitWorker == null || this.layerInitWorker.isDone()) {
                LOG.error((Object)"strange synchronisation problem in Layer Initialisation Thread");
                throw new Exception("strange synchronisation problem in Layer Initialisation Thread");
            }
            if (this.layerInitWorker.isCancelled()) {
                LOG.warn((Object)("LIW[" + this.layerInitWorker.getId() + "]: init is canceled"));
                return;
            }
            if (this.isInitialized() || this.isRefreshNeeded()) {
                LOG.warn((Object)"layer already initialised, forcing complete re-initialisation");
                this.setInitialized(false);
                this.featureFactory = null;
                this.featureServiceAttributes = null;
            }
            if (this.getLayerProperties() == null) {
                this.layerProperties = this.createLayerProperties();
            }
            if (this.layerInitWorker.isCancelled()) {
                LOG.warn((Object)("LIW[" + this.layerInitWorker.getId() + "]: init is canceled"));
                return;
            }
            if (this.featureFactory == null) {
                this.featureFactory = this.createFeatureFactory();
            }
            this.featureFactory.setMaxFeatureCount(this.getMaxFeatureCount());
            this.featureFactory.setLayerProperties(this.layerProperties);
            if (this.layerInitWorker.isCancelled()) {
                LOG.warn((Object)("LIW[" + this.layerInitWorker.getId() + "]: init is canceled"));
                return;
            }
            if (this.getFeatureServiceAttributes() == null || this.getFeatureServiceAttributes().size() == 0) {
                try {
                    this.setFeatureServiceAttributes(this.featureFactory.createAttributes(this.layerInitWorker));
                }
                catch (UnsupportedOperationException uoe) {
                    if (this.getFeatureServiceAttributes() == null) {
                        this.setFeatureServiceAttributes(new ArrayList<FeatureServiceAttribute>());
                    }
                    break block20;
                }
            }
            try {
                List<FeatureServiceAttribute> l = this.featureFactory.createAttributes(this.layerInitWorker);
                HashMap<String, FeatureServiceAttribute> currentAttributes = new HashMap<String, FeatureServiceAttribute>();
                for (FeatureServiceAttribute attr : l) {
                    currentAttributes.put(attr.getName(), attr);
                }
                for (String curName : this.featureServiceAttributes.keySet()) {
                    FeatureServiceAttribute fsa = (FeatureServiceAttribute)currentAttributes.get(curName);
                    if (fsa != null && fsa.getType().equals(this.featureServiceAttributes.get(curName).getType())) continue;
                }
            }
            catch (UnsupportedOperationException l) {
                // empty catch block
            }
        }
        if (this.layerInitWorker.isCancelled()) {
            LOG.warn((Object)("LIW[" + this.layerInitWorker.getId() + "]: init is canceled"));
            return;
        }
        if (this.getLayerProperties().getIdExpressionType() == 1 && this.getLayerProperties().getIdExpression() != null && this.getFeatureServiceAttributes() != null && this.getFeatureServiceAttributes().size() > 0) {
            FeatureServiceAttribute attribute;
            boolean found = false;
            Iterator<FeatureServiceAttribute> iterator = this.getFeatureServiceAttributes().values().iterator();
            while (iterator.hasNext() && !(found = (attribute = iterator.next()).getName().equals(this.getLayerProperties().getIdExpression()))) {
            }
            if (!found) {
                LOG.warn((Object)("property id expression '" + this.getLayerProperties().getIdExpression() + "' not found in attributes, resetting to undefined"));
                this.getLayerProperties().setIdExpression(null, -1);
            }
        }
        if (this.layerInitWorker.isCancelled()) {
            LOG.warn((Object)("LIW[" + this.layerInitWorker.getId() + "]: init is canceled"));
            return;
        }
        this.initConcreteInstance();
    }

    public void initAndWait() throws Exception {
        if (!this.initialized.booleanValue() && (this.layerInitWorker == null || this.layerInitWorker.isCancelled())) {
            this.layerInitWorker = new LayerInitWorker();
            try {
                this.init();
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot initialise feature service", (Throwable)e);
            }
            this.layerInitWorker = null;
        } else if (!this.initialized.booleanValue() && !EventQueue.isDispatchThread()) {
            while (this.layerInitWorker != null && !this.layerInitWorker.isDone()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected abstract LayerProperties createLayerProperties();

    protected abstract FeatureFactory createFeatureFactory() throws Exception;

    public FeatureFactory getFeatureFactory() {
        return this.featureFactory;
    }

    public abstract QT getQuery();

    public abstract void setQuery(QT var1);

    protected boolean cancel(SwingWorker workerThread) {
        boolean canceled = false;
        if (!(workerThread == null || workerThread.isDone() && workerThread.isCancelled())) {
            if (workerThread != null) {
                LOG.warn((Object)("canceling Worker Thread: " + workerThread));
                boolean bl = workerThread.cancel(true);
            }
            canceled = true;
        }
        return canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void retrieve(boolean forced) {
        if (this.featureRetrievalWorker != null && !this.featureRetrievalWorker.isDone()) {
            FeatureRetrievalWorker currentWorker = this.featureRetrievalWorker;
            FeatureFactory featureFactory = this.featureFactory;
            synchronized (featureFactory) {
                if (this.featureFactory instanceof AbstractFeatureFactory) {
                    ((AbstractFeatureFactory)this.featureFactory).waitUntilInterruptedIsAllowed();
                }
                this.cancel(currentWorker);
            }
        }
        if (!this.isEnabled() && !this.isVisible()) {
            LOG.warn((Object)("Service '" + this.getName() + "' is disabled and invisible, ignoring retrieve() request"));
            return;
        }
        if (this.isInitialized() && !this.isRefreshNeeded()) {
            if (forced && this.getFeatureFactory() instanceof CachingFeatureFactory) {
                if (this.featureRetrievalWorker != null && !this.featureRetrievalWorker.isDone()) {
                    LOG.warn((Object)("must wait until thread '" + this.featureRetrievalWorker + "' is finished before flushing cache"));
                    while (!this.featureRetrievalWorker.isDone()) {
                    }
                }
                ((CachingFeatureFactory)this.getFeatureFactory()).flush();
            }
            this.featureRetrievalWorker = new FeatureRetrievalWorker();
            this.featureRetrievalWorker.execute();
        } else if (this.layerInitWorker == null) {
            this.layerInitWorker = new LayerInitWorker();
            this.layerInitWorker.execute();
        } else {
            LOG.warn((Object)"Layer wird z.Z. initialisiert --> request wird ignoriert");
        }
    }

    protected abstract void initConcreteInstance() throws Exception;

    protected abstract String getFeatureLayerType();

    public abstract Icon getLayerIcon(int var1);

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean isInitialized) {
        this.initialized = isInitialized;
    }

    public Map<String, FeatureServiceAttribute> getFeatureServiceAttributes() {
        return this.featureServiceAttributes;
    }

    public void setFeatureServiceAttributes(Map<String, FeatureServiceAttribute> featureServiceAttributes) {
        this.featureServiceAttributes = featureServiceAttributes;
    }

    public List<String> getOrderedFeatureServiceAttributes() {
        return this.orderedFeatureServiceAttributes;
    }

    public void setOrderedFeatureServiceAttributes(List<String> orderedFeatureServiceAttributes) {
        this.orderedFeatureServiceAttributes = orderedFeatureServiceAttributes;
    }

    protected void setFeatureServiceAttributes(List<FeatureServiceAttribute> featureServiceAttributesVector) {
        if (featureServiceAttributesVector != null) {
            if (this.featureServiceAttributes == null) {
                this.featureServiceAttributes = new HashMap<String, FeatureServiceAttribute>(featureServiceAttributesVector.size());
                this.orderedFeatureServiceAttributes = new ArrayList<String>();
            } else {
                this.featureServiceAttributes.clear();
                this.orderedFeatureServiceAttributes.clear();
            }
            for (FeatureServiceAttribute fsa : featureServiceAttributesVector) {
                this.orderedFeatureServiceAttributes.add(fsa.getName());
                this.featureServiceAttributes.put(fsa.getName(), fsa);
            }
        }
    }

    public BoundingBox getBoundingBox() {
        return this.bb;
    }

    @Override
    public void setBoundingBox(BoundingBox bb) {
        this.bb = bb;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getMaxFeatureCount() {
        return this.maxFeatureCount;
    }

    public void setMaxFeatureCount(int maxFeatureCount) {
        this.maxFeatureCount = maxFeatureCount;
        if (this.getFeatureFactory() != null) {
            this.getFeatureFactory().setMaxFeatureCount(maxFeatureCount);
        }
    }

    public LayerProperties getLayerProperties() {
        return this.layerProperties;
    }

    public void setLayerProperties(LayerProperties layerProperties) {
        this.setLayerProperties(layerProperties, true);
    }

    public void setLayerProperties(LayerProperties layerProperties, boolean refreshFeatures) {
        this.layerProperties = layerProperties;
        if (this.featureFactory != null) {
            if (this.featureRetrievalWorker != null && !this.featureRetrievalWorker.isDone()) {
                LOG.warn((Object)("must wait until thread '" + this.featureRetrievalWorker + "' is finished before applying new layer properties"));
                while (!this.featureRetrievalWorker.isDone()) {
                }
            }
            this.featureFactory.setLayerProperties(layerProperties);
            if (refreshFeatures) {
                this.refreshFeatures();
            }
        }
    }

    public void refresh() {
        if (this.featureFactory != null) {
            if (this.featureRetrievalWorker != null && !this.featureRetrievalWorker.isDone()) {
                LOG.warn((Object)("must wait until thread '" + this.featureRetrievalWorker + "' is finished before applying new layer properties"));
                while (!this.featureRetrievalWorker.isDone()) {
                }
            }
            this.featureFactory.setLayerProperties(this.layerProperties);
            this.refreshFeatures();
        }
    }

    @Override
    public float getTranslucency() {
        return this.translucency;
    }

    @Override
    public void setTranslucency(float t) {
        this.translucency = t;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (this.featureFactory != null) {
            this.featureFactory.setLayerName(name);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getLayerPosition() {
        return this.layerPosition;
    }

    @Override
    public void setLayerPosition(int layerPosition) {
        this.layerPosition = layerPosition;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            if (!this.canBeDisabled()) {
                LOG.warn((Object)("Service '" + this.getName() + "' cannot be disabled"));
            } else {
                this.enabled = false;
            }
        } else {
            this.enabled = true;
        }
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setSize(int height, int width) {
    }

    @Override
    public PNode getPNode() {
        return this.pNode;
    }

    @Override
    public void setPNode(PNode pNode) {
        this.pNode = pNode;
    }

    public String toString() {
        return this.getName();
    }

    public String getId() {
        return this.getName();
    }

    @Override
    public Element toElement() {
        Element element = new Element(this.getFeatureLayerType());
        element.setAttribute("name", this.getName());
        element.setAttribute("type", this.getClass().getCanonicalName());
        element.setAttribute("visible", Boolean.valueOf(this.getPNode().getVisible()).toString());
        element.setAttribute("enabled", Boolean.valueOf(this.isEnabled()).toString());
        element.setAttribute("translucency", new Float(this.getTranslucency()).toString());
        element.setAttribute("maxFeatureCount", new Integer(this.getMaxFeatureCount()).toString());
        element.setAttribute("layerPosition", new Integer(this.getLayerPosition()).toString());
        element.setAttribute("isSelectable", Boolean.toString(this.isSelectable()));
        if (this.getFeatureServiceAttributes() != null && this.getFeatureServiceAttributes().size() > 0) {
            Element attrib = new Element("Attributes");
            for (String key : this.getOrderedFeatureServiceAttributes()) {
                FeatureServiceAttribute e = this.getFeatureServiceAttributes().get(key);
                attrib.addContent((Content)e.toElement());
            }
            element.addContent((Content)attrib);
        } else {
            LOG.warn((Object)"FeatureServiceAttributes are null and will not be saved");
        }
        if (this.getLayerProperties() != null) {
            Element layerPropertiesElement = this.getLayerProperties().toElement();
            element.addContent((Content)layerPropertiesElement);
        } else {
            LOG.warn((Object)"Layer Properties are null and will not be saved");
        }
        try {
            if (this.getSLDDefiniton() != null) {
                Document sldDoc = new SAXBuilder().build(this.getSLDDefiniton());
                element.addContent((Content)sldDoc.detachRootElement());
            }
        }
        catch (JDOMException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return element;
    }

    @Override
    public void initFromElement(Element element) throws Exception {
        Element xmlAttributes;
        if (element == null) {
            element = this.getInitElement();
        } else {
            this.setInitElement((Element)element.clone());
        }
        if (element.getAttributeValue("name") != null) {
            this.setName(element.getAttributeValue("name"));
        }
        if (element.getAttributeValue("visible") != null) {
            this.setVisible(Boolean.valueOf(element.getAttributeValue("visible")));
        }
        if (element.getAttributeValue("translucency") != null) {
            this.setTranslucency(element.getAttribute("translucency").getFloatValue());
        }
        if (element.getAttributeValue("enabled") != null) {
            Float minOpacity = CismapBroker.getInstance().getMinOpacityToStayEnabled();
            if (minOpacity != null && (this.getTranslucency() <= minOpacity.floatValue() || !this.isVisible())) {
                this.setEnabled(false);
            } else {
                this.setEnabled(Boolean.valueOf(element.getAttributeValue("enabled")));
            }
        }
        if (element.getAttributeValue("maxFeatureCount") != null) {
            this.setMaxFeatureCount(element.getAttribute("maxFeatureCount").getIntValue());
        }
        if (element.getAttributeValue("layerPosition") != null) {
            this.setLayerPosition(element.getAttribute("layerPosition").getIntValue());
        }
        if (element.getAttributeValue("isSelectable") != null) {
            this.setSelectable(element.getAttribute("isSelectable").getBooleanValue());
        }
        if ((xmlAttributes = element.getChild("Attributes")) != null) {
            this.featureServiceAttributes = FeatureServiceUtilities.getFeatureServiceAttributes(xmlAttributes);
            this.orderedFeatureServiceAttributes = FeatureServiceUtilities.getOrderedFeatureServiceAttributes(xmlAttributes);
            this.setFeatureServiceAttributes(this.featureServiceAttributes);
        }
        if (element.getAttribute("type") == null) {
            LOG.warn((Object)"fromElement: restoring object from deprecated xml element");
            try {
                this.fromOldElement(element);
            }
            catch (Exception e) {
                LOG.warn((Object)("could not restore deprecated configuration: \n" + e.getMessage()), (Throwable)e);
            }
        } else if (element.getChild("LayerProperties") != null) {
            LayerProperties restoredLayerProperties = null;
            try {
                Element layerPropertiesElement = element.getChild("LayerProperties");
                restoredLayerProperties = (LayerProperties)XMLObjectFactory.restoreObjectfromElement(layerPropertiesElement);
                restoredLayerProperties.setFeatureService(this);
            }
            catch (Exception t) {
                LOG.error((Object)("could not restore generic style element '" + element.getChild("LayerProperties").getAttribute("type") + "': \n" + t.getMessage()), (Throwable)t);
            }
            this.layerProperties = restoredLayerProperties;
        } else {
            LOG.warn((Object)"no layer properties ");
        }
        Element sldStyle = element.getChild("StyledLayerDescriptor", Namespace.getNamespace((String)"http://www.opengis.net/sld"));
        if (sldStyle != null) {
            this.sldDefinition = new XMLOutputter().outputString(sldStyle);
        }
        this.initializedFromElement = true;
    }

    @Deprecated
    private void fromOldElement(Element element) {
        DefaultFeatureServiceFeature wfsFeature = new DefaultFeatureServiceFeature();
        Element renderingFeature = element.getChild("renderingFeature").getChild("DefaultWFSFeature");
        wfsFeature.setIdExpression(renderingFeature.getAttributeValue("idExpression"));
        int lineWidth = Integer.parseInt(renderingFeature.getAttributeValue("lineWidth"));
        wfsFeature.setLineWidth(lineWidth);
        wfsFeature.setTransparency(Float.parseFloat(renderingFeature.getAttributeValue("transparency")));
        wfsFeature.setPrimaryAnnotation(renderingFeature.getAttributeValue("primaryAnnotation"));
        wfsFeature.setSecondaryAnnotation(renderingFeature.getAttributeValue("secondaryAnnotation"));
        wfsFeature.setPrimaryAnnotationScaling(Double.parseDouble(renderingFeature.getAttributeValue("primaryAnnotationScaling")));
        wfsFeature.setPrimaryAnnotationJustification(Float.parseFloat(renderingFeature.getAttributeValue("primaryAnnotationJustification")));
        wfsFeature.setMaxScaleDenominator(Integer.parseInt(renderingFeature.getAttributeValue("maxScaleDenominator")));
        wfsFeature.setMinScaleDenominator(Integer.parseInt(renderingFeature.getAttributeValue("minScaleDenominator")));
        wfsFeature.setAutoScale(Boolean.parseBoolean(renderingFeature.getAttributeValue("autoscale")));
        Color fill = null;
        Color line = null;
        if (renderingFeature.getChild("fillingColor") != null) {
            fill = StaticXMLTools.convertXMLElementToColor((Element)renderingFeature.getChild("fillingColor").getChild("Color"));
        }
        wfsFeature.setFillingPaint(fill);
        if (renderingFeature.getChild("lineColor") != null) {
            line = StaticXMLTools.convertXMLElementToColor((Element)renderingFeature.getChild("lineColor").getChild("Color"));
        }
        wfsFeature.setLinePaint(line);
        wfsFeature.setPrimaryAnnotationFont(StaticXMLTools.convertXMLElementToFont((Element)renderingFeature.getChild("primaryAnnotationFont").getChild("Font")));
        wfsFeature.setPrimaryAnnotationPaint(StaticXMLTools.convertXMLElementToColor((Element)renderingFeature.getChild("primaryAnnotationColor").getChild("Color")));
        wfsFeature.setHighlightingEnabled(Boolean.parseBoolean(renderingFeature.getAttributeValue("highlightingEnabled")));
        wfsFeature.getLayerProperties().getStyle().setPointSymbolFilename("Punkt");
        this.layerProperties = wfsFeature.getLayerProperties();
    }

    public void setInitialisationError(boolean initialisationError) {
        this.initialisationError = initialisationError;
    }

    public boolean getInitialisationError() {
        return this.initialisationError;
    }

    public List<DefaultQueryButtonAction> getQueryButtons() {
        return this.queryButtons;
    }

    public String decoratePropertyName(String name) {
        return name;
    }

    public boolean decorateLater() {
        return false;
    }

    public String decorateQuery(String query) {
        return query;
    }

    public String decoratePropertyValue(String columnName, String value) {
        return "'" + value + "'";
    }

    public List retrieveFeatures(BoundingBox boundingBox, int offset, int limit, String orderBy) throws Exception {
        if (!this.initialized.booleanValue()) {
            this.initAndWait();
        }
        return this.getFeatureFactory().createFeatures(this.getQuery(), boundingBox, this.layerInitWorker);
    }

    public int getFeatureCount(QT query, BoundingBox boundingBox) {
        if (!this.initialized.booleanValue()) {
            try {
                this.initAndWait();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while initialising feature service.", (Throwable)e);
            }
        }
        if (boundingBox == null) {
            return this.getFeatureFactory().getFeatureCount(query, this.bb);
        }
        return this.getFeatureFactory().getFeatureCount(query, boundingBox);
    }

    public int getFeatureCount(BoundingBox boundingBox) {
        return this.getFeatureCount(this.getQuery(), boundingBox);
    }

    protected List<FT> retrieveFeatures(FeatureRetrievalWorker worker) throws Exception {
        if (this.initialisationError || this instanceof WebFeatureService && ((WebFeatureService)this).getFeature() == null) {
            if (this instanceof WebFeatureService && ((WebFeatureService)this).getFeature() == null) {
                this.initialisationError = true;
            }
            this.initFromElement(null);
            this.setInitialized(false);
            this.featureFactory = this.createFeatureFactory();
            this.featureFactory.setMaxFeatureCount(this.getMaxFeatureCount());
            this.featureFactory.setLayerProperties(this.layerProperties);
            this.initConcreteInstance();
            if (this.initialisationError) {
                throw new Exception(this.getErrorObject().toString());
            }
        }
        if (worker.isCancelled()) {
            LOG.warn((Object)("FRW[" + worker.getId() + "]: retrieveFeatures is canceled"));
            return null;
        }
        long start = System.currentTimeMillis();
        List features = this.getFeatureFactory().createFeatures(this.getQuery(), this.getBoundingBox(), worker);
        if (features != null && LOG.isInfoEnabled()) {
            LOG.info((Object)("FRW[" + worker.getId() + "]: " + features.size() + " features retrieved in " + (System.currentTimeMillis() - start) + " ms"));
        } else {
            LOG.warn((Object)("FRW[" + worker.getId() + "]: no features found (canceled=" + worker.isCancelled() + ")"));
        }
        return features;
    }

    public Element getInitElement() {
        return this.initElement;
    }

    public void setInitElement(Element initElement) {
        this.initElement = initElement;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isEditable() {
        return false;
    }

    @Override
    public Reader getSLDDefiniton() {
        return this.sldDefinition == null ? null : new StringReader(this.sldDefinition);
    }

    @Override
    public void setSLDInputStream(String inputStream) {
        if (inputStream == null || inputStream.isEmpty()) {
            this.sldDefinition = null;
            this.featureFactory.setSLDStyle(null);
            return;
        }
        this.sldDefinition = inputStream;
        Map<String, LinkedList<Style>> styles = this.parseSLD(new StringReader(inputStream));
        if (styles == null || styles.isEmpty()) {
            return;
        }
        this.featureFactory.setSLDStyle(styles);
    }

    protected Map<String, LinkedList<Style>> parseSLD(Reader input) {
        Map<String, LinkedList<Style>> styles = null;
        try {
            if (input != null) {
                styles = CustomSLDParser.getCustomStyles(input);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler in der SLD", (Throwable)ex);
        }
        if (styles == null) {
            LOG.info((Object)"SLD Parser funtkioniert nicht");
        }
        return styles;
    }

    @Override
    public Pair<Integer, Integer> getLegendSize(int nr) {
        if (this.featureFactory instanceof AbstractFeatureFactory) {
            return this.getLegendSize(this.getLegendStyle().get(0));
        }
        return null;
    }

    private Pair<Integer, Integer> getLegendSize(Style style) {
        return this.legends.getLegendSize(style);
    }

    @Override
    public Pair<Integer, Integer> getLegendSize() {
        return this.getLegendSize(0);
    }

    @Override
    public List<Pair<Integer, Integer>> getLegendSizes() {
        List<Style> styles = this.getLegendStyle();
        LinkedList<Pair<Integer, Integer>> sizes = new LinkedList<Pair<Integer, Integer>>();
        for (Style style : styles) {
            sizes.add(this.getLegendSize(style));
        }
        return sizes;
    }

    @Override
    public void getLegend(int width, int height, Graphics2D g2d) {
        this.getLegend(0, width, height, g2d);
    }

    @Override
    public void getLegend(int nr, int width, int height, Graphics2D g2d) {
        if (this.featureFactory instanceof AbstractFeatureFactory) {
            this.getLegend(this.getLegendStyle().get(0), width, height, g2d);
        }
    }

    private List<Style> getLegendStyle() {
        AbstractFeatureFactory aff = (AbstractFeatureFactory)this.featureFactory;
        List<Style> styles = aff.getStyle(aff.layerName);
        if (styles == null) {
            try {
                String tmp;
                InputStream is = this.getClass().getResourceAsStream("/de/cismet/cismap/commons/featureservice/defaultSld.xml");
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                StringBuilder sldString = new StringBuilder();
                while ((tmp = r.readLine()) != null) {
                    sldString.append(tmp).append("\n");
                }
                r.close();
                Color fillingColor = this.getLayerProperties().getStyle().getFillColor();
                Color lineColor = this.getLayerProperties().getStyle().getFillColor();
                String sld = sldString.toString().replace("$name$", aff.layerName);
                sld = sld.replace("$fillingColor$", this.color2RGBCode(fillingColor));
                sld = sld.replace("$lineColor$", this.color2RGBCode(lineColor));
                sld = sld.replace("$geomProperty$", this.getGeoProperty());
                sld = sld.replace("$pointSymbolUrl$", this.getClass().getResource("/de/cismet/cismap/commons/gui/res/pushpin.png").toString());
                if (this.getGeometryType().toLowerCase().contains("point")) {
                    sld = this.removeRule(sld, "basicLineStyle");
                    sld = this.removeRule(sld, "basicPolyStyle");
                } else if (this.getGeometryType().toLowerCase().contains("polygon")) {
                    sld = this.removeRule(sld, "basicLineStyle");
                    sld = this.removeRule(sld, "pointStyle");
                } else if (this.getGeometryType().toLowerCase().contains("linestring")) {
                    sld = this.removeRule(sld, "basicPolyStyle");
                    sld = this.removeRule(sld, "pointStyle");
                }
                StringReader sldReader = new StringReader(sld);
                Map<String, LinkedList<Style>> stylesMap = this.parseSLD(sldReader);
                return stylesMap.get(aff.layerName);
            }
            catch (IOException e) {
                LOG.error((Object)"Error while reading default sld file", (Throwable)e);
            }
        }
        return styles;
    }

    private String color2RGBCode(Color c) {
        return "#" + Integer.toHexString(c.getRGB() & 0xFFFFFF);
    }

    private String getGeoProperty() {
        Map<String, FeatureServiceAttribute> attributes = this.getFeatureServiceAttributes();
        for (String key : attributes.keySet()) {
            FeatureServiceAttribute attr = attributes.get(key);
            if (!attr.isGeometry()) continue;
            return key;
        }
        return "geom";
    }

    private String removeRule(String sld, String ruleName) {
        try {
            String tmp;
            BufferedReader r = new BufferedReader(new StringReader(sld));
            StringBuilder currentRule = null;
            StringBuilder newSld = new StringBuilder();
            String currentRuleName = null;
            boolean inRule = false;
            while ((tmp = r.readLine()) != null) {
                if (inRule || tmp.toLowerCase().contains("<sld:rule>")) {
                    if (tmp.toLowerCase().contains("<sld:rule>")) {
                        currentRule = new StringBuilder();
                        inRule = true;
                    } else if (tmp.contains("<sld:Name>")) {
                        Pattern pattern = Pattern.compile("<sld:Name>(.+?)</sld:Name>");
                        Matcher matcher = pattern.matcher(tmp);
                        matcher.find();
                        currentRuleName = matcher.group(1);
                    }
                    currentRule.append(tmp).append("\n");
                    if (!tmp.toLowerCase().contains("</sld:rule>")) continue;
                    if (!currentRuleName.equalsIgnoreCase(ruleName)) {
                        newSld.append((CharSequence)currentRule);
                    }
                    inRule = false;
                    continue;
                }
                newSld.append(tmp).append("\n");
            }
            return newSld.toString();
        }
        catch (IOException e) {
            LOG.error((Object)("Error while removing rule from sld:\n" + sld), (Throwable)e);
            return sld;
        }
    }

    private void getLegend(Style style, int width, int height, Graphics2D g2d) {
        this.legends.paintLegend(style, width, height, g2d);
    }

    @Override
    public void getLegends(List<Pair<Integer, Integer>> sizes, Graphics2D[] g2d) {
        AbstractFeatureFactory aff = (AbstractFeatureFactory)this.featureFactory;
        List<Style> styles = aff.getStyle(aff.layerName);
        for (int i = 0; i < styles.size(); ++i) {
            this.legends.paintLegend(styles.get(i), ((Integer)sizes.get((int)i).first).intValue(), ((Integer)sizes.get((int)i).second).intValue(), g2d[i]);
        }
    }

    public void refreshFeatures() {
        final List lastCreatedFeatures = this.featureFactory.getLastCreatedFeatures();
        if (lastCreatedFeatures.size() > 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RetrievalEvent re = new RetrievalEvent();
                    re.setIsComplete(true);
                    re.setHasErrors(false);
                    re.setRefreshExisting(true);
                    re.setRetrievedObject(lastCreatedFeatures);
                    re.setRequestIdentifier(System.currentTimeMillis());
                    AbstractFeatureService.this.fireRetrievalStarted(re);
                    AbstractFeatureService.this.fireRetrievalComplete(re);
                }
            });
        } else {
            LOG.warn((Object)"no last created features that could be refreshed found");
        }
    }

    public String getGeometryType() {
        return UNKNOWN;
    }

    public int getMaxFeaturesPerPage() {
        return -1;
    }

    public String[] getCalculatedAttributes() {
        return new String[0];
    }

    public boolean isVisibleInBoundingBox(XBoundingBox box) {
        Iterator<Style> iterator;
        List<Style> styles;
        FeatureFactory ff = this.getFeatureFactory();
        if (ff instanceof AbstractFeatureFactory && (styles = ((AbstractFeatureFactory)ff).getStyle(((AbstractFeatureFactory)ff).layerName)) != null && (iterator = styles.iterator()).hasNext()) {
            Style tempStyle = iterator.next();
            Style filteredStyle = tempStyle.filter(CismapBroker.getInstance().getMappingComponent().getScaleDenominator());
            LinkedList rules = filteredStyle.getRules();
            return rules != null && !rules.isEmpty();
        }
        return true;
    }

    static {
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("="));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("<>"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("Like"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction(">"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction(">="));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("And"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("<"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("<="));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("Or"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("_", 1));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("%", 1));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("()"){
            {
                this.posCorrection = -1;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.queryTextArea.getSelectionEnd() == 0) {
                    super.actionPerformed(e);
                } else {
                    int start = this.queryTextArea.getSelectionStart();
                    int end = this.queryTextArea.getSelectionEnd();
                    this.queryTextArea.insert("(", start);
                    this.queryTextArea.insert(")", end + 1);
                    if (start == end) {
                        this.CorrectCarret(this.posCorrection);
                    } else {
                        this.CorrectCarret(2);
                    }
                }
            }
        });
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("Is"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("Not"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("Null"));
    }

    protected class LayerInitWorker
    extends SwingWorker<Void, Void>
    implements PropertyChangeListener {
        private final long id = System.nanoTime();

        public LayerInitWorker() {
            this.addPropertyChangeListener(this);
        }

        public long getId() {
            return this.id;
        }

        @Override
        protected Void doInBackground() throws Exception {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    RetrievalEvent r = new RetrievalEvent();
                    r.setPercentageDone(-1);
                    r.setRequestIdentifier(LayerInitWorker.this.getId());
                    r.setInitialisationEvent(true);
                    AbstractFeatureService.this.fireRetrievalStarted(r);
                }
            });
            AbstractFeatureService.this.init();
            return null;
        }

        @Override
        protected void done() {
            AbstractFeatureService.this.setRefreshNeeded(false);
            if (this.isCancelled()) {
                AbstractFeatureService.this.setInitialized(false);
                RetrievalEvent re = new RetrievalEvent();
                re.setInitialisationEvent(true);
                re.setPercentageDone(0);
                re.setRequestIdentifier(this.getId());
                re.setHasErrors(false);
                AbstractFeatureService.this.fireRetrievalAborted(re);
                return;
            }
            try {
                this.get();
                AbstractFeatureService.this.setRefreshNeeded(false);
                RetrievalEvent re = new RetrievalEvent();
                re.setInitialisationEvent(true);
                re.setPercentageDone(100);
                re.setRequestIdentifier(this.getId());
                re.setIsComplete(true);
                re.setHasErrors(false);
                re.setRetrievedObject(null);
                AbstractFeatureService.this.fireRetrievalComplete(re);
            }
            catch (Exception e) {
                if (e.getCause() instanceof ShapeFileImportAborted) {
                    return;
                }
                LOG.error((Object)("LIW[" + this.getId() + "]: Fehler beim initalisieren des Layers: " + e.getMessage()), (Throwable)e);
                AbstractFeatureService.this.setInitialized(false);
                RetrievalEvent re = new RetrievalEvent();
                re.setInitialisationEvent(true);
                re.setPercentageDone(0);
                re.setRequestIdentifier(this.getId());
                AbstractFeatureService.this.fireRetrievalStarted(re);
                re.setHasErrors(true);
                re.setRetrievedObject(e.getMessage());
                AbstractFeatureService.this.fireRetrievalError(re);
                return;
            }
            AbstractFeatureService.this.setInitialized(true);
            AbstractFeatureService.this.layerInitWorker = null;
            AbstractFeatureService.this.retrieve(false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("progress")) {
                int progress = (Integer)evt.getNewValue();
                RetrievalEvent re = new RetrievalEvent();
                re.setInitialisationEvent(true);
                re.setRequestIdentifier(this.getId());
                re.setIsComplete(progress != 100);
                re.setPercentageDone(progress);
                AbstractFeatureService.this.fireRetrievalProgress(re);
            }
        }

        public String toString() {
            return String.valueOf(this.getId());
        }
    }

    protected class FeatureRetrievalWorker
    extends SwingWorker<List<FT>, FT>
    implements PropertyChangeListener {
        private final long id = System.nanoTime();

        public FeatureRetrievalWorker() {
            this.addPropertyChangeListener(this);
        }

        public long getId() {
            return this.id;
        }

        @Override
        protected List<FT> doInBackground() throws Exception {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    RetrievalEvent r = new RetrievalEvent();
                    r.setRequestIdentifier(FeatureRetrievalWorker.this.getId());
                    r.setPercentageDone(-1);
                    AbstractFeatureService.this.fireRetrievalStarted(r);
                }
            });
            if (this.isCancelled()) {
                LOG.warn((Object)("FRW[" + this.getId() + "]: doInBackground() canceled"));
                return null;
            }
            List features = AbstractFeatureService.this.retrieveFeatures(this);
            return features;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                LOG.warn((Object)("FRW[" + this.getId() + "]:  canceled (done)"));
                RetrievalEvent re = new RetrievalEvent();
                re.setRequestIdentifier(this.getId());
                re.setPercentageDone(0);
                re.setHasErrors(false);
                AbstractFeatureService.this.fireRetrievalAborted(re);
                return;
            }
            try {
                List results = null;
                if (!this.isCancelled()) {
                    results = (List)this.get();
                }
                if (results != null) {
                    AbstractFeatureService.this.setRefreshNeeded(false);
                    RetrievalEvent re = new RetrievalEvent();
                    re.setRequestIdentifier(this.getId());
                    re.setIsComplete(true);
                    re.setHasErrors(false);
                    re.setRetrievedObject(results);
                    AbstractFeatureService.this.fireRetrievalComplete(re);
                } else {
                    LOG.warn((Object)("FRW[" + this.getId() + "]: FeatureRetrieverWorker brachte keine Ergebnisse (canceled=" + this.isCancelled() + ")"));
                    RetrievalEvent re = new RetrievalEvent();
                    re.setHasErrors(false);
                    re.setRequestIdentifier(this.getId());
                    if (this.isCancelled()) {
                        AbstractFeatureService.this.fireRetrievalAborted(re);
                    } else {
                        re.setRetrievedObject(new ArrayList());
                        AbstractFeatureService.this.fireRetrievalComplete(re);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("FRW[" + this.getId() + "]: Fehler im FeatureRetrieverWorker (done): \n" + e.getMessage()), (Throwable)e);
                RetrievalEvent re = new RetrievalEvent();
                re.setRequestIdentifier(this.getId());
                re.setPercentageDone(0);
                re.setHasErrors(true);
                re.setRetrievedObject(e.getMessage());
                AbstractFeatureService.this.fireRetrievalError(re);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("progress")) {
                int progress = (Integer)evt.getNewValue();
                RetrievalEvent re = new RetrievalEvent();
                re.setRequestIdentifier(this.getId());
                re.setIsComplete(progress != 100);
                re.setPercentageDone(progress);
                AbstractFeatureService.this.fireRetrievalProgress(re);
            }
        }

        public String toString() {
            return String.valueOf(this.getId());
        }
    }
}

