/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import java.net.URI;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public abstract class DocumentFeatureService<FT extends FeatureServiceFeature, QT>
extends AbstractFeatureService<FT, QT> {
    private static final transient Logger LOG = Logger.getLogger(DocumentFeatureService.class);
    public static final int GML_GEOMETRY_TYPE = 10012;
    protected URI documentURI;
    protected int maxSupportedFeatureCount = Integer.MAX_VALUE;
    protected long documentSize = -1L;

    public DocumentFeatureService(Element e) throws Exception {
        super(e);
    }

    public DocumentFeatureService(String name, URI documentURI, long documentSize, List<FeatureServiceAttribute> attributes) throws Exception {
        super(name, attributes);
        this.documentURI = documentURI;
        this.documentSize = documentSize;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("creating new DocumentFeatureService from URI: " + documentURI));
        }
    }

    protected DocumentFeatureService(DocumentFeatureService dfs) {
        super(dfs);
        this.documentURI = dfs.getDocumentURI();
        this.documentSize = dfs.getDocumentSize();
    }

    @Override
    public Element toElement() {
        Element parentElement = super.toElement();
        Element docURI = new Element("documentURI");
        docURI.setText(this.documentURI.toString());
        parentElement.addContent((Content)docURI);
        parentElement.setAttribute("maxSupportedFeatureCount", String.valueOf(this.maxSupportedFeatureCount));
        parentElement.setAttribute("documentSize", String.valueOf(this.documentSize));
        return parentElement;
    }

    @Override
    public void initFromElement(Element element) throws Exception {
        super.initFromElement(element);
        this.setDocumentURI(new URI(element.getChildText("documentURI").trim()));
        if (element.getAttribute("maxSupportedFeatureCount") != null) {
            this.maxSupportedFeatureCount = element.getAttribute("maxSupportedFeatureCount").getIntValue();
        }
        if (element.getAttribute("documentSize") != null) {
            this.documentSize = element.getAttribute("documentSize").getIntValue();
        }
    }

    public URI getDocumentURI() {
        return this.documentURI;
    }

    public void setDocumentURI(URI documentURI) {
        this.documentURI = documentURI;
    }

    public long getDocumentSize() {
        return this.documentSize;
    }
}

