/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class FeatureServiceUtilities {
    private static final String ENCODING_STRING = "encoding='";
    private static final String ALTERNATE_ENCODING_STRING = "encoding=\"";
    public static final String[] GEO_PROPERTY_TYPES = new String[]{"GeometryPropertyType", "GeometricPrimtivePropertyType", "PointPropertyType", "CurvePropertyType", "SurfacePropertyType", "SolidPropertyType", "PointPropertyType", "CompositeCurveType", "CompositeSurfaceType", "CompositeSolidType", "GeometricComplexPropertyType", "MultiGeometryPropertyType", "MultiPointPropertyType", "MultiCurvePropertyType", "MultiSurfacePropertyType", "MultiSolidPropertyType", "MultiGeometryPropertyType", "MultiLineStringPropertyType", "GEOMETRY", String.valueOf(10012), String.valueOf(11016), String.valueOf(10013), String.valueOf(11015), String.valueOf(11017), String.valueOf(11012), String.valueOf(11013), String.valueOf(11014), String.valueOf(1111)};
    private static final Logger log = Logger.getLogger((String)"de.cismet.cismap.commons.featureservice.FeatureServiceUtilities");
    public static final String STRING_PROPERTY_TYPE = "string";
    public static final String INTEGER_PROPERTY_TYPE = "integer";
    public static final String XML_NAME_STRING = "name";
    public static final String XML_ALIAS_STRING = "alias";
    public static final String XML_TYPE_STRING = "type";
    public static final String IS_GEOMETRY = "isGeometry";
    public static final String IS_VISIBLE = "isVisible";
    public static final String IS_NAME_ELEMENT = "isNameElement";
    public static final String GET_FEATURE = "GetFeature";
    public static final Namespace WFS = Namespace.getNamespace((String)"wfs", (String)"http://www.opengis.net/wfs");

    public static String elementToString(Element e) {
        if (e == null) {
            return "";
        }
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        return out.outputString(e);
    }

    public static String getServiceName(WFSCapabilities cap) {
        String name = cap.getService().getTitle();
        if (name == null || name.equals("")) {
            name = cap.getService().getAbstract();
        }
        if (name == null || name.equals("")) {
            name = cap.getService().getName();
        }
        return name;
    }

    public static String parseDocumentToString(Document doc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"parseDocumentToString()");
        }
        XMLOutputter out = new XMLOutputter();
        return out.outputString(doc);
    }

    public static TreeMap<FeatureType, Vector<FeatureServiceAttribute>> getElementDeclarations(WFSCapabilities cap) throws IOException, Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getElementDeclarations(" + cap.getURL() + ")"));
        }
        TreeMap<FeatureType, Vector<FeatureServiceAttribute>> result = new TreeMap<FeatureType, Vector<FeatureServiceAttribute>>(new Comparator<FeatureType>(){

            @Override
            public int compare(FeatureType o1, FeatureType o2) {
                String title2;
                String title1 = o1 == null ? null : o1.getTitle();
                String string = title2 = o2 == null ? null : o2.getTitle();
                if (title1 == null && title2 == null) {
                    return 0;
                }
                if (title1 == null) {
                    return -1;
                }
                if (title2 == null) {
                    return 1;
                }
                return title1.compareTo(title2);
            }
        });
        for (FeatureType ft : cap.getFeatureTypeList()) {
            Vector<FeatureServiceAttribute> attributes = ft.getFeatureAttributes();
            if (attributes == null) continue;
            result.put(ft, attributes);
        }
        return result;
    }

    public static boolean isElementOfGeometryType(String typeName) {
        String localTypeName = typeName;
        if (localTypeName.indexOf(":") != -1) {
            localTypeName = localTypeName.substring(localTypeName.indexOf(":") + 1);
        }
        boolean res = Arrays.binarySearch(GEO_PROPERTY_TYPES, localTypeName) >= 0;
        return res;
    }

    public static HashMap<String, FeatureServiceAttribute> getFeatureServiceAttributes(Element describeFeatureXML) {
        HashMap<String, FeatureServiceAttribute> fsaMap = new HashMap<String, FeatureServiceAttribute>(describeFeatureXML.getChildren().size());
        for (Element currentElement : describeFeatureXML.getChildren()) {
            try {
                FeatureServiceAttribute fsa = new FeatureServiceAttribute(currentElement);
                fsaMap.put(fsa.getName(), fsa);
            }
            catch (Exception ex) {
                log.warn((Object)("An element could not be parsed as attribute: " + currentElement), (Throwable)ex);
            }
        }
        return fsaMap;
    }

    public static List<String> getOrderedFeatureServiceAttributes(Element describeFeatureXML) {
        ArrayList<String> fsaList = new ArrayList<String>(describeFeatureXML.getChildren().size());
        for (Element currentElement : describeFeatureXML.getChildren()) {
            try {
                FeatureServiceAttribute fsa = new FeatureServiceAttribute(currentElement);
                fsaList.add(fsa.getName());
            }
            catch (Exception ex) {
                log.warn((Object)("An element could not be parsed as attribute: " + currentElement), (Throwable)ex);
            }
        }
        return fsaList;
    }

    public static StringBuilder readInputStream(InputStream is) throws IOException {
        String tmp;
        int count;
        StringBuilder res = new StringBuilder();
        Object charset = null;
        byte[] byteTmp = new byte[128];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((count = is.read(byteTmp)) != -1) {
            bos.write(byteTmp, 0, count);
        }
        byte[] bytesArray = bos.toByteArray();
        bos.close();
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(bytesArray));
        BufferedReader br = new BufferedReader(reader);
        while ((tmp = br.readLine()) != null) {
            res.append(tmp);
        }
        return res;
    }

    private static String checkForCharset(String data) {
        int index = data.indexOf(ENCODING_STRING);
        if (index == -1) {
            index = data.indexOf(ALTERNATE_ENCODING_STRING);
        }
        if (index != -1) {
            String subdata = data.substring(index + ENCODING_STRING.length());
            if ((index = subdata.indexOf("'")) == -1) {
                index = subdata.indexOf("\"");
            }
            if (index != -1) {
                try {
                    String charsetName = subdata.substring(0, index);
                    Charset.forName(charsetName);
                    return charsetName;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    static {
        Arrays.sort(GEO_PROPERTY_TYPES);
    }
}

