/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.JDBCFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.JDBCFeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.H2FeatureServiceFactory;
import de.cismet.cismap.commons.featureservice.style.BasicStyle;
import de.cismet.cismap.commons.gui.attributetable.LockFromSameUserAlreadyExistsException;
import de.cismet.cismap.commons.interaction.CismapBroker;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.deegree.style.se.unevaluated.Style;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.openide.util.NbBundle;

public class H2FeatureService
extends JDBCFeatureService<JDBCFeature> {
    private static final Logger LOG = Logger.getLogger(H2FeatureService.class);
    public static final Map<String, Icon> layerIcons = new HashMap<String, Icon>();
    public static final String H2_FEATURELAYER_TYPE = "H2FeatureServiceLayer";
    private static final String LOCK_FEATURE = "INSERT INTO \"cs_lock\" (\"id\", \"table\", \"lock_time\") VALUES(%s, '%s', now())";
    private static final String UPDATE_SLD = "UPDATE \"sld_meta_data\" set \"sld\" = '%s' where \"table\" = '%s'";
    private static final String INSERT_SLD = "INSERT INTO \"sld_meta_data\" (\"table\", \"sld\") VALUES('%s', '%s')";
    private static final String READ_SLD = "SELECT \"sld\" from \"sld_meta_data\" where \"table\" = '%s'";
    private static final String CHECK_LOCKED_FEATURE = "SELECT \"lock_time\" FROM \"cs_lock\" where (\"id\" = %s OR \"id\" is null) and \"table\" = '%s'";
    private static final String CHECK_LOCKED_FEATURE_TABLE = "SELECT \"lock_time\" FROM \"cs_lock\" where \"table\" = '%s'";
    private static final String CLEAR_LOCKS = "DELETE FROM \"cs_lock\"";
    private static final String REMOVE_UNUSED_SEQUENCES = "DROP FROM \"cs_lock\"";
    private static final String UNLOCK = "DELETE FROM \"cs_lock\" where \"id\" = %s and \"table\" = '%s'";
    private static final String UNLOCK_TABLE = "DELETE FROM \"cs_lock\" where \"table\" = '%s'";
    private static final String DELETE_FROM_TABLE = "DELETE FROM \"%s\" where table = '%s';";
    private static final String DELETE_FROM_LOCK_TABLE = "DELETE FROM \"%s\" where \"table\" = '%s';";
    private static final String DROP_TABLE = "DROP TABLE \"%s\";";
    private static final String DROP_SEQUENCE = "DROP SEQUENCE IF EXISTS \"%s_seq\";";
    private List<FeatureServiceFeature> features;
    private File shapeFile;
    private boolean initialised = true;
    private boolean tableNotFound = false;
    private List<String> orderedAttributeNames = null;
    private String geometryType = UNKNOWN;
    private String tableFormat = null;

    public H2FeatureService(Element e) throws Exception {
        super(e);
        this.checkTable();
    }

    public H2FeatureService(String name, String databasePath, String tableName, List<FeatureServiceAttribute> attributes) throws Exception {
        this(name, databasePath, tableName, attributes, null, null);
    }

    public H2FeatureService(String name, String databasePath, String tableName, List<FeatureServiceAttribute> attributes, File shapeFile) throws Exception {
        this(name, databasePath, tableName, attributes, shapeFile, null);
    }

    public H2FeatureService(String name, String databasePath, String tableName, List<FeatureServiceAttribute> attributes, List<FeatureServiceFeature> features) throws Exception {
        this(name, databasePath, tableName, attributes, null, features);
    }

    public H2FeatureService(String name, String databasePath, String tableName, List<FeatureServiceAttribute> attributes, File shapeFile, List<FeatureServiceFeature> features) throws Exception {
        this(name, databasePath, tableName, attributes, shapeFile, features, null);
    }

    public H2FeatureService(String name, String databasePath, String tableName, List<FeatureServiceAttribute> attributes, File shapeFile, List<FeatureServiceFeature> features, List<String> orderedAttributeNames) throws Exception {
        this(name, databasePath, tableName, attributes, shapeFile, features, null, null);
    }

    public H2FeatureService(String name, String databasePath, String tableName, List<FeatureServiceAttribute> attributes, File shapeFile, List<FeatureServiceFeature> features, List<String> orderedAttributeNames, String format) throws Exception {
        super(name, databasePath, tableName, attributes);
        this.shapeFile = shapeFile;
        this.features = features;
        this.orderedAttributeNames = orderedAttributeNames;
        this.tableFormat = format;
    }

    protected H2FeatureService(H2FeatureService hfs) {
        super(hfs);
        this.checkTable();
    }

    private void checkTable() {
        this.tableNotFound = !H2FeatureService.tableAlreadyExists(this.tableName);
    }

    public void createFromShapeFile(URI shapeFileUri) {
        this.shapeFile = new File(shapeFileUri);
        if (this.getFeatureFactory() != null) {
            ((H2FeatureServiceFactory)this.getFeatureFactory()).setFile(this.shapeFile);
        } else {
            try {
                this.initAndWait();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while initialising the H2FeatureService with a new shape file", (Throwable)e);
            }
        }
        this.checkTable();
    }

    @Override
    public void setSLDInputStream(String inputStream) {
        super.setSLDInputStream(inputStream);
        if (inputStream != null && !inputStream.isEmpty()) {
            this.saveStyleFile(inputStream);
        }
    }

    public static String getTableNameStemFromTableName(String tableName) {
        String tableNameStem = tableName;
        if (tableNameStem.contains("_")) {
            tableNameStem = tableNameStem.substring(0, tableNameStem.lastIndexOf("_"));
        }
        return tableNameStem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStyleFile(String content) {
        ConnectionWrapper conn = null;
        Statement st = null;
        String tableNameStem = H2FeatureService.getTableNameStemFromTableName(this.tableName);
        try {
            Class.forName("org.h2.Driver");
            conn = H2FeatureServiceFactory.getDBConnection("~/cismap/internalH2");
            st = conn.createStatement();
            int rowsAffected = st.executeUpdate(String.format(UPDATE_SLD, content, tableNameStem));
            if (rowsAffected == 0) {
                st.executeUpdate(String.format(INSERT_SLD, tableNameStem, content));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while saving style definition", (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close statement", (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected FeatureFactory createFeatureFactory() throws Exception {
        H2FeatureServiceFactory f;
        if (this.features != null) {
            f = new H2FeatureServiceFactory(this.name, this.databasePath, this.tableName, this.features, this.orderedAttributeNames, this.layerInitWorker, this.parseSLD(this.getSLDDefiniton()));
            this.checkTable();
            this.geometryType = f.getGeometryType();
        } else {
            try {
                f = new H2FeatureServiceFactory(this.name, this.databasePath, this.tableName, this.shapeFile, (SwingWorker)this.layerInitWorker, this.parseSLD(this.getSLDDefiniton()));
            }
            catch (Exception e) {
                CismapBroker.getInstance().getMappingComponent().getMappingModel().removeLayer(this);
                H2FeatureService.removeTableIfExists(this.tableName);
                throw e;
            }
            this.checkTable();
            this.geometryType = f.getGeometryType();
        }
        if (this.tableFormat != null) {
            f.setTableFormat(this.tableFormat);
        }
        if (this.getLayerProperties() != null) {
            this.setTheFactorySpecificLayerProperties((DefaultLayerProperties)this.getLayerProperties(), f);
        }
        this.tableFormat = H2FeatureService.getTableFormat(this.tableName, "~/cismap/internalH2");
        String sldString = this.getSldDefinition();
        if (sldString != null && !sldString.isEmpty()) {
            if (sldString.contains("StyleHistoryElement")) {
                SAXBuilder saxBuilder = new SAXBuilder(false);
                StringReader stringReader = new StringReader(sldString);
                Document document = saxBuilder.build((Reader)stringReader);
                BasicStyle style = new BasicStyle(document.getRootElement());
                if (this.getLayerProperties() != null) {
                    this.getLayerProperties().setStyle(style);
                }
            } else {
                this.sldDefinition = sldString;
                Map<String, LinkedList<Style>> styles = this.parseSLD(new StringReader(sldString));
                if (styles != null && !styles.isEmpty()) {
                    f.setSLDStyle(styles);
                }
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSldDefinition() {
        ConnectionWrapper conn = null;
        Statement st = null;
        ResultSet rs = null;
        String tableNameStem = H2FeatureService.getTableNameStemFromTableName(this.tableName);
        try {
            Class.forName("org.h2.Driver");
            conn = H2FeatureServiceFactory.getDBConnection("~/cismap/internalH2");
            st = conn.createStatement();
            rs = st.executeQuery(String.format(READ_SLD, tableNameStem));
            if (rs.next()) {
                String s;
                String string = s = rs.getString(1);
                return string;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading style definition", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close result set", (Throwable)ex);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close statement", (Throwable)ex);
                }
            }
        }
        return null;
    }

    @Override
    protected void initConcreteInstance() throws Exception {
    }

    @Override
    protected String getFeatureLayerType() {
        return H2_FEATURELAYER_TYPE;
    }

    @Override
    protected LayerProperties createLayerProperties() {
        LayerProperties properties = super.createLayerProperties();
        if (this.featureFactory != null) {
            this.setTheFactorySpecificLayerProperties((DefaultLayerProperties)properties, (H2FeatureServiceFactory)this.featureFactory);
        }
        return properties;
    }

    private void setTheFactorySpecificLayerProperties(DefaultLayerProperties properties, H2FeatureServiceFactory featureFactory) {
        properties.setAttributeTableRuleSet(featureFactory.createH2AttributeTableRuleSet());
        properties.setIdExpression(featureFactory.getIdField(), 1);
    }

    @Override
    public Icon getLayerIcon(int type) {
        try {
            Icon layerIcon;
            if (this.tableFormat == null) {
                this.tableFormat = H2FeatureService.getTableFormat(this.tableName, "~/cismap/internalH2");
            }
            if (this.tableFormat == null && this.shapeFile != null) {
                this.tableFormat = this.shapeFile.getAbsolutePath().toLowerCase().substring(this.shapeFile.getAbsolutePath().length() - 3);
            }
            if ((layerIcon = layerIcons.get(type + ";" + this.tableFormat)) != null) {
                return layerIcon;
            }
            return layerIcons.get(String.valueOf(type));
        }
        catch (Exception e) {
            return layerIcons.get(String.valueOf(type));
        }
    }

    public static Icon getLayerIcon(int type, String tableName, String dbName) {
        String format = H2FeatureService.getTableFormat(tableName, dbName);
        Icon layerIcon = layerIcons.get(type + ";" + format);
        if (layerIcon != null) {
            return layerIcon;
        }
        return layerIcons.get(String.valueOf(type));
    }

    @Override
    public Object clone() {
        return new H2FeatureService(this);
    }

    @Override
    public String getGeometryType() {
        return this.geometryType;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public H2FeatureService createLinearReferencingLayer(String fromField, String tillField, String routeField, String routeJoinField, AbstractFeatureService routeService, String layerName, String domain, String newTableName) throws Exception {
        ((H2FeatureServiceFactory)this.getFeatureFactory()).createLinearReferencingLayer(fromField, tillField, routeField, routeJoinField, routeService, layerName, domain, newTableName);
        H2FeatureService service = new H2FeatureService(newTableName, this.databasePath, newTableName, null);
        service.initAndWait();
        return service;
    }

    public H2FeatureService createPointGeometryInformation(String xField, String yField, String newTableName) throws H2FeatureServiceFactory.NegativeValueException, Exception {
        ((H2FeatureServiceFactory)this.getFeatureFactory()).createPointGeometryLayer(xField, yField, newTableName);
        H2FeatureService service = new H2FeatureService(newTableName, this.databasePath, newTableName, null);
        service.initAndWait();
        return service;
    }

    public boolean equals(Object obj) {
        if (obj instanceof H2FeatureService) {
            H2FeatureService service = (H2FeatureService)obj;
            if (this.tableName != null && this.tableName.equals(service.tableName) && this.databasePath != null && this.databasePath.equals(service.databasePath)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.tableName != null ? this.tableName.hashCode() : 0);
        hash = 89 * hash + (this.databasePath != null ? this.databasePath.hashCode() : 0);
        return hash;
    }

    @Override
    public String decoratePropertyName(String name) {
        return "\"" + name + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableAlreadyExists(String tableName) {
        ConnectionWrapper conn = null;
        ResultSet rs = null;
        boolean tableExists = false;
        try {
            Class.forName("org.h2.Driver");
            conn = H2FeatureServiceFactory.getDBConnection("~/cismap/internalH2");
            rs = conn.getMetaData().getTables(null, null, tableName, null);
            boolean bl = tableExists = rs.next();
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot connect to database", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close result set", (Throwable)ex);
                }
            }
        }
        return tableExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockFeature(Integer id, String tableName) throws Exception {
        ConnectionWrapper conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            Class.forName("org.h2.Driver");
            conn = H2FeatureServiceFactory.getDBConnection("~/cismap/internalH2");
            st = conn.createStatement();
            rs = id == null ? st.executeQuery(String.format(CHECK_LOCKED_FEATURE_TABLE, tableName)) : st.executeQuery(String.format(CHECK_LOCKED_FEATURE, id, tableName));
            boolean lockExists = rs.next();
            if (lockExists) {
                throw new LockFromSameUserAlreadyExistsException("The lock does already exists", NbBundle.getMessage(H2FeatureService.class, (String)"H2FeatureService.lockFeature.localUser"));
            }
            st.execute(String.format(LOCK_FEATURE, id == null ? "null" : id.toString(), tableName));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close result set", (Throwable)ex);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close statement", (Throwable)ex);
                }
            }
        }
    }

    public static void clearLocks() {
        ConnectionWrapper conn = null;
        Statement st = null;
        try {
            H2FeatureServiceFactory.createLockTableIfNotExist();
            Class.forName("org.h2.Driver");
            conn = H2FeatureServiceFactory.getDBConnection("~/cismap/internalH2");
            st = conn.createStatement();
            st.execute(String.format(CLEAR_LOCKS, new Object[0]));
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot connect to database", (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close statement", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUnusedSequences() {
        ConnectionWrapper conn = null;
        Statement st = null;
        try {
            Class.forName("org.h2.Driver");
            conn = H2FeatureServiceFactory.getDBConnection("~/cismap/internalH2");
            st = conn.createStatement();
            ResultSet rs = st.executeQuery(String.format("select * from INFORMATION_SCHEMA.SEQUENCES", new Object[0]));
            TreeSet<String> sequs = new TreeSet<String>();
            while (rs.next()) {
                String seqName = rs.getString("SEQUENCE_NAME");
                if (!seqName.endsWith("_seq")) continue;
                sequs.add(seqName);
            }
            rs.close();
            for (String seqName : new ArrayList(sequs)) {
                rs = st.executeQuery("select 1 from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = 'PUBLIC' AND TABLE_NAME = '" + seqName.substring(0, seqName.length() - 4) + "'");
                if (!rs.next()) continue;
                sequs.remove(seqName);
            }
            for (String seqName : sequs) {
                st.execute("DROP SEQUENCE \"" + seqName + "\"");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot connect to database", (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close statement", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockFeature(Integer id, String tableName) {
        ConnectionWrapper conn = null;
        Statement st = null;
        try {
            Class.forName("org.h2.Driver");
            conn = H2FeatureServiceFactory.getDBConnection("~/cismap/internalH2");
            st = conn.createStatement();
            if (id == null) {
                st.execute(String.format(UNLOCK_TABLE, tableName));
            } else {
                st.execute(String.format(UNLOCK, id, tableName));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot connect to database", (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close statement", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeTableIfExists(String tableName) {
        ConnectionWrapper conn = null;
        ResultSet rs = null;
        boolean tableExists = false;
        try {
            conn = H2FeatureServiceFactory.getDBConnection("~/cismap/internalH2");
            rs = conn.getMetaData().getTables(null, null, tableName, null);
            tableExists = rs.next();
            if (tableExists) {
                Statement st = conn.createStatement();
                st.execute(String.format(DROP_TABLE, tableName));
                st.execute(String.format(DROP_SEQUENCE, tableName));
                st.execute(String.format(DELETE_FROM_TABLE, "linear_referencing_meta", tableName));
                st.execute(String.format(DELETE_FROM_TABLE, "table_meta", tableName));
                st.execute(String.format(DELETE_FROM_TABLE, "table_attributes_meta", tableName));
                st.execute(String.format(DELETE_FROM_LOCK_TABLE, "cs_lock", tableName));
                st.close();
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Cannot connect to database", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close result set", (Throwable)ex);
                }
            }
        }
        return tableExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableFormat(String tableName, String dbName) {
        ConnectionWrapper conn = null;
        ResultSet rs = null;
        Statement st = null;
        String format = "shp";
        try {
            conn = H2FeatureServiceFactory.getDBConnection("~/cismap/internalH2");
            st = conn.createStatement();
            rs = st.executeQuery("SELECT format from \"table_meta\" WHERE table = '" + tableName + "';");
            if (rs.next()) {
                format = rs.getString(1);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Cannot connect to database", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close result set", (Throwable)ex);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close connection", (Throwable)ex);
                }
            }
        }
        return format;
    }

    public boolean isTableNotFound() {
        return this.tableNotFound;
    }

    public void setTableNotFound(boolean tableNotFound) {
        this.tableNotFound = tableNotFound;
    }

    static {
        layerIcons.put(String.valueOf(0), new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerShape.png")));
        layerIcons.put(String.valueOf(2), new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerShapeInvisible.png")));
        layerIcons.put(String.valueOf(1), new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerShape.png")));
        layerIcons.put(String.valueOf(3), new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerShapeInvisible.png")));
        layerIcons.put(String.valueOf(0) + ";shp", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerShape.png")));
        layerIcons.put(String.valueOf(2) + ";shp", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerShapeInvisible.png")));
        layerIcons.put(String.valueOf(1) + ";shp", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerShape.png")));
        layerIcons.put(String.valueOf(3) + ";shp", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerShapeInvisible.png")));
        layerIcons.put(String.valueOf(0) + ";dbf", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerDbf.png")));
        layerIcons.put(String.valueOf(2) + ";dbf", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerDbfInvisible.png")));
        layerIcons.put(String.valueOf(1) + ";dbf", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerDbf.png")));
        layerIcons.put(String.valueOf(3) + ";dbf", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerDbfInvisible.png")));
        layerIcons.put(String.valueOf(0) + ";xy", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerXy.png")));
        layerIcons.put(String.valueOf(2) + ";xy", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerXyInvisible.png")));
        layerIcons.put(String.valueOf(1) + ";xy", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerXy.png")));
        layerIcons.put(String.valueOf(3) + ";xy", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerXyInvisible.png")));
        layerIcons.put(String.valueOf(0) + ";r", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerR.png")));
        layerIcons.put(String.valueOf(2) + ";r", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerRInvisible.png")));
        layerIcons.put(String.valueOf(1) + ";r", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerR.png")));
        layerIcons.put(String.valueOf(3) + ";r", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerRInvisible.png")));
        layerIcons.put(String.valueOf(0) + ";csv", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerCsv.png")));
        layerIcons.put(String.valueOf(2) + ";csv", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerCsvInvisible.png")));
        layerIcons.put(String.valueOf(1) + ";csv", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerCsv.png")));
        layerIcons.put(String.valueOf(3) + ";csv", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerCsvInvisible.png")));
        layerIcons.put(String.valueOf(0) + ";dxf", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerDxf.png")));
        layerIcons.put(String.valueOf(2) + ";dxf", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerDxfInvisible.png")));
        layerIcons.put(String.valueOf(1) + ";dxf", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerDxf.png")));
        layerIcons.put(String.valueOf(3) + ";dxf", new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerDxfInvisible.png")));
    }
}

