/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.JDBCFeatureFactory;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public abstract class JDBCFeatureService<FT extends FeatureServiceFeature>
extends AbstractFeatureService<FT, String> {
    private static final Logger LOG = Logger.getLogger(JDBCFeatureService.class);
    protected String databasePath;
    protected String tableName;
    protected String query;

    public JDBCFeatureService(JDBCFeatureService jfs) {
        super(jfs);
        this.databasePath = jfs.databasePath;
        this.tableName = jfs.tableName;
        this.query = jfs.query;
    }

    public JDBCFeatureService(Element e) throws Exception {
        super(e);
    }

    public JDBCFeatureService(String name, String databasePath, String tableName, List<FeatureServiceAttribute> attributes) throws Exception {
        super(name, attributes);
        this.databasePath = databasePath;
        this.substituteHome();
        this.tableName = tableName;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("creating new JDBCFeatureService from path: " + this.databasePath));
        }
    }

    private void substituteHome() {
        String home = System.getProperty("user.home");
        String fileSep = System.getProperty("file.separator");
        this.databasePath = this.databasePath.replace("~", home);
    }

    @Override
    protected LayerProperties createLayerProperties() {
        DefaultLayerProperties defaultLayerProperties = new DefaultLayerProperties();
        defaultLayerProperties.setIdExpression(null, -1);
        defaultLayerProperties.setFeatureService(this);
        return defaultLayerProperties;
    }

    @Override
    public Element toElement() {
        Element parentElement = super.toElement();
        Element daPath = new Element("databasePath");
        daPath.setText(this.databasePath);
        Element tabName = new Element("tableName");
        tabName.setText(this.tableName);
        Element queryElement = new Element("query");
        queryElement.setText(this.query);
        parentElement.addContent((Content)queryElement);
        parentElement.addContent((Content)daPath);
        parentElement.addContent((Content)tabName);
        return parentElement;
    }

    @Override
    public void initFromElement(Element element) throws Exception {
        super.initFromElement(element);
        this.setDatabasePath(element.getChildText("databasePath").trim());
        this.setTableName(element.getChildText("tableName").trim());
        this.setQuery(element.getChildText("query").trim());
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    public String getDatabasePath() {
        return this.databasePath;
    }

    public void setDatabasePath(String databasePath) {
        this.databasePath = databasePath;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        if (this.featureFactory != null) {
            ((JDBCFeatureFactory)this.featureFactory).setTableName(tableName);
        }
    }

    public void setCrs(Crs crs) {
        ((JDBCFeatureFactory)this.featureFactory).setCrs(crs);
    }
}

