/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.gui.capabilitywidget.StringFilter;
import java.io.File;
import java.io.FileFilter;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ShapeFolderTreeModel
implements TreeModel,
StringFilter {
    private static final Logger LOG = Logger.getLogger(ShapeFolderTreeModel.class);
    File folder;
    ShapeFileFilter filter = new ShapeFileFilter();

    public ShapeFolderTreeModel(String link) {
        try {
            String uri = link;
            if (uri.endsWith("\r")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            this.folder = new File(uri.substring(7).trim());
        }
        catch (Exception e) {
            LOG.error((Object)"Illegale shape folder path found.", (Throwable)e);
        }
    }

    @Override
    public Object getRoot() {
        return this.folder;
    }

    @Override
    public Object getChild(Object parent, int index) {
        File parentFile;
        if (parent instanceof File && (parentFile = (File)parent).isDirectory()) {
            return parentFile.listFiles(this.filter)[index];
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        File parentFile;
        if (parent instanceof File && (parentFile = (File)parent).isDirectory()) {
            return parentFile.listFiles(this.filter).length;
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        File parentFile;
        if (node instanceof File && (parentFile = (File)node).isDirectory()) {
            return parentFile.listFiles(this.filter).length == 0;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent != null && child != null && parent instanceof File) {
            File parentFile = (File)parent;
            File[] list = parentFile.listFiles(this.filter);
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].equals(child)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void setFilterString(String filterString) {
        this.filter.setFilterString(filterString);
    }

    private class ShapeFileFilter
    implements FileFilter {
        private String filterString;

        private ShapeFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return this.fulfilFilterRequirements(pathname);
        }

        public void setFilterString(String filterString) {
            this.filterString = filterString;
        }

        public boolean fulfilFilterRequirements(File pathname) {
            if (pathname.isDirectory()) {
                if (this.filterString == null || pathname.getName().toLowerCase().contains(this.filterString.toLowerCase())) {
                    return true;
                }
                for (File f : pathname.listFiles()) {
                    if (!this.fulfilFilterRequirements(f)) continue;
                    return true;
                }
            } else {
                return !(!pathname.getName().endsWith(".shp") && !pathname.getName().endsWith(".gml") || this.filterString != null && !pathname.getName().toLowerCase().contains(this.filterString.toLowerCase()));
            }
            return false;
        }
    }
}

