/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class WFSCapabilitiesTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Logger log = Logger.getLogger((String)"de.cismet.cismap.commons.raster.wfs.WFSCapabilitiesTreeCellRenderer");
    public static boolean showTitle = false;
    private ImageIcon serverIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/server.png"));
    private ImageIcon featureIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/layer.png"));
    private ImageIcon elementIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/attr.png"));
    private ImageIcon stringIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/string.png"));
    private ImageIcon integerIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/integer.png"));
    private ImageIcon geomIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/featureservice/res/geom.png"));
    private String altRootName = null;

    public WFSCapabilitiesTreeCellRenderer() {
    }

    public WFSCapabilitiesTreeCellRenderer(String name) {
        this();
        this.altRootName = name;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        try {
            if (value instanceof WFSCapabilities) {
                if (this.altRootName != null) {
                    this.setText(this.altRootName);
                } else {
                    this.setText("Web Feature Service");
                }
                this.setIcon(this.serverIcon);
            } else if (value instanceof FeatureType) {
                FeatureType e = (FeatureType)value;
                this.setIcon(this.featureIcon);
                if (showTitle) {
                    this.setText(e.getTitle());
                } else {
                    this.setText(e.getName().getLocalPart());
                }
            } else if (value instanceof FeatureServiceAttribute) {
                FeatureServiceAttribute fsf = (FeatureServiceAttribute)value;
                String type = fsf.getType() != null && fsf.getType().lastIndexOf(":") != -1 ? fsf.getType().substring(fsf.getType().lastIndexOf(":") + 1) : fsf.getType();
                if (type.equals("string")) {
                    this.setIcon(this.stringIcon);
                } else if (type.equals("integer")) {
                    this.setIcon(this.integerIcon);
                } else if (FeatureServiceUtilities.isElementOfGeometryType(type)) {
                    this.setIcon(this.geomIcon);
                } else {
                    this.setIcon(this.elementIcon);
                }
                if (fsf.getName() != null && fsf.getName().lastIndexOf(":") != -1) {
                    this.setText(fsf.getName().substring(fsf.getName().lastIndexOf(":") + 1));
                } else {
                    this.setText(fsf.getName());
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"error in WFSCapabilitiesTreeCellRenderer", (Throwable)ex);
        }
        return this;
    }
}

