/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.factory;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import groovy.lang.GroovyShell;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.deegree.style.se.unevaluated.Style;

public abstract class AbstractFeatureFactory<FT extends FeatureServiceFeature, QT>
implements FeatureFactory<FT, QT> {
    public static final boolean DEBUG = false;
    public String layerName = null;
    protected int ID = -1;
    protected Logger logger = Logger.getLogger(this.getClass());
    protected LayerProperties layerProperties;
    protected int maxFeatureCount = -1;
    protected GroovyShell groovyShell = null;
    protected Vector<FT> lastCreatedfeatureVector = new Vector();
    protected Map<String, LinkedList<Style>> styles;
    protected Geometry lastGeom = null;
    protected QT lastQuery;
    private volatile boolean isInterruptedAllowed = true;

    protected AbstractFeatureFactory() {
    }

    protected AbstractFeatureFactory(AbstractFeatureFactory aff) {
        this.ID = aff.ID;
        this.layerProperties = aff.layerProperties.clone();
        this.maxFeatureCount = aff.maxFeatureCount;
        this.lastCreatedfeatureVector = new Vector(aff.lastCreatedfeatureVector.size());
        this.lastCreatedfeatureVector.addAll(this.lastCreatedfeatureVector);
        this.styles = aff.styles;
        this.layerName = aff.layerName;
    }

    public synchronized void waitUntilInterruptedIsAllowed() {
        try {
            if (!this.isInterruptedAllowed) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"should never happen");
        }
    }

    protected synchronized void setInterruptedAllowed() {
        this.isInterruptedAllowed = true;
        this.notifyAll();
    }

    protected synchronized void setInterruptedNotAllowed() {
        this.isInterruptedAllowed = false;
    }

    @Override
    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    @Override
    public void setSLDStyle(Map<String, LinkedList<Style>> styles) {
        this.styles = styles;
        for (FeatureServiceFeature feature : this.lastCreatedfeatureVector) {
            feature.setSLDStyles(this.getStyle(this.layerName));
        }
    }

    @Override
    public void setLayerProperties(LayerProperties layerProperties) {
        LayerProperties oldLayerProperties = this.layerProperties;
        this.layerProperties = layerProperties;
        if (this.isGenerateIds() && this.layerProperties.isIdExpressionEnabled()) {
            this.logger.warn((Object)"factory supports automatic id generation, disabling id expression support in layer properties");
            this.layerProperties.setIdExpressionEnabled(false);
        }
        if (this.lastCreatedfeatureVector.size() > 0) {
            long start = System.currentTimeMillis();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.lastCreatedfeatureVector.size() + " last created features found, applying updated expressions if applicable"));
            }
            if (!(oldLayerProperties.getIdExpression() != null && !oldLayerProperties.getIdExpression().equals(this.layerProperties.getIdExpression()) || oldLayerProperties.getPrimaryAnnotationExpression() != null && !oldLayerProperties.getPrimaryAnnotationExpression().equals(this.layerProperties.getPrimaryAnnotationExpression()) || oldLayerProperties.getSecondaryAnnotationExpression() != null && !oldLayerProperties.getSecondaryAnnotationExpression().equals(this.layerProperties.getSecondaryAnnotationExpression()))) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"expressions did not change, re-elevation not neccessary");
                }
                for (FeatureServiceFeature feature : this.lastCreatedfeatureVector) {
                    feature.setLayerProperties(this.layerProperties);
                }
            } else if (this.layerProperties.getIdExpressionType() == -1 && this.layerProperties.getPrimaryAnnotationExpressionType() == -1 && this.layerProperties.getSecondaryAnnotationExpressionType() == -1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"re-evaluation not necessary, no supported expressions");
                }
                for (FeatureServiceFeature feature : this.lastCreatedfeatureVector) {
                    feature.setLayerProperties(this.layerProperties);
                }
            } else {
                this.reEvaluteExpressions(this.lastCreatedfeatureVector, null);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("updating layer properties of " + this.lastCreatedfeatureVector.size() + " features took " + (System.currentTimeMillis() - start) + " ms"));
            }
        } else {
            this.logger.warn((Object)"no last created features that could be refreshed found");
        }
    }

    @Override
    public LayerProperties getLayerProperties() {
        return this.layerProperties;
    }

    @Override
    public int getMaxFeatureCount() {
        return this.maxFeatureCount;
    }

    @Override
    public void setMaxFeatureCount(int maxFeatureCount) {
        this.maxFeatureCount = maxFeatureCount;
    }

    protected void sortFeatureList(List<? extends FeatureServiceFeature> featureList, final FeatureServiceAttribute[] attributes) {
        Collections.sort(featureList, new Comparator<FeatureServiceFeature>(){

            @Override
            public int compare(FeatureServiceFeature o1, FeatureServiceFeature o2) {
                for (FeatureServiceAttribute attribute : attributes) {
                    Comparable c2;
                    Comparable c1;
                    int result;
                    Object att1 = o1.getProperty(attribute.getName());
                    Object att2 = o2.getProperty(attribute.getName());
                    if (!(att1 instanceof Comparable) || !(att2 instanceof Comparable) || (result = (c1 = (Comparable)att1).compareTo(c2 = (Comparable)att2)) == 0) continue;
                    return result;
                }
                return 0;
            }
        });
    }

    protected void reEvaluteExpressions(List<FT> features, SwingWorker workerThread) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SW[" + workerThread + "]: performing re-evaluation of the expressions of " + features.size() + " selected features"));
        }
        long start = System.currentTimeMillis();
        int i = 0;
        for (FeatureServiceFeature feature : features) {
            if (this.checkCancelled(workerThread, " evaluating expression")) {
                return;
            }
            feature.setLayerProperties(this.layerProperties);
            this.evaluateExpressions(feature, i);
            ++i;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SW[" + workerThread + "]: re-evaluation of " + features.size() + " features took " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    protected void evaluateExpressions(FT feature, int index) {
        Object property = null;
        String id = null;
        if (!this.isGenerateIds()) {
            switch (this.layerProperties.getIdExpressionType()) {
                case 1: {
                    property = feature.getProperty(this.layerProperties.getIdExpression());
                    try {
                        if (property != null) {
                            feature.setId(Integer.parseInt(property.toString()));
                            break;
                        }
                        feature.setId(this.ID);
                    }
                    catch (NumberFormatException nfe) {
                        feature.setId(this.ID);
                    }
                    break;
                }
                case 3: {
                    id = this.evaluateBeanShellExpression(feature, this.layerProperties.getIdExpression());
                    try {
                        if (id != null) {
                            feature.setId(Integer.parseInt(id.toString()));
                            break;
                        }
                        feature.setId(this.ID);
                    }
                    catch (NumberFormatException nfe) {
                        feature.setId(this.ID);
                    }
                    break;
                }
                case 2: {
                    id = this.evaluateGroovyExpressions(feature, this.layerProperties.getIdExpression());
                    try {
                        if (id != null) {
                            feature.setId(Integer.parseInt(id.toString()));
                            break;
                        }
                        feature.setId(this.ID);
                    }
                    catch (NumberFormatException nfe) {
                        feature.setId(this.ID);
                    }
                    break;
                }
                default: {
                    feature.setId(this.ID);
                }
            }
        }
        switch (this.layerProperties.getPrimaryAnnotationExpressionType()) {
            case 0: {
                feature.setPrimaryAnnotation(this.layerProperties.getPrimaryAnnotationExpression());
                break;
            }
            case 1: {
                property = feature.getProperty(this.layerProperties.getPrimaryAnnotationExpression());
                if (property == null) break;
                feature.setPrimaryAnnotation(property.toString());
                break;
            }
            case 3: {
                feature.setPrimaryAnnotation(this.evaluateBeanShellExpression(feature, this.layerProperties.getPrimaryAnnotationExpression()));
                break;
            }
            case 2: {
                feature.setPrimaryAnnotation(this.evaluateGroovyExpressions(feature, this.layerProperties.getPrimaryAnnotationExpression()));
            }
        }
        switch (this.layerProperties.getSecondaryAnnotationExpressionType()) {
            case 0: {
                feature.setSecondaryAnnotation(this.layerProperties.getSecondaryAnnotationExpression());
                break;
            }
            case 1: {
                property = feature.getProperty(this.layerProperties.getSecondaryAnnotationExpression());
                if (property == null) break;
                feature.setSecondaryAnnotation(property.toString());
                break;
            }
            case 3: {
                feature.setSecondaryAnnotation(this.evaluateBeanShellExpression(feature, this.layerProperties.getSecondaryAnnotationExpression()));
                break;
            }
            case 2: {
                feature.setSecondaryAnnotation(this.evaluateGroovyExpressions(feature, this.layerProperties.getSecondaryAnnotationExpression()));
            }
        }
    }

    protected String evaluateGroovyExpressions(FT feature, String expression) {
        if (this.groovyShell == null) {
            this.groovyShell = new GroovyShell();
        }
        try {
            this.groovyShell.getContext().getVariables().clear();
            this.groovyShell.resetLoadedClasses();
            for (Object key : feature.getProperties().keySet()) {
                Object property = feature.getProperty(key.toString());
                this.groovyShell.setVariable(key.toString().replaceAll(":", "_"), property);
            }
            expression = expression.replaceAll(":", "_");
            return this.groovyShell.evaluate(expression).toString();
        }
        catch (Throwable t) {
            this.logger.error((Object)("could not evaluate groovy expression '" + expression + "'"), t);
            return null;
        }
    }

    protected String evaluateBeanShellExpression(FT feature, String expression) {
        throw new UnsupportedOperationException("BeanShell not supported");
    }

    protected boolean checkCancelled(SwingWorker workerThread, String message) {
        if (workerThread != null && workerThread.isCancelled()) {
            this.logger.warn((Object)("FRW[" + workerThread + "]: operation is canceled after " + message));
            this.lastCreatedfeatureVector.clear();
            return true;
        }
        return false;
    }

    @Override
    public synchronized Vector<FT> getLastCreatedFeatures() {
        return new Vector<FT>(this.lastCreatedfeatureVector);
    }

    protected abstract boolean isGenerateIds();

    protected synchronized void updateLastCreatedFeatures(Collection<FT> features, Geometry geom, QT query) {
        this.lastCreatedfeatureVector.clear();
        this.lastCreatedfeatureVector.ensureCapacity(features.size());
        this.lastCreatedfeatureVector.addAll(features);
        this.lastCreatedfeatureVector.trimToSize();
        this.lastGeom = geom;
        this.lastQuery = query;
    }

    @Override
    public FeatureServiceFeature createNewFeature() {
        throw new UnsupportedOperationException();
    }

    protected boolean featuresAlreadyInMemory(Geometry geom, QT query) {
        if (this.lastQuery == null && query != null || this.lastQuery != null && query != null && !this.lastQuery.equals(query)) {
            return false;
        }
        return this.lastGeom != null && geom.getSRID() == this.lastGeom.getSRID() && geom.within(this.lastGeom);
    }

    protected Vector<FT> createFeaturesFromMemory(QT query, Geometry geom) throws FeatureFactory.TooManyFeaturesException, Exception {
        if (!this.featuresAlreadyInMemory(geom, query)) {
            return null;
        }
        Vector<FeatureServiceFeature> featureList = new Vector<FeatureServiceFeature>();
        for (FeatureServiceFeature feature : this.lastCreatedfeatureVector) {
            if (!geom.intersects(feature.getGeometry())) continue;
            featureList.add(feature);
        }
        return featureList;
    }

    @Override
    public abstract AbstractFeatureFactory clone();

    protected List<Style> getStyle() {
        if (this.styles != null) {
            return this.styles.get("default");
        }
        return null;
    }

    public List<Style> getStyle(String layerName) {
        if (layerName == null) {
            return this.getStyle();
        }
        if (this.styles != null && this.styles.containsKey(layerName)) {
            return this.styles.get(layerName);
        }
        return null;
    }
}

