/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.factory;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.GeometryHeuristics;
import de.cismet.cismap.commons.featureservice.factory.AbstractFeatureFactory;
import java.util.Vector;
import javax.swing.SwingWorker;
import org.deegree.model.feature.Feature;
import org.deegree.model.feature.FeatureProgressListener;
import org.deegree.model.feature.FeatureProperty;
import org.deegree.model.spatialschema.Geometry;
import org.deegree.model.spatialschema.JTSAdapter;

public abstract class DegreeFeatureFactory<FT extends FeatureServiceFeature, QT>
extends AbstractFeatureFactory<FT, QT> {
    protected int geometryIndex;
    protected Integer featureSrid = null;

    public DegreeFeatureFactory() {
    }

    protected DegreeFeatureFactory(DegreeFeatureFactory dff) {
        super(dff);
        this.geometryIndex = dff.geometryIndex;
        this.featureSrid = dff.featureSrid;
    }

    protected Vector<FT> processFeatureCollection(SwingWorker workerThread, Feature[] featureCollection, boolean evaluateExpressions) throws Exception {
        long start = System.currentTimeMillis();
        int i = 0;
        this.geometryIndex = GeometryHeuristics.findBestGeometryIndex(featureCollection[0]);
        Vector<FT> featureVector = new Vector<FT>(featureCollection.length);
        for (Feature degreeFeature : featureCollection) {
            if (this.checkCancelled(workerThread, "converting degree features (" + i + ")")) {
                return featureVector;
            }
            FT featureServiceFeature = this.createFeatureInstance(degreeFeature, i);
            this.initialiseFeature(featureServiceFeature, degreeFeature, evaluateExpressions, i);
            featureVector.add(featureServiceFeature);
            ++i;
        }
        this.logger.info((Object)("SW[" + workerThread + "]: converting " + featureCollection.length + " degree features took " + (System.currentTimeMillis() - start) + " ms"));
        return featureVector;
    }

    protected void initialiseFeature(FT featureServiceFeature, Feature degreeFeature, boolean evaluateExpressions, int index) throws Exception {
        featureServiceFeature.setLayerProperties(this.getLayerProperties());
        if (featureServiceFeature.getGeometry() == null) {
            try {
                featureServiceFeature.setGeometry(JTSAdapter.export((Geometry)degreeFeature.getGeometryPropertyValues()[this.geometryIndex]));
            }
            catch (Exception e) {
                featureServiceFeature.setGeometry(JTSAdapter.export((Geometry)degreeFeature.getDefaultGeometryPropertyValue()));
            }
        }
        if (featureServiceFeature.getGeometry() != null && this.featureSrid != null) {
            featureServiceFeature.getGeometry().setSRID(this.featureSrid.intValue());
        }
        if (featureServiceFeature.getProperties() == null || featureServiceFeature.getProperties().isEmpty()) {
            FeatureProperty[] featureProperties;
            for (FeatureProperty fp : featureProperties = degreeFeature.getProperties()) {
                featureServiceFeature.addProperty(fp.getName().getAsString(), fp.getValue());
            }
        }
        if (evaluateExpressions) {
            this.evaluateExpressions(featureServiceFeature, index);
        }
    }

    protected abstract FT createFeatureInstance(Feature var1, int var2) throws Exception;

    protected class ParsingProgressListener
    implements FeatureProgressListener {
        private final int progressThreshold;
        private final int featureCount;
        private final SwingWorker workerThread;
        private int currentProgress = 0;

        public ParsingProgressListener(SwingWorker workerThread, int featureCount, int progressThreshold) {
            this.progressThreshold = progressThreshold;
            this.workerThread = workerThread;
            this.featureCount = featureCount;
        }

        public void featureProgress(int progress) {
            int newProgress = (int)((double)progress / (double)this.featureCount * (double)this.progressThreshold);
            if (this.workerThread != null && newProgress > this.currentProgress) {
                this.currentProgress = newProgress < this.progressThreshold ? newProgress : -1;
                this.workerThread.firePropertyChange("progress", this.currentProgress - 5, this.currentProgress);
            }
        }
    }
}

