/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.factory;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.JDBCFeature;
import de.cismet.cismap.commons.features.JDBCFeatureInfo;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.LinearReferencingInfo;
import de.cismet.cismap.commons.featureservice.factory.AbstractFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.CsvDialog;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.JDBCFeatureFactory;
import de.cismet.cismap.commons.gui.attributetable.H2AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget;
import de.cismet.cismap.commons.gui.options.CapabilityWidgetOptionsPanel;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.cismap.commons.util.CrsDeterminer;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.util.PObjectOutputStream;
import java.awt.Component;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.deegree.io.shpapi.ShapeFile;
import org.deegree.model.feature.FeatureProperty;
import org.deegree.model.spatialschema.JTSAdapter;
import org.deegree.style.se.unevaluated.Style;
import org.h2.jdbc.JdbcSQLException;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.h2gis.utilities.wrapper.StatementWrapper;
import org.jfree.util.Log;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class H2FeatureServiceFactory
extends JDBCFeatureFactory {
    public static final String DEFAULT_DBF_CHARSET = "ISO8859-1";
    public static final String LR_META_TABLE_NAME = "linear_referencing_meta";
    public static final String META_TABLE_NAME = "table_meta";
    public static final String META_TABLE_ATTRIBUTES_NAME = "table_attributes_meta";
    public static final String SLD_TABLE_NAME = "sld_meta_data";
    public static final String SORT_TABLE_NAME = "sort_meta_data";
    public static final String LOCK_TABLE_NAME = "cs_lock";
    public static final int STATION = 1;
    public static final int STATION_LINE = 2;
    private static final String INSERT_LR_META_DATA = "INSERT INTO \"linear_referencing_meta\" (table, lin_ref_reference, domain, src_join_field, targ_join_field, lin_ref_geom, kind, from_value, till_value) VALUES ('%s','%s','%s','%s','%s','%s',%s,'%s','%s');";
    private static final String DELETE_LR_META_DATA = "DELETE FROM \"linear_referencing_meta\" where table = '%s';";
    private static final String INSERT_META_DATA = "INSERT INTO \"table_meta\" (table, format) VALUES ('%s','%s');";
    private static final String INSERT_ATTRIBUTE_META_DATA = "INSERT INTO \"table_attributes_meta\" (table, attributes) VALUES (?,?);";
    private static final String UPDATE_ATTRIBUTE_META_DATA = "UPDATE \"table_attributes_meta\" set attributes = ? where table = ?;";
    private static final String SELECT_ATTRIBUTE_META_DATA = "SELECT attributes from \"table_attributes_meta\" where table = '%s';";
    private static Logger LOG;
    public static final String DB_NAME = "~/cismap/internalH2";
    private static final String CREATE_SPATIAL_INDEX = "CREATE SPATIAL INDEX \"%s\" ON \"%s\" (\"%s\");";
    private static final String UPDATE_SRID = "UPDATE \"%1$s\" set \"%2$s\" = st_setsrid(\"%2$s\", %3$s) where \"%2$s\" is not null";
    private static final String CREATE_TABLE_FROM_CSV = "CREATE TABLE \"%s\" as select %s from CSVREAD('%s', null, '%s');";
    private static final String CREATE_TABLE_FROM_DBF = "CALL DBFRead('%s', '\"%s\"', '%s');";
    private static final String CREATE_TABLE_FROM_SHP = "CALL SHPRead('%s', '\"%s\"', '%s');";
    private static final String CREATE_TABLE_FROM_FILE = "CALL FILE_TABLE('%s', '\"%s\"');";
    private static final String COPY_TABLE_FROM_DBF = "create table \"%s\" as select * from \"%s\"";
    private static final String DROP_TABLE_REFERENCE = "drop table \"%s\";";
    private static final String SELECT_COLUMN = "select \"%s\", \"%s\" from \"%s\"";
    private static final String UPDATE_COLUMN = "update \"%s\" set \"%s\" = ? where \"%s\" = ?";
    private static final String CREATE_TABLE_TEMPLATE = "create table \"%s\" (%s)";
    private static final String INSERT_TEMPLATE = "INSERT INTO \"%s\" (%s) VALUES (%s)";
    private static final String SPATIAL_INIT = "CALL SPATIAL_INIT();";
    private static final String CREATE_SPATIAL_INIT_ALIAS = "CREATE ALIAS IF NOT EXISTS SPATIAL_INIT FOR  \"org.h2gis.h2spatialext.CreateSpatialExtension.initSpatialExtension\";";
    private static final String CREATE_SEQUENCE = "CREATE SEQUENCE \"%s\";";
    private static final String ADD_SEQUENCE = "ALTER TABLE \"%s\" ADD COLUMN \"%s\" int default \"%s\".nextval;";
    private static final String ADD_NOT_NULL_ID = "ALTER TABLE \"%s\" ALTER COLUMN \"%s\" SET NOT NULL;";
    private static final String CREATE_PRIMARY_KEY = "CREATE PRIMARY KEY \"%s\" ON \"%s\"(\"%s\");";
    private static final String CREATE_LR_META_TABLE = "create table \"%s\" (id serial, table varchar, lin_ref_reference varchar, domain varchar, src_join_field varchar, targ_join_field varchar, lin_ref_geom varchar, kind int, from_value varchar, till_value varchar);";
    private static final String CREATE_SORT_META_TABLE = "create table \"%s\" (id serial, folder varchar, table varchar, position integer);";
    private static final String CREATE_SLD_META_TABLE = "create table \"%s\" (\"id\" serial, \"table\" varchar, \"sld\" varchar);";
    private static final String CREATE_META_TABLE = "create table \"%s\" (id serial, table varchar, format varchar);";
    private static final String CREATE_ATTRIBUTES_META_TABLE = "create table \"%s\" (id serial, table varchar, attributes array);";
    private static final String CREATE_LOCK_TABLE = "create table IF NOT EXISTS \"cs_lock\" (\"id\" integer, \"table\" varchar, \"lock_time\" timestamp);";
    private static final String CREATE_LOCK_TABLE_INDEX = "CREATE INDEX IF NOT EXISTS cs_locks_ind ON \"cs_lock\" (\"id\", \"table\");";
    private static String[] knownShpBundleEndings;
    private static final Map<String, ConnectionWrapper> DB_CONNECTIONS;
    private static Map<String, String> CS_MAPPING;
    protected Vector<FeatureServiceAttribute> featureServiceAttributes;
    private String geometryField;
    private String idField = "id";
    private ConnectionWrapper conn;
    private JDBCFeatureInfo info;
    private String name;
    private List<LinearReferencingInfo> linRefList;
    private int srid = CismapBroker.getInstance().getDefaultCrsAlias();
    private String geometryType = AbstractFeatureService.UNKNOWN;
    private int lastFreeId = 0;
    private boolean removeServiceFromTree = false;

    public H2FeatureServiceFactory(H2FeatureServiceFactory hff) {
        super(hff);
        this.featureServiceAttributes = (Vector)hff.featureServiceAttributes.clone();
        this.geometryField = hff.geometryField;
        this.idField = hff.idField;
        this.name = hff.name;
        this.initConnection();
    }

    public H2FeatureServiceFactory(String name, String databasePath, String tableName, File file, SwingWorker workerThread, Map<String, LinkedList<Style>> styles) throws Exception {
        super(databasePath, tableName);
        this.name = name;
        this.layerName = name;
        this.styles = styles;
        this.initConnection();
        if (file != null) {
            this.importFile(workerThread, file);
        }
        this.initFactory();
    }

    public H2FeatureServiceFactory(String name, String databasePath, String tableName, List<FeatureServiceFeature> featureList, SwingWorker workerThread, Map<String, LinkedList<Style>> styles) {
        this(name, databasePath, tableName, featureList, null, workerThread, styles);
    }

    public H2FeatureServiceFactory(String name, String databasePath, String tableName, List<FeatureServiceFeature> featureList, List<String> orderedAttributeList, SwingWorker workerThread, Map<String, LinkedList<Style>> styles) {
        super(databasePath, tableName);
        this.name = name;
        this.layerName = name;
        this.styles = styles;
        this.initConnection();
        if (featureList != null) {
            this.importFeatures(workerThread, featureList, orderedAttributeList);
        }
        this.initFactory();
    }

    public void setFile(File file) {
        if (file != null) {
            try {
                this.importFile(null, file);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while assigning file", (Throwable)ex);
            }
        }
        this.initFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFile(SwingWorker workerThread, File file) throws Exception {
        block28: {
            StatementWrapper st = null;
            try {
                CapabilityWidget cap;
                st = H2FeatureServiceFactory.createStatement(this.conn);
                H2FeatureServiceFactory.initDatabase(this.conn);
                ResultSet rs = this.conn.getMetaData().getTables(null, null, this.tableName, null);
                this.createSldMetaTableIfNotExist();
                if (!rs.next()) {
                    String crs;
                    rs.close();
                    if (workerThread != null) {
                        workerThread.firePropertyChange("progress", 5, -1);
                    }
                    this.createMetaTableIfNotExist();
                    H2FeatureServiceFactory.createLockTableIfNotExist();
                    if (file.getAbsolutePath().toLowerCase().endsWith("csv")) {
                        this.createTableFromCsv(file, (Statement)st);
                    } else {
                        Class.forName("org.h2.Driver");
                        ConnectionWrapper connection = null;
                        StatementWrapper sta = null;
                        try {
                            connection = (ConnectionWrapper)SFSUtilities.wrapConnection((Connection)DriverManager.getConnection("jdbc:h2:" + this.databasePath));
                            sta = H2FeatureServiceFactory.createStatement(connection);
                            this.createTableFromSHP(file, (Statement)sta);
                        }
                        finally {
                            if (sta != null) {
                                sta.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                        }
                    }
                    String format = file.getAbsolutePath().toLowerCase().substring(file.getAbsolutePath().length() - 3);
                    st.execute(String.format(INSERT_META_DATA, this.tableName, format));
                    rs = this.conn.getMetaData().getColumns(null, null, this.tableName, "%");
                    boolean hasIdField = false;
                    String geoCol = null;
                    while (rs.next()) {
                        if (rs.getString("COLUMN_NAME").equalsIgnoreCase("id")) {
                            hasIdField = true;
                            this.idField = rs.getString("COLUMN_NAME");
                        }
                        if (!rs.getString("TYPE_NAME").toUpperCase().endsWith("GEOMETRY")) continue;
                        geoCol = rs.getString("COLUMN_NAME");
                        this.createSpatialIndex(geoCol, this.tableName);
                    }
                    rs.close();
                    if (!this.createPrimaryKey(hasIdField, this.tableName)) {
                        this.removeServiceFromTree = true;
                        H2FeatureService.removeTableIfExists(this.tableName);
                    }
                    if (geoCol != null && (crs = this.determineShapeCrs(file.toURI())) != null) {
                        PreparedStatement ps = this.conn.prepareStatement("update \"" + this.tableName + "\" set \"" + geoCol + "\" = ? where \"" + this.idField + "\" = ?");
                        ResultSet res = st.executeQuery("select \"" + this.idField + "\", \"" + geoCol + "\" from \"" + this.tableName + "\"");
                        while (res.next()) {
                            int id = res.getInt(1);
                            Geometry geom = (Geometry)res.getObject(2);
                            if (crs.equalsIgnoreCase("EPSG:5650")) {
                                double minX = geom.getEnvelopeInternal().getMinX();
                                double maxX = geom.getEnvelopeInternal().getMaxX();
                                if (minX < 3.3E7 || maxX > 3.3999999E7) {
                                    JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), "Die Shapedatei enth\u00e4lt Rechtwerte, die kleiner 33000000 oder gr\u00f6\u00dfer 33999999 sind", NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.importFile().title"), 0);
                                }
                            }
                            geom.setSRID(CrsTransformer.extractSridFromCrs(crs));
                            Geometry crsTransformed = CrsTransformer.transformToGivenCrs(geom, CismapBroker.getInstance().getDefaultCrs());
                            ps.setObject(1, crsTransformed);
                            ps.setInt(2, id);
                            ps.addBatch();
                        }
                        ps.executeBatch();
                    }
                }
                if ((cap = CapabilityWidgetOptionsPanel.getCapabilityWidget()) != null) {
                    cap.refreshJdbcTrees();
                }
                if (st == null) break block28;
            }
            catch (Exception e) {
                block29: {
                    try {
                        this.logger.error((Object)"Error while creating new shape table", (Throwable)e);
                        String errorMessage = e.getMessage();
                        if (errorMessage.contains("\n") && !errorMessage.startsWith("Shape kann")) {
                            errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n"));
                        }
                        if (file.getAbsolutePath().toLowerCase().endsWith("shp") && e instanceof JdbcSQLException) {
                            IOException ioEx;
                            JdbcSQLException jdbcException = (JdbcSQLException)e;
                            if (jdbcException.getCause() instanceof IOException && (ioEx = (IOException)jdbcException.getCause()).getMessage() != null && ioEx.getMessage().contains("Unknown logical value")) {
                                errorMessage = NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.importFile().dbfError");
                            }
                            if (jdbcException.getCause() instanceof IndexOutOfBoundsException) {
                                errorMessage = NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.importFile().dbfError");
                            }
                            JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), errorMessage, NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.importFile().title"), 0);
                            throw e;
                        }
                        JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), errorMessage, NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.importFile().title"), 0);
                        if (errorMessage.equals(NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.importFile().emptyFile"))) {
                            throw e;
                        }
                        if (st == null) break block29;
                    }
                    catch (Throwable throwable) {
                        if (st != null) {
                            st.close();
                        }
                        Thread t = new Thread("cleanup"){

                            @Override
                            public void run() {
                                System.gc();
                            }
                        };
                        t.start();
                        throw throwable;
                    }
                    st.close();
                }
                Thread t = new /* invalid duplicate definition of identical inner class */;
                t.start();
            }
            st.close();
        }
        Thread t = new /* invalid duplicate definition of identical inner class */;
        t.start();
    }

    private int indexOfString(String[] list, String name) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void setTableFormat(String tableFormat) {
        if (tableFormat != null) {
            try {
                this.getConnection().createStatement().execute(String.format(INSERT_META_DATA, this.tableName, tableFormat));
            }
            catch (Exception e) {
                LOG.error((Object)"Error while changing table format", (Throwable)e);
            }
        }
    }

    private void addCustomIdFieldToAttributes(int index, String name) {
        String[] attributes = this.loadOrderedAttributeArray(this.tableName);
        if (attributes != null) {
            ArrayList<String> orderedAttributes = new ArrayList<String>(Arrays.asList(attributes));
            orderedAttributes.add(index, name);
            this.saveAttributeOrder(this.tableName, orderedAttributes.toArray(new String[orderedAttributes.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAttributeOrder(String table, String[] attributes) {
        Statement st = null;
        try {
            if (attributes[1].equals("id")) {
                String tmp = attributes[0];
                attributes[0] = attributes[1];
                attributes[1] = tmp;
            }
            if (this.existsOrderedAttributeArray(this.tableName)) {
                st = this.conn.prepareStatement(UPDATE_ATTRIBUTE_META_DATA);
                st.setObject(1, attributes);
                st.setString(2, table);
                st.executeUpdate();
            } else {
                st = this.conn.prepareStatement(INSERT_ATTRIBUTE_META_DATA);
                st.setString(1, table);
                st.setObject(2, attributes);
                st.executeUpdate();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot insert attributes", (Throwable)e);
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot close statement", (Throwable)e);
            }
        }
    }

    private void loadAttributeOrder() {
        final String[] attributes = this.loadOrderedAttributeArray(this.tableName);
        if (attributes != null) {
            Collections.sort(this.featureServiceAttributes, new Comparator<FeatureServiceAttribute>(){

                private int indexOfAttributes(String name) {
                    for (int i = 0; i < attributes.length; ++i) {
                        if (!attributes[i].equals(name)) continue;
                        return i;
                    }
                    return -1;
                }

                @Override
                public int compare(FeatureServiceAttribute o1, FeatureServiceAttribute o2) {
                    String name1 = o1.getName();
                    String name2 = o2.getName();
                    return (int)Math.signum(this.indexOfAttributes(name1) - this.indexOfAttributes(name2));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] loadOrderedAttributeArray(String table) {
        ResultSet rs = null;
        Statement st = null;
        try {
            Object o;
            st = this.conn.createStatement();
            rs = st.executeQuery(String.format(SELECT_ATTRIBUTE_META_DATA, table));
            if (rs.next() && (o = rs.getObject(1)) instanceof Object[]) {
                String[] attributes = new String[((Object[])o).length];
                for (int i = 0; i < ((Object[])o).length; ++i) {
                    attributes[i] = (String)((Object[])o)[i];
                }
                String[] stringArray = attributes;
                return stringArray;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot insert attributes", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot close statement", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsOrderedAttributeArray(String table) {
        ResultSet rs = null;
        Statement st = null;
        try {
            st = this.conn.createStatement();
            rs = st.executeQuery(String.format(SELECT_ATTRIBUTE_META_DATA, table));
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot insert attributes", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot close statement", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableFromSHP(File file, Statement st) throws Exception {
        String tmpTableReference = this.tableName + "_temp_reference";
        boolean isDbf = false;
        if (file.getAbsolutePath().toLowerCase().endsWith(".shp")) {
            if (!this.checkForFileNames(file)) {
                this.removeServiceFromTree = true;
                throw new Exception(NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.importFile().invalidFileName"));
            }
        } else {
            isDbf = true;
        }
        try {
            ResultSet set;
            ArrayList<String> attributeNames;
            block32: {
                Charset charset = this.getCharsetDefinition(file.getAbsolutePath());
                if (charset == null) {
                    st.execute(String.format(CREATE_TABLE_FROM_FILE, file.getAbsolutePath(), tmpTableReference));
                } else if (isDbf) {
                    st.execute(String.format(CREATE_TABLE_FROM_DBF, file.getAbsolutePath(), tmpTableReference, charset));
                } else {
                    st.execute(String.format(CREATE_TABLE_FROM_SHP, file.getAbsolutePath(), tmpTableReference, charset));
                }
                ResultSet rs = st.executeQuery("select * from \"" + tmpTableReference + "\" limit 1");
                if (!rs.next()) {
                    throw new Exception(NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.importFile().emptyFile"));
                }
                rs.close();
                StringBuilder attsAndTypes = new StringBuilder();
                StringBuilder atts = new StringBuilder();
                StringBuilder attsRef = new StringBuilder();
                attributeNames = new ArrayList<String>();
                HashMap<String, String> typeMap = new HashMap<String, String>();
                rs = st.executeQuery("select * from \"" + tmpTableReference + "\" limit 1");
                for (int i = 2; i <= rs.getMetaData().getColumnCount(); ++i) {
                    String columnName;
                    if (!attsAndTypes.toString().equals("")) {
                        attsAndTypes.append(",");
                        atts.append(",");
                        attsRef.append(",");
                    }
                    if ((columnName = rs.getMetaData().getColumnName(i).toLowerCase()).equals("the_geom")) {
                        columnName = "geom";
                    }
                    attributeNames.add(columnName);
                    attsAndTypes.append("\"").append(columnName).append("\" ").append(rs.getMetaData().getColumnTypeName(i));
                    typeMap.put(rs.getMetaData().getColumnName(i), rs.getMetaData().getColumnTypeName(i));
                    atts.append("\"").append(columnName).append("\"");
                    attsRef.append("\"").append(rs.getMetaData().getColumnName(i)).append("\"");
                }
                rs.close();
                st.execute(String.format(CREATE_TABLE_TEMPLATE, this.tableName, attsAndTypes.toString()));
                try {
                    st.execute(String.format("INSERT INTO \"%s\" (%s) (select %s from \"%s\")", this.tableName, atts, attsRef, tmpTableReference));
                }
                catch (JdbcSQLException e) {
                    if (e.getOriginalCause() instanceof NullPointerException) {
                        if (!file.getPath().endsWith(".shp")) break block32;
                        ShapeFile shapeFile = new ShapeFile(file.getPath().substring(0, file.getPath().length() - 4));
                        int records = shapeFile.getRecordNum();
                        boolean hasNullGeometries = false;
                        int nullGeometries = 0;
                        for (int i = 1; i <= records; ++i) {
                            if (shapeFile.getGeometryByRecNo(i) != null) continue;
                            hasNullGeometries = true;
                            ++nullGeometries;
                        }
                        if (hasNullGeometries) {
                            String[] attr = attsRef.toString().split("\",\"");
                            attr[0] = attr[0].substring(1);
                            attr[attr.length - 1] = attr[attr.length - 1].substring(0, attr[attr.length - 1].length() - 1);
                            for (int i = 1; i <= records; ++i) {
                                StringBuffer attrValues = null;
                                org.deegree.model.feature.Feature f = shapeFile.getFeatureByRecNo(i);
                                HashMap<String, Object> container = new HashMap<String, Object>();
                                org.deegree.model.spatialschema.Geometry geometry = shapeFile.getGeometryByRecNo(i);
                                FeatureProperty[] featureProperties = f.getProperties();
                                if (geometry == null) continue;
                                for (FeatureProperty featureProperty : featureProperties) {
                                    container.put(featureProperty.getName().getLocalName(), featureProperty.getValue());
                                }
                                for (String string : attr) {
                                    String type = (String)typeMap.get(string);
                                    if (attrValues == null) {
                                        attrValues = new StringBuffer();
                                    } else {
                                        attrValues.append(",");
                                    }
                                    if (type.equalsIgnoreCase("geometry")) {
                                        Geometry g = JTSAdapter.export((org.deegree.model.spatialschema.Geometry)geometry);
                                        attrValues.append("'").append(g.toText()).append("'");
                                        continue;
                                    }
                                    if (container.get(string) == null) {
                                        attrValues.append("null");
                                        continue;
                                    }
                                    if (type.equalsIgnoreCase("char")) {
                                        attrValues.append("'").append(container.get(string)).append("'");
                                        continue;
                                    }
                                    attrValues.append(container.get(string));
                                }
                                st.execute(String.format("INSERT INTO \"%s\" (%s) values (%s)", this.tableName, atts, attrValues));
                            }
                            JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.createTableFromSHP.nullGeom.message", (Object[])new Object[]{nullGeometries}), NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.createTableFromSHP.nullGeom.title"), 2);
                        }
                        throw e;
                    }
                    throw e;
                }
            }
            this.saveAttributeOrder(this.tableName, attributeNames.toArray(new String[0]));
            if (!isDbf && (set = st.executeQuery(String.format("SELECT distinct ST_GeometryType(\"geom\") from \"%s\"", this.tableName))).next() && set.getString(1) != null && set.getString(1).toUpperCase().startsWith("MULTI")) {
                set.close();
                set = st.executeQuery(String.format("SELECT max(ST_NumGeometries(\"geom\")) from \"%s\"", this.tableName));
                if (set.next() && set.getInt(1) == 1) {
                    st.execute(String.format("UPDATE \"%s\" set \"geom\" = ST_GeometryN(\"geom\", 1)", this.tableName));
                }
                set.close();
            }
            st.execute(String.format(DROP_TABLE_REFERENCE, tmpTableReference));
        }
        catch (Throwable throwable) {
            try {
                st.execute(String.format(DROP_TABLE_REFERENCE, tmpTableReference));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            st.execute(String.format(DROP_TABLE_REFERENCE, tmpTableReference));
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableFromCsv(File file, Statement st) throws Exception {
        CsvDialog dialog = new CsvDialog(null, true);
        String separatorChar = this.determineSeparator(file);
        dialog.setSeparatorChar(separatorChar);
        dialog.setSize(225, 200);
        StaticSwingTools.centerWindowOnScreen((Window)dialog);
        StatementWrapper checkStatement = H2FeatureServiceFactory.createStatement(this.conn);
        ResultSet csvRs = null;
        try {
            ResultSet checkResultSet = null;
            String options = "charset=" + dialog.getCharactersetName() + " fieldDelimiter=" + dialog.getTextSep() + " fieldSeparator=" + dialog.getSeparatorChar();
            csvRs = st.executeQuery(String.format("select * from CSVREAD('%s', null, '%s') limit 1;", file.getAbsolutePath(), options));
            int colCount = csvRs.getMetaData().getColumnCount();
            StringBuilder select = null;
            ArrayList<String> attributeNames = new ArrayList<String>();
            for (int i = 1; i <= colCount; ++i) {
                boolean isInteger = false;
                String colName = csvRs.getMetaData().getColumnName(i);
                String columnText = "\"" + colName + "\"";
                try {
                    checkResultSet = checkStatement.executeQuery(String.format("select distinct \"" + colName + "\"::integer = \"" + colName + "\"::double from CSVREAD('%s', null, '%s');", file.getAbsolutePath(), options));
                    if (checkResultSet.next() && checkResultSet.getBoolean(1)) {
                        columnText = columnText + "::integer";
                        isInteger = true;
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (checkResultSet != null) {
                        checkResultSet.close();
                    }
                }
                if (!isInteger) {
                    try {
                        checkResultSet = checkStatement.executeQuery(String.format("select \"" + colName + "\"::double from CSVREAD('%s', null, '%s');", file.getAbsolutePath(), options));
                        columnText = columnText + "::double";
                    }
                    catch (Exception e) {
                        try {
                            checkResultSet = checkStatement.executeQuery(String.format("select replace(\"" + colName + "\",',','.')::double from CSVREAD('%s', null, '%s');", file.getAbsolutePath(), options));
                            columnText = "replace(" + columnText + ",',','.')::double";
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (checkResultSet != null) {
                            checkResultSet.close();
                        }
                    }
                }
                if (select == null) {
                    select = new StringBuilder(columnText);
                } else {
                    select.append(", ").append(columnText);
                }
                select.append(" as \"").append(colName).append("\"");
                attributeNames.add(colName);
            }
            st.execute(String.format(CREATE_TABLE_FROM_CSV, this.tableName, select != null ? select.toString() : " * ", file.getAbsolutePath(), options));
            this.saveAttributeOrder(this.tableName, attributeNames.toArray(new String[0]));
        }
        finally {
            if (csvRs != null) {
                try {
                    csvRs.close();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error while closing result set", (Throwable)e);
                }
            }
            checkStatement.close();
        }
    }

    private boolean checkForFileNames(File shpFile) {
        File parentFolder = shpFile.getParentFile();
        String shpStem = shpFile.getName().substring(0, shpFile.getName().lastIndexOf("."));
        for (File possibleShpSiebling : parentFolder.listFiles()) {
            if (!possibleShpSiebling.isFile() || !possibleShpSiebling.getName().contains(".")) continue;
            String ending = possibleShpSiebling.getName().substring(possibleShpSiebling.getName().lastIndexOf(".") + 1);
            for (String possibleEnding : knownShpBundleEndings) {
                String fileStem;
                if (!possibleEnding.equalsIgnoreCase(ending) || !shpStem.equalsIgnoreCase(fileStem = possibleShpSiebling.getName().substring(0, possibleShpSiebling.getName().lastIndexOf("."))) || shpStem.equals(fileStem)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String determineSeparator(File csvFile) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(csvFile));
            String line = br.readLine();
            if (line.contains(",")) {
                String string = ",";
                return string;
            }
            String string = ";";
            return string;
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot read csv file", (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ",";
    }

    private String determineShapeCrs(URI documentURI) {
        String prjFilename = documentURI.getPath().endsWith(".shp") ? documentURI.getPath().substring(0, documentURI.getPath().length() - 4) : documentURI.getPath();
        File prjFile = new File(prjFilename + ".prj");
        if (!prjFile.exists()) {
            prjFile = new File(prjFilename + ".PRJ");
        }
        try {
            if (prjFile.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(prjFile));
                String crsDefinition = br.readLine();
                br.close();
                if (crsDefinition != null) {
                    String epsg = CrsDeterminer.getEpsgCode(crsDefinition);
                    if (epsg != null) {
                        return epsg;
                    }
                } else {
                    this.logger.warn((Object)"The prj file is empty.");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No prj file found.");
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Error while reading the prj file.", (Throwable)e);
        }
        return null;
    }

    private void importFeatures(SwingWorker workerThread, List<FeatureServiceFeature> features, List<String> orderedAttributeList) {
        try {
            StatementWrapper st = H2FeatureServiceFactory.createStatement(this.conn);
            H2FeatureServiceFactory.initDatabase(this.conn);
            ResultSet rs = this.conn.getMetaData().getTables(null, null, this.tableName, null);
            this.createSldMetaTableIfNotExist();
            if (!rs.next()) {
                Object orderedList;
                if (workerThread != null) {
                    workerThread.firePropertyChange("progress", 5, -1);
                }
                try {
                    this.createMetaTableIfNotExist();
                    H2FeatureServiceFactory.createLockTableIfNotExist();
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot create meta table.", (Throwable)e);
                }
                Map<String, FeatureServiceAttribute> attributeMap = features.get(0).getLayerProperties().getFeatureService().getFeatureServiceAttributes();
                StringBuilder tableAttributesWithType = new StringBuilder();
                StringBuilder tableAttributesWithoutType = new StringBuilder();
                StringBuilder placeholder = new StringBuilder();
                boolean firstAttr = true;
                boolean hasIdField = false;
                Object attributeList = orderedAttributeList != null ? orderedAttributeList : ((orderedList = features.get(0).getLayerProperties().getFeatureService().getOrderedFeatureServiceAttributes()) != null ? orderedList : new ArrayList<String>(attributeMap.keySet()));
                orderedList = attributeList.iterator();
                while (orderedList.hasNext()) {
                    String attrKey = (String)orderedList.next();
                    FeatureServiceAttribute attr = attributeMap.get(attrKey);
                    if (attr == null) continue;
                    if (!firstAttr) {
                        tableAttributesWithType.append(",");
                        tableAttributesWithoutType.append(",");
                        placeholder.append(",");
                    } else {
                        firstAttr = false;
                    }
                    if (attr.getName().equalsIgnoreCase("id")) {
                        hasIdField = true;
                        this.idField = attr.getName();
                    }
                    tableAttributesWithType.append("\"").append(attr.getName()).append("\" ");
                    tableAttributesWithoutType.append("\"").append(attr.getName()).append("\"");
                    placeholder.append("?");
                    tableAttributesWithType.append(FeatureTools.getH2DataType(attr));
                }
                st.execute(String.format(CREATE_TABLE_TEMPLATE, this.tableName, tableAttributesWithType.toString()));
                rs = this.conn.getMetaData().getColumns(null, null, this.tableName, "%");
                while (rs.next()) {
                    if (!rs.getString("TYPE_NAME").toUpperCase().endsWith("GEOMETRY")) continue;
                    String colName = rs.getString("COLUMN_NAME");
                    this.createSpatialIndex(colName, this.tableName);
                }
                rs.close();
                PreparedStatement prepStat = this.conn.prepareStatement(String.format(INSERT_TEMPLATE, this.tableName, tableAttributesWithoutType, placeholder));
                int id = 0;
                String manuallySetId = this.getManuallyToChangePrimaryKey((List<String>)attributeList, features);
                for (FeatureServiceFeature f : features) {
                    int index = 0;
                    Iterator iterator = attributeList.iterator();
                    while (iterator.hasNext()) {
                        String attrKey = (String)iterator.next();
                        FeatureServiceAttribute attr = attributeMap.get(attrKey);
                        if (attr == null) continue;
                        if (manuallySetId != null && manuallySetId.equals(attrKey)) {
                            prepStat.setObject(++index, ++id);
                            continue;
                        }
                        Object value = f.getProperty(attrKey);
                        if (value != null && !(value instanceof Serializable)) {
                            value = value.toString();
                        }
                        prepStat.setObject(++index, value);
                    }
                    prepStat.execute();
                }
                this.createPrimaryKey(hasIdField, this.tableName);
                this.saveAttributeOrder(this.tableName, attributeList.toArray(new String[0]));
            }
            st.close();
            CapabilityWidget cap = CapabilityWidgetOptionsPanel.getCapabilityWidget();
            if (cap != null) {
                cap.refreshJdbcTrees();
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"Error while creating a new table from existing features", (Throwable)e);
        }
    }

    private String removeSpecialCharacterFromIndexName(String indexName) {
        String indexNameWithoutSpecialCharacters = indexName.replace("-", "SMI");
        indexNameWithoutSpecialCharacters = indexNameWithoutSpecialCharacters.replace("/", "SSL");
        indexNameWithoutSpecialCharacters = indexNameWithoutSpecialCharacters.replace(" ", "SSP");
        indexNameWithoutSpecialCharacters = indexNameWithoutSpecialCharacters.replace(",", "SCOM");
        indexNameWithoutSpecialCharacters = indexNameWithoutSpecialCharacters.replace(":", "SCOL");
        indexNameWithoutSpecialCharacters = indexNameWithoutSpecialCharacters.replace("<", "SLE");
        indexNameWithoutSpecialCharacters = indexNameWithoutSpecialCharacters.replace(">", "SGR");
        indexNameWithoutSpecialCharacters = indexNameWithoutSpecialCharacters.replace("(", "KLO");
        return indexNameWithoutSpecialCharacters.replace(")", "KLG");
    }

    private String getManuallyToChangePrimaryKey(List<String> attributeList, List<FeatureServiceFeature> features) {
        for (String attrName : attributeList) {
            if (!attrName.equalsIgnoreCase("id")) continue;
            TreeSet<Object> idSet = new TreeSet<Object>();
            for (FeatureServiceFeature fsf : features) {
                Object idProperty = fsf.getProperty(attrName);
                if (idProperty == null || idSet.contains(idProperty)) {
                    return attrName;
                }
                idSet.add(idProperty);
            }
        }
        return null;
    }

    public static void initDatabase(ConnectionWrapper conn) throws SQLException {
        ResultSet rs = conn.getMetaData().getTables(null, null, "GEOMETRY_COLUMNS", null);
        if (!rs.next()) {
            StatementWrapper st = H2FeatureServiceFactory.createStatement(conn);
            st.execute(CREATE_SPATIAL_INIT_ALIAS);
            st.execute(SPATIAL_INIT);
            st.close();
        }
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createPrimaryKey(boolean hasIdField, String tableName) throws SQLException {
        block8: {
            StatementWrapper st = H2FeatureServiceFactory.createStatement(this.conn);
            if (!hasIdField) {
                String seqName = tableName + "_seq";
                st.execute(String.format(CREATE_SEQUENCE, seqName));
                st.execute(String.format(ADD_SEQUENCE, tableName, this.idField, seqName));
            }
            try {
                String indexName = this.removeSpecialCharacterFromIndexName(tableName) + "PIndex" + System.currentTimeMillis();
                st.execute(String.format(ADD_NOT_NULL_ID, tableName, this.idField));
                st.execute(String.format(CREATE_PRIMARY_KEY, this.removeSpecialCharacterFromIndexName(indexName), tableName, this.idField));
            }
            catch (SQLException e) {
                if (!hasIdField) break block8;
                int index = 0;
                String nameBase = "id___";
                String newName = "id___" + this.fillWithZeros(index);
                while (this.indexOfString(this.loadOrderedAttributeArray(tableName), newName) != -1) {
                    newName = "id___" + this.fillWithZeros(++index);
                }
                int ans = JOptionPane.showConfirmDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.createPrimaryKey", (Object)newName), NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.createPrimaryKey.title"), 2);
                if (ans == 0) {
                    st.execute(String.format("alter table \"%s\" alter column \"%s\" rename to \"%s\"", tableName, this.idField, newName));
                    this.addCustomIdFieldToAttributes(1, newName);
                    this.createPrimaryKey(false, tableName);
                    break block8;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                st.close();
            }
        }
        return true;
    }

    private String fillWithZeros(int number) {
        if (number < 10) {
            return "00" + number;
        }
        if (number < 100) {
            return "0" + number;
        }
        return String.valueOf(number);
    }

    private void createSpatialIndex(String geoField, String tableName) throws SQLException {
        StatementWrapper st = H2FeatureServiceFactory.createStatement(this.conn);
        String indexName = this.removeSpecialCharacterFromIndexName(geoField + tableName + "SpatialIndex") + System.currentTimeMillis();
        int srid = CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode());
        st.execute(String.format(CREATE_SPATIAL_INDEX, indexName, tableName, geoField));
        st.execute(String.format(UPDATE_SRID, tableName, geoField, srid));
        st.close();
    }

    private void createMetaLinRefTablesIfNotExist() throws Exception {
        ResultSet rs = this.conn.getMetaData().getTables(null, null, LR_META_TABLE_NAME, null);
        if (!rs.next()) {
            StatementWrapper st = H2FeatureServiceFactory.createStatement(this.conn);
            st.execute(String.format(CREATE_LR_META_TABLE, LR_META_TABLE_NAME));
            st.close();
        }
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSortMetaTableIfNotExist() throws Exception {
        ConnectionWrapper conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            Class.forName("org.h2.Driver");
            conn = H2FeatureServiceFactory.getDBConnection(DB_NAME);
            rs = conn.getMetaData().getTables(null, null, SORT_TABLE_NAME, null);
            if (!rs.next()) {
                st = conn.createStatement();
                st.execute(String.format(CREATE_SORT_META_TABLE, SORT_TABLE_NAME));
                st.close();
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close result set", (Throwable)ex);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close statement", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createLockTableIfNotExist() throws Exception {
        ConnectionWrapper conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            Class.forName("org.h2.Driver");
            conn = H2FeatureServiceFactory.getDBConnection(DB_NAME);
            rs = conn.getMetaData().getTables(null, null, LOCK_TABLE_NAME, null);
            if (!rs.next()) {
                st = conn.createStatement();
                st.execute(CREATE_LOCK_TABLE);
                st.execute(CREATE_LOCK_TABLE_INDEX);
                st.close();
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close result set", (Throwable)ex);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close statement", (Throwable)ex);
                }
            }
        }
    }

    private void createMetaTableIfNotExist() throws Exception {
        StatementWrapper st;
        ResultSet rs = this.conn.getMetaData().getTables(null, null, META_TABLE_NAME, null);
        if (!rs.next()) {
            st = H2FeatureServiceFactory.createStatement(this.conn);
            st.execute(String.format(CREATE_META_TABLE, META_TABLE_NAME));
            st.close();
        }
        rs.close();
        rs = this.conn.getMetaData().getTables(null, null, META_TABLE_ATTRIBUTES_NAME, null);
        if (!rs.next()) {
            st = H2FeatureServiceFactory.createStatement(this.conn);
            st.execute(String.format(CREATE_ATTRIBUTES_META_TABLE, META_TABLE_ATTRIBUTES_NAME));
            st.close();
        }
        rs.close();
    }

    private void createSldMetaTableIfNotExist() {
        try {
            ResultSet rs = this.conn.getMetaData().getTables(null, null, SLD_TABLE_NAME, null);
            if (!rs.next()) {
                StatementWrapper st = H2FeatureServiceFactory.createStatement(this.conn);
                st.execute(String.format(CREATE_SLD_META_TABLE, SLD_TABLE_NAME));
                st.close();
            }
            rs.close();
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot create sld meta table", (Throwable)e);
        }
    }

    private Charset getCharsetDefinition(String filename) {
        Charset cs = null;
        String cpgFilename = filename.endsWith(".shp") || filename.endsWith(".dbf") ? filename.substring(0, filename.length() - 4) : filename;
        File cpgFile = new File(cpgFilename + ".cpg");
        try {
            if (cpgFile.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(cpgFile));
                String csName = br.readLine();
                csName = CS_MAPPING.getOrDefault(csName, csName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("cpg file with charset " + csName + " found"));
                }
                if (csName != null && Charset.isSupported(csName)) {
                    cs = Charset.forName(csName);
                } else {
                    LOG.warn((Object)("The given charset is not supported. Charset: " + csName));
                }
                br.close();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No cpg file found.");
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error while reading the cpg file.");
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLinearReferencingLayer(String fromField, String tillField, String routeField, String routeJoinField, AbstractFeatureService routeService, String layerName, String domain, String newTableName) {
        StatementWrapper st = null;
        ResultSet rs = null;
        Statement linRefGeomUpdate = null;
        Statement removeLine = null;
        int creationSuccessfully = 0;
        int errorCode = 0;
        int errorStation = 0;
        int onlyParts = 0;
        int dsCount = 0;
        try {
            if (!routeService.isInitialized()) {
                routeService.initAndWait();
            }
            List featureList = routeService.retrieveFeatures(null, 0, 0, this.name);
            HashMap<Object, Geometry> routeGeometries = new HashMap<Object, Geometry>();
            for (Feature f : featureList) {
                if (!(f instanceof FeatureServiceFeature)) continue;
                FeatureServiceFeature feature = (FeatureServiceFeature)f;
                routeGeometries.put(feature.getProperty(routeJoinField), feature.getGeometry());
            }
            String geoCol = layerName;
            if (geoCol.indexOf(".") != -1) {
                geoCol = geoCol.substring(geoCol.lastIndexOf(".") + 1);
            }
            st = H2FeatureServiceFactory.createStatement(this.conn);
            st.execute("create table \"" + newTableName + "\" as select * from \"" + this.tableName + "\"");
            if (this.geometryField != null) {
                st.execute("alter table \"" + newTableName + "\" drop column \"" + this.geometryField + "\"");
            }
            String newGeometryField = "geom";
            st.execute("alter table \"" + newTableName + "\" add column \"" + "geom" + "\" Geometry");
            String additionalFields = "\"" + fromField + "\",\"" + routeField + "\"";
            linRefGeomUpdate = this.conn.prepareStatement("UPDATE \"" + newTableName + "\" set \"" + "geom" + "\" = ? WHERE \"" + this.idField + "\" = ?");
            removeLine = this.conn.prepareStatement("DELETE FROM \"" + newTableName + "\"  WHERE \"" + this.idField + "\" = ?");
            String[] attributes = this.loadOrderedAttributeArray(this.tableName);
            ArrayList<String> attributeList = new ArrayList<String>(Arrays.asList(attributes));
            attributeList.add(0, "geom");
            this.saveAttributeOrder(newTableName, attributeList.toArray(new String[attributeList.size()]));
            if (tillField != null) {
                additionalFields = additionalFields + ",\"" + tillField + "\"";
            }
            rs = st.executeQuery("select \"" + this.idField + "\"," + additionalFields + " from \"" + newTableName + "\"");
            while (rs.next()) {
                boolean fromError = false;
                int id = rs.getInt(1);
                double from = rs.getDouble(2);
                Object routeId = rs.getObject(3);
                Point geom = null;
                Geometry routeGeom = (Geometry)routeGeometries.get(routeId);
                ++dsCount;
                if (routeGeom == null && routeId instanceof Long) {
                    routeGeom = (Geometry)routeGeometries.get(new BigDecimal((Long)routeId));
                }
                if (routeGeom == null) {
                    LOG.warn((Object)("No geometry found for route " + routeId));
                    ++errorCode;
                    removeLine.setInt(1, id);
                    removeLine.execute();
                    continue;
                }
                double routeLength = routeGeom.getLength();
                LengthIndexedLine line = new LengthIndexedLine(routeGeom);
                ++creationSuccessfully;
                if (from > routeLength) {
                    ++errorStation;
                    fromError = true;
                    --creationSuccessfully;
                }
                if (tillField != null) {
                    double till = rs.getDouble(4);
                    if (till > routeLength) {
                        ++errorStation;
                        if (!fromError) {
                            ++onlyParts;
                            --creationSuccessfully;
                        }
                    }
                    if (till > routeLength && from > routeLength && (from = routeLength - 1.0) < 0.0) {
                        from = 0.0;
                    }
                    geom = line.extractLine(from, till);
                } else {
                    Coordinate coords = line.extractPoint(from);
                    geom = routeGeom.getFactory().createPoint(coords);
                }
                linRefGeomUpdate.setObject(1, geom);
                linRefGeomUpdate.setInt(2, id);
                linRefGeomUpdate.execute();
            }
            this.createMetaLinRefTablesIfNotExist();
            String tillInfo = tillField == null ? "" : tillField;
            int kind = tillField == null ? 1 : 2;
            st.execute(String.format(INSERT_LR_META_DATA, newTableName, layerName, domain, routeField, routeJoinField, "geom", new Integer(kind), fromField, tillInfo));
            st.execute(String.format(INSERT_META_DATA, newTableName, "r"));
            this.createPrimaryKey(true, newTableName);
            this.createSpatialIndex("geom", newTableName);
            if (creationSuccessfully == 0) {
                JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.createLinearReferencingLayer().noresult", (Object)errorCode, (Object)errorStation), NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.createLinearReferencingLayer().title"), 1);
                H2FeatureService.removeTableIfExists(newTableName);
            } else if (errorCode == 0 && errorStation == 0) {
            } else if (tillField == null) {
                JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.createLinearReferencingLayer().points", (Object)creationSuccessfully, (Object)dsCount, (Object)errorCode, (Object)errorStation, (Object[])new Object[0]), NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.createLinearReferencingLayer().title"), 1);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.createLinearReferencingLayer()", (Object)creationSuccessfully, (Object)dsCount, (Object)onlyParts, (Object)errorCode, (Object[])new Object[]{errorStation}), NbBundle.getMessage(H2FeatureServiceFactory.class, (String)"H2FeatureServiceFactory.createLinearReferencingLayer().title"), 1);
            }
        }
        catch (Exception e) {
            try {
                if (st != null) {
                    st.execute("drop table \"" + newTableName + "\"");
                }
            }
            catch (SQLException ex) {
                LOG.error((Object)"Cannot drop table", (Throwable)ex);
            }
            LOG.error((Object)"Error while joining linear referenced table.", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while closing result set", (Throwable)ex);
                }
            }
            if (linRefGeomUpdate != null) {
                try {
                    linRefGeomUpdate.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while closing prepared statement", (Throwable)ex);
                }
            }
            if (removeLine != null) {
                try {
                    removeLine.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while closing prepared statement", (Throwable)ex);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Error while closing statement", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPointGeometryLayer(String xField, String yField, String newTableName) throws NegativeValueException {
        StatementWrapper st = null;
        Statement linRefGeomUpdate = null;
        ResultSet rs = null;
        try {
            st = H2FeatureServiceFactory.createStatement(this.conn);
            st.execute("create table \"" + newTableName + "\" as select * from \"" + this.tableName + "\"");
            String newGeometryField = "geo_xy";
            if (this.geometryField != null) {
                st.execute("alter table \"" + newTableName + "\" drop column \"" + this.geometryField + "\"");
            }
            st.execute("alter table \"" + newTableName + "\" add column \"" + "geo_xy" + "\" Geometry");
            String additionalFields = "\"" + xField + "\",\"" + yField + "\"";
            linRefGeomUpdate = this.conn.prepareStatement("UPDATE \"" + newTableName + "\" set \"" + "geo_xy" + "\" = ? WHERE \"" + this.idField + "\" = ?");
            rs = st.executeQuery("select \"" + this.idField + "\"," + additionalFields + " from \"" + newTableName + "\"");
            GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.getCurrentSrid());
            boolean xNegative = false;
            boolean yNegative = false;
            while (rs.next()) {
                int id = rs.getInt(1);
                double x = rs.getDouble(2);
                double y = rs.getDouble(3);
                if (!xNegative && x < 0.0) {
                    xNegative = true;
                }
                if (!yNegative && y < 0.0) {
                    yNegative = true;
                }
                if (xNegative || yNegative) continue;
                Point geom = gf.createPoint(new Coordinate(x, y));
                linRefGeomUpdate.setObject(1, geom);
                linRefGeomUpdate.setInt(2, id);
                linRefGeomUpdate.addBatch();
            }
            if (xNegative || yNegative) {
                NegativeValueException e = new NegativeValueException(xNegative && yNegative, "Negative values found");
                if (xNegative && !yNegative) {
                    e.setAttributeName(xField);
                }
                if (!xNegative && yNegative) {
                    e.setAttributeName(yField);
                }
                throw e;
            }
            linRefGeomUpdate.executeBatch();
            st.execute(String.format(INSERT_META_DATA, newTableName, "xy"));
            this.createPrimaryKey(true, newTableName);
            this.createSpatialIndex("geo_xy", newTableName);
        }
        catch (NegativeValueException e) {
            try {
                if (st != null) {
                    st.execute("drop table \"" + newTableName + "\"");
                }
            }
            catch (SQLException ex) {
                LOG.error((Object)"Cannot drop table", (Throwable)ex);
            }
            throw e;
        }
        catch (Exception e) {
            try {
                if (st != null) {
                    st.execute("drop table \"" + newTableName + "\"");
                }
            }
            catch (SQLException ex) {
                LOG.error((Object)"Cannot drop table", (Throwable)ex);
            }
            LOG.error((Object)"Error while adding point geometries.", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Cannot close result set", (Throwable)ex);
                }
            }
            if (linRefGeomUpdate != null) {
                try {
                    linRefGeomUpdate.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Cannot close prepared statement", (Throwable)ex);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Cannot close statement", (Throwable)ex);
                }
            }
        }
    }

    private synchronized void initFactory() {
        this.featureServiceAttributes = new Vector();
        try {
            ResultSet rs = this.conn.getMetaData().getColumns(null, null, this.tableName, "%");
            boolean upperCaseTryed = false;
            int rep = 0;
            do {
                ++rep;
                while (rs.next()) {
                    if (rs.getString("COLUMN_NAME").equalsIgnoreCase("id")) {
                        this.idField = rs.getString("COLUMN_NAME");
                    }
                    this.featureServiceAttributes.add(new FeatureServiceAttribute(rs.getString("COLUMN_NAME"), String.valueOf(rs.getInt("DATA_TYPE")), true));
                    if (!rs.getString("TYPE_NAME").toUpperCase().endsWith("GEOMETRY")) continue;
                    this.geometryField = rs.getString("COLUMN_NAME");
                    FeatureServiceAttribute attr = this.featureServiceAttributes.get(this.featureServiceAttributes.size() - 1);
                    attr.setGeometry(true);
                    attr.setType(rs.getString("TYPE_NAME"));
                }
                if (!this.featureServiceAttributes.isEmpty() || upperCaseTryed) continue;
                rs.close();
                rs = this.conn.getMetaData().getColumns(null, null, this.tableName.toUpperCase(), "%");
                upperCaseTryed = true;
            } while (rep < 2);
            rs.close();
            this.loadAttributeOrder();
            this.createMetaLinRefTablesIfNotExist();
            StatementWrapper st = H2FeatureServiceFactory.createStatement(this.conn);
            ResultSet lrMeta = st.executeQuery("SELECT lin_ref_reference, domain, src_join_field, targ_join_field, lin_ref_geom, kind, from_value, till_value FROM \"linear_referencing_meta\" where table = '" + this.tableName + "'");
            this.linRefList = new ArrayList<LinearReferencingInfo>();
            while (lrMeta.next()) {
                LinearReferencingInfo refInfo = new LinearReferencingInfo();
                refInfo.setLinRefReferenceName(lrMeta.getString(1));
                refInfo.setDomain(lrMeta.getString(2));
                refInfo.setSrcLinRefJoinField(lrMeta.getString(3));
                refInfo.setTrgLinRefJoinField(lrMeta.getString(4));
                refInfo.setGeomField(lrMeta.getString(5));
                refInfo.setFromField(lrMeta.getString(7));
                refInfo.setTillField(lrMeta.getString(8));
                this.linRefList.add(refInfo);
            }
            if (this.layerProperties instanceof DefaultLayerProperties) {
                ((DefaultLayerProperties)this.layerProperties).setAttributeTableRuleSet(this.createH2AttributeTableRuleSet());
            }
            if (this.geometryField != null) {
                ResultSet envelopeSet = st.executeQuery("SELECT ST_Extent(\"" + this.geometryField + "\"), (SELECT st_srid(\"" + this.geometryField + "\"::Geometry) from \"" + this.tableName + "\" limit 1) from \"" + this.tableName + "\" where \"" + this.geometryField + "\" is not null;");
                if (envelopeSet.next()) {
                    Object geomObject = envelopeSet.getObject(1);
                    if (geomObject instanceof Envelope) {
                        GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), envelopeSet.getInt(2));
                        this.envelope = gf.toGeometry((Envelope)geomObject);
                    } else if (geomObject instanceof Polygon) {
                        this.envelope = (Polygon)geomObject;
                        this.envelope.setSRID(envelopeSet.getInt(2));
                    } else if (geomObject instanceof Geometry) {
                        Geometry g = (Geometry)geomObject;
                        if (!g.isEmpty()) {
                            this.envelope = g.getEnvelope().buffer(50.0);
                            this.envelope.setSRID(envelopeSet.getInt(2));
                        }
                    } else {
                        this.envelope = null;
                    }
                    envelopeSet.close();
                } else {
                    this.logger.error((Object)"cannot determine H2 layer envelope");
                }
                ResultSet geometryTypeRs = st.executeQuery("SELECT distinct st_geometryType(\"" + this.geometryField + "\"), (select \"" + this.geometryField + "\" from \"" + this.tableName + "\" where \"" + this.geometryField + "\" is not null limit 1) from \"" + this.tableName + "\" where \"" + this.geometryField + "\" is not null limit 1;");
                if (geometryTypeRs.next()) {
                    this.geometryType = geometryTypeRs.getString(1);
                    Object o = geometryTypeRs.getObject(2);
                    if (geometryTypeRs.next()) {
                        this.geometryType = AbstractFeatureService.UNKNOWN;
                    } else if (o instanceof Geometry) {
                        this.geometryType = ((Geometry)o).getGeometryType();
                    }
                    if (this.getLayerProperties() instanceof DefaultLayerProperties) {
                        ((DefaultLayerProperties)this.getLayerProperties()).setAttributeTableRuleSet(this.createH2AttributeTableRuleSet());
                    }
                }
                geometryTypeRs.close();
            } else {
                this.geometryType = AbstractFeatureService.NONE;
                if (this.getLayerProperties() instanceof DefaultLayerProperties) {
                    ((DefaultLayerProperties)this.getLayerProperties()).setAttributeTableRuleSet(this.createH2AttributeTableRuleSet());
                }
            }
            st.close();
            if (this.info == null) {
                this.info = new JDBCFeatureInfo((Connection)this.conn, this.srid, this.geometryField, this.tableName, this.idField);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while reading meta information of table " + this.databasePath + "." + this.tableName), (Throwable)e);
        }
    }

    public H2AttributeTableRuleSet createH2AttributeTableRuleSet() {
        Collection attributeRuleSet = Lookup.getDefault().lookupAll(H2AttributeTableRuleSet.class);
        if (attributeRuleSet != null && attributeRuleSet.size() > 0) {
            H2AttributeTableRuleSet ruleSet = attributeRuleSet.toArray(new H2AttributeTableRuleSet[attributeRuleSet.size()])[0].clone();
            ruleSet.init(this.linRefList, this.geometryType, this.featureServiceAttributes, this.tableName);
            return ruleSet;
        }
        return null;
    }

    @Override
    public void setLayerProperties(LayerProperties layerProperties) {
        super.setLayerProperties(layerProperties);
        if (layerProperties instanceof DefaultLayerProperties) {
            if (this.removeServiceFromTree && layerProperties.getFeatureService() != null) {
                CismapBroker.getInstance().getMappingComponent().getMappingModel().removeLayer(layerProperties.getFeatureService());
            }
            ((DefaultLayerProperties)layerProperties).setAttributeTableRuleSet(this.createH2AttributeTableRuleSet());
        }
    }

    private void updatePFeatures() {
        try {
            PreparedStatement ps = this.conn.prepareStatement("update \"" + this.tableName + "\" set pfeature = ? where \"" + this.idField + "\" = ?;");
            StatementWrapper upState = (StatementWrapper)this.conn.createStatement();
            ResultSet resultSet = upState.executeQuery("select \"" + this.idField + "\", " + this.geometryField + " from \"" + this.tableName + "\"");
            try {
                int i = 0;
                while (resultSet.next()) {
                    int id = resultSet.getInt(1);
                    Geometry geom = (Geometry)resultSet.getObject(2);
                    PFeature feature = new PFeature(new DefaultFeatureServiceFeature(id, geom, this.getLayerProperties()), CismapBroker.getInstance().getMappingComponent());
                    ps.setObject(1, PObjectOutputStream.toByteArray((Object)feature));
                    ps.setInt(2, id);
                    ps.addBatch();
                    if (++i % 1000 != 0) continue;
                    ps.executeBatch();
                }
                ps.executeBatch();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while creating pfeatures.", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while creating pfeatures", (Throwable)e);
        }
    }

    public static void main(String[] args) {
    }

    private synchronized void initConnection() {
        this.conn = H2FeatureServiceFactory.getDBConnection(this.databasePath);
    }

    private ConnectionWrapper getConnection() {
        return H2FeatureServiceFactory.getDBConnection(this.databasePath);
    }

    public static ConnectionWrapper getDBConnection(String databasePath) {
        String path = databasePath == null ? DB_NAME : databasePath;
        ConnectionWrapper connection = DB_CONNECTIONS.get(path);
        boolean isConnectionClosed = false;
        try {
            if (connection != null) {
                isConnectionClosed = connection.isClosed() || !connection.isValid(100);
            }
        }
        catch (Exception e) {
            isConnectionClosed = true;
        }
        if (connection == null || isConnectionClosed) {
            try {
                if (connection != null) {
                    connection.close();
                }
                Class.forName("org.h2.Driver");
                connection = (ConnectionWrapper)SFSUtilities.wrapConnection((Connection)DriverManager.getConnection("jdbc:h2:" + path));
                DB_CONNECTIONS.put(path, connection);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"Error while creating database connection.", (Throwable)e);
                return null;
            }
            catch (SQLException e) {
                LOG.error((Object)"Error while creating database connection.", (Throwable)e);
                return null;
            }
        }
        return connection;
    }

    public static void tryDBConnection(String databasePath) throws SQLException {
        String path = databasePath == null ? DB_NAME : databasePath;
        ConnectionWrapper connection = DB_CONNECTIONS.get(path);
        boolean isConnectionClosed = false;
        try {
            if (connection != null) {
                isConnectionClosed = connection.isClosed() || !connection.isValid(100);
            }
        }
        catch (Exception e) {
            isConnectionClosed = true;
        }
        if (connection == null || isConnectionClosed) {
            try {
                if (connection != null) {
                    connection.close();
                }
                Class.forName("org.h2.Driver");
                connection = (ConnectionWrapper)SFSUtilities.wrapConnection((Connection)DriverManager.getConnection("jdbc:h2:" + path));
                DB_CONNECTIONS.put(path, connection);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"Error while creating database connection.", (Throwable)e);
            }
            catch (SQLException e) {
                LOG.error((Object)"Error while creating database connection.", (Throwable)e);
                throw e;
            }
        }
    }

    public static synchronized StatementWrapper createStatement(ConnectionWrapper conn) throws SQLException {
        return (StatementWrapper)conn.createStatement();
    }

    @Override
    protected boolean isGenerateIds() {
        return true;
    }

    @Override
    public AbstractFeatureFactory clone() {
        return new H2FeatureServiceFactory(this);
    }

    @Override
    public List createFeatures(Object query, BoundingBox boundingBox, SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, Exception {
        return this.createFeaturesInternal(query, boundingBox, workerThread, 0, 80000, null, true);
    }

    @Override
    public List createFeatures(Object query, BoundingBox boundingBox, SwingWorker workerThread, int offset, int limit, FeatureServiceAttribute[] orderBy) throws FeatureFactory.TooManyFeaturesException, Exception {
        return this.createFeaturesInternal(query, boundingBox, workerThread, offset, limit, orderBy, false);
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
        if (this.info != null) {
            this.info.setTableName(tableName);
        }
    }

    @Override
    public synchronized FeatureServiceFeature createNewFeature() {
        JDBCFeature feature = new JDBCFeature(this.info, this.getStyle(this.name));
        feature.setId(this.getFreeId());
        feature.setLayerProperties(this.getLayerProperties());
        return feature;
    }

    public String getIdField() {
        return this.idField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFreeId() {
        if (this.lastFreeId > 0) {
            return ++this.lastFreeId;
        }
        int freeId = -1;
        StatementWrapper st = null;
        try {
            st = H2FeatureServiceFactory.createStatement(this.conn);
            String maxId = "SELECT max(\"%1s\") + 1 from \"%2s\";";
            String query = String.format("SELECT max(\"%1s\") + 1 from \"%2s\";", this.idField, this.tableName);
            ResultSet rs = st.executeQuery(query);
            if (rs != null && rs.next()) {
                this.lastFreeId = freeId = rs.getInt(1);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            Log.error((Object)"cannot determine free id", (Exception)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Cannot close statement", (Throwable)ex);
                }
            }
        }
        return freeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void determineEnvelope() throws Exception {
        StatementWrapper st = null;
        try {
            st = H2FeatureServiceFactory.createStatement(this.conn);
            ResultSet envelopeSet = st.executeQuery("SELECT ST_Extent(\"" + this.geometryField + "\"), (SELECT st_srid(\"" + this.geometryField + "\"::Geometry) from \"" + this.tableName + "\" limit 1) from \"" + this.tableName + "\" where \"" + this.geometryField + "\" is not null;");
            if (envelopeSet.next()) {
                Object geomObject = envelopeSet.getObject(1);
                if (geomObject instanceof Envelope) {
                    GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), envelopeSet.getInt(2));
                    this.envelope = gf.toGeometry((Envelope)geomObject);
                } else if (geomObject instanceof Polygon) {
                    this.envelope = (Polygon)geomObject;
                    this.envelope.setSRID(envelopeSet.getInt(2));
                } else {
                    this.envelope = null;
                }
                envelopeSet.close();
            } else {
                this.logger.error((Object)"cannot determine H2 layer envelope");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while determining envelope", (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Error while closing statement", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineIdField() {
        String id = "id";
        ResultSet rs = null;
        try {
            rs = this.conn.getMetaData().getColumns(null, null, this.tableName, "%");
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                if (!rs.getString("COLUMN_NAME").equalsIgnoreCase("id")) continue;
                id = rs.getMetaData().getColumnName(i);
                break;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot determine the id field", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.idField = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List createFeaturesInternal(Object query, BoundingBox boundingBox, SwingWorker workerThread, int offset, int limit, FeatureServiceAttribute[] orderBy, boolean saveAsLastCreated) throws FeatureFactory.TooManyFeaturesException, Exception {
        StringBuilder sb = new StringBuilder("select \"" + this.idField + "\" from \"");
        int srid = CrsTransformer.extractSridFromCrs(this.crs.getCode());
        if (boundingBox != null && this.geometryField == null) {
            return new ArrayList();
        }
        if (boundingBox != null) {
            sb.append(this.tableName).append("\" WHERE \"").append(this.geometryField).append("\" && '").append(boundingBox.getGeometry(srid)).append("'");
        } else {
            sb.append(this.tableName).append("\"");
        }
        if (query != null && !query.equals("")) {
            if (boundingBox != null) {
                sb.append(" and ");
            } else {
                sb.append(" WHERE ");
            }
            sb.append(query);
        }
        if (limit != 0) {
            sb.append(" limit ").append(limit);
        }
        if (offset != 0) {
            sb.append(" offset ").append(offset);
        }
        if (orderBy != null && orderBy.length > 0) {
            boolean firstAttr = true;
            sb.append(" order by ");
            for (FeatureServiceAttribute attr : orderBy) {
                if (!firstAttr) {
                    sb.append(", ");
                } else {
                    firstAttr = false;
                }
                sb.append(attr.getName());
            }
        }
        String select = sb.toString();
        try {
            ArrayList<JDBCFeature> arrayList;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("db query: " + select));
            }
            this.setInterruptedNotAllowed();
            StatementWrapper st = H2FeatureServiceFactory.createStatement(this.conn);
            ResultSet rs = st.executeQuery(select);
            ArrayList<JDBCFeature> selectedFeatures = new ArrayList<JDBCFeature>();
            if (this.info == null) {
                this.info = new JDBCFeatureInfo((Connection)this.conn, srid, this.geometryField, this.tableName, this.idField);
            }
            List<Style> style = this.getStyle(this.name);
            Geometry boundingBoxGeom = null;
            if (boundingBox != null) {
                boundingBoxGeom = boundingBox.getGeometry(srid);
            }
            while (rs.next()) {
                if (workerThread != null && workerThread.isCancelled()) {
                    arrayList = null;
                    return arrayList;
                }
                JDBCFeature feature = new JDBCFeature(this.info, style);
                feature.setId(rs.getInt(this.idField));
                feature.setLayerProperties(this.getLayerProperties());
                Geometry featureGeometry = feature.getGeometry();
                if (!saveAsLastCreated && boundingBoxGeom != null && featureGeometry != null && !boundingBoxGeom.intersects(featureGeometry)) continue;
                selectedFeatures.add(feature);
            }
            rs.close();
            st.close();
            if (saveAsLastCreated) {
                this.updateLastCreatedFeatures(selectedFeatures, boundingBox.getGeometry(srid), query);
            }
            arrayList = selectedFeatures;
            return arrayList;
        }
        catch (SQLException e) {
            LOG.error((Object)("Error during the createFeatures operation. Query: " + query), (Throwable)e);
        }
        finally {
            this.setInterruptedAllowed();
        }
        return new ArrayList();
    }

    @Override
    public synchronized List createAttributes(SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, UnsupportedOperationException, Exception {
        if (this.featureServiceAttributes == null || this.featureServiceAttributes.isEmpty()) {
            this.initFactory();
        }
        if (this.featureServiceAttributes == null || this.featureServiceAttributes.isEmpty()) {
            this.logger.error((Object)("SW[" + workerThread + "]: no attributes could be found in h2 database table"));
            throw new Exception("no attributes could be found in the database table '" + this.databasePath + "." + this.tableName + "'");
        }
        return this.featureServiceAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFeatureCount(Object query, BoundingBox bb) {
        StringBuilder sb = new StringBuilder("select count(*) from \"");
        int srid = CrsTransformer.extractSridFromCrs(this.crs.getCode());
        if (bb != null) {
            sb.append(this.tableName).append("\" WHERE ").append(this.geometryField).append(" && '").append(bb.getGeometry(srid)).append("'");
        } else {
            sb.append(this.tableName).append("\"");
        }
        if (query != null && !query.equals("")) {
            if (bb != null) {
                sb.append(" and ");
            } else {
                sb.append(" WHERE ");
            }
            sb.append(query);
        }
        String sqlQuery = sb.toString();
        int result = 0;
        StatementWrapper st = null;
        ResultSet rs = null;
        try {
            st = H2FeatureServiceFactory.createStatement(this.conn);
            rs = st.executeQuery(sqlQuery);
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("Error while determining the feature count. Query: " + sqlQuery), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close result set", (Throwable)ex);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Cannot close statement", (Throwable)ex);
                }
            }
        }
        return result;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeConnection();
    }

    public void closeConnection() {
    }

    public List<LinearReferencingInfo> getLinRefList() {
        return this.linRefList;
    }

    public String getGeometryType() {
        return this.geometryType;
    }

    static {
        block3: {
            LOG = Logger.getLogger(H2FeatureServiceFactory.class);
            knownShpBundleEndings = new String[]{"dbf", "atx", "sbn", "prj", "shx", "sbx", "aih", "ain", "cpg"};
            DB_CONNECTIONS = Collections.synchronizedMap(new HashMap());
            CS_MAPPING = new HashMap<String, String>();
            try {
                ResourceBundle csMapping = ResourceBundle.getBundle("cismapCsMapping", Locale.getDefault());
                Enumeration<String> en = csMapping.getKeys();
                while (en.hasMoreElements()) {
                    String key = en.nextElement();
                    String value = csMapping.getString(key);
                    if (value == null) continue;
                    CS_MAPPING.put(key, value);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Cannot open the resource bundle for the cs mapping.", (Throwable)e);
            }
        }
    }

    public static class NegativeValueException
    extends Exception {
        private final boolean both;
        private String attributeName;

        public NegativeValueException(boolean both, String message) {
            super(message);
            this.both = both;
        }

        public boolean isBoth() {
            return this.both;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }
    }
}

