/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.factory;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.exceptions.ShapeFileImportAborted;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.ShapeFeature;
import de.cismet.cismap.commons.features.ShapeInfo;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.CachingFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.DegreeFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.cismap.commons.util.CrsDeterminer;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.deegree.io.rtree.HyperBoundingBox;
import org.deegree.io.rtree.HyperPoint;
import org.deegree.io.rtree.RTree;
import org.deegree.io.rtree.RTreeException;
import org.deegree.io.shpapi.shape_new.ShapeFile;
import org.deegree.io.shpapi.shape_new.ShapeFileReader;
import org.deegree.model.feature.Feature;
import org.deegree.model.feature.FeatureCollection;
import org.deegree.model.feature.schema.FeatureType;
import org.deegree.model.feature.schema.PropertyType;
import org.deegree.model.spatialschema.Envelope;
import org.deegree.model.spatialschema.Geometry;
import org.deegree.model.spatialschema.GeometryException;
import org.deegree.model.spatialschema.GeometryFactory;
import org.deegree.model.spatialschema.JTSAdapter;
import org.deegree.model.spatialschema.Point;
import org.deegree.style.se.unevaluated.Style;
import org.openide.util.NbBundle;

public class ShapeFeatureFactory
extends DegreeFeatureFactory<ShapeFeature, String>
implements CachingFeatureFactory<ShapeFeature, String> {
    protected int maxCachedFeatureCount = Integer.MAX_VALUE;
    protected URI documentURI;
    protected org.deegree.io.shpapi.ShapeFile shapeFile;
    protected boolean initialised = false;
    protected Vector<FeatureServiceAttribute> featureServiceAttributes;
    private boolean noGeometryRecognised = false;
    private boolean errorInGeometryFound = false;
    private String shapeCrs = null;
    private Crs crs = CismapBroker.getInstance().getSrs();
    private Envelope envelope;
    private FeatureCollection fc = null;
    private String filename;
    private String geometryType = AbstractFeatureService.UNKNOWN;
    private int lastFreeId = -1;
    private ShapeInfo info = null;

    public ShapeFeatureFactory(LayerProperties layerProperties, URI documentURL, int maxCachedFeatureCount, SwingWorker workerThread, Map<String, LinkedList<Style>> styles) throws Exception {
        this(layerProperties, documentURL, maxCachedFeatureCount, workerThread, styles, null);
    }

    public ShapeFeatureFactory(LayerProperties layerProperties, URI documentURL, int maxCachedFeatureCount, SwingWorker workerThread, Map<String, LinkedList<Style>> styles, String shapeCrs) throws Exception {
        this.layerProperties = layerProperties;
        this.documentURI = documentURL;
        this.maxCachedFeatureCount = maxCachedFeatureCount;
        this.styles = styles;
        this.shapeCrs = shapeCrs;
        if (shapeCrs != null) {
            this.featureSrid = CrsTransformer.extractSridFromCrs(shapeCrs);
        }
        try {
            this.parseShapeFile(workerThread);
            this.initialised = true;
        }
        catch (ShapeFileImportAborted e) {
            throw e;
        }
        catch (Exception ex) {
            this.logger.error((Object)("SW[" + workerThread + "]: error parsing shape file"), (Throwable)ex);
            this.cleanup();
        }
    }

    protected ShapeFeatureFactory(ShapeFeatureFactory shpff) {
        super(shpff);
        this.maxCachedFeatureCount = shpff.maxCachedFeatureCount;
        this.documentURI = shpff.documentURI;
        this.shapeFile = shpff.shapeFile;
        this.featureServiceAttributes = new Vector<FeatureServiceAttribute>(shpff.featureServiceAttributes);
        this.initialised = shpff.initialised;
        this.crs = shpff.crs;
        this.shapeCrs = shpff.shapeCrs;
        this.fc = shpff.fc;
        this.filename = shpff.filename;
        this.envelope = shpff.envelope;
        this.geometryType = shpff.geometryType;
        this.noGeometryRecognised = shpff.noGeometryRecognised;
        this.errorInGeometryFound = shpff.errorInGeometryFound;
    }

    @Override
    protected ShapeFeature createFeatureInstance(Feature degreeFeature, int index) throws Exception {
        return null;
    }

    protected ShapeFeature createFeatureInstance(Feature degreeFeature, ShapeInfo shapeInfo, int index) throws Exception {
        this.layerName = this.filename;
        ShapeFeature shapeFeature = new ShapeFeature(shapeInfo, this.getStyle(this.filename));
        shapeFeature.setId(index);
        return shapeFeature;
    }

    @Override
    protected void initialiseFeature(ShapeFeature featureServiceFeature, Feature degreeFeature, boolean evaluateExpressions, int index) throws Exception {
        featureServiceFeature.setLayerProperties(this.getLayerProperties());
        if (evaluateExpressions) {
            this.evaluateExpressions(featureServiceFeature, index);
        }
    }

    protected synchronized void cleanup() {
        if (this.shapeFile != null) {
            this.shapeFile.close();
            this.shapeFile = null;
            System.gc();
        }
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    private Charset getCharsetDefinition() {
        Charset cs = null;
        String cpgFilename = this.documentURI.getPath().endsWith(".shp") ? this.documentURI.getPath().substring(0, this.documentURI.getPath().length() - 4) : this.documentURI.getPath();
        File cpgFile = new File(cpgFilename + ".cpg");
        if (!cpgFile.exists()) {
            cpgFile = new File(cpgFilename + ".CPG");
        }
        try {
            if (cpgFile.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(cpgFile));
                String csName = br.readLine();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("cpg file with charset " + csName + " found"));
                }
                if (csName != null && Charset.isSupported(csName)) {
                    cs = Charset.forName(csName);
                } else {
                    this.logger.warn((Object)("The given charset is not supported. Charset: " + csName));
                }
                br.close();
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No cpg file found.");
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Error while reading the cpg file.");
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSldDefinition() {
        String sldFilename = this.documentURI.getPath().endsWith(".shp") ? this.documentURI.getPath().substring(0, this.documentURI.getPath().length() - 4) : this.documentURI.getPath();
        File sldFile = new File(sldFilename + ".sld");
        if (!sldFile.exists()) {
            sldFile = new File(sldFilename + ".SLD");
        }
        BufferedReader br = null;
        try {
            if (sldFile.exists()) {
                StringBuilder sld = new StringBuilder();
                br = new BufferedReader(new FileReader(sldFile));
                String tmp = null;
                while ((tmp = br.readLine()) != null) {
                    sld.append(tmp).append("\n");
                }
                String sldString = sld.toString();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("sld file with content " + sldString + " found"));
                }
                if (!sldString.equals("")) {
                    String string = sldString;
                    return string;
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No sld file found.");
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Error while reading the sld file.");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    this.logger.error((Object)"Cannot close sld file", (Throwable)ex);
                }
            }
        }
        return null;
    }

    protected synchronized void parseShapeFile(SwingWorker workerThread) throws Exception {
        this.filename = new File(this.documentURI).getName();
        this.shapeFile = this.getShapeFile();
        this.envelope = this.shapeFile.getFileMBR();
        if (this.getShapeCrs() == null) {
            this.setShapeCrs(this.determineShapeCrs());
            if (this.getShapeCrs() == null) {
                throw new ShapeFileImportAborted();
            }
            this.featureSrid = CrsTransformer.extractSridFromCrs(this.getShapeCrs());
        }
        Feature degreeFeature = this.shapeFile.getFeatureByRecNo(1);
        FeatureType type = degreeFeature.getFeatureType();
        this.logger.info((Object)("SW[" + workerThread + "]: creating " + type.getProperties().length + " featureServiceAttributes from first parsed degree feature"));
        this.featureServiceAttributes = new Vector(type.getProperties().length);
        for (PropertyType pt : type.getProperties()) {
            this.featureServiceAttributes.add(new FeatureServiceAttribute(pt.getName().getAsString(), Integer.toString(pt.getType()), true));
        }
        int currentProgress = 0;
        String filename = this.documentURI.getPath().endsWith(".shp") ? this.documentURI.getPath().substring(0, this.documentURI.getPath().length() - 4) : this.documentURI.getPath();
        this.createFeatureCollectionIfRequired();
        try {
            if (!this.shapeFile.hasRTreeIndex()) {
                int features = this.shapeFile.getRecordNum();
                RTree rtree = new RTree(2, 11, filename + ".rti");
                for (int i = 1; i < features + 1; ++i) {
                    Feature feature = null;
                    feature = this.fc != null ? this.fc.getFeature(i - 1) : this.shapeFile.getFeatureByRecNo(i);
                    Geometry[] geometries = feature.getGeometryPropertyValues();
                    if (geometries.length == 0) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)("no geometries at recno" + i));
                        continue;
                    }
                    Envelope envelope = null;
                    envelope = feature.getDefaultGeometryPropertyValue().getEnvelope();
                    if (envelope == null && geometries[0] instanceof Point) {
                        Point pnt = (Point)geometries[0];
                        envelope = GeometryFactory.createEnvelope((double)pnt.getX(), (double)pnt.getY(), (double)pnt.getX(), (double)pnt.getY(), null);
                    }
                    HyperBoundingBox box = new HyperBoundingBox(new HyperPoint(envelope.getMin().getAsArray()), new HyperPoint(envelope.getMax().getAsArray()));
                    rtree.insert((Object)new Integer(i), box);
                    int newProgress = (int)((double)i / (double)features * 100.0);
                    if (workerThread == null || newProgress % 5 != 0 || newProgress <= currentProgress || newProgress < 5) continue;
                    currentProgress = newProgress <= 100 ? newProgress : -1;
                    workerThread.firePropertyChange("progress", currentProgress - 5, currentProgress);
                }
                rtree.close();
            }
        }
        catch (RTreeException e) {
            this.logger.error((Object)"The index file cannot be created. The corresponding folder is possibly write protected.", (Throwable)e);
        }
        this.determineGeometryType();
        this.initialised = true;
        this.cleanup();
    }

    private String determineShapeCrs() {
        String prjFilename = this.documentURI.getPath().endsWith(".shp") ? this.documentURI.getPath().substring(0, this.documentURI.getPath().length() - 4) : this.documentURI.getPath();
        File prjFile = new File(prjFilename + ".prj");
        if (!prjFile.exists()) {
            prjFile = new File(prjFilename + ".PRJ");
        }
        try {
            if (prjFile.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(prjFile));
                String crsDefinition = br.readLine();
                br.close();
                if (crsDefinition != null) {
                    String epsg = CrsDeterminer.getEpsgCode(crsDefinition);
                    if (epsg != null) {
                        return epsg;
                    }
                    return CismapBroker.getInstance().getSrs().getCode();
                }
                this.logger.warn((Object)"The prj file is empty.");
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No prj file found.");
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Error while reading the prj file.", (Throwable)e);
        }
        if (this.featureSrid == null) {
            this.featureSrid = CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode());
        }
        BoundingBox currentBBox = CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBoxFromCamera();
        if (this.getEnvelope().intersects(currentBBox.getGeometry(this.featureSrid))) {
            return CismapBroker.getInstance().getSrs().getCode();
        }
        List<Crs> crsList = CismapBroker.getInstance().getMappingComponent().getCrsList();
        ArrayList<CrsWrapper> definedMappings = new ArrayList<CrsWrapper>();
        for (Crs tmpCrs : crsList) {
            if (!tmpCrs.hasEsriDefinition()) continue;
            definedMappings.add(new CrsWrapper(tmpCrs));
        }
        Object userAnswer = JOptionPane.showInputDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(ShapeFeatureFactory.class, (String)"ShapeFeatureFactory.determineShapeCrs.message"), NbBundle.getMessage(ShapeFeatureFactory.class, (String)"ShapeFeatureFactory.determineShapeCrs.title"), 2, null, definedMappings.toArray(), definedMappings.get(0));
        if (userAnswer instanceof CrsWrapper) {
            return ((CrsWrapper)userAnswer).getCrs().getCode();
        }
        return null;
    }

    private void determineGeometryType() {
        try {
            org.deegree.io.shpapi.ShapeFile persShapeFile = this.getShapeFile();
            ShapeInfo info = new ShapeInfo(this.filename, persShapeFile, this.featureSrid, this.fc);
            ShapeFeature featureServiceFeature = this.createFeatureInstance(null, info, 1);
            this.initialiseFeature(featureServiceFeature, (Feature)null, false, 1);
            this.geometryType = featureServiceFeature.getGeometry().getGeometryType();
        }
        catch (Exception e) {
            this.logger.error((Object)"Cannot determine the geometry type of a shape file.", (Throwable)e);
        }
    }

    public org.deegree.io.shpapi.ShapeFile getShapeFile() throws IOException {
        this.cleanup();
        Charset cs = this.getCharsetDefinition();
        String filename = null;
        filename = this.documentURI.getPath().endsWith(".shp") ? this.documentURI.getPath().substring(0, this.documentURI.getPath().length() - 4) : this.documentURI.getPath();
        this.shapeFile = new org.deegree.io.shpapi.ShapeFile(filename, cs);
        return this.shapeFile;
    }

    public void refreshData() {
        try {
            if (this.info != null) {
                if (this.info.getFile() != null) {
                    this.info.getFile().close();
                }
                this.info.setFile(this.getShapeFile());
                if (this.info.getFc() != null) {
                    this.createFeatureCollectionIfRequired();
                    this.info.setFc(this.fc);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while refreshing data", (Throwable)e);
        }
    }

    private void createFeatureCollectionIfRequired() throws Exception {
        String filename = this.documentURI.getPath().endsWith(".shp") ? this.documentURI.getPath().substring(0, this.documentURI.getPath().length() - 4) : this.documentURI.getPath();
        ShapeFileReader reader = new ShapeFileReader(filename);
        int shapeType = reader.getShapeType();
        if (shapeType == 28 || shapeType == 23 || shapeType == 25 || shapeType == 21 || shapeType == 15 || shapeType == 13 || shapeType == 11) {
            ShapeFile shapeFromReader = reader.read();
            this.fc = shapeFromReader.getFeatureCollection();
        }
    }

    @Override
    public synchronized void flush() {
        this.logger.warn((Object)"flushing cached features");
        this.lastCreatedfeatureVector.clear();
        this.lastGeom = null;
        this.lastQuery = null;
        System.gc();
    }

    @Override
    public int getMaxCachedFeatureCount() {
        try {
            int n = this.getShapeFile().getRecordNum();
            return n;
        }
        catch (IOException ex) {
            this.logger.error((Object)"Cannot open the shape file", (Throwable)ex);
            int n = 0;
            return n;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public void setMaxCachedFeatureCount(int maxCachedFeatureCount) {
    }

    public URI getDocumentURI() {
        return this.documentURI;
    }

    public synchronized void setDocumentURI(URI documentURI) {
        this.documentURI = documentURI;
        try {
            this.parseShapeFile(null);
        }
        catch (Exception e) {
            this.logger.error((Object)"Errro while parsing shape file", (Throwable)e);
        }
    }

    @Override
    public synchronized List<ShapeFeature> createFeatures(String query, BoundingBox boundingBox, SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, Exception {
        return this.createFeatures_internal(query, boundingBox, workerThread, 0, 0, null, true);
    }

    public synchronized Vector<FeatureServiceAttribute> createAttributes(SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, Exception {
        if (this.featureServiceAttributes == null || this.featureServiceAttributes.size() == 0) {
            this.logger.warn((Object)("SW[" + workerThread + "]: Factory not correctly initialised, parsing shape file"));
            this.parseShapeFile(workerThread);
        }
        if (this.featureServiceAttributes == null || this.featureServiceAttributes.size() == 0) {
            this.logger.error((Object)("SW[" + workerThread + "]: no attributes could be found in shape file"));
            throw new Exception("no attributes could be found in shape file '" + this.documentURI + "'");
        }
        return this.featureServiceAttributes;
    }

    @Override
    protected boolean isGenerateIds() {
        return true;
    }

    @Override
    public ShapeFeatureFactory clone() {
        return new ShapeFeatureFactory(this);
    }

    public boolean isNoGeometryRecognised() {
        return this.noGeometryRecognised;
    }

    public boolean isErrorInGeometryFound() {
        return this.errorInGeometryFound;
    }

    public void setCrs(Crs crs) {
        this.crs = crs;
    }

    public com.vividsolutions.jts.geom.Geometry getEnvelope() {
        try {
            if (this.envelope == null) {
                this.envelope = this.getShapeFile().getFileMBR();
                this.cleanup();
            }
            Coordinate[] polyCords = new Coordinate[]{new Coordinate(this.envelope.getMin().getX(), this.envelope.getMin().getY()), new Coordinate(this.envelope.getMin().getX(), this.envelope.getMax().getY()), new Coordinate(this.envelope.getMax().getX(), this.envelope.getMax().getY()), new Coordinate(this.envelope.getMax().getX(), this.envelope.getMin().getY()), new Coordinate(this.envelope.getMin().getX(), this.envelope.getMin().getY())};
            com.vividsolutions.jts.geom.GeometryFactory geomFactory = new com.vividsolutions.jts.geom.GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), this.featureSrid.intValue());
            Polygon boundingPolygon = geomFactory.createPolygon(geomFactory.createLinearRing(polyCords), null);
            return boundingPolygon.getEnvelope();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error whie reading Shape file", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFeatureCount(String query, BoundingBox bb) {
        try {
            Coordinate[] polyCords = new Coordinate[]{new Coordinate(bb.getX1(), bb.getY1()), new Coordinate(bb.getX1(), bb.getY2()), new Coordinate(bb.getX2(), bb.getY2()), new Coordinate(bb.getX2(), bb.getY1()), new Coordinate(bb.getX1(), bb.getY1())};
            com.vividsolutions.jts.geom.GeometryFactory geomFactory = new com.vividsolutions.jts.geom.GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(this.crs.getCode()));
            Polygon boundingPolygon = geomFactory.createPolygon(geomFactory.createLinearRing(polyCords), null);
            boundingPolygon = CrsTransformer.transformToGivenCrs(boundingPolygon, this.getShapeCrs());
            int n = this.getShapeFile().getGeoNumbersByRect(JTSAdapter.wrap((com.vividsolutions.jts.geom.Geometry)boundingPolygon).getEnvelope()).length;
            return n;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while determining the feature count", (Throwable)e);
        }
        finally {
            this.cleanup();
        }
        return 0;
    }

    @Override
    public synchronized List<ShapeFeature> createFeatures(String query, BoundingBox boundingBox, SwingWorker workerThread, int offset, int limit, FeatureServiceAttribute[] orderBy) throws FeatureFactory.TooManyFeaturesException, Exception {
        return this.createFeatures_internal(query, boundingBox, workerThread, offset, limit, orderBy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<ShapeFeature> createFeatures_internal(String query, BoundingBox boundingBox, SwingWorker workerThread, int offset, int limit, FeatureServiceAttribute[] orderBy, boolean saveAsLastCreated) throws FeatureFactory.TooManyFeaturesException, Exception {
        try {
            List<Style> style;
            Object filename;
            List<Object> selectedFeatures;
            if (!this.initialised) {
                this.logger.warn((Object)("SW[" + workerThread + "]: Factory not correclty initialised, parsing shape file"));
                this.parseShapeFile(workerThread);
                this.initialised = true;
                if (this.checkCancelled(workerThread, " initialisation")) {
                    List<ShapeFeature> list = null;
                    return list;
                }
            }
            long start = System.currentTimeMillis();
            Coordinate[] polyCords = new Coordinate[5];
            if (boundingBox == null) {
                boundingBox = new XBoundingBox(this.getEnvelope());
            }
            polyCords[0] = new Coordinate(boundingBox.getX1(), boundingBox.getY1());
            polyCords[1] = new Coordinate(boundingBox.getX1(), boundingBox.getY2());
            polyCords[2] = new Coordinate(boundingBox.getX2(), boundingBox.getY2());
            polyCords[3] = new Coordinate(boundingBox.getX2(), boundingBox.getY1());
            polyCords[4] = new Coordinate(boundingBox.getX1(), boundingBox.getY1());
            com.vividsolutions.jts.geom.GeometryFactory geomFactory = new com.vividsolutions.jts.geom.GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(this.crs.getCode()));
            Polygon boundingPolygon = geomFactory.createPolygon(geomFactory.createLinearRing(polyCords), null);
            boundingPolygon = CrsTransformer.transformToGivenCrs(boundingPolygon, this.getShapeCrs());
            if (this.checkCancelled(workerThread, " quering spatial index structure")) {
                List<ShapeFeature> list = null;
                return list;
            }
            if (this.featuresAlreadyInMemory((com.vividsolutions.jts.geom.Geometry)boundingPolygon, query)) {
                selectedFeatures = this.createFeaturesFromMemory(query, (com.vividsolutions.jts.geom.Geometry)boundingPolygon);
            } else {
                filename = null;
                filename = this.documentURI.getPath().endsWith(".shp") ? this.documentURI.getPath().substring(0, this.documentURI.getPath().length() - 4) : this.documentURI.getPath();
                if (this.info == null) {
                    this.info = new ShapeInfo((String)filename, this.getShapeFile(), this.featureSrid, this.fc);
                }
                org.deegree.io.shpapi.ShapeFile persShapeFile = this.info.getFile();
                this.shapeFile = null;
                int[] nArray = persShapeFile.getGeoNumbersByRect(JTSAdapter.wrap((com.vividsolutions.jts.geom.Geometry)boundingPolygon).getEnvelope());
                if (nArray == null) {
                    Vector<ShapeFeature> vector = new Vector<ShapeFeature>();
                    return vector;
                }
                if (this.checkCancelled(workerThread, " quering spatial index structure")) {
                    List<ShapeFeature> list = null;
                    return list;
                }
                selectedFeatures = new ArrayList(nArray.length);
                int count = 0;
                for (int record : nArray) {
                    ShapeFeature featureServiceFeature;
                    ++count;
                    if (this.fc != null) {
                        featureServiceFeature = this.createFeatureInstance(null, this.info, record - 1);
                        this.initialiseFeature(featureServiceFeature, (Feature)null, false, record - 1);
                    } else {
                        featureServiceFeature = this.createFeatureInstance(null, this.info, record);
                        this.initialiseFeature(featureServiceFeature, (Feature)null, false, record);
                    }
                    if (this.fulfilQuery(query, featureServiceFeature)) {
                        selectedFeatures.add(featureServiceFeature);
                    }
                    if (saveAsLastCreated && count > 50000) break;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("feature crs: " + this.getShapeCrs() + " features " + selectedFeatures.size() + " boundingbox: " + boundingPolygon.getEnvelopeInternal()));
            }
            if (this.checkCancelled(workerThread, " quering spatial index structure")) {
                filename = null;
                return filename;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SW[" + workerThread + "]: quering spatial index for bounding box took " + (System.currentTimeMillis() - start) + " ms"));
            }
            if (selectedFeatures.size() > this.getMaxFeatureCount()) {
                throw new FeatureFactory.TooManyFeaturesException("features in selected area " + selectedFeatures.size() + " exceeds max feature count " + this.getMaxFeatureCount());
            }
            if (selectedFeatures.size() == 0) {
                this.logger.warn((Object)("SW[" + workerThread + "]: no features found in selected bounding box"));
                filename = selectedFeatures;
                return filename;
            }
            if (orderBy != null && orderBy.length > 0) {
                this.sortFeatureList(selectedFeatures, orderBy);
            }
            if (offset > 0) {
                selectedFeatures = selectedFeatures.subList(offset, selectedFeatures.size());
            }
            if (limit > 0 && selectedFeatures.size() > limit) {
                selectedFeatures = selectedFeatures.subList(0, limit);
            }
            this.reEvaluteExpressions(selectedFeatures, workerThread);
            if (this.checkCancelled(workerThread, " saving LastCreatedFeatures ")) {
                filename = null;
                return filename;
            }
            if (saveAsLastCreated) {
                this.updateLastCreatedFeatures(selectedFeatures, (com.vividsolutions.jts.geom.Geometry)boundingPolygon, query);
            }
            if ((style = this.getStyle(this.layerName)) != null && selectedFeatures != null) {
                for (ShapeFeature shapeFeature : selectedFeatures) {
                    shapeFeature.setSLDStyles(style);
                }
            }
            Vector<Object> vector = new Vector<Object>(selectedFeatures);
            return vector;
        }
        finally {
            this.cleanup();
        }
    }

    private boolean fulfilQuery(String query, ShapeFeature feature) {
        if (query == null || query.equals("")) {
            return true;
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("js");
        try {
            String dataDefinition = this.toVariableString(feature);
            String code = query;
            code = dataDefinition + "\n " + code.replace("app:", "");
            Object result = engine.eval(code);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            this.logger.error((Object)"invalid query");
            return false;
        }
        catch (Exception e) {
            this.logger.error((Object)("invalid fromula: " + query), (Throwable)e);
            return false;
        }
    }

    private String toVariableString(FeatureServiceFeature feature) {
        StringBuilder vars = new StringBuilder("");
        HashMap props = feature.getProperties();
        for (String propName : props.keySet()) {
            FeatureServiceAttribute attr = feature.getLayerProperties().getFeatureService().getFeatureServiceAttributes().get(propName);
            Class<?> cl = FeatureTools.getClass(attr);
            Object value = props.get(propName);
            if (value instanceof Geometry) {
                try {
                    value = JTSAdapter.export((Geometry)((Geometry)value));
                }
                catch (GeometryException ex) {
                    this.logger.error((Object)"Error while converting deegree geometry to jts geometry", (Throwable)ex);
                }
            }
            if (vars.length() > 0) {
                vars.append(";\n");
            }
            vars.append(propName.replace("app:", "")).append("=");
            if (value != null && (cl.equals(String.class) || cl.equals(Date.class))) {
                vars.append("\"").append(value).append("\"");
                continue;
            }
            vars.append(String.valueOf(value));
        }
        vars.append(";\n");
        return vars.toString();
    }

    private int getNextFreeId() throws Exception {
        if (this.lastFreeId > 0) {
            return ++this.lastFreeId;
        }
        if (this.fc != null) {
            this.lastFreeId = this.fc.size();
        } else {
            org.deegree.io.shpapi.ShapeFile persShapeFile = this.getShapeFile();
            this.lastFreeId = persShapeFile.getRecordNum() + 1;
        }
        return this.lastFreeId;
    }

    @Override
    public FeatureServiceFeature createNewFeature() {
        try {
            org.deegree.io.shpapi.ShapeFile persShapeFile = this.getShapeFile();
            ShapeInfo info = new ShapeInfo(this.filename, persShapeFile, this.featureSrid, this.fc);
            try {
                ShapeFeature featureServiceFeature;
                int freeid = this.getNextFreeId();
                if (this.fc != null) {
                    featureServiceFeature = this.createFeatureInstance(null, info, freeid);
                    this.initialiseFeature(featureServiceFeature, (Feature)null, false, freeid);
                } else {
                    featureServiceFeature = this.createFeatureInstance(null, info, freeid);
                    this.initialiseFeature(featureServiceFeature, (Feature)null, false, freeid);
                }
                return featureServiceFeature;
            }
            catch (Exception e) {
                this.logger.error((Object)"Error while creating new feature", (Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while creating new feature", (Throwable)e);
            return null;
        }
    }

    public String getGeometryType() {
        return this.geometryType;
    }

    public String getShapeCrs() {
        return this.shapeCrs;
    }

    public void setShapeCrs(String shapeCrs) {
        this.shapeCrs = shapeCrs;
    }

    private class CrsWrapper {
        private Crs crs;

        public CrsWrapper(Crs crs) {
            this.crs = crs;
        }

        public String toString() {
            return this.crs.getShortname();
        }

        public Crs getCrs() {
            return this.crs;
        }

        public void setCrs(Crs crs) {
            this.crs = crs;
        }
    }
}

