/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.factory;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.WFSFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.DegreeFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.GeometryUtils;
import de.cismet.cismap.commons.wfs.WFSFacade;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.commons.security.AccessHandler;
import de.cismet.security.WebAccessManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingWorker;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.methods.PostMethod;
import org.deegree.model.feature.Feature;
import org.deegree.model.feature.FeatureCollection;
import org.deegree.model.feature.FeatureProperty;
import org.deegree.model.feature.GMLFeatureCollectionDocument;
import org.deegree.model.spatialschema.Geometry;
import org.deegree.model.spatialschema.JTSAdapter;
import org.deegree.style.se.unevaluated.Style;
import org.jdom.Element;
import org.w3c.dom.Document;

public class WFSFeatureFactory
extends DegreeFeatureFactory<WFSFeature, String> {
    private static final String ENCODING_STRING = "encoding='";
    private static final String ALTERNATE_ENCODING_STRING = "encoding=\"";
    protected String hostname = null;
    protected FeatureType featureType;
    private Crs crs;
    private boolean reverseAxisOrder = false;

    public WFSFeatureFactory(LayerProperties layerProperties, String hostname, FeatureType featureType, Crs crs, Map<String, LinkedList<Style>> styles) {
        this(layerProperties, hostname, featureType, crs, styles, false);
    }

    public WFSFeatureFactory(LayerProperties layerProperties, String hostname, FeatureType featureType, Crs crs, Map<String, LinkedList<Style>> styles, boolean reverseAxisOrder) {
        this.logger.info((Object)("initialising WFSFeatureFactory with hostname: '" + hostname + "'"));
        this.layerProperties = layerProperties;
        this.hostname = hostname;
        this.featureType = featureType;
        this.crs = crs;
        this.styles = styles;
        this.reverseAxisOrder = reverseAxisOrder;
    }

    protected WFSFeatureFactory(WFSFeatureFactory wfsff) {
        super(wfsff);
        this.hostname = wfsff.hostname;
        this.featureType = wfsff.featureType;
        this.crs = wfsff.crs;
        this.reverseAxisOrder = wfsff.reverseAxisOrder;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public Vector<WFSFeature> createFeatures(String query, BoundingBox boundingBox, SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, Exception {
        return this.createFeatures_internal(query, boundingBox, workerThread, true);
    }

    private Vector<WFSFeature> createFeatures_internal(String query, BoundingBox boundingBox, SwingWorker workerThread, boolean saveAsLastCreated) throws FeatureFactory.TooManyFeaturesException, Exception {
        Vector<WFSFeature> features;
        String baseUrl;
        if (this.checkCancelled(workerThread, "createFeatures()")) {
            return null;
        }
        XBoundingBox bbox = new XBoundingBox(boundingBox.getX1(), boundingBox.getY1(), boundingBox.getX2(), boundingBox.getY2(), this.getCrs().getCode(), this.getCrs().isMetric());
        long start = System.currentTimeMillis();
        WFSFacade facade = this.featureType.getWFSCapabilities().getServiceFacade();
        String postString = facade.setGetFeatureBoundingBox(query, bbox, this.featureType, this.getCrs().getCode(), this.reverseAxisOrder);
        this.featureSrid = CrsTransformer.extractSridFromCrs(WFSFacade.getOptimalCrsForFeature(this.featureType, this.getCrs().getCode()));
        if (this.checkCancelled(workerThread, "creating post string")) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("FRW[" + workerThread + "]: Host name: " + this.hostname + "\nWFS Query: \n" + postString));
        }
        if ((baseUrl = CismapBroker.getInstance().aliasToUrl(this.hostname)).contains("?")) {
            baseUrl = baseUrl.substring(0, baseUrl.indexOf("?"));
        }
        InputStream respIs = WebAccessManager.getInstance().doRequest(new URL(baseUrl), postString, AccessHandler.ACCESS_METHODS.POST_REQUEST);
        if (this.checkCancelled(workerThread, "executing http request")) {
            return null;
        }
        this.logger.info((Object)("FRW[" + workerThread + "]: WFS request took " + (System.currentTimeMillis() - start) + " ms"));
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(respIs));
        if (this.checkCancelled(workerThread, "creating InputStreamReader")) {
            return null;
        }
        GMLFeatureCollectionDocument featureCollectionDocument = new GMLFeatureCollectionDocument();
        try {
            String tmp;
            start = System.currentTimeMillis();
            if (this.checkCancelled(workerThread, "creating GMLFeatureCollectionDocument")) {
                return null;
            }
            StringBuilder res = new StringBuilder();
            String charset = null;
            BufferedReader br = new BufferedReader(reader);
            while ((tmp = br.readLine()) != null) {
                if (charset != null) {
                    try {
                        res.append(new String(tmp.getBytes(), charset));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.error((Object)("Unsupported encoding found: " + charset), (Throwable)e);
                        res.append(new String(tmp.getBytes()));
                    }
                    continue;
                }
                charset = this.checkForCharset(tmp);
                if (charset != null) {
                    try {
                        res.append(new String(tmp.getBytes(), charset));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.error((Object)("Unsupported encoding found: " + charset), (Throwable)e);
                        res.append(new String(tmp.getBytes()));
                    }
                    continue;
                }
                res.append(new String(tmp.getBytes()));
            }
            br.close();
            br = null;
            System.gc();
            if (this.logger.isDebugEnabled() && res.length() < 10000000) {
                this.logger.debug((Object)("wfs response: " + res.toString()));
            }
            StringReader re = new StringReader(res.toString());
            res = null;
            featureCollectionDocument.load((Reader)re, "http://dummyID");
            re.close();
            re = null;
            if (this.checkCancelled(workerThread, "loading features")) {
                return null;
            }
            if (featureCollectionDocument.getFeatureCount() == 0) {
                this.logger.warn((Object)("FRW[" + workerThread + "]: no features found before parsing"));
                return null;
            }
            FeatureCollection featureCollection = featureCollectionDocument.parse();
            if (this.checkCancelled(workerThread, "parsing features")) {
                return null;
            }
            if (featureCollection.size() == 1 && featureCollection.getFeature(0).getName() != null && featureCollection.getFeature(0).getName().getLocalName().equals("ExceptionText")) {
                this.logger.warn((Object)"The wfs response contains only one feature with the name ExceptionText. So an error occured. Trying to extract the error message.");
                try {
                    String errorMessage = featureCollectionDocument.getRootElement().getFirstChild().getFirstChild().getTextContent();
                    throw new Exception(errorMessage);
                }
                catch (NullPointerException e) {
                    this.logger.error((Object)"Cannot extract the error message from the wfs response.");
                    throw new Exception("The wfs replies with an Exception, but the error text cannot be extracted.");
                }
            }
            featureCollectionDocument = null;
            System.gc();
            this.logger.info((Object)("FRW[" + workerThread + "]: parsing " + featureCollection.size() + " features took " + (System.currentTimeMillis() - start) + " ms"));
            if (featureCollection.size() > this.getMaxFeatureCount()) {
                throw new FeatureFactory.TooManyFeaturesException("FRW[" + workerThread + "]: feature in feature document " + featureCollection.size() + " exceeds max feature count " + this.getMaxFeatureCount());
            }
            if (featureCollection.size() == 0) {
                this.logger.warn((Object)("FRW[" + workerThread + "]: no features found after parsing"));
                return null;
            }
            Feature[] featureArray = featureCollection.toArray();
            featureCollection = null;
            System.gc();
            features = this.processFeatureCollection(workerThread, featureArray, true);
        }
        catch (Exception t) {
            this.logger.error((Object)("FRW[" + workerThread + "]: error parsing features: " + t.getMessage()), (Throwable)t);
            throw t;
        }
        if (this.checkCancelled(workerThread, " saving LastCreatedFeatures ")) {
            return null;
        }
        if (saveAsLastCreated) {
            this.updateLastCreatedFeatures(features, boundingBox.getGeometry(this.featureSrid), query);
        }
        return features;
    }

    private String checkForCharset(String data) {
        int index = data.indexOf(ENCODING_STRING);
        if (index == -1) {
            index = data.indexOf(ALTERNATE_ENCODING_STRING);
        }
        if (index != -1) {
            String subdata = data.substring(index + ENCODING_STRING.length());
            if ((index = subdata.indexOf("'")) == -1) {
                index = subdata.indexOf("\"");
            }
            if (index != -1) {
                try {
                    String charsetName = subdata.substring(0, index);
                    Charset.forName(charsetName);
                    return charsetName;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Vector createAttributes(SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, UnsupportedOperationException, Exception {
        throw new UnsupportedOperationException("LIW[" + workerThread + "]: WFSFeatureFactory does not support Attributes");
    }

    @Override
    protected void initialiseFeature(WFSFeature featureServiceFeature, Feature degreeFeature, boolean evaluateExpressions, int index) throws Exception {
        FeatureProperty[] featureProperties;
        featureServiceFeature.setLayerProperties(this.getLayerProperties());
        if (featureServiceFeature.getGeometry() == null) {
            try {
                com.vividsolutions.jts.geom.Geometry geom = JTSAdapter.export((Geometry)degreeFeature.getGeometryPropertyValues()[this.geometryIndex]);
                if (this.reverseAxisOrder) {
                    geom = GeometryUtils.reverseGeometryCoordinates(geom);
                }
                featureServiceFeature.setGeometry(geom);
            }
            catch (Exception e) {
                com.vividsolutions.jts.geom.Geometry geom = JTSAdapter.export((Geometry)degreeFeature.getGeometryPropertyValues()[this.geometryIndex]);
                if (this.reverseAxisOrder) {
                    geom = GeometryUtils.reverseGeometryCoordinates(geom);
                }
                featureServiceFeature.setGeometry(geom);
            }
        }
        if (featureServiceFeature.getGeometry() != null && this.featureSrid != null) {
            featureServiceFeature.getGeometry().setSRID(this.featureSrid.intValue());
        }
        for (FeatureProperty fp : featureProperties = degreeFeature.getProperties()) {
            if (featureServiceFeature.getProperty(fp.getName().getAsString()) != null) continue;
            featureServiceFeature.addProperty(fp.getName().getAsString(), fp.getValue());
        }
        if (evaluateExpressions) {
            this.evaluateExpressions(featureServiceFeature, index);
        }
        if (featureServiceFeature.getId() == -1) {
            try {
                featureServiceFeature.setId(Integer.parseInt(featureServiceFeature.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void cleanup(InputStreamReader reader, PostMethod httppost) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            reader = null;
        }
        if (httppost != null) {
            httppost.releaseConnection();
            httppost = null;
        }
    }

    @Override
    protected WFSFeature createFeatureInstance(Feature degreeFeature, int index) throws Exception {
        WFSFeature f = new WFSFeature();
        String name = null;
        if (this.layerProperties != null && this.layerProperties.getFeatureService() != null) {
            name = this.layerProperties.getFeatureService().getName();
        }
        if (name == null && this.featureType != null && this.featureType.getName() != null) {
            name = WFSFeatureFactory.convertFeatureQnameToName(this.featureType.getName());
        }
        f.setSLDStyles(this.getStyle(name));
        return f;
    }

    public static String convertFeatureQnameToName(QName qname) {
        if (qname.getPrefix() == null || qname.getPrefix().equals("")) {
            return qname.getLocalPart();
        }
        return qname.getPrefix() + ":" + qname.getLocalPart();
    }

    @Override
    protected boolean isGenerateIds() {
        return false;
    }

    @Override
    public WFSFeatureFactory clone() {
        return new WFSFeatureFactory(this);
    }

    public Crs getCrs() {
        return this.crs;
    }

    public void setCrs(Crs crs) {
        this.crs = crs;
    }

    @Override
    public int getFeatureCount(String query, BoundingBox bb) {
        XBoundingBox bbox = new XBoundingBox(bb.getX1(), bb.getY1(), bb.getX2(), bb.getY2(), this.getCrs().getCode(), this.getCrs().isMetric());
        WFSFacade facade = this.featureType.getWFSCapabilities().getServiceFacade();
        Element queryElement = facade.getGetFeatureQuery(this.featureType);
        String wfsQuery = query;
        if (wfsQuery == null) {
            wfsQuery = FeatureServiceUtilities.elementToString(queryElement);
        }
        String postString = facade.setGetFeatureBoundingBox(wfsQuery, bbox, this.featureType, this.getCrs().getCode(), this.reverseAxisOrder, true);
        this.featureSrid = CrsTransformer.extractSridFromCrs(WFSFacade.getOptimalCrsForFeature(this.featureType, this.getCrs().getCode()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Host name: " + this.hostname + "\nWFS Query: \n" + postString));
        }
        long start = System.currentTimeMillis();
        try {
            String tmp;
            InputStream respIs = WebAccessManager.getInstance().doRequest(new URL(this.hostname), postString, AccessHandler.ACCESS_METHODS.POST_REQUEST);
            this.logger.info((Object)("WFS request took " + (System.currentTimeMillis() - start) + " ms"));
            InputStreamReader reader = new InputStreamReader(new BufferedInputStream(respIs));
            GMLFeatureCollectionDocument featureCollectionDocument = new GMLFeatureCollectionDocument();
            String res = "";
            BufferedReader br = new BufferedReader(reader);
            while ((tmp = br.readLine()) != null) {
                res = res + tmp;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("wfs response: " + res));
            }
            StringReader re = new StringReader(res);
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fac.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(res.getBytes("UTF-8")));
            String numberOfFeatures = doc.getDocumentElement().getAttribute("numberOfFeatures");
            return Integer.parseInt(numberOfFeatures);
        }
        catch (Exception t) {
            this.logger.error((Object)("error parsing features: " + t.getMessage()), (Throwable)t);
            return 0;
        }
    }

    @Override
    public List<WFSFeature> createFeatures(String query, BoundingBox boundingBox, SwingWorker workerThread, int offset, int limit, FeatureServiceAttribute[] orderBy) throws FeatureFactory.TooManyFeaturesException, Exception {
        return this.createFeatures_internal(query, boundingBox, workerThread, false);
    }
}

