/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.style;

import de.cismet.cismap.commons.featureservice.style.Style;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.tools.gui.PointSymbolCreator;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class StylePreviewPanel
extends JPanel {
    private static final String SAMPLE_TEXT = NbBundle.getMessage(StylePreviewPanel.class, (String)"StylePreviewPanel.SAMPLE_TEXT");
    private final Logger log = Logger.getLogger(this.getClass());
    private Style style;
    private Color lineColor;
    private Color fillColor;
    private Image pointSymbol = null;

    public StylePreviewPanel() {
        this.initComponents();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Create StylePreviewPanel");
        }
    }

    public void update(Style style, FeatureAnnotationSymbol pointSymbol) {
        this.style = style;
        this.fillColor = style.isDrawFill() ? style.getFillColor() : null;
        this.lineColor = style.isDrawLine() ? style.getLineColor() : null;
        this.pointSymbol = pointSymbol == null ? this.createPointSymbol() : pointSymbol.getImage();
        this.repaint();
    }

    public Image getPointSymbol() {
        return this.pointSymbol;
    }

    private BufferedImage createPointSymbol() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("createPointSymbol: PointSymbolSize=" + this.style.getPointSymbolSize() + ", LineWidth=" + this.style.getLineWidth()));
        }
        return PointSymbolCreator.createPointSymbol((boolean)this.style.isDrawLine(), (boolean)this.style.isDrawFill(), (int)(this.style.getPointSymbolSize() > 5 ? this.style.getPointSymbolSize() : 5), (int)this.style.getLineWidth(), (Color)this.fillColor, (Color)this.lineColor);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setComposite(AlphaComposite.getInstance(10, this.style.getAlpha()));
        int[] pointsX = new int[]{10, this.getWidth() - 50, this.getWidth() - 10, 40};
        int[] pointsY = new int[]{this.getHeight() / 3, 10, this.getHeight() / 2, this.getHeight() - 20};
        if (this.style.isDrawFill()) {
            g2d.setColor(this.fillColor);
            g2d.fillPolygon(pointsX, pointsY, 4);
        }
        if (this.style.isDrawLine()) {
            g2d.setColor(this.lineColor);
            g2d.setStroke(new BasicStroke(this.style.getLineWidth(), 1, 1));
            g2d.drawPolygon(pointsX, pointsY, 4);
        }
        if (this.style.isDrawLabel()) {
            g2d.setColor(this.style.getFontColor());
            g2d.setFont(this.style.getFont());
            g2d.drawString(SAMPLE_TEXT, this.getWidth() / 3, this.getHeight() / 2);
        }
        g2d.drawImage(this.pointSymbol, this.getWidth() - this.pointSymbol.getWidth(null) / 2 - 40, this.getHeight() - this.pointSymbol.getWidth(null) / 2 - 20, null);
        g2d.dispose();
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setMinimumSize(new Dimension(50, 50));
        this.setLayout(new BorderLayout());
    }
}

