/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureNameProvider;
import de.cismet.cismap.commons.gui.FeatureGroupMember;

public class FeatureGroupWrapper
implements FeatureGroupMember {
    private final String groupName;
    private final String groupId;
    private final Feature feature;

    public FeatureGroupWrapper(Feature feature, String groupId, String groupName) {
        if (feature == null) {
            throw new NullPointerException("Given feature must not be null");
        }
        if (groupId == null) {
            throw new NullPointerException("Given groupId must not be null");
        }
        if (groupName == null) {
            throw new NullPointerException("Given groupName must not be null");
        }
        this.feature = feature;
        this.groupId = groupId;
        this.groupName = groupName;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getName() {
        String subName = this.getFeature() != null ? (this.getFeature() instanceof FeatureNameProvider ? ((FeatureNameProvider)((Object)this.getFeature())).getName() : this.getFeature().toString()) : null;
        return this.getGroupName() + (subName != null && !subName.isEmpty() ? " | " + subName : "");
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public Geometry getGeometry() {
        return this.feature.getGeometry();
    }

    @Override
    public void setGeometry(Geometry geom) {
        this.feature.setGeometry(geom);
    }

    @Override
    public boolean canBeSelected() {
        return this.feature.canBeSelected();
    }

    @Override
    public void setCanBeSelected(boolean canBeSelected) {
        this.feature.setCanBeSelected(canBeSelected);
    }

    @Override
    public boolean isEditable() {
        return this.feature.isEditable();
    }

    @Override
    public void setEditable(boolean editable) {
        this.feature.setEditable(editable);
    }

    @Override
    public boolean isHidden() {
        return this.feature.isHidden();
    }

    @Override
    public void hide(boolean hiding) {
        this.feature.hide(hiding);
    }

    @Override
    public Feature getFeature() {
        return this.feature;
    }
}

