/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui;

import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MessenGeometryListener;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.commons.security.AccessHandler;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.security.WebAccessManager;
import edu.umd.cs.piccolo.event.PInputEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.httpclient.Header;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RasterfariDocumentLoaderPanel
extends JPanel
implements ConnectionContextProvider {
    private static final String MAP_TEMPLATE = "<rasterfari:url>?REQUEST=GetMap&SERVICE=WMS&SRS=EPSG:25832&BBOX=<cismap:boundingBox>&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&LAYERS=<rasterfari:document>&CUSTOMSCALE=<rasterfari:scale>&CUSTOMOFFSETX=<rasterfari:offsetX>&CUSTOMOFFSETY=<rasterfari:offsetY>&TRANSPARENT=false&REBUILDCACHE=no";
    private static final String MAP_TEMPLATE_REBUILD_CACHE_IF_NEEDED = "<rasterfari:url>?REQUEST=GetMap&SERVICE=WMS&SRS=EPSG:25832&BBOX=<cismap:boundingBox>&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&LAYERS=<rasterfari:document>&CUSTOMSCALE=<rasterfari:scale>&CUSTOMOFFSETX=<rasterfari:offsetX>&CUSTOMOFFSETY=<rasterfari:offsetY>&TRANSPARENT=false";
    private static final String DOWNLOAD_TEMPLATE = "<rasterfari:url>?REQUEST=GetMap&SERVICE=WMS&customDocumentInfo=download&LAYERS=<rasterfari:document>";
    private static final String MY_MESSEN_MODE = "MY_MESSEN_MODE";
    private static final Logger LOG = Logger.getLogger(RasterfariDocumentLoaderPanel.class);
    private static final String SRS = "EPSG:25832";
    private static final Crs CRS = new Crs("EPSG:25832", "EPSG:25832", "EPSG:25832", true, true);
    private static final XBoundingBox INITIAL_BOUNDINGBOX = new XBoundingBox(-0.5, -0.5, 0.5, 0.5, "EPSG:25832", true);
    private static final int NO_SELECTION = -1;
    private static final ListModel MODEL_LOAD = new DefaultListModel(){
        {
            this.add(0, NbBundle.getMessage(RasterfariDocumentLoaderPanel.class, (String)"RasterfariDocumentLoaderPanel.lstPages.loading"));
        }
    };
    private static final ListModel FEHLER_MODEL = new DefaultListModel(){
        {
            this.add(0, NbBundle.getMessage(RasterfariDocumentLoaderPanel.class, (String)"RasterfariDocumentLoaderPanel.lstPages.loadingError"));
        }
    };
    private final String rasterfariUrl;
    private String currentDocument = "";
    private int currentPage = -1;
    private final ConnectionContext connectionContext;
    private final Listener listener;
    private double scale = 1.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private final Crs crs;
    private Geometry mainDocumentGeometry;
    private final MessenGeometryListener mapListener;
    private JButton btnHome;
    private JList lstPages;
    private MappingComponent map;
    private JPanel panCenter;
    private JScrollPane scpPages;
    private JToggleButton togPan;
    private JToggleButton togZoom;

    public RasterfariDocumentLoaderPanel() {
        this(null, null, INITIAL_BOUNDINGBOX, CRS, ConnectionContext.createDeprecated());
    }

    public RasterfariDocumentLoaderPanel(String rasterfariUrl, Listener listener, ConnectionContext connectionContext) {
        this(rasterfariUrl, listener, INITIAL_BOUNDINGBOX, CRS, connectionContext);
    }

    public RasterfariDocumentLoaderPanel(String rasterfariUrl, Listener listener, XBoundingBox initialBoundingBox, Crs crs, ConnectionContext connectionContext) {
        this.rasterfariUrl = rasterfariUrl;
        this.listener = listener;
        this.crs = crs;
        this.connectionContext = connectionContext;
        this.initComponents();
        this.mapListener = new MessenGeometryListener(this.map);
        this.mainDocumentGeometry = null;
        ActiveLayerModel mappingModel = new ActiveLayerModel();
        mappingModel.addHome(initialBoundingBox);
        mappingModel.setSrs(crs);
        mappingModel.setDefaultHomeSrs(crs);
        this.map.setAnimationDuration(0);
        this.map.setReadOnly(false);
        this.map.setMappingModel(mappingModel);
        this.map.gotoInitialBoundingBox();
        this.map.setInteractionMode("PAN");
        this.map.addInputListener(MY_MESSEN_MODE, this.mapListener);
        this.map.unlock();
    }

    public MessenGeometryListener getMessenInputListener() {
        return this.mapListener;
    }

    public void dispose() {
        if (this.map != null) {
            this.map.removeInputEventListener((PInputEventListener)this.mapListener);
            this.map.dispose();
        }
        ((DefaultListModel)FEHLER_MODEL).removeAllElements();
        ((DefaultListModel)MODEL_LOAD).removeAllElements();
    }

    public JToggleButton getTogPan() {
        return this.togPan;
    }

    public JToggleButton getTogZoom() {
        return this.togZoom;
    }

    public JButton getBtnHome() {
        return this.btnHome;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void actionOverview() {
        this.showFullDocument();
    }

    public Geometry getMainDocumentGeometry() {
        return this.mainDocumentGeometry;
    }

    public void setMainDocumentGeometry(Geometry mainDocumentGeometry) {
        this.mainDocumentGeometry = mainDocumentGeometry;
    }

    public void actionMeasurePolygon() {
        this.mapListener.setMode("POLYGON");
        this.map.setInteractionMode(MY_MESSEN_MODE);
        this.map.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void actionMeasureLine() {
        this.mapListener.setMode("LINESTRING");
        this.map.setInteractionMode(MY_MESSEN_MODE);
        this.map.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void actionPan() {
        this.map.setInteractionMode("PAN");
    }

    public void actionZoom() {
        this.map.setInteractionMode("ZOOM");
    }

    public double calculateScaleFactor(double realDistance) {
        for (Feature f : this.map.getFeatureCollection().getAllFeatures()) {
            double virtualDistance;
            if (!(f instanceof PureNewFeature) || (virtualDistance = f.getGeometry().getLength()) == 0.0) continue;
            return realDistance / virtualDistance;
        }
        return 0.0;
    }

    public void removeAllFeatures() {
        if (this.map != null) {
            FeatureCollection fc = this.map.getFeatureCollection();
            if (fc instanceof DefaultFeatureCollection) {
                ((DefaultFeatureCollection)fc).clear();
            } else {
                fc.removeAllFeatures();
            }
        }
    }

    public void showFullDocument() {
        Geometry geometry = this.mainDocumentGeometry != null ? this.mainDocumentGeometry : this.getMap().getInitialBoundingBox().getGeometry(CrsTransformer.extractSridFromCrs(this.getMap().getMappingModel().getSrs().getCode()));
        this.getMap().gotoBoundingBoxWithHistory(new XBoundingBox(geometry.buffer(this.scale / 10.0)));
    }

    public double getScale() {
        return this.scale;
    }

    public MappingComponent getMap() {
        return this.map;
    }

    public FeatureCollection getFeatureCollection() {
        return this.map.getFeatureCollection();
    }

    private void initComponents() {
        this.scpPages = new JScrollPane();
        this.lstPages = new JList();
        this.togPan = new JToggleButton();
        this.togZoom = new JToggleButton();
        this.btnHome = new JButton();
        this.panCenter = new JPanel();
        this.map = new MappingComponent();
        this.scpPages.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.scpPages.setMinimumSize(new Dimension(31, 75));
        this.scpPages.setOpaque(false);
        this.scpPages.setPreferredSize(new Dimension(85, 75));
        this.lstPages.setSelectionMode(0);
        this.lstPages.setFixedCellWidth(75);
        this.lstPages.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RasterfariDocumentLoaderPanel.this.lstPagesValueChanged(evt);
            }
        });
        this.scpPages.setViewportView(this.lstPages);
        this.togPan.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/pan.gif")));
        this.togPan.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.togPan, (String)NbBundle.getMessage(RasterfariDocumentLoaderPanel.class, (String)"RasterfariDocumentLoaderPanel.togPan.text"));
        this.togPan.setToolTipText(NbBundle.getMessage(RasterfariDocumentLoaderPanel.class, (String)"RasterfariDocumentLoaderPanel.togPan.toolTipText"));
        this.togPan.setFocusPainted(false);
        this.togPan.setHorizontalAlignment(2);
        this.togPan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterfariDocumentLoaderPanel.this.togPanActionPerformed(evt);
            }
        });
        this.togZoom.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/zoom.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.togZoom, (String)NbBundle.getMessage(RasterfariDocumentLoaderPanel.class, (String)"RasterfariDocumentLoaderPanel.togZoom.text"));
        this.togZoom.setToolTipText(NbBundle.getMessage(RasterfariDocumentLoaderPanel.class, (String)"RasterfariDocumentLoaderPanel.togZoom.toolTipText"));
        this.togZoom.setFocusPainted(false);
        this.togZoom.setHorizontalAlignment(2);
        this.togZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterfariDocumentLoaderPanel.this.togZoomActionPerformed(evt);
            }
        });
        this.btnHome.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/home.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnHome, (String)NbBundle.getMessage(RasterfariDocumentLoaderPanel.class, (String)"RasterfariDocumentLoaderPanel.btnHome.text"));
        this.btnHome.setToolTipText(NbBundle.getMessage(RasterfariDocumentLoaderPanel.class, (String)"RasterfariDocumentLoaderPanel.btnHome.toolTipText"));
        this.btnHome.setFocusPainted(false);
        this.btnHome.setHorizontalAlignment(2);
        this.btnHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterfariDocumentLoaderPanel.this.btnHomeActionPerformed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.panCenter.setOpaque(false);
        this.panCenter.setLayout(new BorderLayout());
        this.map.setBorder(BorderFactory.createEtchedBorder());
        this.panCenter.add((Component)((Object)this.map), "Center");
        this.add((Component)this.panCenter, "Center");
    }

    private void lstPagesValueChanged(ListSelectionEvent evt) {
        Object page;
        if (!evt.getValueIsAdjusting() && (page = this.lstPages.getSelectedValue()) instanceof Integer) {
            this.loadPage((Integer)page - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPage(int page) {
        this.currentPage = page;
        this.reset();
        this.listener.showMeasureIsLoading();
        try {
            MappingModel mm = this.map.getMappingModel();
            String template = MAP_TEMPLATE.replace("<rasterfari:url>", this.rasterfariUrl).replace("<rasterfari:scale>", Double.toString(this.scale)).replace("<rasterfari:offsetX>", Double.toString(this.offsetX)).replace("<rasterfari:offsetY>", Double.toString(this.offsetY)).replace("<rasterfari:document>", this.currentDocument + (this.lstPages.getModel().getSize() > 1 ? URLEncoder.encode("[" + this.currentPage + "]", "UTF-8") : ""));
            mm.addLayer(new SimpleWMS(new SimpleWmsGetMapUrl(template), 0, true, false, "prefetching_Lageplan"));
            mm.addLayer(new SimpleWMS(new SimpleWmsGetMapUrl(template), 1, true, false, "Lageplan"));
            this.togPan.setSelected(true);
            this.showFullDocument();
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        finally {
            this.listener.showMeasurePanel();
        }
    }

    public void calibrate(double distance) {
        double scalefactor = this.calculateScaleFactor(distance);
        this.doScale(scalefactor);
        this.loadPage(this.currentPage);
    }

    private void doScale(double scalefactor) {
        this.setScale(this.scale * scalefactor);
        Geometry documentGeom = (Geometry)this.getMainDocumentGeometry().clone();
        Point oldCentroid = documentGeom.getCentroid();
        documentGeom.apply((CoordinateSequenceFilter)AffineTransformation.scaleInstance((double)scalefactor, (double)scalefactor));
        Point newCentroid = documentGeom.getCentroid();
        documentGeom.apply((CoordinateSequenceFilter)AffineTransformation.translationInstance((double)(oldCentroid.getX() - newCentroid.getX()), (double)(oldCentroid.getY() - newCentroid.getY())));
        this.setMainDocumentGeometry(documentGeom);
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    public void setScaleAndOffsets(double scale, double offsetX, double offsetY) {
        this.setScale(scale);
        this.setOffsetX(offsetX);
        this.setOffsetY(offsetY);
    }

    public void reload() {
        this.loadPage(this.currentPage);
    }

    public URL getDocumentUrl() {
        return this.getDocumentUrl(this.currentDocument);
    }

    public URL getDocumentUrl(String document) {
        try {
            return new URL(DOWNLOAD_TEMPLATE.replace("<rasterfari:url>", this.rasterfariUrl).replace("<rasterfari:document>", document));
        }
        catch (MalformedURLException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    private void togPanActionPerformed(ActionEvent evt) {
        this.actionPan();
    }

    private void togZoomActionPerformed(ActionEvent evt) {
        this.actionZoom();
    }

    private void btnHomeActionPerformed(ActionEvent evt) {
        this.showFullDocument();
    }

    public JList getLstPages() {
        return this.lstPages;
    }

    public String getCurrentDocument() {
        return this.currentDocument;
    }

    public void setDocument(String document) {
        this.currentDocument = document;
        this.lstPages.setModel(MODEL_LOAD);
        this.listener.showMeasureIsLoading();
        new SwingWorker<Integer, Void>(){

            @Override
            protected Integer doInBackground() throws Exception {
                String template = RasterfariDocumentLoaderPanel.MAP_TEMPLATE_REBUILD_CACHE_IF_NEEDED.replace("<rasterfari:url>", RasterfariDocumentLoaderPanel.this.rasterfariUrl).replace("<cismap:boundingBox>", "-0.5,-0.5,0.5,0.5").replace("<cismap:width>", "10").replace("<cismap:height>", "10").replace("<rasterfari:document>", RasterfariDocumentLoaderPanel.this.currentDocument).replace("<rasterfari:scale>", Double.toString(1.0)).replace("<rasterfari:offsetX>", Double.toString(0.0)).replace("<rasterfari:offsetY>", Double.toString(0.0));
                URL url = new URL(template);
                InputStream is = WebAccessManager.getInstance().doRequest(url, (Reader)new StringReader(""), AccessHandler.ACCESS_METHODS.HEAD_REQUEST);
                try (ObjectInputStream ois = new ObjectInputStream(is);){
                    Header[] headers;
                    Object object = ois.readObject();
                    for (Header header : headers = (Header[])object) {
                        if (!"X-Rasterfari-numOfPages".equals(header.getName())) continue;
                        Integer n = Integer.parseInt(header.getValue());
                        return n;
                    }
                }
                return -1;
            }

            @Override
            protected void done() {
                try {
                    Integer pages = (Integer)this.get();
                    DefaultListModel<Integer> dlm = new DefaultListModel<Integer>();
                    for (int i = 0; i < pages; ++i) {
                        dlm.addElement(i + 1);
                    }
                    RasterfariDocumentLoaderPanel.this.lstPages.setModel(dlm);
                    RasterfariDocumentLoaderPanel.this.lstPages.setEnabled(true);
                    RasterfariDocumentLoaderPanel.this.lstPages.setSelectedIndex(0);
                }
                catch (Exception ex) {
                    RasterfariDocumentLoaderPanel.this.lstPages.setModel(FEHLER_MODEL);
                    LOG.error((Object)ex, (Throwable)ex);
                    RasterfariDocumentLoaderPanel.this.setCurrentPageNull();
                }
            }
        }.execute();
    }

    public void setCurrentPageNull() {
        this.currentPage = -1;
        this.lstPages.setEnabled(false);
        this.reset();
    }

    public void reset() {
        this.removeAllFeatures();
        this.getMap().setInteractionMode("PAN");
        MappingModel mm = this.getMap().getMappingModel();
        for (RetrievalServiceLayer rsl : mm.getRasterServices().values()) {
            mm.removeLayer(rsl);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static interface Listener {
        public void showMeasureIsLoading();

        public void showMeasurePanel();
    }
}

