/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.attributetable;

import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class AttributeTableFactory {
    private static final Logger LOG = Logger.getLogger(AttributeTableFactory.class);
    private MappingComponent mappingComponent;
    private AttributeTableListener listener = null;

    private AttributeTableFactory() {
    }

    public static AttributeTableFactory getInstance() {
        return LazyInitializer.INSTANCE;
    }

    public void showAttributeTable(AbstractFeatureService featureService) {
        try {
            AttributeTable table = new AttributeTable(featureService);
            table.setMappingComponent(this.mappingComponent);
            this.listener.showAttributeTable(table, AttributeTableFactory.createId(featureService), NbBundle.getMessage(AttributeTableFactory.class, (String)"AttributeTableFactory.showAttributeTable().name", (Object)featureService.getName()), featureService.getName());
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving all features", (Throwable)e);
        }
    }

    public void switchProcessingMode(AbstractFeatureService featureService) {
        this.listener.switchProcessingMode(featureService, AttributeTableFactory.createId(featureService));
    }

    public AttributeTable getAttributeTable(AbstractFeatureService featureService) {
        return this.listener.getAttributeTable(AttributeTableFactory.createId(featureService));
    }

    public void closeAttributeTable(AbstractFeatureService featureService) {
        this.listener.closeAttributeTable(featureService);
    }

    public void changeAttributeTableName(AbstractFeatureService featureService, String newName) {
        try {
            this.listener.changeName(AttributeTableFactory.createId(featureService), newName);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving all features", (Throwable)e);
        }
    }

    public void processingModeChanged(AbstractFeatureService featureService, boolean active) {
        try {
            this.listener.processingModeChanged(featureService, active);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving all features", (Throwable)e);
        }
    }

    public void setAttributeTableListener(AttributeTableListener listener) {
        this.listener = listener;
    }

    public MappingComponent getMappingComponent() {
        return this.mappingComponent;
    }

    public void setMappingComponent(MappingComponent mappingComponent) {
        this.mappingComponent = mappingComponent;
    }

    public static String createId(AbstractFeatureService service) {
        return "Attributtabelle " + service.getId();
    }

    private static final class LazyInitializer {
        private static final transient AttributeTableFactory INSTANCE = new AttributeTableFactory();

        private LazyInitializer() {
        }
    }
}

