/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.attributetable;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.math.geometry.StaticGeometryFunctions;
import java.lang.reflect.Constructor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.deegree.model.spatialschema.Geometry;
import org.deegree.model.spatialschema.GeometryException;
import org.deegree.model.spatialschema.JTSAdapter;
import org.jdesktop.swingx.JXTable;

public class SimpleAttributeTableModel
implements TableModel {
    private static final Logger LOG = Logger.getLogger(SimpleAttributeTableModel.class);
    protected String[] attributeAlias;
    protected String[] attributeNames;
    protected Map<String, FeatureServiceAttribute> featureServiceAttributes;
    protected List<String> orderedFeatureServiceAttributes;
    protected List<FeatureServiceFeature> featureList;
    protected List<TableModelListener> listener = new ArrayList<TableModelListener>();
    protected AttributeTableRuleSet tableRuleSet;
    protected List<FeatureServiceFeature> removedFeatures = new ArrayList<FeatureServiceFeature>();

    public SimpleAttributeTableModel(List<String> orderedFeatureServiceAttributes, Map<String, FeatureServiceAttribute> featureServiceAttributes, List<FeatureServiceFeature> propertyContainer, AttributeTableRuleSet tableRuleSet) {
        this.featureServiceAttributes = featureServiceAttributes;
        this.orderedFeatureServiceAttributes = orderedFeatureServiceAttributes;
        this.featureList = propertyContainer;
        this.tableRuleSet = tableRuleSet;
        this.fillHeaderArrays();
    }

    public void addFeature(FeatureServiceFeature feature) {
        this.featureList.add(feature);
        this.fireContentsChanged();
    }

    public void addFeatures(List<FeatureServiceFeature> features) {
        this.featureList.addAll(features);
        this.fireContentsChanged();
    }

    private void fillHeaderArrays() {
        int index = 0;
        this.attributeNames = new String[this.attributeCount()];
        this.attributeAlias = new String[this.attributeCount()];
        if (this.orderedFeatureServiceAttributes != null) {
            for (String attributeName : this.orderedFeatureServiceAttributes) {
                String alias;
                FeatureServiceAttribute fsa = this.featureServiceAttributes.get(attributeName);
                if (fsa != null && !fsa.isVisible()) continue;
                this.attributeNames[index] = attributeName;
                String aliasName = attributeName;
                if (fsa != null && !fsa.getAlias().equals("") && (alias = fsa.getAlias()) != null) {
                    aliasName = alias;
                }
                if (aliasName.startsWith("app:")) {
                    this.attributeAlias[index++] = aliasName.substring(4);
                    continue;
                }
                this.attributeAlias[index++] = aliasName;
            }
        }
        this.fireTableStructureChanged(new TableModelEvent(this, -1));
        this.fireContentsChanged();
    }

    private int attributeCount() {
        int count = 0;
        if (this.orderedFeatureServiceAttributes != null) {
            for (String key : this.orderedFeatureServiceAttributes) {
                FeatureServiceAttribute fsa = this.featureServiceAttributes.get(key);
                if (!fsa.isVisible()) continue;
                ++count;
            }
        }
        return count;
    }

    public void setNewFeatureList(List<FeatureServiceFeature> propertyContainer) {
        this.featureList = propertyContainer;
        this.fireContentsChanged();
    }

    @Override
    public int getRowCount() {
        if (this.featureList == null) {
            return 0;
        }
        return this.featureList.size();
    }

    @Override
    public int getColumnCount() {
        if (this.attributeAlias == null) {
            return 0;
        }
        return this.attributeAlias.length;
    }

    public void moveRowUp(int index) {
        FeatureServiceFeature propToMove = this.featureList.get(index);
        for (int i = index; i > 0; --i) {
            this.featureList.set(i, this.featureList.get(i - 1));
        }
        this.featureList.set(0, propToMove);
        this.fireContentsChanged();
    }

    public void moveRowUp(FeatureServiceFeature[] propToMove) {
        for (int i = propToMove.length - 1; i >= 0; --i) {
            this.featureList.remove(propToMove[i]);
            this.featureList.add(0, propToMove[i]);
        }
        this.fireContentsChanged();
    }

    public void moveRowUp(int index, boolean fireEvent) {
        this.featureList.add(0, this.featureList.remove(index));
        if (fireEvent) {
            this.fireContentsChanged();
        }
    }

    public com.vividsolutions.jts.geom.Geometry getGeometryFromRow(int row) {
        return this.featureList.get(row).getGeometry();
    }

    public boolean isNumeric(int col) {
        String key = this.attributeNames[col];
        FeatureServiceAttribute attr = this.featureServiceAttributes.get(key);
        return attr != null && (attr.getType().equals(String.valueOf(4)) || attr.getType().equals(String.valueOf(-5)) || attr.getType().equals(String.valueOf(5)) || attr.getType().equals(String.valueOf(-6)) || attr.getType().equals(String.valueOf(2)) || attr.getType().equals(String.valueOf(8)) || attr.getType().equals(String.valueOf(6)) || attr.getType().equals(String.valueOf(3)) || attr.getType().equals("xsd:float") || attr.getType().equals("xsd:decimal") || attr.getType().equals("xsd:double") || attr.getType().equals("xsd:integer"));
    }

    public FeatureServiceFeature getFeatureServiceFeature(int row) {
        return this.featureList.get(row);
    }

    public FeatureServiceFeature getFeatureServiceFeatureById(int id) {
        if (id > 0) {
            for (FeatureServiceFeature feature : new ArrayList<FeatureServiceFeature>(this.featureList)) {
                if (feature.getId() != id) continue;
                return feature;
            }
        }
        return null;
    }

    public int getRowByFeature(FeatureServiceFeature feature) {
        return this.featureList.indexOf(feature);
    }

    public void removeFeatureServiceFeature(FeatureServiceFeature feature) {
        this.featureList.remove(feature);
        this.fireContentsChanged();
    }

    public List<FeatureServiceFeature> getFeatureServiceFeatures() {
        return this.featureList;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.attributeAlias[columnIndex];
    }

    public String getColumnNameByAttributeName(String name) {
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (!this.attributeNames[i].equals(name)) continue;
            return this.attributeAlias[i];
        }
        return null;
    }

    public String getColumnAttributeName(int columnIndex) {
        return this.attributeNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        String key = this.attributeNames[columnIndex];
        FeatureServiceAttribute attr = this.featureServiceAttributes.get(key);
        return FeatureTools.getClass(attr);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = this.featureList.get(rowIndex).getProperty(this.attributeNames[columnIndex]);
        if (value instanceof com.vividsolutions.jts.geom.Geometry) {
            return ((com.vividsolutions.jts.geom.Geometry)value).getGeometryType();
        }
        if (value instanceof Geometry) {
            Geometry geom = (Geometry)value;
            try {
                if (!this.featureList.get(rowIndex).getLayerProperties().getFeatureService().getGeometryType().startsWith("Multi")) return JTSAdapter.export((Geometry)geom).getGeometryType();
                com.vividsolutions.jts.geom.Geometry geometry = JTSAdapter.export((Geometry)geom);
                if (geometry == null) return value;
                return StaticGeometryFunctions.toMultiGeometry((com.vividsolutions.jts.geom.Geometry)geometry).getGeometryType();
            }
            catch (GeometryException e) {
                LOG.error((Object)"Error while transforming deegree geometry to jts geometry.", (Throwable)e);
            }
            return value;
        } else {
            if (value == null) return value;
            if (value.getClass().isAssignableFrom(this.getColumnClass(columnIndex))) return value;
            Class<?> colClass = this.getColumnClass(columnIndex);
            String valAsString = value.toString();
            if (valAsString.getClass().isInstance(colClass)) {
                return valAsString;
            }
            if (Number.class.isAssignableFrom(colClass)) {
                try {
                    Constructor<?> numberConstructor = colClass.getConstructor(String.class);
                    return numberConstructor.newInstance(valAsString);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) return value;
                    LOG.debug((Object)"Cannot cast ", (Throwable)e);
                    return value;
                }
            } else {
                if (!colClass.getClass().isAssignableFrom(Date.class)) return value;
                if (!(value instanceof Timestamp)) return value;
                return new Date(((Timestamp)value).getTime());
            }
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listener.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listener.remove(l);
    }

    public void hideColumn(int col) {
        this.attributeNames = this.remove(this.attributeNames, col);
        this.attributeAlias = this.remove(this.attributeAlias, col);
        this.fireTableStructureChanged(new TableModelEvent(this, -1));
    }

    public void showColumns() {
        this.fillHeaderArrays();
        this.fireTableStructureChanged(new TableModelEvent(this, -1));
    }

    public void setColumnName(int col, String name) {
        if (col >= 0 && col < this.attributeAlias.length) {
            this.attributeAlias[col] = name;
            this.fireContentsChanged(new TableModelEvent(this, -1));
        }
    }

    public void addRemovedFeature(FeatureServiceFeature feature) {
        this.removedFeatures.add(feature);
    }

    public List<FeatureServiceFeature> getRemovedFeature() {
        return this.removedFeatures;
    }

    public void clearRemovedFeatures() {
        this.removedFeatures.clear();
    }

    private String[] remove(String[] array, int index) {
        if (index >= 0 && index < array.length) {
            String[] resultArray = new String[array.length - 1];
            int indexResArray = 0;
            for (int i = 0; i < array.length; ++i) {
                if (i == index) continue;
                resultArray[indexResArray++] = array[i];
            }
            return resultArray;
        }
        return array;
    }

    protected void fireContentsChanged() {
        TableModelEvent e = new TableModelEvent(this);
        for (TableModelListener tmp : this.listener) {
            tmp.tableChanged(e);
        }
    }

    protected void fireContentsChanged(TableModelEvent e) {
        for (TableModelListener tmp : this.listener) {
            tmp.tableChanged(e);
        }
    }

    protected void fireTableStructureChanged(TableModelEvent e) {
        for (TableModelListener tmp : this.listener) {
            if (!(tmp instanceof JXTable)) continue;
            tmp.tableChanged(e);
        }
    }
}

