/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.attributetable.creator;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedEvent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedListener;
import de.cismet.cismap.commons.gui.attributetable.creator.AbstractFeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.CreaterGeometryListener;
import de.cismet.cismap.commons.gui.attributetable.creator.GeometryFinishedListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateNewGeometryListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.math.geometry.StaticGeometryFunctions;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import edu.umd.cs.piccolo.PNode;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class PrimitiveGeometryCreator
extends AbstractFeatureCreator {
    private static final Logger LOG = Logger.getLogger(PrimitiveGeometryCreator.class);
    protected List<FeatureCreatedListener> listener = new ArrayList<FeatureCreatedListener>();
    private final String mode;
    private boolean multi;
    private CreaterGeometryListener geometryListener = null;
    private AbstractFeatureService service = null;
    private PNode tmpFeature;
    private MappingComponent mc = null;
    private boolean activateResume = false;
    private double minArea;
    private double minLength;

    public PrimitiveGeometryCreator(String mode) {
        this(mode, null);
    }

    public PrimitiveGeometryCreator(String mode, Map<String, Object> properties) {
        this(mode, properties, false);
    }

    public PrimitiveGeometryCreator(String mode, boolean multi) {
        this(mode, null, multi);
    }

    public PrimitiveGeometryCreator(String mode, Map<String, Object> properties, boolean multi) {
        this.mode = mode;
        this.properties = properties;
        this.multi = multi;
    }

    public double getMinArea() {
        return this.minArea;
    }

    public void setMinArea(double minArea) {
        this.minArea = minArea;
    }

    public double getMinLength() {
        return this.minLength;
    }

    public void setMinLength(double minLength) {
        this.minLength = minLength;
    }

    @Override
    public void createFeature(final MappingComponent mc, final FeatureServiceFeature feature) {
        this.mc = mc;
        if (feature != null && feature.getLayerProperties() != null) {
            this.service = feature.getLayerProperties().getFeatureService();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String oldInteractionMode = mc.getInteractionMode();
                CreaterGeometryListener listener = new CreaterGeometryListener(mc, new GeometryFinishedListener(){

                    @Override
                    public void geometryFinished(final Geometry g) {
                        WaitingDialogThread wdt = new WaitingDialogThread(StaticSwingTools.getParentFrame((Component)((Object)mc)), true, "Erstelle Objekt", null, 1000){

                            protected Object doInBackground() throws Exception {
                                Geometry geom = g;
                                if (PrimitiveGeometryCreator.this.mode.equals("LINESTRING") && geom.getGeometryType().equals("Point")) {
                                    geom = g.getFactory().createLineString(new Coordinate[]{g.getCoordinate(), new Coordinate(g.getCoordinate().x + 1.0, g.getCoordinate().y + 1.0)});
                                }
                                geom = PrimitiveGeometryCreator.this.multi ? StaticGeometryFunctions.toMultiGeometry((Geometry)geom) : StaticGeometryFunctions.toSimpleGeometry((Geometry)geom);
                                if (PrimitiveGeometryCreator.this.minArea != 0.0 && PrimitiveGeometryCreator.this.mode.equals("POLYGON") && geom.getArea() < PrimitiveGeometryCreator.this.minArea) {
                                    JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(PrimitiveGeometryCreator.class, (String)"PrimitiveGeometryCreator.createFeature().tooSmall.message", (Object[])new Object[]{PrimitiveGeometryCreator.this.minArea}), NbBundle.getMessage(PrimitiveGeometryCreator.class, (String)"PrimitiveGeometryCreator.createFeature().tooSmall.title"), 2);
                                    return null;
                                }
                                if (PrimitiveGeometryCreator.this.minLength != 0.0 && PrimitiveGeometryCreator.this.mode.equals("LINESTRING") && geom.getLength() < PrimitiveGeometryCreator.this.minLength) {
                                    JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(PrimitiveGeometryCreator.class, (String)"PrimitiveGeometryCreator.createFeature().tooShort.message", (Object[])new Object[]{PrimitiveGeometryCreator.this.minLength}), NbBundle.getMessage(PrimitiveGeometryCreator.class, (String)"PrimitiveGeometryCreator.createFeature().tooShort.title"), 2);
                                    return null;
                                }
                                feature.setGeometry(geom);
                                if (feature instanceof DefaultFeatureServiceFeature) {
                                    try {
                                        AbstractFeatureCreator.fillFeatureWithDefaultValues((DefaultFeatureServiceFeature)feature, PrimitiveGeometryCreator.this.properties);
                                        ((DefaultFeatureServiceFeature)feature).saveChanges();
                                        AbstractFeatureCreator.fillFeatureWithDefaultValuesAfterSave((DefaultFeatureServiceFeature)feature, PrimitiveGeometryCreator.this.properties);
                                        for (FeatureCreatedListener featureCreatedListener : PrimitiveGeometryCreator.this.listener) {
                                            featureCreatedListener.featureCreated(new FeatureCreatedEvent(PrimitiveGeometryCreator.this, feature));
                                        }
                                    }
                                    catch (Exception e) {
                                        LOG.error((Object)"Cannot save new feature", (Throwable)e);
                                    }
                                }
                                return null;
                            }
                        };
                        wdt.start();
                    }
                });
                if (CismapBroker.getInstance() != null && CismapBroker.getInstance().getMappingComponent() != null) {
                    CreateNewGeometryListener result = (CreateNewGeometryListener)CismapBroker.getInstance().getMappingComponent().getInputListener("NEW_POLYGON");
                    listener.setShowCurrentLength(result.isShowCurrentLength());
                }
                PrimitiveGeometryCreator.this.geometryListener = listener;
                mc.addInputListener("SimpleGeometryCreater", listener);
                mc.putCursor("SimpleGeometryCreater", new Cursor(1));
                listener.setMode(PrimitiveGeometryCreator.this.mode);
                mc.setInteractionMode("SimpleGeometryCreater");
            }
        });
    }

    @Override
    public void addFeatureCreatedListener(FeatureCreatedListener listener) {
        this.listener.add(listener);
    }

    @Override
    public String getTypeName() {
        if (this.mode.equals("LINESTRING")) {
            return NbBundle.getMessage(PrimitiveGeometryCreator.class, (String)"PrimitiveGeometryCreator.getTypeName().linestring");
        }
        if (this.mode.equals("POLYGON")) {
            return NbBundle.getMessage(PrimitiveGeometryCreator.class, (String)"PrimitiveGeometryCreator.getTypeName().polygon");
        }
        if (this.mode.equals("POINT")) {
            return NbBundle.getMessage(PrimitiveGeometryCreator.class, (String)"PrimitiveGeometryCreator.getTypeName().point");
        }
        if (this.mode.equals("BOUNDING_BOX")) {
            return NbBundle.getMessage(PrimitiveGeometryCreator.class, (String)"PrimitiveGeometryCreator.getTypeName().rectangle");
        }
        if (this.mode.equals("ELLIPSE")) {
            return NbBundle.getMessage(PrimitiveGeometryCreator.class, (String)"PrimitiveGeometryCreator.getTypeName().ellipse");
        }
        return NbBundle.getMessage(PrimitiveGeometryCreator.class, (String)"PrimitiveGeometryCreator.getTypeName().other");
    }

    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void resume() {
        CismapBroker.getInstance().getMappingComponent().setInteractionMode("SimpleGeometryCreater");
        if (this.mc != null) {
            CreateNewGeometryListener result = (CreateNewGeometryListener)this.mc.getInputListener("NEW_POLYGON");
            if (this.geometryListener != null) {
                this.geometryListener.setShowCurrentLength(result.isShowCurrentLength());
            }
        }
    }

    @Override
    public AbstractFeatureService getService() {
        return this.service;
    }

    public String getMode() {
        return this.mode;
    }
}

