/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.featurecontrolwidget;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.FeatureGroups;
import de.cismet.cismap.commons.features.FeatureRenderer;
import de.cismet.cismap.commons.features.FeatureRendererAwareFeature;
import de.cismet.cismap.commons.features.SubFeature;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.featurecontrolwidget.CoordHider;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.MapBoundsListener;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.StaticDecimalTools;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.gui.GUIWindow;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class FeatureControl
extends JPanel
implements FeatureCollectionListener,
MapBoundsListener,
Configurable,
GUIWindow {
    private static final transient Logger LOG = Logger.getLogger(FeatureControl.class);
    boolean wizardMode = false;
    private FeatureCollectionFilter featureCollectionFilter;
    private ImageIcon icoGreenled = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/greenled.png"));
    private MappingComponent mappingComponent = null;
    private ListSelectionListener theListSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"invocation of the method SelectionListener.valueChanged from jxtFeatures");
                }
                FeatureControl.this.updateSelection();
            }
        }
    };
    private JButton cmdHold;
    private JButton cmdRemoveAll;
    private JButton cmdRemoveFeatures;
    private JButton cmdZoomToAllFeatures;
    private JButton cmdZoomToFeatures;
    private JScrollPane jScrollPane2;
    private JToolBar jToolBar1;
    private JXTable jxtFeatures;
    private JToggleButton togDisplayObjectInfo;
    private JToggleButton togFixMapExtent;
    private JToggleButton togFixMapScale;
    private JToggleButton togHoldAll;
    private JToggleButton togShowOnlyVisible;

    public FeatureControl() {
    }

    public FeatureControl(MappingComponent mappingComponent) {
        this.init(mappingComponent);
    }

    public void init(MappingComponent mappingComponent) {
        this.initComponents();
        this.mappingComponent = mappingComponent;
        FeatureCollectionTableModel model = new FeatureCollectionTableModel();
        this.jxtFeatures.setModel((TableModel)model);
        this.jxtFeatures.getColumnModel().getColumn(0).setCellRenderer(this.jxtFeatures.getDefaultRenderer(Icon.class));
        this.jxtFeatures.getColumnModel().getColumn(4).setCellRenderer(this.jxtFeatures.getDefaultRenderer(Number.class));
        this.jxtFeatures.getColumnModel().getColumn(5).setCellRenderer(this.jxtFeatures.getDefaultRenderer(Number.class));
        this.jxtFeatures.getColumnModel().getColumn(7).setCellRenderer(this.jxtFeatures.getDefaultRenderer(Icon.class));
        this.featureCollectionFilter = new FeatureCollectionFilter(false, model);
        ArrayList<RowFilter> usedFilters = new ArrayList<RowFilter>();
        SubFeatureFilter subFeatureFilter = new SubFeatureFilter();
        usedFilters.add(this.featureCollectionFilter);
        usedFilters.add(subFeatureFilter);
        TableRowSorter<FeatureCollectionTableModel> sorter = new TableRowSorter<FeatureCollectionTableModel>(model);
        sorter.setRowFilter(RowFilter.andFilter(usedFilters));
        this.jxtFeatures.setRowSorter(sorter);
        this.jxtFeatures.getSelectionModel().addListSelectionListener(this.theListSelectionListener);
        this.jxtFeatures.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    FeatureControl.this.updateSelection();
                }
            }
        });
    }

    private void updateSelection() {
        int[] rows = this.jxtFeatures.getSelectedRows();
        ArrayList tableSelection = TypeSafeCollections.newArrayList();
        for (int i = 0; i < rows.length; ++i) {
            int mappedRow = this.mapRowToModel(rows[i]);
            tableSelection.add(this.getFeatureCollection().getFeature(mappedRow));
        }
        this.mappingComponent.getFeatureCollection().removeFeatureCollectionListener(this);
        this.mappingComponent.getFeatureCollection().select(tableSelection);
        this.mappingComponent.getFeatureCollection().addFeatureCollectionListener(this);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.cmdZoomToAllFeatures = new JButton();
        this.cmdZoomToFeatures = new JButton();
        this.cmdRemoveFeatures = new JButton();
        this.cmdRemoveAll = new JButton();
        this.togShowOnlyVisible = new JToggleButton();
        this.togFixMapExtent = new JToggleButton();
        this.togFixMapScale = new JToggleButton();
        this.togDisplayObjectInfo = new JToggleButton();
        this.togHoldAll = new JToggleButton();
        this.cmdHold = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jxtFeatures = new JXTable();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.setLayout(new BorderLayout());
        this.jToolBar1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.cmdZoomToAllFeatures.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/zoomToAll.png")));
        this.cmdZoomToAllFeatures.setToolTipText(NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.cmdZoomToAllFeatures.toolTipText"));
        this.cmdZoomToAllFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureControl.this.cmdZoomToAllFeaturesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdZoomToAllFeatures);
        this.cmdZoomToFeatures.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/zoomToSelection.png")));
        this.cmdZoomToFeatures.setToolTipText(NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.cmdZoomToFeatures.toolTipText"));
        this.cmdZoomToFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureControl.this.cmdZoomToFeaturesActionPerformed(evt);
            }
        });
        this.cmdZoomToFeatures.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FeatureControl.this.cmdZoomToFeaturesMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                FeatureControl.this.cmdZoomToFeaturesMouseExited(evt);
            }
        });
        this.jToolBar1.add(this.cmdZoomToFeatures);
        this.cmdRemoveFeatures.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/removerow.png")));
        this.cmdRemoveFeatures.setToolTipText(NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.cmdRemoveFeatures.toolTipText"));
        this.cmdRemoveFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureControl.this.cmdRemoveFeaturesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdRemoveFeatures);
        this.cmdRemoveAll.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/removeAll.png")));
        this.cmdRemoveAll.setToolTipText(NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.cmdRemoveAll.toolTipText"));
        this.cmdRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureControl.this.cmdRemoveAllActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdRemoveAll);
        this.togShowOnlyVisible.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/showOnlyVisible_disabled.png")));
        this.togShowOnlyVisible.setToolTipText(NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.togShowOnlyVisible.toolTipText"));
        this.togShowOnlyVisible.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/showOnlyVisible_disabled.png")));
        this.togShowOnlyVisible.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/showOnlyVisible.png")));
        this.togShowOnlyVisible.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/showOnlyVisible.png")));
        this.togShowOnlyVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureControl.this.togShowOnlyVisibleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.togShowOnlyVisible);
        this.togFixMapExtent.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapExtent_disabled.png")));
        this.togFixMapExtent.setToolTipText(NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.togFixMapExtent.toolTipText"));
        this.togFixMapExtent.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapExtent_disabled.png")));
        this.togFixMapExtent.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapExtent.png")));
        this.togFixMapExtent.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapExtent.png")));
        this.togFixMapExtent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureControl.this.togFixMapExtentActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.togFixMapExtent);
        this.togFixMapScale.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapScale_disabled.png")));
        this.togFixMapScale.setToolTipText(NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.togFixMapScale.toolTipText"));
        this.togFixMapScale.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapScale_disabled.png")));
        this.togFixMapScale.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapScale.png")));
        this.togFixMapScale.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapScale.png")));
        this.togFixMapScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureControl.this.togFixMapScaleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.togFixMapScale);
        this.togDisplayObjectInfo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/infoLabel_disabled.png")));
        this.togDisplayObjectInfo.setToolTipText(NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.togDisplayObjectInfo.toolTipText"));
        this.togDisplayObjectInfo.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/infoLabel_disabled.png")));
        this.togDisplayObjectInfo.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/infoLabel.png")));
        this.togDisplayObjectInfo.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/infoLabel.png")));
        this.togDisplayObjectInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureControl.this.togDisplayObjectInfoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.togDisplayObjectInfo);
        this.togHoldAll.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/holdAll_disabled.png")));
        this.togHoldAll.setToolTipText(NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.togHoldAll.toolTipText"));
        this.togHoldAll.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/holdAll_disabled.png")));
        this.togHoldAll.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/holdAll.png")));
        this.togHoldAll.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/holdAll.png")));
        this.togHoldAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureControl.this.togHoldAllActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.togHoldAll);
        this.cmdHold.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/holdSelection.png")));
        this.cmdHold.setToolTipText(NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.cmdHold.toolTipText"));
        this.cmdHold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureControl.this.cmdHoldActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdHold);
        this.add((Component)this.jToolBar1, "North");
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane2.setViewportView((Component)this.jxtFeatures);
        this.add((Component)this.jScrollPane2, "Center");
    }

    private void togHoldAllActionPerformed(ActionEvent evt) {
        this.mappingComponent.getFeatureCollection().setHoldAll(this.togHoldAll.isSelected());
    }

    private void cmdRemoveAllActionPerformed(ActionEvent evt) {
        this.mappingComponent.getFeatureCollection().removeAllFeatures();
        this.mappingComponent.getMemUndo().clear();
        this.mappingComponent.getMemRedo().clear();
    }

    private void togFixMapScaleActionPerformed(ActionEvent evt) {
        this.mappingComponent.setFixedMapScale(this.togFixMapScale.isSelected());
    }

    private void togFixMapExtentActionPerformed(ActionEvent evt) {
        this.mappingComponent.setFixedMapExtent(this.togFixMapExtent.isSelected());
    }

    private void togDisplayObjectInfoActionPerformed(ActionEvent evt) {
        this.mappingComponent.setInfoNodesVisible(this.togDisplayObjectInfo.isSelected());
    }

    private void cmdHoldActionPerformed(ActionEvent evt) {
        int[] rows = this.jxtFeatures.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            int mappedRow = this.mapRowToModel(rows[i]);
            Feature f = this.getFeatureCollection().getFeature(mappedRow);
            if (this.getFeatureCollection().isHoldFeature(f)) {
                this.getFeatureCollection().unholdFeature(f);
                continue;
            }
            this.getFeatureCollection().holdFeature(f);
        }
    }

    private FeatureCollection getFeatureCollection() {
        try {
            return this.mappingComponent.getFeatureCollection();
        }
        catch (Exception e) {
            LOG.warn((Object)"Problem with method getFeatureCollection().", (Throwable)e);
            return new DefaultFeatureCollection();
        }
    }

    private int mapRowToModel(int displayedRow) {
        return this.jxtFeatures.convertRowIndexToModel(displayedRow);
    }

    public Vector<Feature> getAllFeaturesSorted() {
        Vector<Feature> v = new Vector<Feature>();
        FeatureCollection fc = this.getFeatureCollection();
        if (fc.getFeatureCount() > 0) {
            for (int i = 0; i < this.jxtFeatures.getRowCount(); ++i) {
                try {
                    v.add(fc.getAllFeatures().get(this.mapRowToModel(i)));
                    continue;
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in getAllFeaturesSorted() allFeatures=" + fc.getAllFeatures() + ", try to access " + this.mapRowToModel(i) + ". position"), t);
                }
            }
        }
        return v;
    }

    private void cmdRemoveFeaturesActionPerformed(ActionEvent evt) {
        this.mappingComponent.getMemUndo().clear();
        this.mappingComponent.getMemRedo().clear();
        int[] rows = this.jxtFeatures.getSelectedRows();
        HashSet toRemove = TypeSafeCollections.newHashSet();
        int firstSelectedRow = -1;
        for (int i = 0; i < rows.length; ++i) {
            if (firstSelectedRow == -1) {
                firstSelectedRow = rows[i];
            }
            int mappedRow = this.mapRowToModel(rows[i]);
            Feature currentFeature = this.getFeatureCollection().getFeature(mappedRow);
            if (toRemove.contains(currentFeature)) continue;
            if (currentFeature instanceof FeatureGroup) {
                toRemove.addAll(FeatureGroups.expandAll((FeatureGroup)currentFeature));
                continue;
            }
            toRemove.add(currentFeature);
        }
        this.getFeatureCollection().removeFeatures(toRemove);
        if (this.jxtFeatures.getRowCount() == firstSelectedRow) {
            --firstSelectedRow;
        }
        if (firstSelectedRow >= 0) {
            this.jxtFeatures.getSelectionModel().setSelectionInterval(firstSelectedRow, firstSelectedRow);
        }
    }

    private void cmdZoomToFeaturesMouseExited(MouseEvent evt) {
    }

    private void cmdZoomToFeaturesActionPerformed(ActionEvent evt) {
        this.mappingComponent.zoomToSelection();
    }

    private void cmdZoomToAllFeaturesActionPerformed(ActionEvent evt) {
        this.mappingComponent.zoomToFeatureCollection();
    }

    private void cmdZoomToFeaturesMouseEntered(MouseEvent evt) {
    }

    private void togShowOnlyVisibleActionPerformed(ActionEvent evt) {
        this.featureCollectionFilter.setArmed(this.togShowOnlyVisible.isSelected());
        this.fireTableDataChanged();
    }

    @Override
    public void shownMapBoundsChanged() {
        if (this.featureCollectionFilter.isArmed()) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public void featuresRemoved(FeatureCollectionEvent fce) {
        this.fireTableDataChanged();
    }

    @Override
    public void featuresChanged(FeatureCollectionEvent fce) {
        Collection fc = fce.getFeatureCollection().getSelectedFeatures();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("in featuresChanged: Selectedfeatures (" + fc.size() + ")" + fc), (Throwable)new CurrentStackTrace());
        }
        this.fireTableDataChanged();
        for (Feature feat : fc) {
            int index = this.getFeatureCollection().getAllFeatures().indexOf(feat);
            if (index == -1) continue;
            int viewIndex = this.jxtFeatures.convertRowIndexToView(index);
            this.jxtFeatures.getSelectionModel().addSelectionInterval(viewIndex, viewIndex);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("SelectionIntervall added " + viewIndex));
        }
    }

    @Override
    public void featuresAdded(FeatureCollectionEvent fce) {
        this.fireTableDataChanged();
    }

    private void fireTableDataChanged() {
        if (EventQueue.isDispatchThread()) {
            ((FeatureCollectionTableModel)this.jxtFeatures.getModel()).fireTableDataChanged();
        } else {
            LOG.warn((Object)"fireTableDataChanged not in edt", (Throwable)new Exception());
            EventQueue.invokeLater(new Thread("fireTableDatachanged in FeatureControl"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DefaultFeatureCollection fc = new DefaultFeatureCollection();
                    for (int row : FeatureControl.this.jxtFeatures.getSelectedRows()) {
                        int mappedRow = FeatureControl.this.mapRowToModel(row);
                        Feature feature = FeatureControl.this.getFeatureCollection().getFeature(mappedRow);
                        fc.addFeature(feature);
                    }
                    fc.select(fc.getAllFeatures());
                    try {
                        FeatureControl.this.jxtFeatures.getSelectionModel().removeListSelectionListener(FeatureControl.this.theListSelectionListener);
                        ((FeatureCollectionTableModel)FeatureControl.this.jxtFeatures.getModel()).fireTableDataChanged();
                    }
                    finally {
                        FeatureControl.this.jxtFeatures.getSelectionModel().addListSelectionListener(FeatureControl.this.theListSelectionListener);
                    }
                    FeatureControl.this.addFeatureToSelection(fc);
                }
            });
        }
    }

    @Override
    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        try {
            this.addFeatureToSelection(fce.getFeatureCollection());
        }
        catch (Exception e) {
            LOG.error((Object)"Error in featureSelectionChanged", (Throwable)e);
        }
    }

    private void addFeatureToSelection(FeatureCollection fc) {
        try {
            Collection features = fc.getSelectedFeatures();
            this.jxtFeatures.getSelectionModel().removeListSelectionListener(this.theListSelectionListener);
            this.jxtFeatures.getSelectionModel().clearSelection();
            if (features != null && features.size() > 0) {
                Iterator featureIt = features.iterator();
                for (int i = 0; i < features.size(); ++i) {
                    int collectionIndex;
                    Feature current = (Feature)featureIt.next();
                    if (current instanceof SubFeature) {
                        SubFeature sf = (SubFeature)current;
                        current = FeatureGroups.getRootFeature(sf);
                    }
                    if ((collectionIndex = this.mappingComponent.getFeatureCollection().getAllFeatures().indexOf(current)) == -1) continue;
                    int viewIndex = this.jxtFeatures.convertRowIndexToView(collectionIndex);
                    this.jxtFeatures.getSelectionModel().addSelectionInterval(viewIndex, viewIndex);
                }
            } else {
                this.jxtFeatures.scrollRowToVisible(0);
            }
            this.jxtFeatures.getSelectionModel().addListSelectionListener(this.theListSelectionListener);
        }
        catch (Exception e) {
            LOG.error((Object)"Error in addFeatureToSelection", (Throwable)e);
        }
    }

    public Element getConfiguration() {
        try {
            Element ret = new Element("cismapFeatureControl");
            ret.setAttribute("showOnlyObjectsInMap", new Boolean(this.togShowOnlyVisible.isSelected()).toString());
            ret.setAttribute("fixedMapExtent", new Boolean(this.togFixMapExtent.isSelected()).toString());
            ret.setAttribute("fixedMapScale", new Boolean(this.togFixMapScale.isSelected()).toString());
            ret.setAttribute("displayObjectInfo", new Boolean(this.togDisplayObjectInfo.isSelected()).toString());
            ret.setAttribute("holdAll", new Boolean(this.togHoldAll.isSelected()).toString());
            if (this.jxtFeatures.getSortedColumn() != null) {
                ret.setAttribute("sortedColumn", this.jxtFeatures.getSortedColumn().getIdentifier().toString());
                int viewIndex = this.jxtFeatures.convertColumnIndexToView(this.jxtFeatures.getSortedColumn().getModelIndex());
                ret.setAttribute("ascendingSortOrder", new Boolean(this.jxtFeatures.getSortOrder(viewIndex).equals((Object)SortOrder.ASCENDING)).toString());
            }
            Element columnSequence = new Element("columnSequence");
            for (Object tce : this.jxtFeatures.getColumns()) {
                columnSequence.addContent((Content)new Element("id").addContent(((TableColumnExt)tce).getIdentifier().toString()));
            }
            ret.addContent((Content)columnSequence);
            for (Object o : this.jxtFeatures.getColumns(true)) {
                TableColumnExt tce = (TableColumnExt)o;
                Element columnElement = new Element("column");
                columnElement.setAttribute("title", tce.getTitle());
                columnElement.setAttribute("identifier", tce.getIdentifier().toString());
                columnElement.setAttribute("visible", new Boolean(tce.isVisible()).toString());
                columnElement.setAttribute("width", "" + tce.getWidth());
                ret.addContent((Content)columnElement);
            }
            return ret;
        }
        catch (Throwable t) {
            LOG.error((Object)"Error while creating configuration (application exit)", t);
            return new Element("cismapFeatureControl");
        }
    }

    public void masterConfigure(Element e) {
    }

    public void configure(Element e) {
        block26: {
            try {
                Element conf = e.getChild("cismapFeatureControl");
                if (conf != null) {
                    try {
                        this.togShowOnlyVisible.setSelected(conf.getAttribute("showOnlyObjectsInMap").getBooleanValue());
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Error while reading configs", (Throwable)ex);
                    }
                    try {
                        this.togFixMapExtent.setSelected(conf.getAttribute("fixedMapExtent").getBooleanValue());
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Error while reading configs", (Throwable)ex);
                    }
                    try {
                        this.togFixMapScale.setSelected(conf.getAttribute("fixedMapScale").getBooleanValue());
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Error while reading configs", (Throwable)ex);
                    }
                    try {
                        this.togDisplayObjectInfo.setSelected(conf.getAttribute("displayObjectInfo").getBooleanValue());
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Error while reading configs", (Throwable)ex);
                    }
                    try {
                        this.togHoldAll.setSelected(conf.getAttribute("holdAll").getBooleanValue());
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Error while reading configs", (Throwable)ex);
                    }
                    try {
                        List seq = conf.getChild("columnSequence").getChildren("id");
                        Object[] oa = new Object[seq.size()];
                        int i = 0;
                        for (Object elem : seq) {
                            oa[i++] = ((Element)elem).getText();
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug(oa[i - 1]);
                        }
                        this.jxtFeatures.setColumnSequence(oa);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Error while reading configs", (Throwable)ex);
                    }
                    try {
                        String columnId = conf.getAttribute("sortedColumn").getValue();
                        boolean ascending = conf.getAttribute("ascendingSortOrder").getBooleanValue();
                        int viewIndex = this.jxtFeatures.convertColumnIndexToView(this.jxtFeatures.getColumn((Object)columnId).getModelIndex());
                        this.jxtFeatures.toggleSortOrder(viewIndex);
                        if (!ascending) {
                            this.jxtFeatures.toggleSortOrder(viewIndex);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Error while reading configs", (Throwable)ex);
                    }
                    List lst = conf.getChildren("column");
                    try {
                        for (Object elem : lst) {
                            Element col = (Element)elem;
                            String id = col.getAttribute("identifier").getValue();
                            try {
                                this.jxtFeatures.getColumnExt((Object)id).setVisible(col.getAttribute("visible").getBooleanValue());
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)"Error while reading configs", (Throwable)ex);
                            }
                            try {
                                this.jxtFeatures.getColumnExt((Object)id).setPreferredWidth(col.getAttribute("width").getIntValue());
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)"Error while reading configs", (Throwable)ex);
                            }
                        }
                    }
                    catch (Throwable t) {
                        LOG.warn((Object)"Error while configuring featureControlComponent:", t);
                    }
                    this.featureCollectionFilter.setArmed(this.togShowOnlyVisible.isSelected());
                    this.mappingComponent.setInfoNodesVisible(this.togDisplayObjectInfo.isSelected());
                    this.mappingComponent.setFixedMapExtent(this.togFixMapExtent.isSelected());
                    this.mappingComponent.setFixedMapScale(this.togFixMapScale.isSelected());
                    this.mappingComponent.getFeatureCollection().setHoldAll(this.togHoldAll.isSelected());
                    break block26;
                }
                LOG.warn((Object)"No configurarion data for FeatureControl available.");
            }
            catch (Throwable t) {
                LOG.error((Object)"Error while loading configuration (application start)", t);
            }
        }
    }

    @Override
    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
    }

    @Override
    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
        this.fireTableDataChanged();
    }

    @Override
    public void featureCollectionChanged() {
    }

    public JComponent getGuiComponent() {
        return this;
    }

    public String getPermissionString() {
        return "NoPermissionRequired";
    }

    public boolean isWizardMode() {
        return this.wizardMode;
    }

    public String getViewTitle() {
        return NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.getViewTitle");
    }

    public Icon getViewIcon() {
        ImageIcon icoMap = new ImageIcon(this.getClass().getResource("/images/objects.png"));
        return Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1);
    }

    class FeatureCollectionFilter
    extends RowFilter<AbstractTableModel, Integer> {
        private FeatureCollectionTableModel model;
        private boolean armed = false;

        public FeatureCollectionFilter(boolean armed, FeatureCollectionTableModel model) {
            this.armed = armed;
            this.model = model;
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (!this.armed) {
                return true;
            }
            int modelRow = (Integer)entry.getIdentifier();
            try {
                Feature value = FeatureControl.this.getFeatureCollection().getFeature(modelRow);
                PFeature pf = FeatureControl.this.mappingComponent.getPFeatureHM().get(value);
                if (pf != null) {
                    PBounds all = FeatureControl.this.mappingComponent.getCamera().getViewBounds();
                    PDimension delta = all.deltaRequiredToContain((Rectangle2D)pf.getFullBounds());
                    FeatureControl.this.mappingComponent.getCamera().viewToLocal((Dimension2D)delta);
                    PDimension size = new PDimension(pf.getFullBounds().getSize());
                    FeatureControl.this.mappingComponent.getCamera().viewToLocal((Dimension2D)size);
                    boolean test = Math.abs(delta.width) <= size.width && Math.abs(delta.height) <= size.height;
                    return test;
                }
                return false;
            }
            catch (Throwable t) {
                LOG.error((Object)"Error while testing in filter.", t);
                return true;
            }
        }

        public boolean isArmed() {
            return this.armed;
        }

        public void setArmed(boolean armed) {
            this.armed = armed;
            FeatureControl.this.fireTableDataChanged();
        }
    }

    final class SubFeatureFilter
    extends RowFilter<AbstractTableModel, Integer> {
        SubFeatureFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            int modelRow = (Integer)entry.getIdentifier();
            try {
                Feature currentTestFeature = FeatureControl.this.getFeatureCollection().getFeature(modelRow);
                if (currentTestFeature instanceof SubFeature) {
                    return ((SubFeature)currentTestFeature).getParentFeature() == null;
                }
                return true;
            }
            catch (Throwable t) {
                LOG.error((Object)"Error while testing in filter", t);
                return true;
            }
        }
    }

    class FeatureCollectionTableModel
    extends AbstractTableModel {
        FeatureCollectionTableModel() {
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1 && FeatureControl.this.getFeatureCollection().getFeature(rowIndex) instanceof AbstractNewFeature) {
                ((AbstractNewFeature)FeatureControl.this.getFeatureCollection().getFeature(rowIndex)).setName(aValue.toString());
                Vector<Feature> v = new Vector<Feature>();
                v.add(FeatureControl.this.getFeatureCollection().getFeature(rowIndex));
                ((DefaultFeatureCollection)FeatureControl.this.mappingComponent.getFeatureCollection()).fireFeaturesChanged(v);
            }
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.getColumnName(int).return.ico");
                }
                case 1: {
                    return NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.getColumnName(int).return.name");
                }
                case 2: {
                    return NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.getColumnName(int).return.typ");
                }
                case 3: {
                    return NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.getColumnName(int).return.geometrie");
                }
                case 4: {
                    return NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.getColumnName(int).return.groesse");
                }
                case 5: {
                    return NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.getColumnName(int).return.laenge");
                }
                case 6: {
                    return NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.getColumnName(int).return.zentrum");
                }
                case 7: {
                    return NbBundle.getMessage(FeatureControl.class, (String)"FeatureControl.getColumnName(int).return.Halten");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && FeatureControl.this.getFeatureCollection().getFeature(rowIndex) instanceof AbstractNewFeature;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                Feature f = FeatureControl.this.getFeatureCollection().getFeature(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        if (f instanceof XStyledFeature) {
                            return ((XStyledFeature)f).getIconImage();
                        }
                        return null;
                    }
                    case 1: {
                        if (f instanceof XStyledFeature) {
                            return ((XStyledFeature)f).getName();
                        }
                        return f;
                    }
                    case 2: {
                        if (f instanceof XStyledFeature) {
                            return ((XStyledFeature)f).getType();
                        }
                        if (f instanceof FeatureGroup) {
                            return "GRUPPE";
                        }
                        return "";
                    }
                    case 3: {
                        if (f.getGeometry() != null) {
                            return f.getGeometry().getGeometryType();
                        }
                        return "";
                    }
                    case 4: {
                        if (f.getGeometry() != null) {
                            Geometry geom = CrsTransformer.transformToMetricCrs(f.getGeometry(), FeatureControl.this.mappingComponent.getCrsList());
                            double correctionFactor = CrsTransformer.getCrsFactor(geom.getCentroid());
                            return StaticDecimalTools.round((double)(geom.getArea() / (correctionFactor * correctionFactor)));
                        }
                        return 0.0;
                    }
                    case 5: {
                        if (f != null && f.getGeometry() != null) {
                            Geometry geom = CrsTransformer.transformToMetricCrs(f.getGeometry(), FeatureControl.this.mappingComponent.getCrsList());
                            return StaticDecimalTools.round((double)(geom.getLength() / CrsTransformer.getCrsFactor(geom.getCentroid())));
                        }
                        return 0.0;
                    }
                    case 6: {
                        FeatureRenderer renderer;
                        if (f instanceof FeatureRendererAwareFeature && (renderer = ((FeatureRendererAwareFeature)((Object)f)).getFeatureRenderer()) instanceof CoordHider) {
                            return "";
                        }
                        if (f.getGeometry() != null) {
                            Geometry geom = CrsTransformer.transformToCurrentCrs(f.getGeometry());
                            String pattern = CismapBroker.getInstance().getSrs().isMetric() ? "0.00" : "0.000000";
                            return "(" + StaticDecimalTools.round((String)pattern, (double)geom.getCentroid().getX()) + "," + StaticDecimalTools.round((String)pattern, (double)geom.getCentroid().getY()) + ")";
                        }
                        return 0.0;
                    }
                    case 7: {
                        if (FeatureControl.this.getFeatureCollection().isHoldFeature(f)) {
                            return FeatureControl.this.icoGreenled;
                        }
                        return null;
                    }
                }
                return null;
            }
            catch (Throwable t) {
                LOG.error((Object)"Error in table.", t);
                return null;
            }
        }

        @Override
        public int getRowCount() {
            return FeatureControl.this.getFeatureCollection() != null ? FeatureControl.this.getFeatureCollection().getFeatureCount() : 0;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }
    }
}

