/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.featureinfowidget.displays;

import calpa.html.CalHTMLObserver;
import calpa.html.CalHTMLPane;
import calpa.html.CalHTMLPreferences;
import calpa.html.DefaultCalHTMLObserver;
import de.cismet.cismap.commons.gui.featureinfowidget.AbstractFeatureInfoDisplay;
import de.cismet.cismap.commons.gui.featureinfowidget.FeatureInfoDisplayKey;
import de.cismet.cismap.commons.gui.featureinfowidget.displays.FXPanelWrapper;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.MapClickedEvent;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.cismap.commons.retrieval.UniversalRetrieval;
import de.cismet.commons.security.AccessHandler;
import de.cismet.security.WebAccessManager;
import de.cismet.security.handler.WSSAccessHandler;
import de.cismet.tools.BrowserLauncher;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class OGCWMSGetFeatureInfoRequestHtmlDisplay
extends AbstractFeatureInfoDisplay<WMSLayer>
implements RetrievalListener,
HyperlinkListener {
    private static final Logger LOG = Logger.getLogger(OGCWMSGetFeatureInfoRequestHtmlDisplay.class);
    WMSLayer wmsLayer = null;
    UniversalRetrieval ur = null;
    private final Icon icoProgress = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/featureinfowidget/res/progress.png"));
    private final Icon icoProgress64 = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/featureinfowidget/res/progress64.png"));
    private final Icon icoInfo = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/featureinfowidget/res/info.png"));
    private final DefaultCalHTMLObserver htmlObserver = new DefaultCalHTMLObserver(){

        public void statusUpdate(CalHTMLPane calHTMLPane, int i, URL uRL, int i0, String string) {
            super.statusUpdate(calHTMLPane, i, uRL, i0, string);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("StatusUpdate" + i + uRL));
            }
        }

        public void linkActivatedUpdate(CalHTMLPane calHTMLPane, URL uRL, String string, String string0) {
            super.linkActivatedUpdate(calHTMLPane, uRL, string, string0);
        }

        public void linkFocusedUpdate(CalHTMLPane calHTMLPane, URL uRL) {
            super.linkFocusedUpdate(calHTMLPane, uRL);
        }
    };
    private CalHTMLPane calpaHtmlPane;
    private final CalHTMLPreferences htmlPrefs = new CalHTMLPreferences();
    private AppletContext appletContext;
    private boolean shiftDown;
    private JTabbedPane tabbedparent;
    private String urlBuffer;
    private SwingWorker currentWorker;
    private FXPanelWrapper fxBrowserPanel;
    private boolean fxIniterror = false;
    private JButton cmdOpenExternal;
    private JButton cmdRefresh;
    private JTextPane htmlPane_;
    private JPanel jPanel1;
    private JPanel pnlWebView;
    private JToolBar tbLeft;
    private JToolBar tbRight;

    public OGCWMSGetFeatureInfoRequestHtmlDisplay() {
        super(new FeatureInfoDisplayKey(WMSLayer.class, FeatureInfoDisplayKey.ANY_SERVER, FeatureInfoDisplayKey.ANY_LAYER));
        this.htmlPrefs.setAutomaticallyFollowHyperlinks(false);
        this.htmlPrefs.setHandleFormSubmission(false);
        this.htmlPrefs.setOptimizeDisplay(2);
        this.htmlPrefs.setDisplayErrorDialogs(false);
        this.htmlPrefs.setLoadImages(true);
        this.initComponents();
        this.tbLeft.setVisible(false);
        try {
            if (System.getProperty("java.version").startsWith("1.6")) {
                this.fxIniterror = true;
                this.initCalpaAsFallback();
            } else {
                this.fxBrowserPanel = new FXPanelWrapper();
                this.pnlWebView.add((Component)this.fxBrowserPanel, "Center");
            }
        }
        catch (Error e) {
            this.fxIniterror = true;
            LOG.warn((Object)"Error initialising JavaFX WebView. Using Calpa as Fallback", (Throwable)e);
            this.initCalpaAsFallback();
        }
        catch (Exception ex) {
            this.fxIniterror = true;
            LOG.warn((Object)"Excpetion initialising JavaFX WebView. Using Calpa as Fallback", (Throwable)ex);
            this.initCalpaAsFallback();
        }
    }

    private void initCalpaAsFallback() {
        this.calpaHtmlPane = new CalHTMLPane(this.htmlPrefs, (CalHTMLObserver)this.htmlObserver, "cismap");
        this.pnlWebView.removeAll();
        this.pnlWebView.add((Component)this.calpaHtmlPane, "Center");
    }

    @Override
    public void init(WMSLayer layer, JTabbedPane parentTabbedPane) {
        this.wmsLayer = layer;
        this.tabbedparent = parentTabbedPane;
    }

    @Override
    public void showFeatureInfo(MapClickedEvent mce) {
        this.showContent((int)mce.getX(), (int)mce.getY());
    }

    private void showContent(int x, int y) {
        String url = this.wmsLayer.getParentServiceLayer().getGetFeatureInfoUrl(x, y, this.wmsLayer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("showContet of " + url));
        }
        this.urlBuffer = url;
        if (this.currentWorker != null && !this.currentWorker.isCancelled()) {
            this.currentWorker.cancel(true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"before FeatureInfoRetriever creation");
        }
        this.currentWorker = new FeatureInfoRetriever(url);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"afterFeatureInfoCreation");
        }
        CismapBroker.getInstance().execute(this.currentWorker);
    }

    @Override
    public void retrievalStarted(RetrievalEvent e) {
    }

    @Override
    public void retrievalProgress(RetrievalEvent e) {
    }

    @Override
    public void retrievalError(RetrievalEvent e) {
    }

    @Override
    public void retrievalComplete(RetrievalEvent e) {
        if (this.tabbedparent != null) {
            this.tabbedparent.setIconAt(this.tabbedparent.indexOfComponent(this), this.icoInfo);
        }
        if (e.getRetrievedObject() instanceof String) {
            if (this.fxIniterror) {
                this.calpaHtmlPane.showHTMLDocument(e.getRetrievedObject().toString());
            } else {
                try {
                    this.fxBrowserPanel.getJfxPanel().loadContent(e.getRetrievedObject().toString());
                }
                catch (Exception loadContentEx) {
                    LOG.error((Object)("Problem during loadContent of fxBrowserPanel.getJfxPanel():" + loadContentEx));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("String:" + e.getRetrievedObject().toString()));
            }
        } else if (e.getRetrievedObject() instanceof Image && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Image:" + e.getRetrievedObject()));
        }
    }

    @Override
    public void retrievalAborted(RetrievalEvent e) {
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hyperlinkUpdate: " + event));
        }
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (this.shiftDown) {
                this.openUrlInExternalBrowser(event.getURL().toExternalForm());
            } else {
                UniversalRetrieval ur = new UniversalRetrieval(event.getURL().toExternalForm());
                ur.addRetrievalListener(this);
                ur.retrieve(false);
            }
        }
    }

    private void openUrlInExternalBrowser(String url) {
        try {
            if (this.appletContext == null) {
                BrowserLauncher.openURL((String)url);
            } else {
                URL u = new URL(url);
                this.appletContext.showDocument(u, "cismetBrowser");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while opening: " + url + ".\nNew try."), (Throwable)e);
            try {
                BrowserLauncher.openURL((String)url);
            }
            catch (Exception e2) {
                LOG.warn((Object)("Second try also failed. Error while opening: " + url + "\nLast try."), (Throwable)e2);
                try {
                    BrowserLauncher.openURL((String)("file://" + url));
                }
                catch (Exception e3) {
                    LOG.error((Object)("Third try also failed. Error while opening: file://" + url), (Throwable)e3);
                }
            }
        }
    }

    private void initComponents() {
        this.htmlPane_ = new JTextPane();
        this.jPanel1 = new JPanel();
        this.tbLeft = new JToolBar();
        this.tbLeft.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.cmdRefresh = new JButton();
        this.tbRight = new JToolBar();
        this.tbRight.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.cmdOpenExternal = new JButton();
        this.pnlWebView = new JPanel();
        this.htmlPane_.setEditable(false);
        this.htmlPane_.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OGCWMSGetFeatureInfoRequestHtmlDisplay.this.htmlPane_MouseMoved(evt);
            }
        });
        this.htmlPane_.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                OGCWMSGetFeatureInfoRequestHtmlDisplay.this.htmlPane_KeyPressed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.tbLeft.setFloatable(false);
        this.cmdRefresh.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/featureinfowidget/res/reload16.gif")));
        this.cmdRefresh.setText(NbBundle.getMessage(OGCWMSGetFeatureInfoRequestHtmlDisplay.class, (String)"OGCWMSGetFeatureInfoRequestHtmlDisplay.cmdRefresh.text"));
        this.cmdRefresh.setToolTipText(NbBundle.getMessage(OGCWMSGetFeatureInfoRequestHtmlDisplay.class, (String)"OGCWMSGetFeatureInfoRequestHtmlDisplay.cmdRefresh.toolTipText"));
        this.cmdRefresh.setBorderPainted(false);
        this.cmdRefresh.setFocusable(false);
        this.cmdRefresh.setHorizontalTextPosition(0);
        this.cmdRefresh.setVerticalTextPosition(3);
        this.cmdRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OGCWMSGetFeatureInfoRequestHtmlDisplay.this.cmdRefreshActionPerformed(evt);
            }
        });
        this.tbLeft.add(this.cmdRefresh);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.tbLeft, gridBagConstraints);
        this.tbRight.setFloatable(false);
        this.cmdOpenExternal.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/featureinfowidget/res/extWindow.png")));
        this.cmdOpenExternal.setText(NbBundle.getMessage(OGCWMSGetFeatureInfoRequestHtmlDisplay.class, (String)"OGCWMSGetFeatureInfoRequestHtmlDisplay.cmdOpenExternal.text"));
        this.cmdOpenExternal.setToolTipText(NbBundle.getMessage(OGCWMSGetFeatureInfoRequestHtmlDisplay.class, (String)"OGCWMSGetFeatureInfoRequestHtmlDisplay.cmdOpenExternal.toolTipText"));
        this.cmdOpenExternal.setBorderPainted(false);
        this.cmdOpenExternal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OGCWMSGetFeatureInfoRequestHtmlDisplay.this.cmdOpenExternalActionPerformed(evt);
            }
        });
        this.tbRight.add(this.cmdOpenExternal);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.tbRight, gridBagConstraints);
        this.add((Component)this.jPanel1, "North");
        this.pnlWebView.setLayout(new BorderLayout());
        this.add((Component)this.pnlWebView, "Center");
    }

    private void cmdOpenExternalActionPerformed(ActionEvent evt) {
        if (this.urlBuffer != null) {
            try {
                URL urlWithCredentials = WebAccessManager.getUrlWithCredentials((URL)new URL(this.urlBuffer));
                AccessHandler handler = WebAccessManager.getInstance().getHandlerForURL(urlWithCredentials);
                if (handler != null) {
                    if (handler instanceof WSSAccessHandler) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"handler is wss handler --> creating wss get request");
                        }
                        String wssRequest = ((WSSAccessHandler)handler).createGetRequest(urlWithCredentials.toString());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("created wss request: " + wssRequest));
                        }
                        this.openUrlInExternalBrowser(wssRequest);
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"No special handler --> default access via open URL");
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"no handler available for given url default access via openURL");
                }
                this.openUrlInExternalBrowser(urlWithCredentials.toString());
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while creating url for featureinfo", (Throwable)ex);
            }
        } else {
            this.openUrlInExternalBrowser("http://www.cismet.de");
        }
    }

    private void htmlPane_MouseMoved(MouseEvent evt) {
        this.shiftDown = (evt.getModifiers() & 1) == 1;
    }

    private void htmlPane_KeyPressed(KeyEvent evt) {
    }

    private void cmdRefreshActionPerformed(ActionEvent evt) {
        this.fxBrowserPanel.refresh();
    }

    class FeatureInfoRetriever
    extends SwingWorker<String, Void> {
        private String url;

        FeatureInfoRetriever(String url) {
            this.url = url;
        }

        @Override
        protected String doInBackground() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"FeatureInfoRetriever started");
            }
            try {
                int c;
                String parameter;
                URL baseUrl;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (OGCWMSGetFeatureInfoRequestHtmlDisplay.this.tabbedparent != null) {
                            OGCWMSGetFeatureInfoRequestHtmlDisplay.this.tabbedparent.setIconAt(OGCWMSGetFeatureInfoRequestHtmlDisplay.this.tabbedparent.indexOfComponent(OGCWMSGetFeatureInfoRequestHtmlDisplay.this), OGCWMSGetFeatureInfoRequestHtmlDisplay.this.icoProgress);
                        }
                    }
                });
                if (this.url.indexOf(63) != -1) {
                    baseUrl = new URL(this.url.substring(0, this.url.indexOf(63)));
                    parameter = this.url.substring(this.url.indexOf(63) + 1, this.url.length());
                } else {
                    baseUrl = new URL(this.url);
                    parameter = "";
                }
                if (this.isCancelled()) {
                    return null;
                }
                BufferedInputStream in = new BufferedInputStream(WebAccessManager.getInstance().doRequest(baseUrl, parameter, AccessHandler.ACCESS_METHODS.GET_REQUEST));
                if (this.isCancelled()) {
                    return null;
                }
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                while ((c = in.read()) != -1) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    byteArrayOut.write(c);
                }
                String s = byteArrayOut.toString();
                String charset = this.getCharset(s);
                if (charset != null) {
                    try {
                        s = byteArrayOut.toString(charset);
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.error((Object)"Unsupported charset used", (Throwable)e);
                    }
                }
                return s;
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while fetching FeatureInfos", (Throwable)ex);
                return null;
            }
        }

        private String getCharset(String s) {
            Pattern p = Pattern.compile("<meta(?!\\s*(?:name|value)\\s*=)[^>]*?charset\\s*=[\\s\"']*([^\\s\"'/>]*)");
            Matcher m = p.matcher(s);
            if (m.find()) {
                return m.group(1);
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            if (this.isCancelled()) {
                LOG.warn((Object)"FeatureInfoRetriever was canceled");
                return;
            }
            try {
                if (OGCWMSGetFeatureInfoRequestHtmlDisplay.this.tabbedparent != null) {
                    OGCWMSGetFeatureInfoRequestHtmlDisplay.this.tabbedparent.setIconAt(OGCWMSGetFeatureInfoRequestHtmlDisplay.this.tabbedparent.indexOfComponent(OGCWMSGetFeatureInfoRequestHtmlDisplay.this), OGCWMSGetFeatureInfoRequestHtmlDisplay.this.icoInfo);
                }
                String result = (String)this.get();
                if (OGCWMSGetFeatureInfoRequestHtmlDisplay.this.fxIniterror) {
                    OGCWMSGetFeatureInfoRequestHtmlDisplay.this.calpaHtmlPane.showHTMLDocument(result);
                } else {
                    OGCWMSGetFeatureInfoRequestHtmlDisplay.this.fxBrowserPanel.getJfxPanel().loadContent(result);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("String:" + result));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while processing data of FeatureInfoRetriever", (Throwable)ex);
                return;
            }
        }
    }
}

