/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.ChildrenProvider;
import de.cismet.cismap.commons.CidsLayerFactory;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.MappingModelListener;
import de.cismet.cismap.commons.ModeLayer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModelStore;
import de.cismet.cismap.commons.gui.layerwidget.LayerCollection;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidget;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.raster.wms.AbstractWMS;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.raster.wms.featuresupportlayer.SimpleFeatureSupportingRasterLayer;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import de.cismet.tools.PropertyEqualsProvider;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.treetable.AbstractTreeTableModel;
import de.cismet.tools.gui.treetable.TreeTableModel;
import de.cismet.tools.gui.treetable.TreeTableModelAdapter;
import java.awt.EventQueue;
import java.awt.Image;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class ActiveLayerModel
extends AbstractTreeTableModel
implements MappingModel,
Configurable {
    protected static final boolean DEBUG = false;
    Vector layers = new Vector();
    Vector<MappingModelListener> mappingModelListeners = new Vector();
    BoundingBox initialBoundingBox;
    private final Logger log = Logger.getLogger(this.getClass());
    private HashMap<String, XBoundingBox> homes = new HashMap();
    private Crs srs;
    private String preferredRasterFormat;
    private String preferredTransparentPref;
    private String preferredBGColor;
    private String preferredExceptionsFormat;
    private TreeTableModelAdapter tableModel;
    private boolean initalLayerConfigurationFromServer = false;
    private HashMap<String, Element> masterLayerHashmap = new HashMap();
    private Crs defaultHomeSrs;
    private List<TreeModelListener> listenerWithOutProgress = new ArrayList<TreeModelListener>();
    private final HashMap<String, WMSCapabilities> capabilities = new HashMap();

    public ActiveLayerModel() {
        super((Object)"Layer");
        this.setDefaults();
        this.tableModel = new TreeTableModelAdapter((TreeTableModel)this, new JTree());
    }

    private void setDefaults() {
        this.preferredRasterFormat = "image/png";
        this.preferredBGColor = "0xF0F0F0";
        this.preferredExceptionsFormat = "application/vnd.ogc.se_xml";
        this.initialBoundingBox = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
    }

    public synchronized void addEmptyLayerCollection(LayerCollection layer) {
        this.layers.add(layer);
        layer.setModel(this);
        this.fireTreeStructureChanged(this, new Object[]{this.root}, null, new Object[]{layer});
    }

    public synchronized void addEmptyLayerCollection(TreePath path, LayerCollection layer) {
        Object parentCollection = path.getLastPathComponent();
        if (parentCollection instanceof LayerCollection) {
            LayerCollection collection = (LayerCollection)parentCollection;
            collection.add(layer);
            layer.setModel(this);
            this.fireTreeStructureChanged(this, path.getPath(), null, new Object[]{layer});
        }
    }

    public synchronized void addLayerCollection(LayerCollection layer, int index) {
        this.layers.add(index, layer);
        this.registerLayerFromLayerCollection(layer);
        this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
    }

    private void registerLayerFromLayerCollection(LayerCollection lc) {
        for (Object o : lc) {
            if (o instanceof LayerCollection) {
                this.registerLayerFromLayerCollection((LayerCollection)o);
                continue;
            }
            if (!(o instanceof RetrievalServiceLayer)) continue;
            this.registerRetrievalServiceLayer((RetrievalServiceLayer)o);
        }
    }

    public synchronized void addLayer(Object layer, int index) {
        if (layer instanceof LayerCollection) {
            this.addLayerCollection((LayerCollection)layer, index);
        } else if (layer instanceof RetrievalServiceLayer) {
            this.addLayer((RetrievalServiceLayer)layer, index);
        }
    }

    @Override
    public synchronized void addLayer(RetrievalServiceLayer layer) {
        this.addLayer(layer, this.layers.size());
    }

    public synchronized void addLayer(RetrievalServiceLayer layer, int index) {
        if (this.layers.contains(layer)) {
            throw new IllegalArgumentException("Layer '" + layer.getName() + "' already exists");
        }
        if (layer instanceof PropertyEqualsProvider) {
            for (Object o : this.layers) {
                if (!(o instanceof PropertyEqualsProvider) || !((PropertyEqualsProvider)o).propertyEquals((Object)layer)) continue;
                throw new IllegalArgumentException("Layer '" + layer.getName() + "' already exists");
            }
        }
        this.registerRetrievalServiceLayer(layer);
        this.layers.add(index, layer);
        this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
        this.reorderLayer();
    }

    public void registerRetrievalServiceLayer(RetrievalServiceLayer layer) {
        final RetrievalServiceLayer currentLayer = layer;
        ActiveLayerEvent ale = new ActiveLayerEvent();
        ale.setLayer(currentLayer);
        CismapBroker.getInstance().fireLayerAdded(ale);
        CidsLayerFactory.wmsSpecificConfiguration(layer, this.preferredBGColor, this.preferredExceptionsFormat, this.preferredRasterFormat, this.srs);
        layer.addRetrievalListener(new RetrievalListener(){

            @Override
            public void retrievalStarted(RetrievalEvent e) {
                ActiveLayerModel.this.fireProgressChanged(currentLayer);
            }

            @Override
            public void retrievalProgress(RetrievalEvent e) {
                ActiveLayerModel.this.fireProgressChanged(currentLayer);
            }

            @Override
            public void retrievalComplete(RetrievalEvent e) {
                ActiveLayerModel.this.fireProgressChanged(currentLayer);
                if (e.isHasErrors()) {
                    this.retrievalError(e);
                } else {
                    currentLayer.setErrorObject(null);
                }
            }

            @Override
            public void retrievalAborted(RetrievalEvent e) {
                ActiveLayerModel.this.fireProgressChanged(currentLayer);
            }

            @Override
            public void retrievalError(RetrievalEvent e) {
                currentLayer.setProgress(0);
                ActiveLayerModel.this.fireProgressChanged(currentLayer);
                if (e.getRetrievedObject() != null) {
                    Object errorObject = e.getRetrievedObject();
                    if (errorObject instanceof Image) {
                        Image i = Static2DTools.removeUnusedBorder((Image)((Image)errorObject), (int)5, (double)0.7);
                        errorObject = i;
                    } else if (e.getRetrievedObject() instanceof String) {
                        String message = (String)e.getRetrievedObject();
                        message = message.replaceAll("<.*?>", "");
                        errorObject = e.getErrorType().equals("SERVERERROR") ? NbBundle.getMessage(ActiveLayerModel.class, (String)"ActiveLayerModel.retrievalError(RetrievalEvent).errorObject.servererror", (Object[])new Object[]{message}) : (message != null ? NbBundle.getMessage(ActiveLayerModel.class, (String)"ActiveLayerModel.retrievalError(RetrievalEvent).errorObject.noServererror", (Object[])new Object[]{message}) : NbBundle.getMessage(ActiveLayerModel.class, (String)"ActiveLayerModel.retrievalError(RetrievalEvent).errorObject.noServererror", (Object[])new Object[0]));
                    }
                    currentLayer.setErrorObject(errorObject);
                }
            }
        });
        if (layer instanceof ModeLayer) {
            this.fireMapServiceAdded((MapService)((Object)((ModeLayer)layer).getCurrentLayer()));
        } else if (layer instanceof MapService) {
            this.fireMapServiceAdded((MapService)((Object)layer));
        } else {
            this.log.warn((Object)("fireMapServiceAdded event not fired, layer is no MapService:" + layer));
        }
    }

    public void refreshWebFeatureServices() {
        Object[] oa = this.layers.toArray();
        Vector<WebFeatureService> removedLayer = new Vector<WebFeatureService>();
        for (int i = 0; i < oa.length; ++i) {
            if (!(oa[i] instanceof WebFeatureService)) continue;
            removedLayer.add((WebFeatureService)oa[i]);
            this.removeLayer(oa[i], null);
        }
        for (WebFeatureService tmp : removedLayer) {
            this.addLayer((WebFeatureService)tmp.clone());
        }
    }

    public void refreshShapeFileLayer() {
        Object[] oa = this.layers.toArray();
        for (int i = 0; i < oa.length; ++i) {
            if (!(oa[i] instanceof ShapeFileFeatureService)) continue;
            ((ShapeFileFeatureService)oa[i]).getPNode().removeAllChildren();
            ((ShapeFileFeatureService)oa[i]).setCrs(this.srs);
            if (!((ShapeFileFeatureService)oa[i]).isInitialized()) continue;
            ((ShapeFileFeatureService)oa[i]).refreshFeatures();
        }
    }

    public void removeAllLayers() {
        Object[] oa = this.layers.toArray();
        for (int i = 0; i < oa.length; ++i) {
            Object elem = oa[i];
            this.removeLayer(elem, null);
        }
    }

    public void removeLayer(TreePath treePath) {
        Object layer = treePath.getLastPathComponent();
        this.removeLayer(layer, treePath);
    }

    public void removeLayer(Object layer, TreePath treePath) {
        if (treePath != null && !treePath.getParentPath().getLastPathComponent().equals(this.getRoot())) {
            Object parent = treePath.getParentPath().getLastPathComponent();
            if (parent instanceof LayerCollection) {
                ((LayerCollection)parent).remove(layer);
                ActiveLayerEvent ale = new ActiveLayerEvent();
                this.fireTreeStructureChanged(this, null, null, null);
                if (layer instanceof MapService) {
                    ale.setLayer(layer);
                    CismapBroker.getInstance().fireLayerRemoved(ale);
                    this.fireMapServiceRemoved((MapService)layer);
                }
            }
        } else if (layer instanceof RetrievalServiceLayer) {
            this.removeLayer((RetrievalServiceLayer)layer);
        } else if (layer instanceof LayerCollection) {
            this.layers.remove(layer);
            this.fireTreeStructureChanged(this, new Object[]{layer}, null, null);
        } else if (treePath != null && layer instanceof WMSLayer) {
            TreePath parentPath = treePath.getParentPath();
            if (parentPath.getLastPathComponent() instanceof WMSServiceLayer) {
                ((WMSServiceLayer)parentPath.getLastPathComponent()).removeLayer((WMSLayer)layer);
            }
            this.fireTreeStructureChanged(this, new Object[]{this.root, (WMSServiceLayer)parentPath.getLastPathComponent()}, null, null);
            ActiveLayerEvent ale = new ActiveLayerEvent();
            ale.setLayer((WMSLayer)layer);
            CismapBroker.getInstance().fireLayerRemoved(ale);
        }
    }

    @Override
    public void removeLayer(RetrievalServiceLayer layer) {
        RetrievalServiceLayer wmsServiceLayer = layer;
        this.layers.remove(wmsServiceLayer);
        for (Object entry : this.layers) {
            if (!(entry instanceof LayerCollection)) continue;
            this.removeServiceFromLayerCollection((LayerCollection)entry, layer);
        }
        ActiveLayerEvent ale = new ActiveLayerEvent();
        ale.setLayer(wmsServiceLayer);
        CismapBroker.getInstance().fireLayerRemoved(ale);
        this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
        this.fireMapServiceRemoved((MapService)((Object)wmsServiceLayer));
    }

    private void removeServiceFromLayerCollection(LayerCollection col, RetrievalServiceLayer layer) {
        for (Object o : (ArrayList)col.clone()) {
            if (o instanceof LayerCollection) {
                this.removeServiceFromLayerCollection((LayerCollection)o, layer);
                continue;
            }
            if (!o.equals(layer)) continue;
            col.remove(layer);
        }
    }

    private void removeLayerCollectionFromLayerCollection(LayerCollection col, LayerCollection layerToRemove) {
        for (Object o : (ArrayList)col.clone()) {
            if (o instanceof LayerCollection) {
                this.removeLayerCollectionFromLayerCollection((LayerCollection)o, layerToRemove);
                continue;
            }
            if (!o.equals(layerToRemove)) continue;
            col.remove(layerToRemove);
        }
    }

    public void removeLayer(Object layer) {
        if (layer instanceof LayerCollection) {
            this.removeLayerCollection((LayerCollection)layer);
        } else if (layer instanceof RetrievalServiceLayer) {
            this.removeLayer((RetrievalServiceLayer)layer);
        }
    }

    public void removeLayerCollection(LayerCollection layer) {
        this.layers.remove(layer);
        for (Object entry : this.layers) {
            if (!(entry instanceof LayerCollection)) continue;
            this.removeLayerCollectionFromLayerCollection((LayerCollection)entry, layer);
        }
        ActiveLayerEvent ale = new ActiveLayerEvent();
        ale.setLayer(layer);
        CismapBroker.getInstance().fireLayerRemoved(ale);
        this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
    }

    public void disableLayer(TreePath treePath) {
        Object layer = treePath.getLastPathComponent();
        ActiveLayerEvent activeLayerEvent = new ActiveLayerEvent();
        if (layer instanceof RetrievalServiceLayer) {
            RetrievalServiceLayer wmsServiceLayer;
            wmsServiceLayer.setEnabled(!(wmsServiceLayer = (RetrievalServiceLayer)layer).isEnabled());
            activeLayerEvent.setLayer(layer);
            CismapBroker.getInstance().fireLayerAvailabilityChanged(activeLayerEvent);
            if (wmsServiceLayer.isEnabled()) {
                wmsServiceLayer.setRefreshNeeded(true);
                wmsServiceLayer.retrieve(true);
            }
            this.fireTreeNodesChanged(this, new Object[]{this.root}, null, null);
        } else if (layer instanceof WMSLayer) {
            TreePath parentPath = treePath.getParentPath();
            ((WMSLayer)layer).setEnabled(!((WMSLayer)layer).isEnabled());
            activeLayerEvent.setLayer(layer);
            CismapBroker.getInstance().fireLayerAvailabilityChanged(activeLayerEvent);
            ((WMSServiceLayer)parentPath.getLastPathComponent()).setRefreshNeeded(true);
            this.fireTreeNodesChanged(this, new Object[]{this.root, (WMSServiceLayer)parentPath.getLastPathComponent()}, null, null);
        }
    }

    public void handleVisibility(TreePath treePath) {
        Object layer = treePath.getLastPathComponent();
        if (layer instanceof RetrievalServiceLayer) {
            boolean flag;
            RetrievalServiceLayer wmsServiceLayer = (RetrievalServiceLayer)layer;
            boolean bl = flag = !wmsServiceLayer.getPNode().getVisible();
            if (wmsServiceLayer instanceof AbstractWMS) {
                ((AbstractWMS)((Object)wmsServiceLayer)).setVisible(flag);
            } else if (wmsServiceLayer instanceof ModeLayer) {
                ((ModeLayer)wmsServiceLayer).setVisible(flag);
            } else if (wmsServiceLayer instanceof AbstractFeatureService) {
                ((AbstractFeatureService)wmsServiceLayer).setVisible(flag);
            }
            wmsServiceLayer.getPNode().setVisible(flag);
            this.fireTreeNodesChanged(this, new Object[]{this.root}, null, null);
            ActiveLayerEvent ale = new ActiveLayerEvent();
            ale.setLayer(wmsServiceLayer);
            CismapBroker.getInstance().fireLayerVisibilityChanged(ale);
        }
    }

    public boolean isVisible(TreePath treePath) {
        Object layer = treePath.getLastPathComponent();
        if (layer instanceof RetrievalServiceLayer) {
            RetrievalServiceLayer wmsServiceLayer = (RetrievalServiceLayer)layer;
            return wmsServiceLayer.getPNode().getVisible();
        }
        return false;
    }

    public void moveLayer(TreePath source, TreePath destination, int index, Object layer) {
        int indexOfRemovedObject = 0;
        if (source.getLastPathComponent().equals(this.getRoot())) {
            indexOfRemovedObject = this.layers.indexOf(layer);
            this.layers.remove(layer);
        } else if (source.getLastPathComponent() instanceof LayerCollection) {
            indexOfRemovedObject = ((LayerCollection)source.getLastPathComponent()).indexOf(layer);
            ((LayerCollection)source.getLastPathComponent()).remove(layer);
        }
        if (destination.getLastPathComponent().equals(this.getRoot())) {
            this.layers.add(this.layers.size() - index, layer);
        } else if (destination.getLastPathComponent() instanceof LayerCollection) {
            LayerCollection collection = (LayerCollection)destination.getLastPathComponent();
            collection.add(collection.size() - index, layer);
        }
        this.fireTreeStructureChanged(this, source.getPath(), new int[]{indexOfRemovedObject}, new Object[]{layer});
        this.fireTreeStructureChanged(this, destination.getPath(), null, new Object[]{layer});
        this.reorderLayer();
    }

    private void reorderLayer() {
        TreeMap<Integer, MapService> map = this.getMapServices();
        MapService lastService = null;
        for (Integer key : map.keySet()) {
            MapService s = map.get(key);
            if (lastService == null) {
                lastService = s;
                continue;
            }
            if (s.getPNode() != null && lastService.getPNode() != null) {
                s.getPNode().moveInFrontOf(lastService.getPNode());
            } else {
                this.log.warn((Object)"reorder layer on a service without a pnode");
            }
            lastService = s;
        }
    }

    public void moveLayerUp(TreePath treePath) {
        Object layer = treePath.getLastPathComponent();
        if (layer instanceof RetrievalServiceLayer) {
            MapService l = (MapService)layer;
            int pos = this.layers.indexOf(l);
            if (pos + 1 != this.layers.size()) {
                this.layers.remove(l);
                this.layers.add(pos + 1, l);
                if (this.layers.get(pos) instanceof MapService) {
                    l.getPNode().moveInFrontOf(((MapService)this.layers.get(pos)).getPNode());
                }
                this.fireTreeStructureChanged(this, new Object[]{this.root}, new int[]{pos, pos + 1}, new Object[]{this.layers.get(pos), l});
            }
        } else if (layer instanceof WMSLayer) {
            WMSLayer l = (WMSLayer)layer;
            WMSServiceLayer parent = (WMSServiceLayer)treePath.getParentPath().getLastPathComponent();
            int pos = parent.getWMSLayers().indexOf(l);
            if (pos + 1 != parent.getWMSLayers().size()) {
                parent.getWMSLayers().remove(l);
                parent.getWMSLayers().add(pos + 1, l);
                parent.setRefreshNeeded(true);
                this.fireTreeStructureChanged(this, new Object[]{this.root, parent}, null, null);
            }
        }
    }

    public void moveLayerDown(TreePath treePath) {
        Object layer = treePath.getLastPathComponent();
        if (layer instanceof MapService) {
            MapService l = (MapService)layer;
            int pos = this.layers.indexOf(l);
            if (pos != 0) {
                this.layers.remove(l);
                this.layers.add(pos - 1, l);
                if (this.layers.get(pos) instanceof MapService) {
                    l.getPNode().moveInBackOf(((MapService)this.layers.get(pos)).getPNode());
                }
                this.fireTreeStructureChanged(this, new Object[]{this.root}, new int[]{pos - 1, pos}, new Object[]{l, this.layers.get(pos)});
            }
        } else if (layer instanceof WMSLayer) {
            WMSLayer l = (WMSLayer)layer;
            WMSServiceLayer parent = (WMSServiceLayer)treePath.getParentPath().getLastPathComponent();
            int pos = parent.getWMSLayers().indexOf(l);
            if (pos != 0) {
                parent.getWMSLayers().remove(l);
                parent.getWMSLayers().add(pos - 1, l);
                parent.setRefreshNeeded(true);
                this.fireTreeStructureChanged(this, new Object[]{this.root, parent}, null, null);
            }
        }
    }

    public int getLayerPosition(TreePath treePath) {
        Object layer = treePath.getLastPathComponent();
        if (layer instanceof MapService) {
            MapService l = (MapService)layer;
            int pos = this.layers.indexOf(l);
            return pos;
        }
        if (layer instanceof WMSLayer) {
            WMSLayer l = (WMSLayer)layer;
            WMSServiceLayer parent = (WMSServiceLayer)treePath.getParentPath().getLastPathComponent();
            int pos = parent.getWMSLayers().indexOf(l);
            return pos;
        }
        return 0;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 1: {
                return TreeTableModel.class;
            }
        }
        return Object.class;
    }

    public int getChildCount(Object parent) {
        if (parent == super.getRoot()) {
            return this.layers.size();
        }
        if (parent instanceof WMSServiceLayer) {
            WMSServiceLayer wmsServiceLayer = (WMSServiceLayer)parent;
            if (wmsServiceLayer.getWMSLayers().size() > 1) {
                return wmsServiceLayer.getWMSLayers().size();
            }
            return 0;
        }
        if (parent instanceof LayerCollection) {
            return ((LayerCollection)parent).size();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public Object getValueAt(Object node, int column) {
        if (node instanceof RetrievalServiceLayer) {
            return (RetrievalServiceLayer)node;
        }
        if (node instanceof WMSLayer) {
            return (WMSLayer)node;
        }
        if (node instanceof LayerCollection) {
            return (LayerCollection)node;
        }
        return "ROOT 0";
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return NbBundle.getMessage(ActiveLayerModel.class, (String)"ActiveLayerModel.getColumnName(int).return.layer");
            }
            case 2: {
                return NbBundle.getMessage(ActiveLayerModel.class, (String)"ActiveLayerModel.getColumnName(int).return.style");
            }
            case 3: {
                return NbBundle.getMessage(ActiveLayerModel.class, (String)"ActiveLayerModel.getColumnName(int).return.info");
            }
            case 4: {
                return NbBundle.getMessage(ActiveLayerModel.class, (String)"ActiveLayerModel.getColumnName(int).return.fortschrittTransparent");
            }
            case 5: {
                return "";
            }
        }
        return "";
    }

    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this.layers.get(this.layers.size() - 1 - index);
        }
        if (parent instanceof WMSServiceLayer) {
            return ((WMSServiceLayer)parent).getWMSLayers().get(((WMSServiceLayer)parent).getWMSLayers().size() - 1 - index);
        }
        if (parent instanceof LayerCollection) {
            return ((LayerCollection)parent).get(((LayerCollection)parent).size() - 1 - index);
        }
        return null;
    }

    private int getLayerCollectionCount(Object parent) {
        AbstractList col;
        int count = 0;
        if (parent == this.root) {
            col = this.layers;
        } else if (parent instanceof LayerCollection) {
            col = (LayerCollection)parent;
        } else {
            return 0;
        }
        for (Object o : col) {
            if (o instanceof LayerCollection) continue;
            ++count;
        }
        return count;
    }

    public int getColumnCount() {
        return 6;
    }

    public boolean isCellEditable(Object node, int column) {
        switch (column) {
            case 0: {
                return true;
            }
            case 1: {
                if (node instanceof WMSServiceLayer) {
                    return true;
                }
                return node instanceof LayerCollection && ((LayerCollection)node).size() > 0;
            }
            case 2: {
                if (node instanceof WMSServiceLayer && ((WMSServiceLayer)node).getWMSLayers().size() > 1) {
                    return false;
                }
                if (node instanceof WMSServiceLayer && ((WMSServiceLayer)node).getWMSLayers().size() == 1 && ((WMSLayer)((WMSServiceLayer)node).getWMSLayers().get(0)).getOgcCapabilitiesLayer().getStyles().length > 1) {
                    return true;
                }
                if (node instanceof WMSLayer && ((WMSLayer)node).getOgcCapabilitiesLayer().getStyles().length > 1) {
                    return false;
                }
                return node instanceof AbstractFeatureService;
            }
            case 3: {
                if (node instanceof LayerInfoProvider) {
                    return ((LayerInfoProvider)node).isQueryable();
                }
                return false;
            }
            case 4: {
                return node instanceof RetrievalServiceLayer;
            }
            case 5: {
                return true;
            }
        }
        boolean retValue = super.isCellEditable(node, column);
        return true;
    }

    public void setValueAt(Object aValue, Object node, int column) {
        if (column == 1) {
            if (node instanceof LayerCollection) {
                ((LayerCollection)node).setName(aValue.toString());
                this.fireTreeNodesChanged(this, new Object[]{this.root}, null, null);
            } else {
                ((WMSServiceLayer)node).setName(aValue.toString());
                this.fireTreeNodesChanged(this, new Object[]{this.root, node}, null, null);
            }
        } else if (column == 3) {
            // empty if block
        }
        super.setValueAt(aValue, node, column);
    }

    @Override
    public void removeMappingModelListener(MappingModelListener mml) {
        this.mappingModelListeners.remove(mml);
    }

    @Override
    public void addMappingModelListener(MappingModelListener mml) {
        this.mappingModelListeners.add(mml);
    }

    public TreeMap<Integer, MapService> getMapServices() {
        ArrayList l = new ArrayList(this.layers);
        Iterator it = l.iterator();
        TreeMap<Integer, MapService> tm = new TreeMap<Integer, MapService>();
        int counter = 0;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof MapService) {
                tm.put(new Integer(counter++), (MapService)o);
                continue;
            }
            if (o instanceof LayerCollection) {
                for (MapService ms : this.getMapServicesFromLayerCollection((LayerCollection)o)) {
                    tm.put(new Integer(counter++), ms);
                }
                continue;
            }
            this.log.warn((Object)("service is not of type MapService: " + o));
        }
        return tm;
    }

    public boolean switchLayer(Object origLayer, Object newLayer) {
        ArrayList l = new ArrayList(this.layers);
        Iterator it = l.iterator();
        for (int i = 0; i < l.size(); ++i) {
            Object o = l.get(i);
            if (o instanceof MapService) {
                if (!origLayer.equals(o)) continue;
                this.layers.remove(origLayer);
                ActiveLayerEvent ale = new ActiveLayerEvent();
                ale.setLayer(origLayer);
                CismapBroker.getInstance().fireLayerRemoved(ale);
                this.fireMapServiceRemoved((MapService)origLayer);
                this.registerRetrievalServiceLayer((RetrievalServiceLayer)newLayer);
                this.layers.add(i, newLayer);
                this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
                this.reorderLayer();
                return true;
            }
            if (o instanceof LayerCollection) {
                if (!this.switchLayerInLayerCollection((LayerCollection)o, origLayer, newLayer)) continue;
                return true;
            }
            this.log.warn((Object)("service is not of type MapService: " + o));
        }
        return false;
    }

    private boolean switchLayerInLayerCollection(LayerCollection collection, Object origLayer, Object newLayer) {
        for (int i = 0; i < collection.size(); ++i) {
            Object o = collection.get(i);
            if (o instanceof LayerCollection) {
                boolean found = this.switchLayerInLayerCollection((LayerCollection)o, origLayer, newLayer);
                if (!found) continue;
                return true;
            }
            if (!o.equals(origLayer)) continue;
            this.layers.remove(origLayer);
            collection.remove(origLayer);
            ActiveLayerEvent ale = new ActiveLayerEvent();
            ale.setLayer(origLayer);
            CismapBroker.getInstance().fireLayerRemoved(ale);
            this.fireMapServiceRemoved((MapService)origLayer);
            this.registerRetrievalServiceLayer((RetrievalServiceLayer)newLayer);
            this.layers.add(i, newLayer);
            collection.add(i, newLayer);
            this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
            this.reorderLayer();
            return true;
        }
        return false;
    }

    public TreeMap<Integer, Object> getMapServicesAndCollections() {
        Iterator it = this.layers.iterator();
        TreeMap<Integer, Object> tm = new TreeMap<Integer, Object>();
        int counter = 0;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof MapService) {
                tm.put(new Integer(counter++), (MapService)o);
                continue;
            }
            if (o instanceof LayerCollection) {
                tm.put(new Integer(counter++), (LayerCollection)o);
                continue;
            }
            this.log.warn((Object)("service is not of type MapService: " + o));
        }
        return tm;
    }

    public List<MapService> getMapServicesFromLayerCollection(LayerCollection col) {
        ArrayList<MapService> resultList = new ArrayList<MapService>();
        for (Object o : col) {
            if (o instanceof MapService) {
                resultList.add((MapService)o);
                continue;
            }
            if (!(o instanceof LayerCollection)) continue;
            resultList.addAll(this.getMapServicesFromLayerCollection((LayerCollection)o));
        }
        return resultList;
    }

    public HashMap getHomeBoundingBoxes() {
        return this.homes;
    }

    public void addHome(XBoundingBox xbb) {
        this.homes.put(xbb.getSrs(), xbb);
    }

    @Override
    public BoundingBox getInitialBoundingBox() {
        if (this.srs == null && this.defaultHomeSrs == null) {
            this.log.warn((Object)"SRS and default SRS are not set, yet");
            return null;
        }
        XBoundingBox homeBox = this.homes.get(this.srs.getCode());
        if (homeBox == null) {
            XBoundingBox defaultBox;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No home found for srs " + this.srs.getCode()));
            }
            if ((defaultBox = this.homes.get(this.defaultHomeSrs.getCode())) != null) {
                try {
                    CrsTransformer transformer = new CrsTransformer(this.srs.getCode());
                    homeBox = transformer.transformBoundingBox(defaultBox);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error while transforming coordinates from " + defaultBox.getSrs() + " to " + this.srs), (Throwable)e);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No default bunding box (home) found. ");
            }
        }
        if (homeBox == null) {
            this.log.error((Object)("home bounding box == null for srs " + this.srs.getCode()));
        }
        return homeBox;
    }

    @Override
    public Crs getSrs() {
        return this.srs;
    }

    public void setSrs(String srs) {
        this.setSrs(new Crs(srs, srs, srs, true, false));
    }

    public void setSrs(Crs srs) {
        if (this.defaultHomeSrs == null) {
            this.defaultHomeSrs = srs;
        }
        for (Object layer : this.layers) {
            CidsLayerFactory.setLayerToCrs(srs, layer);
        }
        this.srs = srs;
    }

    public String getPreferredRasterFormat() {
        return this.preferredRasterFormat;
    }

    public void setPreferredRasterFormat(String preferredRasterFormat) {
        this.preferredRasterFormat = preferredRasterFormat;
    }

    public String getPreferredTransparentPref() {
        return this.preferredTransparentPref;
    }

    public void setPreferredTransparentPref(String preferredTransparentPref) {
        this.preferredTransparentPref = preferredTransparentPref;
    }

    public String getPreferredBGColor() {
        return this.preferredBGColor;
    }

    public void setPreferredBGColor(String preferredBGColor) {
        this.preferredBGColor = preferredBGColor;
    }

    public String getPreferredExceptionsFormat() {
        return this.preferredExceptionsFormat;
    }

    public void setPreferredExceptionsFormat(String preferredExceptionsFormat) {
        this.preferredExceptionsFormat = preferredExceptionsFormat;
    }

    public void fireProgressChanged(ServiceLayer sl) {
        int pos = this.layers.indexOf(sl);
        if (pos >= 0) {
            this.fireTreeNodesProgressChanged(this, new Object[]{this.root, sl}, null, null);
            this.fireTableChanged(null);
        }
    }

    public void addTreeModelWithoutProgressListener(TreeModelListener l) {
        super.addTreeModelListener(l);
        this.listenerWithOutProgress.add(l);
    }

    public void removeTreeModelWithoutProgressListener(TreeModelListener l) {
        super.removeTreeModelListener(l);
        this.listenerWithOutProgress.remove(l);
    }

    protected void fireTreeNodesProgressChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class || this.listenerWithOutProgress.contains(listeners[i + 1])) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    public void fireMapServiceAdded(MapService rasterService) {
        Vector<MappingModelListener> v = new Vector<MappingModelListener>(this.mappingModelListeners);
        for (MappingModelListener o : v) {
            if (!(o instanceof MappingModelListener)) continue;
            MappingModelListener mml = o;
            mml.mapServiceAdded(rasterService);
        }
    }

    public void fireMapServiceRemoved(MapService rasterService) {
        for (MappingModelListener o : this.mappingModelListeners) {
            if (!(o instanceof MappingModelListener)) continue;
            MappingModelListener mml = o;
            mml.mapServiceRemoved(rasterService);
        }
    }

    public Element getConfiguration() throws NoWriteError {
        Element conf = new Element("cismapActiveLayerConfiguration");
        Iterator<Integer> it = this.getMapServicesAndCollections().keySet().iterator();
        Element allLayerConf = new Element("Layers");
        int counter = 0;
        while (it.hasNext()) {
            Object service = this.layers.get(it.next());
            if (service instanceof ServiceLayer) {
                ((ServiceLayer)service).setLayerPosition(counter);
            }
            if (service instanceof SimpleFeatureSupportingRasterLayer) continue;
            Element layerConf = CidsLayerFactory.getElement(service);
            allLayerConf.addContent((Content)layerConf);
            ++counter;
        }
        if (counter == 0) {
            // empty if block
        }
        conf.addContent((Content)allLayerConf);
        return conf;
    }

    public void masterConfigure(Element e) {
        this.masterLayerHashmap.clear();
        if (this.initalLayerConfigurationFromServer) {
            try {
                Element[] orderedLayers;
                Element layersElement = e.getChild("cismapActiveLayerConfiguration").getChild("Layers");
                if (layersElement == null) {
                    this.log.warn((Object)"LayerElement nicht gefunden! Suche nach altem Kind \"RasterLayers\"");
                    layersElement = e.getChild("cismapActiveLayerConfiguration").getChild("RasterLayers");
                    if (layersElement == null) {
                        this.log.error((Object)"Kein valides Layerelement gefunden.");
                        return;
                    }
                }
                for (Element curLayerElement : orderedLayers = CidsLayerFactory.orderLayers(layersElement)) {
                    String curKeyString = CidsLayerFactory.getKeyforLayerElement(curLayerElement);
                    if (curKeyString != null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Adding element: " + curLayerElement + " with key: " + curKeyString));
                        }
                        this.masterLayerHashmap.put(curKeyString, curLayerElement);
                        continue;
                    }
                    this.log.warn((Object)("Es war nicht m\u00f6glich einen Keystring f\u00fcr das Element: " + curLayerElement + " zu erzeugen"));
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)"Kann die Layerkonfiguration des Servers nicht laden", (Throwable)ex);
            }
        }
    }

    public synchronized void configure(Element e) {
        this.configure(e, false);
    }

    public synchronized void configure(Element e, boolean merge) {
        try {
            Element conf = e.getChild("cismapActiveLayerConfiguration");
            List<String> links = LayerWidget.getCapabilities(conf, new ArrayList<String>());
            if (links.size() > 0) {
                this.createLayers(conf, this.capabilities, merge);
            } else {
                this.createLayers(conf, this.capabilities, merge);
            }
        }
        catch (Throwable ex) {
            this.log.error((Object)"Error during the configuration of the ActiveLayerModell", ex);
        }
    }

    private void createLayers(Element conf, HashMap<String, WMSCapabilities> capabilities, boolean merge) {
        Element[] orderedLayers;
        Element layerElement;
        if (!merge) {
            this.removeAllLayers();
        }
        if ((layerElement = conf.getChild("Layers")) == null) {
            this.log.warn((Object)"LayerElement not found! Check for old version child \"RasterLayers\"");
            layerElement = conf.getChild("RasterLayers");
            if (layerElement == null) {
                this.log.error((Object)"no valid layers element found");
                return;
            }
        }
        this.log.info((Object)("restoring " + layerElement.getChildren().size() + " layers from xml configuration"));
        for (Element element : orderedLayers = CidsLayerFactory.orderLayers(layerElement)) {
            this.createLayer(element, capabilities);
        }
    }

    private void createLayer(Element element, HashMap<String, WMSCapabilities> capabilities) {
        String currentKeyString = CidsLayerFactory.getKeyforLayerElement(element);
        if (this.isInitalLayerConfigurationFromServer() && !this.masterLayerHashmap.containsKey(currentKeyString)) {
            this.log.info((Object)("Layer in Serverkonfiguration nicht vorhanden, wird nicht hinzugef\u00fcgt KeyString: " + currentKeyString));
            return;
        }
        try {
            final ServiceLayer layer = CidsLayerFactory.createLayer(element, capabilities, this);
            boolean layerAlreadyExists = this.layers.contains(layer);
            if (!layerAlreadyExists && layer instanceof PropertyEqualsProvider) {
                for (Object o : this.layers) {
                    if (!(o instanceof PropertyEqualsProvider) || !((PropertyEqualsProvider)o).propertyEquals((Object)layer)) continue;
                    layerAlreadyExists = true;
                    break;
                }
            }
            if (layer != null && !layerAlreadyExists) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                ActiveLayerModel.this.log.info((Object)("addLayer  (" + layer.getName() + ")"));
                                if (layer instanceof ActiveLayerModelStore) {
                                    ((ActiveLayerModelStore)((Object)layer)).setActiveLayerModel(ActiveLayerModel.this);
                                }
                                ActiveLayerModel.this.addLayer(layer, ActiveLayerModel.this.layers.size());
                                ActiveLayerEvent ale = new ActiveLayerEvent();
                                ale.setLayer(layer);
                                CismapBroker.getInstance().fireLayerInformationStatusChanged(ale);
                                if (layer instanceof ChildrenProvider) {
                                    ChildrenProvider childrenProvider = (ChildrenProvider)((Object)layer);
                                    for (Object child : childrenProvider.getChildren()) {
                                        ale = new ActiveLayerEvent();
                                        ale.setLayer(child);
                                        CismapBroker.getInstance().fireLayerInformationStatusChanged(ale);
                                    }
                                }
                            }
                            catch (IllegalArgumentException schonVorhanden) {
                                ActiveLayerModel.this.log.warn((Object)("Layer '" + layer.getName() + "' already existed. Do not add the Layer. \n" + schonVorhanden.getMessage()));
                            }
                        }
                        catch (Exception e) {
                            ActiveLayerModel.this.log.error((Object)"Error while initialising WMS", (Throwable)e);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Layer layer '" + element.getName() + "' could not be created: \n" + t.getMessage()), t);
        }
    }

    @Override
    @Deprecated
    public TreeMap getRasterServices() {
        return this.getMapServices();
    }

    @Override
    public TreeMap getFeatureServices() {
        return new TreeMap();
    }

    public boolean isInitalLayerConfigurationFromServer() {
        return this.initalLayerConfigurationFromServer;
    }

    public void setInitalLayerConfigurationFromServer(boolean initalLayerConfigurationFromServer) {
        this.initalLayerConfigurationFromServer = initalLayerConfigurationFromServer;
    }

    public Crs getDefaultHomeSrs() {
        return this.defaultHomeSrs;
    }

    public void setDefaultHomeSrs(Crs defaultSrs) {
        this.defaultHomeSrs = defaultSrs;
    }
}

